/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SequenceConversions {
    public static <T> Sequence<T> fromArray(TypeInfo<T> ti, T[] values) {
        if (values == null) {
            return ti.emptySequence;
        }
        return new ArraySequence<T>(ti, values);
    }

    public static Sequence<Long> fromArray(long[] values) {
        if (values == null) {
            return TypeInfo.Long.emptySequence;
        }
        Long[] boxed = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return new ArraySequence<Long>(TypeInfo.Long, (T[])boxed, values.length);
    }

    public static Sequence<Integer> fromArray(int[] values) {
        if (values == null) {
            return TypeInfo.Integer.emptySequence;
        }
        Integer[] boxed = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return new ArraySequence<Integer>(TypeInfo.Integer, (T[])boxed, values.length);
    }

    public static Sequence<Integer> fromArray(short[] values) {
        if (values == null) {
            return TypeInfo.Integer.emptySequence;
        }
        Integer[] boxed = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return new ArraySequence<Integer>(TypeInfo.Integer, (T[])boxed, values.length);
    }

    public static Sequence<Integer> fromArray(char[] values) {
        if (values == null) {
            return TypeInfo.Integer.emptySequence;
        }
        Integer[] boxed = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return new ArraySequence<Integer>(TypeInfo.Integer, (T[])boxed, values.length);
    }

    public static Sequence<Integer> fromArray(byte[] values) {
        if (values == null) {
            return TypeInfo.Integer.emptySequence;
        }
        Integer[] boxed = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return new ArraySequence<Integer>(TypeInfo.Integer, (T[])boxed, values.length);
    }

    public static Sequence<Double> fromArray(double[] values) {
        if (values == null) {
            return TypeInfo.Double.emptySequence;
        }
        Double[] boxed = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return new ArraySequence<Double>(TypeInfo.Double, (T[])boxed, values.length);
    }

    public static Sequence<Double> fromArray(float[] values) {
        if (values == null) {
            return TypeInfo.Double.emptySequence;
        }
        Double[] boxed = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return new ArraySequence<Double>(TypeInfo.Double, (T[])boxed, values.length);
    }

    public static Sequence<Boolean> fromArray(boolean[] values) {
        if (values == null) {
            return TypeInfo.Boolean.emptySequence;
        }
        Boolean[] boxed = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return new ArraySequence<Boolean>(TypeInfo.Boolean, (T[])boxed, values.length);
    }

    public static <T> T[] toArray(Sequence<T> seq) {
        T[] unboxed = Util.newObjectArray(seq.size());
        int i = 0;
        for (T val : seq) {
            unboxed[i++] = val;
        }
        return unboxed;
    }

    public static long[] toArray(Sequence<Long> seq) {
        long[] unboxed = new long[seq.size()];
        int i = 0;
        for (Long val : seq) {
            unboxed[i++] = val;
        }
        return unboxed;
    }

    public static int[] toArray(Sequence<Integer> seq) {
        int[] unboxed = new int[seq.size()];
        int i = 0;
        for (Integer val : seq) {
            unboxed[i++] = val;
        }
        return unboxed;
    }

    public static double[] toDoubleArray(Sequence<? extends Number> seq) {
        double[] unboxed = new double[seq.size()];
        int i = 0;
        for (Number number : seq) {
            unboxed[i++] = number.doubleValue();
        }
        return unboxed;
    }

    public static float[] toFloatArray(Sequence<? extends Number> seq) {
        float[] unboxed = new float[seq.size()];
        int i = 0;
        for (Number number : seq) {
            unboxed[i++] = number.floatValue();
        }
        return unboxed;
    }

    public static boolean[] toArray(Sequence<Boolean> seq) {
        boolean[] unboxed = new boolean[seq.size()];
        int i = 0;
        for (Boolean val : seq) {
            unboxed[i++] = val;
        }
        return unboxed;
    }
}

