/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import com.sun.javafx.runtime.sequence.Sequences;
import java.util.BitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceMutator {
    private SequenceMutator() {
    }

    public static <T> Sequence<T> replaceSlice(Sequence<T> target, Listener<T> listener, int startPos, int endPos, Sequence<? extends T> newValues) {
        Sequence<Object> result;
        TypeInfo<T> elementType = target.getElementType();
        int size = Sequences.size(target);
        if (startPos > size || startPos < 0) {
            return target;
        }
        if (endPos < startPos - 1) {
            endPos = startPos - 1;
        } else if (endPos > size) {
            endPos = size;
        }
        if (startPos == 0 && endPos == size - 1) {
            result = newValues != null ? Sequences.upcast(newValues) : target.getEmptySequence();
        } else if (startPos == endPos + 1) {
            result = Sequences.size(newValues) == 0 ? target : (startPos == 0 ? Sequences.concatenate(elementType, newValues, target) : (startPos == size ? Sequences.concatenate(elementType, target, newValues) : Sequences.replace(target, startPos, startPos, newValues)));
        } else if (Sequences.size(newValues) == 0) {
            if (newValues == null) {
                newValues = target.getEmptySequence();
            }
            result = endPos == startPos - 1 ? target : (endPos >= size - 1 ? Sequences.subsequence(target, 0, startPos) : (startPos == 0 ? Sequences.subsequence(target, endPos + 1, size) : Sequences.replace(target, startPos, endPos + 1, elementType.emptySequence)));
        } else if (startPos <= endPos) {
            result = Sequences.replace(target, startPos, endPos + 1, newValues);
        } else {
            throw new IllegalArgumentException();
        }
        if (result != target && Sequences.shouldFlatten(result)) {
            result = Sequences.flatten(result);
        }
        if (result != target && listener != null) {
            listener.onReplaceSlice(startPos, endPos, newValues, target, result);
        }
        return result;
    }

    public static <T> Sequence<T> replaceSlice(Sequence<T> target, Listener<T> listener, int startPos, int endPos, T newValue) {
        int size = Sequences.size(target);
        if (startPos > size || startPos < 0 || endPos >= size) {
            return target;
        }
        if (newValue == null) {
            return SequenceMutator.replaceSlice(target, listener, startPos, endPos, target.getEmptySequence());
        }
        Sequence<T> result = startPos == endPos ? Sequences.replace(target, startPos, newValue) : Sequences.replace(target, startPos, endPos + 1, newValue);
        if (Sequences.shouldFlatten(result)) {
            result = Sequences.flatten(result);
        }
        if (listener != null) {
            listener.onReplaceElement(startPos, endPos, newValue, target, result);
        }
        return result;
    }

    public static <T> Sequence<T> set(Sequence<T> target, Listener<T> listener, int position, T value) {
        return SequenceMutator.replaceSlice(target, listener, position, position, value);
    }

    public static <T> Sequence<T> delete(Sequence<T> target, Listener<T> listener, int position) {
        return SequenceMutator.replaceSlice(target, listener, position, position, target.getEmptySequence());
    }

    public static <T> Sequence<T> insert(Sequence<T> target, Listener<T> listener, T value) {
        return SequenceMutator.replaceSlice(target, listener, target.size(), target.size() - 1, value);
    }

    public static <T> Sequence<T> insert(Sequence<T> target, Listener<T> listener, Sequence<? extends T> values) {
        return SequenceMutator.replaceSlice(target, listener, target.size(), target.size() - 1, values);
    }

    public static <T> Sequence<T> insertFirst(Sequence<T> target, Listener<T> listener, T value) {
        return SequenceMutator.replaceSlice(target, listener, 0, -1, value);
    }

    public static <T> Sequence<T> insertFirst(Sequence<T> target, Listener<T> listener, Sequence<? extends T> values) {
        return SequenceMutator.replaceSlice(target, listener, 0, -1, values);
    }

    public static <T> Sequence<T> insertBefore(Sequence<T> target, Listener<T> listener, T value, int position) {
        if (position > target.size()) {
            return target;
        }
        return SequenceMutator.replaceSlice(target, listener, position, position - 1, value);
    }

    public static <T> Sequence<T> insertBefore(Sequence<T> target, Listener<T> listener, Sequence<? extends T> values, int position) {
        if (position > target.size()) {
            return target;
        }
        return SequenceMutator.replaceSlice(target, listener, position, position - 1, values);
    }

    public static <T> Sequence<T> insertAfter(Sequence<T> target, Listener<T> listener, T value, int position) {
        if (position < 0 || position >= target.size()) {
            return target;
        }
        return SequenceMutator.replaceSlice(target, listener, position + 1, position, value);
    }

    public static <T> Sequence<T> insertAfter(Sequence<T> target, Listener<T> listener, Sequence<? extends T> values, int position) {
        return SequenceMutator.replaceSlice(target, listener, position + 1, position, values);
    }

    public static <T> Sequence<T> delete(Sequence<T> target, Listener<T> listener, SequencePredicate<? super T> predicate) {
        BitSet bits = target.getBits(predicate);
        if (bits.cardinality() == 0) {
            return target;
        }
        bits.flip(0, target.size());
        Sequence<T> result = Sequences.filter(target, bits);
        if (listener != null) {
            Sequence<T> lastValue = target;
            BitSet partialBits = new BitSet(target.size());
            partialBits.flip(0, target.size());
            for (int i = target.size() - 1; i >= 0; --i) {
                if (bits.get(i)) continue;
                partialBits.flip(i);
                Sequence<T> nextValue = Sequences.filter(target, partialBits);
                listener.onReplaceSlice(i, i, target.getEmptySequence(), lastValue, nextValue);
                lastValue = nextValue;
            }
        }
        return result;
    }

    public static <T> Sequence<T> insertBefore(Sequence<T> target, Listener<T> listener, T value, SequencePredicate<? super T> predicate) {
        BitSet bits = target.getBits(predicate);
        if (bits.cardinality() == 0) {
            return target;
        }
        if (bits.cardinality() == 1) {
            return SequenceMutator.insertBefore(target, listener, value, bits.nextSetBit(0));
        }
        return SequenceMutator.multiInsertBefore(target, listener, bits, Sequences.singleton(target.getElementType(), value));
    }

    public static <T> Sequence<T> insertBefore(Sequence<T> target, Listener<T> listener, Sequence<? extends T> values, SequencePredicate<? super T> predicate) {
        BitSet bits = target.getBits(predicate);
        if (bits.cardinality() == 0) {
            return target;
        }
        if (bits.cardinality() == 1) {
            return SequenceMutator.insertBefore(target, listener, values, bits.nextSetBit(0));
        }
        return SequenceMutator.multiInsertBefore(target, listener, bits, values);
    }

    public static <T> Sequence<T> insertAfter(Sequence<T> target, Listener<T> listener, T value, SequencePredicate<? super T> predicate) {
        BitSet bits = target.getBits(predicate);
        if (bits.cardinality() == 0) {
            return target;
        }
        if (bits.cardinality() == 1) {
            return SequenceMutator.insertAfter(target, listener, value, bits.nextSetBit(0));
        }
        return SequenceMutator.multiInsertAfter(target, listener, bits, Sequences.singleton(target.getElementType(), value));
    }

    public static <T> Sequence<T> insertAfter(Sequence<T> target, Listener<T> listener, Sequence<? extends T> values, SequencePredicate<? super T> predicate) {
        BitSet bits = target.getBits(predicate);
        if (bits.cardinality() == 0) {
            return target;
        }
        if (bits.cardinality() == 1) {
            return SequenceMutator.insertAfter(target, listener, values, bits.nextSetBit(0));
        }
        return SequenceMutator.multiInsertAfter(target, listener, bits, values);
    }

    private static <T> Sequence<T> multiInsertBefore(Sequence<T> target, Listener<T> listener, BitSet bits, Sequence<? extends T> values) {
        assert (bits.cardinality() > 1);
        Sequence<Object> nextValue = target;
        int firstBit = bits.nextSetBit(0);
        int curPos = firstBit > 0 ? firstBit : 0;
        int i = firstBit;
        int j = bits.nextSetBit(i + 1);
        while (i >= 0) {
            nextValue = SequenceMutator.replaceSlice(nextValue, listener, curPos, curPos - 1, values);
            curPos += (j > 0 ? j - i : target.size() - i) + Sequences.size(values);
            i = j;
            j = bits.nextSetBit(j + 1);
        }
        return nextValue;
    }

    private static <T> Sequence<T> multiInsertAfter(Sequence<T> target, Listener<T> listener, BitSet bits, Sequence<? extends T> values) {
        assert (bits.cardinality() > 1);
        Sequence<Object> nextValue = target;
        int j = bits.nextSetBit(0);
        int iteration = 0;
        while (j >= 0) {
            int curPos = j + iteration * Sequences.size(values) + 1;
            nextValue = SequenceMutator.replaceSlice(nextValue, listener, curPos, curPos - 1, values);
            j = bits.nextSetBit(j + 1);
            ++iteration;
        }
        return nextValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener<T> {
        public void onReplaceSlice(int var1, int var2, Sequence<? extends T> var3, Sequence<T> var4, Sequence<T> var5);

        public void onReplaceElement(int var1, int var2, T var3, Sequence<T> var4, Sequence<T> var5);
    }
}

