/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.location.SequenceChangeListener;
import com.sun.javafx.runtime.location.SequenceLocation;
import com.sun.javafx.runtime.sequence.AbstractBoundSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleBoundComprehension<T, V>
extends AbstractBoundSequence<V>
implements SequenceLocation<V> {
    private final SequenceLocation<T> sequenceLocation;
    private final boolean dependsOnIndex;

    public SimpleBoundComprehension(Class<V> clazz, SequenceLocation<T> sequenceLocation, boolean dependsOnIndex) {
        super(clazz);
        this.sequenceLocation = sequenceLocation;
        this.dependsOnIndex = dependsOnIndex;
        this.setInitialValue(this.computeValue());
        this.addTriggers();
    }

    public SimpleBoundComprehension(Class<V> clazz, SequenceLocation<T> sequenceLocation) {
        this(clazz, sequenceLocation, false);
    }

    protected abstract V computeElement$(T var1, int var2);

    private Sequence<V> computeValue() {
        Sequence<T> sequence = this.sequenceLocation.getAsSequence();
        T[] intermediateResults = Util.newObjectArray(sequence.size());
        for (int i = 0; i < intermediateResults.length; ++i) {
            intermediateResults[i] = this.computeElement$(sequence.get(i), i);
        }
        return Sequences.make(TypeInfo.getTypeInfo(this.getClazz()), intermediateResults);
    }

    private void addTriggers() {
        this.sequenceLocation.addChangeListener(new SequenceChangeListener<T>(){

            @Override
            public void onChange(int startPos, int endPos, Sequence<? extends T> newElements, Sequence<T> oldValue, Sequence<T> newValue) {
                int i;
                int directlyAffectedSize = Sequences.size(newElements);
                int elementsAdded = directlyAffectedSize - (endPos - startPos + 1);
                boolean updateTrailingElements = SimpleBoundComprehension.this.dependsOnIndex && elementsAdded != 0 && endPos + 1 < Sequences.size(oldValue);
                int indirectlyAffectedStart = 0;
                int indirectlyAffectedEnd = 0;
                int indirectlyAffectedSize = 0;
                if (updateTrailingElements) {
                    indirectlyAffectedStart = endPos + 1;
                    indirectlyAffectedEnd = oldValue.size() - 1;
                    indirectlyAffectedSize = indirectlyAffectedEnd - indirectlyAffectedStart + 1;
                }
                T[] ourNewElements = Util.newObjectArray(directlyAffectedSize + indirectlyAffectedSize);
                for (i = 0; i < directlyAffectedSize; ++i) {
                    ourNewElements[i] = SimpleBoundComprehension.this.computeElement$(newElements.get(i), SimpleBoundComprehension.this.dependsOnIndex ? startPos + i : -1);
                }
                for (i = 0; i < indirectlyAffectedSize; ++i) {
                    ourNewElements[directlyAffectedSize + i] = SimpleBoundComprehension.this.computeElement$(oldValue.get(indirectlyAffectedStart + i), indirectlyAffectedStart + i + elementsAdded);
                }
                Sequence vSequence = Sequences.make(TypeInfo.getTypeInfo(SimpleBoundComprehension.this.getClazz()), ourNewElements);
                SimpleBoundComprehension.this.updateSlice(startPos, updateTrailingElements ? indirectlyAffectedEnd : endPos, vSequence);
            }
        });
    }
}

