/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.util;

import com.sun.javafx.runtime.util.Linkable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkable<T, H>
implements Linkable<T, H> {
    public static <T, H> boolean isUnused(Linkable<T, H> element) {
        return element.getHost() == null && element.getNext() == null;
    }

    public static <T extends Linkable<T, H>, H> void addAtEnd(Linkable.HeadAccessor<T, H> ha, H host, T element) {
        Linkable head = (Linkable)ha.getHead(host);
        assert (element.getNext() == null);
        assert (element.getHost() == null);
        element.setHost(host);
        if (head == null) {
            ha.setHead(host, element);
        } else {
            Linkable nextPtr;
            Linkable cur = head;
            while ((nextPtr = (Linkable)cur.getNext()) != null) {
                cur = nextPtr;
            }
            cur.setNext(element);
        }
    }

    public static <T extends Linkable<T, H>, H> void remove(Linkable.HeadAccessor<T, H> ha, H host, T element) {
        Linkable head = (Linkable)ha.getHead(host);
        if (head == element) {
            ha.setHead(host, element.getNext());
        } else {
            Linkable nextPtr;
            Linkable cur = head;
            while (cur != null && (nextPtr = (Linkable)cur.getNext()) != element) {
                cur = nextPtr;
            }
            if (cur != null) {
                cur.setNext(element.getNext());
            }
        }
        element.setNext(null);
        element.setHost(null);
    }

    public static <T extends Linkable<T, ?>> int size(T head) {
        int size = 0;
        for (Object cur = head; cur != null; cur = (Linkable)cur.getNext()) {
            ++size;
        }
        return size;
    }

    public static <T extends Linkable<T, ?>> void iterate(T head, Linkable.IterationClosure<T> closure) {
        for (Object cur = head; cur != null; cur = (Linkable)cur.getNext()) {
            closure.action(cur);
        }
    }

    public static <T extends Linkable<T, H>, H> void iterate(Linkable.HeadAccessor<T, H> ha, H host, Linkable.MutativeIterationClosure<T, H> closure) {
        Linkable cur = (Linkable)ha.getHead(host);
        while (cur != null && !closure.action(cur)) {
            Linkable next = (Linkable)cur.getNext();
            cur.setNext(null);
            cur.setHost(null);
            cur = next;
            ha.setHead(host, cur);
        }
        if (cur == null) {
            return;
        }
        Linkable prev = cur;
        cur = (Linkable)cur.getNext();
        while (cur != null) {
            if (!closure.action(cur)) {
                Linkable next = (Linkable)cur.getNext();
                cur.setNext(null);
                cur.setHost(null);
                cur = next;
                prev.setNext(cur);
                continue;
            }
            prev = cur;
            cur = (Linkable)cur.getNext();
        }
    }
}

