/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.util;

import com.sun.javafx.runtime.util.ClassContext;
import com.sun.javafx.runtime.util.FXFormatter;
import com.sun.javafx.runtime.util.FXPropertyResourceBundle;
import com.sun.javafx.runtime.util.backport.ResourceBundle;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLocalization {
    private static final Map<ThreadGroup, Map<String, String>> map = Collections.synchronizedMap(new WeakHashMap());
    private static final ClassContext CC = new ClassContext();
    private static final String PKGNAME = StringLocalization.class.getPackage().getName();

    public static String getLocalizedString(String scriptName, String explicitKey, String literal, Object ... embeddedExpr) {
        String key = scriptName.replaceAll("/", "\\.");
        int lastDot = key.lastIndexOf(46);
        key = lastDot != -1 ? key.substring(0, lastDot) + "/" + key.substring(lastDot + 1) : "/" + key;
        return StringLocalization.getLocalizedString(StringLocalization.getPropertiesName(key), explicitKey, literal, Locale.getDefault(), embeddedExpr);
    }

    public static String getLocalizedString(String propertiesName, String explicitKey, String literal, Locale locale, Object ... embeddedExpr) {
        String localization = literal;
        ResourceBundle rb = ResourceBundle.getBundle(propertiesName, locale, StringLocalization.getCallerLoader(), FXPropertyResourceBundle.FXPropertiesControl.INSTANCE);
        if (explicitKey != null) {
            localization = rb.getString(explicitKey);
            if (explicitKey.equals(localization) && !rb.keySet().contains(explicitKey)) {
                localization = literal;
            }
        } else {
            localization = rb.getString(literal.replaceAll("\r\n|\r|\n", "\n"));
        }
        if (embeddedExpr.length != 0) {
            localization = FXFormatter.sprintf(locale, localization, embeddedExpr);
        }
        return localization;
    }

    public static void associate(String source, String properties) {
        StringLocalization.getAssociation().put(source, properties);
    }

    public static void dissociate(String source) {
        Map<String, String> assoc = StringLocalization.getAssociation();
        assoc.remove(source);
        if (source.indexOf(47) == -1) {
            String toRemove = source + "/";
            for (String key : assoc.keySet()) {
                if (!key.startsWith(toRemove)) continue;
                assoc.remove(key);
            }
        }
    }

    public static String getPropertiesName(String key) {
        String propertiesName = key.replaceAll("^/", "").replaceAll("/", ".");
        Map<String, String> assoc = StringLocalization.getAssociation();
        Pattern chopoff = Pattern.compile("[\\./][^\\./]*\\z");
        while (true) {
            if (assoc.containsKey(key)) {
                propertiesName = assoc.get(key);
                break;
            }
            if ("".equals(key)) break;
            if (chopoff.matcher(key).find()) {
                key = chopoff.matcher(key).replaceAll("");
                continue;
            }
            key = "";
        }
        return propertiesName;
    }

    private static Map<String, String> getAssociation() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        Map<String, String> assoc = map.get(tg);
        if (assoc == null) {
            assoc = new ConcurrentHashMap<String, String>();
            map.put(tg, assoc);
        }
        return assoc;
    }

    private static ClassLoader getCallerLoader() {
        Class[] callers = CC.getClassContext();
        try {
            for (Class c : callers) {
                if (c.getName().startsWith(PKGNAME)) continue;
                ClassLoader cl = c.getClassLoader();
                if (cl != null) {
                    return cl;
                }
                break;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ClassLoader.getSystemClassLoader();
    }
}

