/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.ant;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.SourceFileScanner;

public class JavaFxAntTask
extends Javac {
    public Path compilerClassPath;
    public String profile;
    private static final String FAIL_MSG = "JavaFX compile failed; see the compiler error output for details.";
    public static final String FX_ENTRY_POINT = "com.sun.tools.javafx.Main";

    public JavaFxAntTask() {
        super.setCompiler(JavaFxCompilerAdapter.class.getName());
        super.setIncludeantruntime(true);
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m = new GlobPatternMapper();
        m.setFrom("*.fx");
        m.setTo("*.class");
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        File[] newFiles = sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m);
        if (newFiles.length > 0) {
            File[] newCompileList = new File[this.compileList.length + newFiles.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles, 0, newCompileList, this.compileList.length, newFiles.length);
            this.compileList = newCompileList;
        }
    }

    protected void compile() {
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.getDestdir() != null ? " to " + this.getDestdir() : ""));
            if (this.listFiles) {
                for (int i = 0; i < this.compileList.length; ++i) {
                    String filename = this.compileList[i].getAbsolutePath();
                    this.log(filename);
                }
            }
            JavaFxCompilerAdapter adapter = new JavaFxCompilerAdapter();
            adapter.setJavac(this);
            if (!adapter.execute()) {
                if (this.failOnError) {
                    throw new BuildException(FAIL_MSG, this.getLocation());
                }
                this.log(FAIL_MSG, 0);
            }
        }
    }

    public void setCompilerClassPath(Path p) {
        this.compilerClassPath = p;
    }

    public void setCompilerClassPathRef(Reference r) {
        this.setCompilerClassPath((Path)r.getReferencedObject());
    }

    private URL[] pathAsURLs() throws MalformedURLException {
        Path p = this.compilerClassPath != null ? this.compilerClassPath : new Path(this.getProject());
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String s : p.list()) {
            urls.add(new File(s).toURI().toURL());
        }
        return urls.toArray(new URL[0]);
    }

    public void setProfile(String s) {
        this.profile = s;
    }

    public String getCompiler() {
        return "extJavac";
    }

    protected void checkParameters() throws BuildException {
        super.checkParameters();
        if (super.getExecutable() == null && this.compilerClassPath == null) {
            throw new BuildException("javafxc: executable or compilerclasspath must be set", this.getLocation());
        }
    }

    public static class JavaFxCompilerAdapter
    extends DefaultCompilerAdapter {
        public boolean execute() throws BuildException {
            try {
                if (this.getJavac().isForkedJavac()) {
                    return this.forkeExecute();
                }
                Commandline cmd = this.setupModernJavacCommand();
                URL[] jars = ((JavaFxAntTask)this.getJavac()).pathAsURLs();
                URLClassLoader loader = new URLClassLoader(jars){

                    protected Class loadClass(String n, boolean r) throws ClassNotFoundException {
                        if (n.indexOf("sun.tools") >= 0 || n.startsWith("com.sun.source")) {
                            Class<?> c = this.findLoadedClass(n);
                            if (c != null) {
                                JavaFxCompilerAdapter.this.getJavac().log("found loaded class: " + n);
                                return c;
                            }
                            c = this.findClass(n);
                            if (c == null) {
                                JavaFxCompilerAdapter.this.getJavac().log("didn't find class:  " + n);
                                return super.loadClass(n, r);
                            }
                            if (r) {
                                this.resolveClass(c);
                            }
                            return c;
                        }
                        return super.loadClass(n, r);
                    }
                };
                Class<?> c = Class.forName(JavaFxAntTask.FX_ENTRY_POINT, true, loader);
                Object compiler2 = c.newInstance();
                Method compile = c.getMethod("compile", String[].class);
                String[] args = cmd.getArguments();
                int result = (Integer)compile.invoke(compiler2, new Object[]{args});
                return result == 0;
            }
            catch (Exception ex) {
                this.getJavac().log(ex.toString());
                if (ex instanceof ClassNotFoundException || ex instanceof InvocationTargetException) {
                    throw new BuildException((Throwable)ex);
                }
                if (ex instanceof BuildException) {
                    throw (BuildException)ex;
                }
                throw new BuildException("Error starting JavaFX compiler", (Throwable)ex, this.location);
            }
        }

        public boolean forkeExecute() throws Exception {
            String profile;
            Commandline cmd = new Commandline();
            String executable = this.getJavac().getExecutable();
            if (executable != null) {
                cmd.setExecutable(executable);
                if (((JavaFxAntTask)this.getJavac()).compilerClassPath != null) {
                    this.getJavac().log("Ignoring attribute compilerclasspath, because executable is set.", 1);
                }
            } else {
                cmd.setExecutable(JavaEnvUtils.getJdkExecutable((String)"java"));
                if (this.memoryInitialSize != null) {
                    cmd.createArgument().setValue("-Xms" + this.memoryInitialSize);
                    this.memoryInitialSize = null;
                }
                if (this.memoryMaximumSize != null) {
                    cmd.createArgument().setValue("-Xmx" + this.memoryMaximumSize);
                    this.memoryMaximumSize = null;
                }
                String cp = "-Xbootclasspath/p:" + ((JavaFxAntTask)this.getJavac()).compilerClassPath.toString();
                cmd.createArgument().setValue(cp);
                cmd.createArgument().setValue(JavaFxAntTask.FX_ENTRY_POINT);
            }
            if ((profile = ((JavaFxAntTask)this.getJavac()).profile) != null) {
                cmd.createArgument().setLine("-profile " + profile);
            }
            this.setupJavacCommandlineSwitches(cmd, true);
            int firstFileName = cmd.size();
            this.logAndAddFilesToCompile(cmd);
            return this.executeExternalCompile(cmd.getCommandline(), firstFileName, true) == 0;
        }
    }
}

