/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.antlr;

import com.sun.tools.javac.util.Log;

public class StringLiteralProcessor {
    private final int basepos;
    private char[] sbuf;
    private int sp;
    private final char[] buf;
    private int bp;
    private final int buflen;
    private char ch;
    private int unicodeConversionBp = -1;
    private final Log log;

    public static String convert(Log log, int pos, String str) {
        StringLiteralProcessor slp = new StringLiteralProcessor(log, pos, str);
        return slp.convert();
    }

    private StringLiteralProcessor(Log log, int pos, String str) {
        this.log = log;
        this.basepos = pos;
        this.buf = str.toCharArray();
        this.buflen = this.buf.length - 1;
        this.bp = 0;
        this.sbuf = new char[this.buflen];
        this.sp = 0;
    }

    private String convert() {
        this.scanChar();
        while (this.bp < this.buflen) {
            this.scanLitChar();
        }
        return new String(this.sbuf, 0, this.sp);
    }

    private void lexError(String key, Object ... args) {
        this.log.error(this.basepos + this.bp - 1 - this.buflen, key, args);
    }

    private int digit(int base) {
        char c = this.ch;
        int result = Character.digit(c, base);
        if (result >= 0 && c > '\u007f') {
            this.lexError("illegal.nonascii.digit", new Object[0]);
            this.ch = "0123456789abcdef".charAt(result);
        }
        return result;
    }

    private void putChar(char ch) {
        if (this.sp == this.sbuf.length) {
            char[] newsbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
            this.sbuf = newsbuf;
        }
        this.sbuf[this.sp++] = ch;
    }

    private void convertUnicode() {
        if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
            ++this.bp;
            this.ch = this.buf[this.bp];
            if (this.ch == 'u') {
                do {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                } while (this.ch == 'u');
                int limit = this.bp + 3;
                if (limit < this.buflen) {
                    int d;
                    int code = d = this.digit(16);
                    while (this.bp < limit && d >= 0) {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        d = this.digit(16);
                        code = (code << 4) + d;
                    }
                    if (d >= 0) {
                        this.ch = (char)code;
                        this.unicodeConversionBp = this.bp;
                        return;
                    }
                }
                this.lexError("illegal.unicode.esc", new Object[0]);
            } else {
                --this.bp;
                this.ch = (char)92;
            }
        }
    }

    private void scanChar() {
        this.ch = this.buf[++this.bp];
        if (this.ch == '\\') {
            this.convertUnicode();
        }
    }

    private void scanLitChar() {
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                this.putChar('\\');
                this.scanChar();
            } else {
                this.scanChar();
                switch (this.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char leadch = this.ch;
                        int oct = this.digit(8);
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '7') {
                            oct = oct * 8 + this.digit(8);
                            this.scanChar();
                            if (leadch <= '3' && '0' <= this.ch && this.ch <= '7') {
                                oct = oct * 8 + this.digit(8);
                                this.scanChar();
                            }
                        }
                        this.putChar((char)oct);
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        this.scanChar();
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        this.scanChar();
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        this.scanChar();
                        break;
                    }
                    case 'f': {
                        this.putChar('\f');
                        this.scanChar();
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        this.scanChar();
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        this.scanChar();
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        this.scanChar();
                        break;
                    }
                    case '{': {
                        this.putChar('{');
                        this.scanChar();
                        break;
                    }
                    case '}': {
                        this.putChar('}');
                        this.scanChar();
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        this.scanChar();
                        break;
                    }
                    default: {
                        this.lexError("illegal.esc.char", new Object[0]);
                        break;
                    }
                }
            }
        } else if (this.bp != this.buflen) {
            this.putChar(this.ch);
            this.scanChar();
        }
    }
}

