/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.api;

import com.sun.javafx.api.JavafxTaskEvent;
import com.sun.javafx.api.JavafxTaskListener;
import com.sun.javafx.api.JavafxcTask;
import com.sun.javafx.api.tree.Tree;
import com.sun.javafx.api.tree.UnitTree;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javafx.api.JavafxcTool;
import com.sun.tools.javafx.comp.JavafxAttrContext;
import com.sun.tools.javafx.comp.JavafxEnv;
import com.sun.tools.javafx.main.CommandLine;
import com.sun.tools.javafx.main.JavafxCompiler;
import com.sun.tools.javafx.main.Main;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXTree;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxcTaskImpl
extends JavafxcTask {
    private Main compilerMain;
    private JavafxCompiler compiler;
    private String[] args;
    private Context context;
    private List<JavaFileObject> fileObjects;
    private Map<JavaFileObject, JFXScript> notYetEntered;
    private List<JFXScript> units;
    private JavafxTaskListener taskListener;
    private AtomicBoolean used = new AtomicBoolean();
    private Integer result = null;
    private List<JavafxEnv<JavafxAttrContext>> genList;
    private boolean compilationInProgress = false;
    private boolean parsed = false;

    JavafxcTaskImpl(JavafxcTool tool, Main compilerMain, String[] args, Context context, List<JavaFileObject> fileObjects) {
        this.compilerMain = compilerMain;
        this.args = args;
        this.context = context;
        this.fileObjects = fileObjects;
        compilerMain.getClass();
        args.getClass();
        context.getClass();
        fileObjects.getClass();
        Options optionTable = Options.instance(context);
        optionTable.put("-Xjcov", "-Xjcov");
    }

    JavafxcTaskImpl(JavafxcTool tool, Main compilerMain, Iterable<String> flags, Context context, Iterable<? extends JavaFileObject> fileObjects) {
        this(tool, compilerMain, JavafxcTaskImpl.toArray(flags), context, JavafxcTaskImpl.toList(fileObjects));
    }

    private static String[] toArray(Iterable<String> flags) {
        ListBuffer<String> result = new ListBuffer<String>();
        if (flags != null) {
            for (String flag : flags) {
                result.append(flag);
            }
        }
        return result.toArray(new String[result.length()]);
    }

    private static List<JavaFileObject> toList(Iterable<? extends JavaFileObject> fileObjects) {
        if (fileObjects == null) {
            return List.nil();
        }
        ListBuffer<JavaFileObject> result = new ListBuffer<JavaFileObject>();
        for (JavaFileObject javaFileObject : fileObjects) {
            result.append(javaFileObject);
        }
        return result.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        if (!this.used.getAndSet(true)) {
            this.beginContext();
            try {
                this.result = this.compilerMain.compile(this.args, this.context, this.fileObjects);
            }
            finally {
                this.endContext();
            }
            this.compilerMain = null;
            this.args = null;
            this.context = null;
            this.fileObjects = null;
            return this.result == 0;
        }
        throw new IllegalStateException("multiple calls to method 'call'");
    }

    private void prepareCompiler() throws IOException {
        if (!this.used.getAndSet(true)) {
            this.beginContext();
            this.compilerMain.registerServices(this.context, this.args);
            this.compilerMain.setOptions(Options.instance(this.context));
            this.compilerMain.filenames = new ListBuffer();
            List<File> filenames = this.compilerMain.processArgs(CommandLine.parse(this.args));
            if (!filenames.isEmpty()) {
                throw new IllegalArgumentException("Malformed arguments " + filenames.toString(" "));
            }
            this.compiler = JavafxCompiler.instance(this.context);
            this.compiler.keepComments = true;
            this.notYetEntered = new HashMap<JavaFileObject, JFXScript>();
            for (JavaFileObject file : this.fileObjects) {
                this.notYetEntered.put(file, null);
            }
            this.args = null;
            this.genList = List.nil();
        }
    }

    private void beginContext() {
        this.context.put(JavafxcTaskImpl.class, this);
        if (this.context.get(JavafxTaskListener.class) != null) {
            this.context.put(JavafxTaskListener.class, (JavafxTaskListener)null);
        }
        if (this.taskListener != null) {
            this.context.put(JavafxTaskListener.class, this.wrap(this.taskListener));
        }
        if (this.compilationInProgress) {
            throw new IllegalStateException("Compilation in progress");
        }
        this.compilationInProgress = true;
    }

    private JavafxTaskListener wrap(final JavafxTaskListener tl) {
        tl.getClass();
        return new JavafxTaskListener(){

            public void started(JavafxTaskEvent e) {
                try {
                    tl.started(e);
                }
                catch (Throwable t) {
                    throw new ClientCodeException(t);
                }
            }

            public void finished(JavafxTaskEvent e) {
                try {
                    tl.finished(e);
                }
                catch (Throwable t) {
                    throw new ClientCodeException(t);
                }
            }
        };
    }

    private void endContext() {
        this.compilationInProgress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<? extends UnitTree> parse() throws IOException {
        try {
            this.prepareCompiler();
            this.units = this.compiler.parseFiles(this.fileObjects);
            for (JFXScript unit : this.units) {
                JavaFileObject file = unit.getSourceFile();
                if (!this.notYetEntered.containsKey(file)) continue;
                this.notYetEntered.put(file, unit);
            }
            List<JFXScript> list = this.units;
            return list;
        }
        finally {
            this.parsed = true;
            if (this.compiler != null && this.compiler.log != null) {
                this.compiler.log.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enter() throws IOException {
        this.prepareCompiler();
        ListBuffer<JFXScript> roots = null;
        if (this.notYetEntered.size() > 0) {
            if (!this.parsed) {
                this.parse();
            }
            for (JavaFileObject file : this.fileObjects) {
                JFXScript unit = this.notYetEntered.remove(file);
                if (unit == null) continue;
                if (roots == null) {
                    roots = new ListBuffer<JFXScript>();
                }
                roots.append(unit);
            }
            this.notYetEntered.clear();
        }
        if (roots != null) {
            try {
                this.compiler.enterTrees(roots.toList());
            }
            finally {
                if (this.compiler != null && this.compiler.log != null) {
                    this.compiler.log.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<? extends UnitTree> analyze() throws IOException {
        try {
            this.enter();
            this.genList = this.genList.appendList(this.compiler.attribute());
            List<JFXScript> list = this.units;
            return list;
        }
        finally {
            if (this.compiler != null && this.compiler.log != null) {
                this.compiler.log.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int errorCheck() throws IOException {
        try {
            this.enter();
            this.compiler.errorCheck();
        }
        finally {
            if (this.compiler != null && this.compiler.log != null) {
                this.compiler.log.flush();
            }
        }
        return this.compiler.errorCount();
    }

    @Override
    public Iterable<? extends JavaFileObject> generate() throws IOException {
        this.analyze();
        ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        this.compiler.generate(this.genList, results);
        return results;
    }

    @Override
    public void setTaskListener(JavafxTaskListener taskListener) {
        this.taskListener = taskListener;
    }

    @Override
    public TypeMirror getTypeMirror(Iterable<? extends Tree> path) {
        if (path == null) {
            return null;
        }
        Tree last = null;
        Iterator<? extends Tree> i$ = path.iterator();
        while (i$.hasNext()) {
            Tree node;
            last = node = i$.next();
        }
        return ((JFXTree)last).type;
    }

    @Override
    public JavacElements getElements() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacElements.instance(this.context);
    }

    @Override
    public JavacTypes getTypes() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacTypes.instance(this.context);
    }

    public Context getContext() {
        return this.context;
    }
}

