/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.api;

import com.sun.javafx.api.JavafxCompiler;
import com.sun.javafx.api.JavafxcTask;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacFileManager;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javafx.Main;
import com.sun.tools.javafx.api.JavafxcTaskImpl;
import com.sun.tools.javafx.main.JavafxOption;
import com.sun.tools.javafx.main.RecognizedOptions;
import com.sun.tools.javafx.util.JavafxFileManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavafxcTool
implements JavafxCompiler {
    private final Context dummyContext = new Context();
    private final PrintWriter silent = new PrintWriter(new OutputStream(){

        public void write(int b) {
        }
    });
    private final com.sun.tools.javafx.main.Main sharedCompiler = new com.sun.tools.javafx.main.Main("javafxc", this.silent);

    public JavafxcTool() {
        this.sharedCompiler.setOptions(Options.instance(this.dummyContext));
    }

    public static JavafxcTool create() {
        return new JavafxcTool();
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        if (err == null) {
            err = System.err;
        }
        for (String argument : arguments) {
            argument.getClass();
        }
        return Main.compile(arguments, new PrintWriter(err, true));
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return Collections.unmodifiableSet(EnumSet.range(SourceVersion.RELEASE_3, SourceVersion.latest()));
    }

    @Override
    public JavacFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        Context context = new Context();
        if (diagnosticListener != null) {
            context.put(DiagnosticListener.class, diagnosticListener);
        }
        context.put(Log.outKey, new PrintWriter(System.err, true));
        return new JavafxFileManager(context, true, charset);
    }

    @Override
    public JavafxcTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<? extends JavaFileObject> compilationUnits) {
        String kindMsg = "All compilation units must be of SOURCE kind";
        if (options != null) {
            for (String string : options) {
                string.getClass();
            }
        }
        if (compilationUnits != null) {
            for (JavaFileObject javaFileObject : compilationUnits) {
                if (javaFileObject.getKind().name().equals("SOURCE")) continue;
                throw new IllegalArgumentException("All compilation units must be of SOURCE kind");
            }
        }
        Context context = new Context();
        if (diagnosticListener != null) {
            context.put(DiagnosticListener.class, diagnosticListener);
        }
        if (out == null) {
            context.put(Log.outKey, new PrintWriter(System.err, true));
        } else {
            context.put(Log.outKey, new PrintWriter(out, true));
        }
        if (fileManager == null) {
            fileManager = this.getStandardFileManager((DiagnosticListener)diagnosticListener, (Locale)null, (Charset)null);
        }
        context.put(JavaFileManager.class, fileManager);
        JavafxcTool.processOptions(context, fileManager, options);
        com.sun.tools.javafx.main.Main main = new com.sun.tools.javafx.main.Main("javacTask", context.get(Log.outKey));
        return new JavafxcTaskImpl(this, main, options, context, compilationUnits);
    }

    private static void processOptions(Context context, JavaFileManager fileManager, Iterable<String> options) {
        if (options == null) {
            return;
        }
        Options optionTable = Options.instance(context);
        JavafxOption.Option[] recognizedOptions = RecognizedOptions.getJavacToolOptions(new RecognizedOptions.GrumpyHelper());
        Iterator<String> flags = options.iterator();
        while (flags.hasNext()) {
            int j;
            String flag = flags.next();
            for (j = 0; j < recognizedOptions.length && !recognizedOptions[j].matches(flag); ++j) {
            }
            if (j == recognizedOptions.length) {
                if (fileManager.handleOption(flag, flags)) continue;
                String msg = com.sun.tools.javafx.main.Main.getLocalizedString("err.invalid.flag", flag);
                throw new IllegalArgumentException(msg);
            }
            JavafxOption.Option option = recognizedOptions[j];
            if (option.hasArg()) {
                if (!flags.hasNext()) {
                    String msg = com.sun.tools.javafx.main.Main.getLocalizedString("err.req.arg", flag);
                    throw new IllegalArgumentException(msg);
                }
                String operand = flags.next();
                if (!option.process(optionTable, flag, operand)) continue;
                throw new IllegalArgumentException(flag + " " + operand);
            }
            if (!option.process(optionTable, flag)) continue;
            throw new IllegalArgumentException(flag);
        }
    }

    @Override
    public int isSupportedOption(String option) {
        JavafxOption.Option[] recognizedOptions;
        for (JavafxOption.Option o : recognizedOptions = RecognizedOptions.getJavacToolOptions(new RecognizedOptions.GrumpyHelper())) {
            if (!o.matches(option)) continue;
            return o.hasArg() ? 1 : 0;
        }
        return -1;
    }
}

