/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.code.JavafxTypes;
import com.sun.tools.javafx.comp.JavafxClassReader;
import com.sun.tools.javafx.comp.JavafxTypeMorpher;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXOnReplace;
import com.sun.tools.javafx.tree.JFXOverrideClassVar;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JavafxTag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavafxAnalyzeClass {
    private final JCDiagnostic.DiagnosticPosition diagPos;
    private final Symbol.ClassSymbol currentClassSym;
    private final ListBuffer<VarInfo> attributeInfos = ListBuffer.lb();
    private final Map<String, Symbol.MethodSymbol> needDispatchMethods = new HashMap<String, Symbol.MethodSymbol>();
    private final Map<Name, VarInfo> translatedAttributes = new HashMap<Name, VarInfo>();
    private final Map<Name, VarInfo> visitedAttributes = new HashMap<Name, VarInfo>();
    private final Set<Symbol> addedBaseClasses = new HashSet<Symbol>();
    private final List<TranslatedVarInfo> translatedAttrInfo;
    private final Log log;
    private final Name.Table names;
    private final JavafxTypes types;
    private final JavafxClassReader reader;
    private final JavafxTypeMorpher typeMorpher;

    JavafxAnalyzeClass(JCDiagnostic.DiagnosticPosition diagPos, Symbol.ClassSymbol currentClassSym, List<TranslatedVarInfo> translatedAttrInfo, List<TranslatedOverrideClassVarInfo> translatedOverrideAttrInfo, Log log, Name.Table names, JavafxTypes types, JavafxClassReader reader, JavafxTypeMorpher typeMorpher) {
        this.log = log;
        this.names = names;
        this.types = types;
        this.reader = reader;
        this.typeMorpher = typeMorpher;
        this.diagPos = diagPos;
        this.currentClassSym = currentClassSym;
        this.translatedAttrInfo = translatedAttrInfo;
        for (TranslatedVarInfo translatedVarInfo : translatedAttrInfo) {
            this.translatedAttributes.put(translatedVarInfo.getName(), translatedVarInfo);
        }
        for (TranslatedOverrideClassVarInfo translatedOverrideClassVarInfo : translatedOverrideAttrInfo) {
            this.translatedAttributes.put(translatedOverrideClassVarInfo.getName(), translatedOverrideClassVarInfo);
        }
        this.process(currentClassSym, true);
        types.isCompoundClass(currentClassSym);
    }

    public List<VarInfo> instanceAttributeInfos() {
        return this.attributeInfos.toList();
    }

    public List<VarInfo> staticAttributeInfos() {
        ListBuffer ais = ListBuffer.lb();
        for (TranslatedVarInfo ai : this.translatedAttrInfo) {
            if (!ai.isStatic()) continue;
            ais.append(ai);
        }
        return ais.toList();
    }

    public List<Symbol.MethodSymbol> needDispatch() {
        ListBuffer meths = ListBuffer.lb();
        for (Symbol.MethodSymbol mSym : this.needDispatchMethods.values()) {
            meths.append(mSym);
        }
        return meths.toList();
    }

    private void process(Symbol sym, boolean cloneVisible) {
        block10: {
            JFXClassDeclaration cDecl;
            block11: {
                if (this.addedBaseClasses.contains(sym) || !this.types.isJFXClass(sym)) break block10;
                Symbol.ClassSymbol cSym = (Symbol.ClassSymbol)sym;
                this.addedBaseClasses.add(cSym);
                cDecl = this.types.getFxClass(cSym);
                if (cSym == this.currentClassSym) {
                    this.process(this.types.superType((JFXClassDeclaration)cDecl).tsym, false);
                } else if ((cSym.flags() & 0x800000000200L) == 0L) {
                    cloneVisible = false;
                }
                if (cDecl != null) break block11;
                for (Type supertype : cSym.getInterfaces()) {
                    Symbol.ClassSymbol iSym = (Symbol.ClassSymbol)supertype.tsym;
                    this.process(iSym, cloneVisible);
                }
                if ((cSym.flags_field & 0x200L) != 0L || cSym.members() == null) break block10;
                ListBuffer<Symbol> reversed = ListBuffer.lb();
                Scope.Entry e = cSym.members().elems;
                while (e != null && e.sym != null) {
                    reversed.prepend(e.sym);
                    e = e.sibling;
                }
                for (Symbol mem : reversed) {
                    if (mem.kind == 16) {
                        this.processMethodFromClassFile((Symbol.MethodSymbol)mem, cSym, cloneVisible);
                        continue;
                    }
                    if (!(mem instanceof Symbol.VarSymbol)) continue;
                    this.processAttribute((Symbol.VarSymbol)mem, cSym, cloneVisible);
                }
                break block10;
            }
            for (JFXExpression supertype : cDecl.getSupertypes()) {
                this.process(supertype.type.tsym, cloneVisible);
            }
            for (JFXTree def : cDecl.getMembers()) {
                if (def.getFXTag() == JavafxTag.VAR_DEF) {
                    this.processAttribute(((JFXVar)def).sym, cDecl.sym, cloneVisible);
                    continue;
                }
                if (!cloneVisible || def.getFXTag() != JavafxTag.FUNCTION_DEF) continue;
                this.processMethod(((JFXFunctionDefinition)def).sym);
            }
        }
    }

    private VarInfo addAttribute(Name attrName, Symbol.VarSymbol sym, boolean needsCloning) {
        VarInfo attrInfo = this.translatedAttributes.get(attrName);
        if (attrInfo == null || attrInfo.getSymbol() != sym) {
            attrInfo = new VarInfo(this.diagPos, attrName, sym, this.typeMorpher.varMorphInfo(sym), null, sym.owner == this.currentClassSym);
        }
        attrInfo.setNeedsCloning(needsCloning || attrInfo.isDirectOwner());
        this.attributeInfos.append(attrInfo);
        return attrInfo;
    }

    private void processMethodFromClassFile(Symbol.MethodSymbol meth, Symbol.ClassSymbol cSym, boolean cloneVisible) {
        if (cloneVisible && meth.name != this.names.init) {
            this.processMethod(meth);
        }
    }

    private void processMethod(Symbol.MethodSymbol meth) {
        if ((meth.flags() & 0x1408L) == 0L && (meth.owner.flags() & 0x800000000000L) != 0L) {
            String nameSig = this.methodSignature(meth);
            this.needDispatchMethods.put(nameSig, meth);
        }
    }

    private void processAttribute(Symbol.VarSymbol var, Symbol.ClassSymbol cSym, boolean cloneVisible) {
        if (var.owner.kind == 2 && (var.flags() & 8L) == 0L) {
            Name attrName = var.name;
            if (this.visitedAttributes.containsKey(attrName)) {
                this.log.error("javafx.cannot.override.default.initializer", attrName, cSym.name, this.visitedAttributes.get(attrName));
            } else {
                VarInfo ai = this.addAttribute(attrName, var, cloneVisible);
                if ((var.flags() & 2L) == 0L) {
                    this.visitedAttributes.put(attrName, ai);
                }
            }
        }
    }

    private String methodSignature(Symbol.MethodSymbol meth) {
        StringBuilder nameSigBld = new StringBuilder();
        nameSigBld.append(meth.name.toString());
        nameSigBld.append(":");
        nameSigBld.append(meth.getReturnType().toString());
        nameSigBld.append(":");
        for (Symbol.VarSymbol param : meth.getParameters()) {
            nameSigBld.append(param.type.toString());
            nameSigBld.append(":");
        }
        return nameSigBld.toString();
    }

    static class TranslatedOverrideClassVarInfo
    extends VarInfo {
        private final JFXOnReplace onReplace;
        private final JCTree.JCBlock onReplaceTranslatedBody;

        TranslatedOverrideClassVarInfo(JFXOverrideClassVar override, JavafxTypeMorpher.VarMorphInfo vmi, JCTree.JCStatement initStmt, JFXOnReplace onReplace, JCTree.JCBlock onReplaceTranslatedBody) {
            super(override.pos(), override.sym.name, override.sym, vmi, initStmt, true);
            this.onReplace = onReplace;
            this.onReplaceTranslatedBody = onReplaceTranslatedBody;
        }

        JFXOnReplace onReplace() {
            return this.onReplace;
        }

        JCTree.JCBlock onReplaceTranslatedBody() {
            return this.onReplaceTranslatedBody;
        }
    }

    static class TranslatedVarInfo
    extends VarInfo {
        final JFXVar var;
        private final JFXOnReplace onReplace;
        private final JCTree.JCBlock onReplaceTranslatedBody;

        TranslatedVarInfo(JFXVar var, JavafxTypeMorpher.VarMorphInfo vmi, JCTree.JCStatement initStmt, JFXOnReplace onReplace, JCTree.JCBlock onReplaceTranslatedBody) {
            super(var.pos(), var.sym.name, var.sym, vmi, initStmt, true);
            this.var = var;
            this.onReplace = onReplace;
            this.onReplaceTranslatedBody = onReplaceTranslatedBody;
        }

        public boolean needsCloning() {
            return true;
        }

        JFXOnReplace onReplace() {
            return this.onReplace;
        }

        JCTree.JCBlock onReplaceTranslatedBody() {
            return this.onReplaceTranslatedBody;
        }
    }

    static class VarInfo {
        private final JCDiagnostic.DiagnosticPosition diagPos;
        private final Symbol.VarSymbol sym;
        private final JavafxTypeMorpher.VarMorphInfo vmi;
        private final Name name;
        private final JCTree.JCStatement initStmt;
        private final boolean isDirectOwner;
        private boolean needsCloning;

        private VarInfo(JCDiagnostic.DiagnosticPosition diagPos, Name name, Symbol.VarSymbol attrSym, JavafxTypeMorpher.VarMorphInfo vmi, JCTree.JCStatement initStmt, boolean isDirectOwner) {
            this.diagPos = diagPos;
            this.name = name;
            this.sym = attrSym;
            this.vmi = vmi;
            this.initStmt = initStmt;
            this.isDirectOwner = isDirectOwner;
        }

        public Symbol.VarSymbol getSymbol() {
            return this.sym;
        }

        public JCDiagnostic.DiagnosticPosition pos() {
            return this.diagPos;
        }

        public Type getRealType() {
            return this.vmi.getRealType();
        }

        public Type getVariableType() {
            return this.vmi.getVariableType();
        }

        public Type getLocationType() {
            return this.vmi.getLocationType();
        }

        public Type getElementType() {
            return this.vmi.getElementType();
        }

        public Name getName() {
            return this.name;
        }

        public String getNameString() {
            return this.name.toString();
        }

        public long getFlags() {
            return this.sym.flags();
        }

        private void setNeedsCloning(boolean needs) {
            this.needsCloning = needs;
        }

        public boolean needsCloning() {
            return this.needsCloning;
        }

        public boolean isStatic() {
            return (this.getFlags() & 8L) != 0L;
        }

        public boolean isDef() {
            return (this.getFlags() & 0x20000000000L) != 0L;
        }

        public JavafxTypeMorpher.VarMorphInfo getVMI() {
            return this.vmi;
        }

        public boolean isDirectOwner() {
            return this.isDirectOwner;
        }

        public JCTree.JCStatement getDefaultInitStatement() {
            return this.initStmt;
        }

        JFXOnReplace onReplace() {
            return null;
        }

        JCTree.JCBlock onReplaceTranslatedBody() {
            return null;
        }

        public String toString() {
            return this.getNameString();
        }
    }
}

