/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.javafx.api.JavafxBindStatus;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Warner;
import com.sun.tools.javafx.code.JavafxClassSymbol;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.code.JavafxTypes;
import com.sun.tools.javafx.comp.JavafxAttr;
import com.sun.tools.javafx.comp.JavafxAttrContext;
import com.sun.tools.javafx.comp.JavafxDefs;
import com.sun.tools.javafx.comp.JavafxEnv;
import com.sun.tools.javafx.comp.JavafxResolve;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXIdent;
import com.sun.tools.javafx.tree.JFXLiteral;
import com.sun.tools.javafx.tree.JFXSelect;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxTreeInfo;
import com.sun.tools.javafx.tree.JavafxTreeScanner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxCheck {
    protected static final Context.Key<JavafxCheck> javafxCheckKey = new Context.Key();
    private final JavafxDefs defs;
    private final Name.Table names;
    private final Log log;
    private final JavafxSymtab syms;
    private final Infer infer;
    private final Target target;
    private final Source source;
    private final JavafxTypes types;
    private final JavafxTreeInfo treeinfo;
    private final JavafxResolve rs;
    private Lint lint;
    boolean allowGenerics;
    boolean complexInference;
    public Map<Name, Symbol.ClassSymbol> compiled = new HashMap<Name, Symbol.ClassSymbol>();
    private MandatoryWarningHandler deprecationHandler;
    private MandatoryWarningHandler uncheckedHandler;
    private Validator validator = new Validator();
    private Warner overrideWarner = new Warner();

    public static JavafxCheck instance(Context context) {
        JavafxCheck instance = context.get(javafxCheckKey);
        if (instance == null) {
            instance = new JavafxCheck(context);
        }
        return instance;
    }

    public static void preRegister(final Context context) {
        context.put(javafxCheckKey, new Context.Factory<JavafxCheck>(){

            @Override
            public JavafxCheck make() {
                return new JavafxCheck(context);
            }
        });
    }

    protected JavafxCheck(Context context) {
        context.put(javafxCheckKey, this);
        this.defs = JavafxDefs.instance(context);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.syms = (JavafxSymtab)Symtab.instance(context);
        this.infer = Infer.instance(context);
        this.types = JavafxTypes.instance(context);
        Options options = Options.instance(context);
        this.target = Target.instance(context);
        this.source = Source.instance(context);
        this.lint = Lint.instance(context);
        this.treeinfo = JavafxTreeInfo.instance(context);
        this.allowGenerics = this.source.allowGenerics();
        this.complexInference = options.get("-complexinference") != null;
        boolean verboseDeprecated = this.lint.isEnabled(Lint.LintCategory.DEPRECATION);
        boolean verboseUnchecked = this.lint.isEnabled(Lint.LintCategory.UNCHECKED);
        this.deprecationHandler = new MandatoryWarningHandler(this.log, verboseDeprecated, "deprecated");
        this.uncheckedHandler = new MandatoryWarningHandler(this.log, verboseUnchecked, "unchecked");
        this.rs = JavafxResolve.instance(context);
    }

    Lint setLint(Lint newLint) {
        Lint prev = this.lint;
        this.lint = newLint;
        return prev;
    }

    void warnDeprecated(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (!this.lint.isSuppressed(Lint.LintCategory.DEPRECATION)) {
            this.deprecationHandler.report(pos, "has.been.deprecated", sym, sym.location());
        }
    }

    public void warnUnchecked(JCDiagnostic.DiagnosticPosition pos, String msg, Object ... args) {
        if (!this.lint.isSuppressed(Lint.LintCategory.UNCHECKED)) {
            this.uncheckedHandler.report(pos, msg, args);
        }
    }

    public void reportDeferredDiagnostics() {
        this.deprecationHandler.reportDeferredDiagnostic();
        this.uncheckedHandler.reportDeferredDiagnostic();
    }

    public Type completionError(JCDiagnostic.DiagnosticPosition pos, Symbol.CompletionFailure ex) {
        this.log.error(pos, "cant.access", ex.sym, ex.errmsg);
        if (ex instanceof ClassReader.BadClassFile) {
            throw new Abort();
        }
        return this.syms.errType;
    }

    Type typeError(JCDiagnostic.DiagnosticPosition pos, Object problem, Type found, Type req) {
        String foundAsJavaFXType = this.types.toJavaFXString(found);
        String requiredAsJavaFXType = this.types.toJavaFXString(req);
        this.log.error(pos, "prob.found.req", problem, foundAsJavaFXType, requiredAsJavaFXType);
        return this.syms.errType;
    }

    Type typeError(JCDiagnostic.DiagnosticPosition pos, String problem, Type found, Type req, Object explanation) {
        String foundAsJavaFXType = this.types.toJavaFXString(found);
        String requiredAsJavaFXType = this.types.toJavaFXString(req);
        this.log.error(pos, "prob.found.req.1", problem, foundAsJavaFXType, requiredAsJavaFXType, explanation);
        return this.syms.errType;
    }

    Type typeTagError(JCDiagnostic.DiagnosticPosition pos, Object required, Object found) {
        Object foundAsJavaFXType;
        Object requiredAsJavaFXType = required;
        if (required instanceof Type) {
            requiredAsJavaFXType = this.types.toJavaFXString((Type)requiredAsJavaFXType);
        }
        if ((foundAsJavaFXType = found) instanceof Type) {
            foundAsJavaFXType = this.types.toJavaFXString((Type)foundAsJavaFXType);
        }
        this.log.error(pos, "type.found.req", foundAsJavaFXType, requiredAsJavaFXType);
        return this.syms.errType;
    }

    void earlyRefError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        this.log.error(pos, "cant.ref.before.ctor.called", sym);
    }

    void duplicateError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (sym.type == null || !sym.type.isErroneous()) {
            this.log.error(pos, "already.defined", sym, sym.location());
        }
    }

    void varargsDuplicateError(JCDiagnostic.DiagnosticPosition pos, Symbol sym1, Symbol sym2) {
        if (!sym1.type.isErroneous() && !sym2.type.isErroneous()) {
            this.log.error(pos, "array.and.varargs", sym1, sym2, sym2.location());
        }
    }

    void checkTransparentVar(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol v, Scope s) {
        if (s.next != null) {
            Scope.Entry e = s.next.lookup(v.name);
            while (e.scope != null && e.sym.owner == v.owner) {
                if (e.sym.kind == 4 && (e.sym.owner.kind & 0x14) != 0 && v.name != this.names.error) {
                    this.duplicateError(pos, e.sym);
                    return;
                }
                e = e.next();
            }
        }
    }

    void checkTransparentClass(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c, Scope s) {
        if (s.next != null) {
            Scope.Entry e = s.next.lookup(c.name);
            while (e.scope != null && e.sym.owner == c.owner) {
                if (e.sym.kind == 2 && (e.sym.owner.kind & 0x14) != 0 && c.name != this.names.error) {
                    this.duplicateError(pos, e.sym);
                    return;
                }
                e = e.next();
            }
        }
    }

    boolean checkUniqueClassName(JCDiagnostic.DiagnosticPosition pos, Name name, Scope s) {
        Scope.Entry e = s.lookup(name);
        while (e.scope == s) {
            if (e.sym.kind == 2 && e.sym.name != this.names.error) {
                this.duplicateError(pos, e.sym);
                return false;
            }
            e = e.next();
        }
        Symbol sym = s.owner;
        while (sym != null) {
            if (sym.kind == 2 && sym.name == name && sym.name != this.names.error) {
                this.duplicateError(pos, sym);
                return true;
            }
            sym = sym.owner;
        }
        return true;
    }

    Name localClassName(Symbol.ClassSymbol c) {
        int i = 1;
        Name flatname;
        while (this.compiled.get(flatname = this.names.fromString("" + c.owner.enclClass().flatname + this.target.syntheticNameChar() + i + c.name)) != null) {
            ++i;
        }
        return flatname;
    }

    private Type deLocationize(Type external) {
        Name flatname;
        Type deloc;
        if (external.tag == 10 && (deloc = this.defs.delocationize(flatname = ((Symbol.ClassSymbol)external.tsym).flatname)) != null) {
            throw new AssertionError((Object)"At this point we should not have Location(s). This is most likely JavafxReader problem. It should convert all the Location types to the \"real\" types.");
        }
        return external;
    }

    Type checkType(JCDiagnostic.DiagnosticPosition pos, Type foundRaw, Type reqRaw, JavafxAttr.Sequenceness pSequenceness) {
        Type found;
        Type req = this.deLocationize(reqRaw);
        Type realFound = found = this.deLocationize(foundRaw);
        if (req.tag == 19) {
            return req;
        }
        if (found == this.syms.unreachableType) {
            return found;
        }
        if (found.tag == 16) {
            if (req == this.syms.javafx_UnspecifiedType) {
                return this.types.erasure(found);
            }
            return this.instantiatePoly(pos, (Type.ForAll)found, req, this.convertWarner(pos, found, req));
        }
        if (req.tag == 18 || req == this.syms.javafx_UnspecifiedType) {
            return found;
        }
        if (this.types.isSequence(req)) {
            req = this.types.elementType(req);
            pSequenceness = JavafxAttr.Sequenceness.REQUIRED;
        }
        if (this.types.isSequence(found) || this.types.isArray(found)) {
            if (pSequenceness != JavafxAttr.Sequenceness.DISALLOWED) {
                found = this.types.isSequence(found) ? this.types.elementType(found) : this.types.elemtype(found);
            } else {
                return this.typeError(pos, JCDiagnostic.fragment("incompatible.types", new Object[0]), found, req);
            }
        }
        if (this.types.isAssignable(found, req, this.convertWarner(pos, found, req))) {
            if (req.tag <= 5 && found.tag >= 6 && found.tag <= 7) {
                String foundAsJavaFXType = this.types.toJavaFXString(found);
                String requiredAsJavaFXType = this.types.toJavaFXString(req);
                this.log.warning(pos, "prob.found.req", JCDiagnostic.fragment("possible.loss.of.precision", new Object[0]), foundAsJavaFXType, requiredAsJavaFXType);
            }
            return realFound;
        }
        ListBuffer<Type> supertypes = ListBuffer.lb();
        HashSet<Type> superSet = new HashSet<Type>();
        supertypes.append(found);
        superSet.add(found);
        this.types.getSupertypes(found.tsym, supertypes, superSet);
        for (Type baseType : supertypes) {
            if (!this.types.isAssignable(baseType, req, this.convertWarner(pos, found, req))) continue;
            return realFound;
        }
        if (found.tag <= 7 && req.tag <= 7) {
            String foundAsJavaFXType = this.types.toJavaFXString(found);
            String requiredAsJavaFXType = this.types.toJavaFXString(req);
            this.log.warning(pos.getStartPosition(), "prob.found.req", JCDiagnostic.fragment("possible.loss.of.precision", new Object[0]), foundAsJavaFXType, requiredAsJavaFXType);
            return realFound;
        }
        if (found.isSuperBound()) {
            this.log.error(pos, "assignment.from.super-bound", found);
            return this.syms.errType;
        }
        if (req.isExtendsBound()) {
            this.log.error(pos, "assignment.to.extends-bound", req);
            return this.syms.errType;
        }
        return this.typeError(pos, JCDiagnostic.fragment("incompatible.types", new Object[0]), found, req);
    }

    Type instantiatePoly(JCDiagnostic.DiagnosticPosition pos, Type.ForAll t, Type pt, Warner warn) {
        if (pt == Infer.anyPoly && this.complexInference) {
            return t;
        }
        if (pt == Infer.anyPoly || pt.tag == 18) {
            Type newpt = t.qtype.tag <= 9 ? t.qtype : this.syms.objectType;
            return this.instantiatePoly(pos, t, newpt, warn);
        }
        if (pt.tag == 19) {
            return pt;
        }
        try {
            return this.infer.instantiateExpr(t, pt, warn);
        }
        catch (Infer.NoInstanceException ex) {
            if (ex.isAmbiguous) {
                JCDiagnostic d = ex.getDiagnostic();
                this.log.error(pos, d != null ? "undetermined.type.1" : "undetermined.type", t, d);
                return this.syms.errType;
            }
            JCDiagnostic d = ex.getDiagnostic();
            return this.typeError(pos, JCDiagnostic.fragment(d != null ? "incompatible.types.1" : "incompatible.types", d), t, pt);
        }
    }

    Type checkCastable(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
        HashSet<Type> superSet;
        ListBuffer<Type> supertypes;
        if (found.tag == 16 && found instanceof Type.ForAll) {
            this.instantiatePoly(pos, (Type.ForAll)found, req, this.castWarner(pos, found, req));
            return req;
        }
        if (this.types.isCastable(found, req, this.castWarner(pos, found, req))) {
            return req;
        }
        if (found.tsym != null && found.tsym instanceof JavafxClassSymbol) {
            supertypes = ListBuffer.lb();
            superSet = new HashSet<Type>();
            supertypes.append(found);
            superSet.add(found);
            this.types.getSupertypes(found.tsym, supertypes, superSet);
            for (Type baseType : supertypes) {
                if (!this.types.isCastable(baseType, req, this.castWarner(pos, found, req))) continue;
                return req;
            }
        }
        if (req.tsym != null && req.tsym instanceof JavafxClassSymbol) {
            supertypes = ListBuffer.lb();
            superSet = new HashSet();
            supertypes.append(req);
            superSet.add(req);
            this.types.getSupertypes(req.tsym, supertypes, superSet);
            for (Type baseType : supertypes) {
                if (!this.types.isCastable(baseType, found, this.castWarner(pos, found, req))) continue;
                return req;
            }
        }
        return this.typeError(pos, JCDiagnostic.fragment("inconvertible.types", new Object[0]), found, req);
    }

    boolean isTypeVar(Type t) {
        return t.tag == 14 || t.tag == 11 && this.isTypeVar(this.types.elemtype(t));
    }

    private void checkExtends(JCDiagnostic.DiagnosticPosition pos, Type a, Type.TypeVar bs) {
        if (a.isUnbound()) {
            return;
        }
        if (a.tag != 15) {
            a = this.types.upperBound(a);
            List<Type> l = this.types.getBounds(bs);
            while (l.nonEmpty()) {
                if (!this.types.isSubtype(a, (Type)l.head)) {
                    this.log.error(pos, "not.within.bounds", a);
                    return;
                }
                l = l.tail;
            }
        } else if (a.isExtendsBound()) {
            if (!this.types.isCastable(bs.getUpperBound(), this.types.upperBound(a), Warner.noWarnings)) {
                this.log.error(pos, "not.within.bounds", a);
            }
        } else if (a.isSuperBound() && this.types.notSoftSubtype(this.types.lowerBound(a), bs.getUpperBound())) {
            this.log.error(pos, "not.within.bounds", a);
        }
    }

    Type checkNonVoid(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.tag == 9) {
            this.log.error(pos, "void.not.allowed.here", new Object[0]);
            return this.syms.errType;
        }
        return t;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.tag != 10 && t.tag != 19) {
            return this.typeTagError(pos, JCDiagnostic.fragment("type.req.class", new Object[0]), t.tag == 14 ? JCDiagnostic.fragment("type.parameter", t) : t);
        }
        return t;
    }

    boolean isAssignableAsBlankFinal(Symbol.VarSymbol v, JavafxEnv<JavafxAttrContext> env) {
        Symbol owner = ((JavafxAttrContext)env.info).scope.owner;
        return v.owner == owner || (owner.name == this.names.init || owner.kind == 4 || (owner.flags() & 0x100000L) != 0L) && v.owner == owner.owner && (v.flags() & 8L) != 0L == JavafxResolve.isStatic(env);
    }

    void checkAssignable(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol v, JFXTree base, Type site, JavafxEnv<JavafxAttrContext> env, WriteKind writeKind) {
        if (!((v.flags() & 0x10L) == 0L || this.types.isJFXClass(v.owner) || (v.flags() & 0x40000L) == 0L && (base == null || base.getFXTag() == JavafxTag.IDENT && JavafxTreeInfo.name(base) == this.names._this) && this.isAssignableAsBlankFinal(v, env))) {
            this.log.error(pos, "cant.assign.val.to.final.var", v);
        } else if ((v.flags() & 0x20000000000L) != 0L) {
            this.log.error(pos, "javafx.cannot.assign.to.def", v);
        } else if ((v.flags() & 0x200000000L) != 0L) {
            this.log.error(pos, "javafx.cannot.assign.to.parameter", v);
        } else {
            switch (writeKind) {
                case INIT_NON_BIND: {
                    if ((v.flags() & 0x80000000000L) == 0L) break;
                    return;
                }
            }
            if (!this.rs.isAccessibleForWrite(env, site, v)) {
                String msg;
                switch (writeKind) {
                    case INIT_BIND: {
                        msg = "javafx.report.bind.access";
                        break;
                    }
                    case INIT_NON_BIND: {
                        msg = "javafx.report.init.access";
                        break;
                    }
                    case VAR_QUERY: {
                        msg = "javafx.report.var.query.access";
                        break;
                    }
                    default: {
                        msg = "javafx.report.write.access";
                    }
                }
                this.log.error(pos, msg, v, JavafxCheck.protectionString(v.flags()), v.location());
            }
        }
    }

    void checkBidiBind(JFXExpression init, JavafxBindStatus bindStatus, JavafxEnv<JavafxAttrContext> env, Type pt) {
        if (bindStatus.isBidiBind()) {
            Symbol initSym = null;
            JFXExpression base = null;
            Type site = null;
            switch (init.getFXTag()) {
                case IDENT: {
                    initSym = ((JFXIdent)init).sym;
                    base = null;
                    site = env.enclClass.sym.type;
                    break;
                }
                case SELECT: {
                    JFXSelect select = (JFXSelect)init;
                    initSym = select.sym;
                    base = select.getExpression();
                    site = select.type;
                    break;
                }
            }
            if (initSym instanceof Symbol.VarSymbol) {
                if (pt != null && bindStatus.isBidiBind() && !this.types.isSameType(pt, initSym.type)) {
                    this.log.error(init.pos(), "javafx.wrong.type.for.bidi.bind", this.types.toJavaFXString(initSym.type), this.types.toJavaFXString(pt));
                }
                this.checkAssignable(init.pos(), (Symbol.VarSymbol)initSym, base, site, env, WriteKind.INIT_BIND);
            } else {
                this.log.error(init.pos(), "javafx.expr.unsupported.for.bidi.bind", new Object[0]);
            }
        }
    }

    public Type checkSequenceElementType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (this.types.isSequence(t)) {
            return this.types.elementType(t);
        }
        if (t.tag != 19) {
            return this.typeTagError(pos, this.types.sequenceType(this.syms.unknownType), t);
        }
        return this.syms.errType;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition pos, Type t, boolean noBounds) {
        t = this.checkClassType(pos, t);
        if (noBounds && t.isParameterized()) {
            List<Type> args = t.getTypeArguments();
            while (args.nonEmpty()) {
                if (((Type)args.head).tag == 15) {
                    return this.typeTagError(pos, Log.getLocalizedString("type.req.exact", new Object[0]), args.head);
                }
                args = args.tail;
            }
        }
        return t;
    }

    Type checkReifiableReferenceType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.tag != 10 && t.tag != 11 && t.tag != 19) {
            return this.typeTagError(pos, JCDiagnostic.fragment("type.req.class.array", new Object[0]), t);
        }
        if (!this.types.isReifiable(t)) {
            this.log.error(pos, "illegal.generic.type.for.instof", new Object[0]);
            return this.syms.errType;
        }
        return t;
    }

    Type checkRefType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        switch (t.tag) {
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: {
                return t;
            }
        }
        return this.typeTagError(pos, JCDiagnostic.fragment("type.req.ref", new Object[0]), t);
    }

    Type checkNullOrRefType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        switch (t.tag) {
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                return t;
            }
        }
        return this.typeTagError(pos, JCDiagnostic.fragment("type.req.ref", new Object[0]), t);
    }

    boolean checkDisjoint(JCDiagnostic.DiagnosticPosition pos, long flags, long set1, long set2) {
        if ((flags & set1) != 0L && (flags & set2) != 0L) {
            this.log.error(pos, "illegal.combination.of.modifiers", JavafxTreeInfo.flagNames(JavafxTreeInfo.firstFlag(flags & set1)), JavafxTreeInfo.flagNames(JavafxTreeInfo.firstFlag(flags & set2)));
            return false;
        }
        return true;
    }

    boolean checkDisjointWarn(JCDiagnostic.DiagnosticPosition pos, long flags, long set1, long set2) {
        if ((flags & set1) != 0L && (flags & set2) != 0L) {
            this.log.warning(pos, "javafx.redundant.access.modifiers", JavafxTreeInfo.flagNames(JavafxTreeInfo.firstFlag(flags & set1)), JavafxTreeInfo.flagNames(JavafxTreeInfo.firstFlag(flags & set2)));
            return false;
        }
        return true;
    }

    long checkFlags(JCDiagnostic.DiagnosticPosition pos, long flags, Symbol sym, JFXTree tree) {
        long mask;
        String thing;
        String msg = "javafx.mod.not.allowed.on";
        boolean isScriptLevel = (flags & 8L) != 0L;
        switch (sym.kind) {
            case 4: {
                boolean isDef = (flags & 0x20000000000L) != 0L;
                String string = thing = isDef ? "def" : "var";
                if (sym.owner.kind != 2) {
                    mask = 0x200000000L;
                    msg = "javafx.mod.not.allowed.on.local";
                    break;
                }
                if (isDef) {
                    mask = 21990232555535L;
                    msg = "javafx.mod.not.allowed.on";
                    break;
                }
                if (isScriptLevel) {
                    mask = 21990232555535L;
                    msg = "javafx.mod.not.allowed.on.script";
                    break;
                }
                mask = 30786325577735L;
                msg = "javafx.mod.not.allowed.on.instance";
                break;
            }
            case 16: {
                if (isScriptLevel) {
                    mask = 18141941858319L;
                    msg = "javafx.mod.not.allowed.on.script";
                } else {
                    mask = 19241453487111L;
                }
                thing = "function";
                break;
            }
            case 2: {
                mask = 17592186045455L;
                thing = "class";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long illegal = flags & 0x1D800000040FL & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        if (illegal != 0L) {
            this.log.error(pos, msg, JavafxTreeInfo.flagNames(illegal), thing);
        } else if (sym.kind != 2 && !this.checkDisjoint(pos, flags, 1024L, 10L) || !this.checkDisjoint(pos, flags, 1536L, 304L) || !this.checkDisjoint(pos, flags, 1L, 0x300000000006L) || !this.checkDisjoint(pos, flags, 2L, 0x300000000005L) || !this.checkDisjoint(pos, flags, 0x200000000000L, 0x100000000007L) || !this.checkDisjoint(pos, flags, 0x100000000000L, 0x200000000007L) || sym.kind != 2 && !this.checkDisjoint(pos, flags, 1280L, 2048L) || !this.checkDisjointWarn(pos, flags, 1L, 0xC0000000000L) || this.checkDisjointWarn(pos, flags, 0x80000000000L, 0x40000000000L)) {
            // empty if block
        }
        return flags & (illegal ^ 0xFFFFFFFFFFFFFFFFL);
    }

    void validate(JFXTree tree) {
        try {
            if (tree != null) {
                tree.accept(this.validator);
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(tree.pos(), ex);
        }
    }

    void validate(List<? extends JFXTree> trees) {
        List<JFXTree> l = trees;
        while (l.nonEmpty()) {
            this.validate((JFXTree)l.head);
            l = l.tail;
        }
    }

    boolean subset(Type t, List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (this.types.isSubtype(t, (Type)l.head)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    boolean intersects(Type t, List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (this.types.isSubtype(t, (Type)l.head) || this.types.isSubtype((Type)l.head, t)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    List<Type> incl(Type t, List<Type> ts) {
        return this.subset(t, ts) ? ts : this.excl(t, ts).prepend(t);
    }

    List<Type> excl(Type t, List<Type> ts) {
        if (ts.isEmpty()) {
            return ts;
        }
        List<Type> ts1 = this.excl(t, ts.tail);
        if (this.types.isSubtype((Type)ts.head, t)) {
            return ts1;
        }
        if (ts1 == ts.tail) {
            return ts;
        }
        return ts1.prepend((Type)ts.head);
    }

    List<Type> union(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = ts1;
        List<Type> l = ts2;
        while (l.nonEmpty()) {
            ts = this.incl((Type)l.head, ts);
            l = l.tail;
        }
        return ts;
    }

    List<Type> diff(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = ts1;
        List<Type> l = ts2;
        while (l.nonEmpty()) {
            ts = this.excl((Type)l.head, ts);
            l = l.tail;
        }
        return ts;
    }

    public List<Type> intersect(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = List.nil();
        List<Type> l = ts1;
        while (l.nonEmpty()) {
            if (this.subset((Type)l.head, ts2)) {
                ts = this.incl((Type)l.head, ts);
            }
            l = l.tail;
        }
        l = ts2;
        while (l.nonEmpty()) {
            if (this.subset((Type)l.head, ts1)) {
                ts = this.incl((Type)l.head, ts);
            }
            l = l.tail;
        }
        return ts;
    }

    boolean isUnchecked(Symbol.ClassSymbol exc) {
        return exc.kind == 31 || exc.isSubClass(this.syms.errorType.tsym, this.types) || exc.isSubClass(this.syms.runtimeExceptionType.tsym, this.types);
    }

    boolean isUnchecked(Type exc) {
        return exc.tag == 14 ? this.isUnchecked(this.types.supertype(exc)) : (exc.tag == 10 ? this.isUnchecked((Symbol.ClassSymbol)exc.tsym) : exc.tag == 17);
    }

    boolean isUnchecked(JCDiagnostic.DiagnosticPosition pos, Type exc) {
        try {
            return this.isUnchecked(exc);
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(pos, ex);
            return true;
        }
    }

    boolean isHandled(Type exc, List<Type> handled) {
        return this.isUnchecked(exc) || this.subset(exc, handled);
    }

    List<Type> unHandled(List<Type> thrown, List<Type> handled) {
        List<Type> unhandled = List.nil();
        List<Type> l = thrown;
        while (l.nonEmpty()) {
            if (!this.isHandled((Type)l.head, handled)) {
                unhandled = unhandled.prepend((Type)l.head);
            }
            l = l.tail;
        }
        return unhandled;
    }

    static int protection(long flags) {
        switch ((short)(flags & 7L)) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            default: {
                return 0;
            }
            case 0: 
        }
        return (flags & 0x200000000000L) == 0L ? 2 : 3;
    }

    public static String protectionString(long flags) {
        long flags1 = flags & 0x300000000007L;
        return JavafxTreeInfo.flagNames(flags1);
    }

    static Object cannotOverride(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String key = (other.owner.flags() & 0x200L) == 0L ? "cant.override" : ((m.owner.flags() & 0x200L) == 0L ? "cant.implement" : "clashes.with");
        return JCDiagnostic.fragment(key, m, m.location(), other, other.location());
    }

    static Object uncheckedOverrides(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String key = (other.owner.flags() & 0x200L) == 0L ? "unchecked.override" : ((m.owner.flags() & 0x200L) == 0L ? "unchecked.implement" : "unchecked.clash.with");
        return JCDiagnostic.fragment(key, m, m.location(), other, other.location());
    }

    static Object varargsOverrides(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String key = (other.owner.flags() & 0x200L) == 0L ? "varargs.override" : ((m.owner.flags() & 0x200L) == 0L ? "varargs.implement" : "varargs.clash.with");
        return JCDiagnostic.fragment(key, m, m.location(), other, other.location());
    }

    private void checkOverride(JFXTree tree, Symbol.MethodSymbol m, Symbol.MethodSymbol other, Symbol.ClassSymbol origin) {
        if ((m.flags() & 0x80001000L) != 0L || (other.flags() & 0x1000L) != 0L) {
            return;
        }
        if ((m.flags() & 8L) != 0L && (other.flags() & 8L) == 0L) {
            this.log.error(JavafxTreeInfo.diagnosticPositionFor(m, tree), "override.static", JavafxCheck.cannotOverride(m, other));
            return;
        }
        if ((other.flags() & 0x10L) != 0L || (m.flags() & 8L) == 0L && (other.flags() & 8L) != 0L) {
            this.log.error(JavafxTreeInfo.diagnosticPositionFor(m, tree), "override.meth", JavafxCheck.cannotOverride(m, other), JavafxTreeInfo.flagNames(other.flags() & 0x18L));
            return;
        }
        if ((other.flags() & 0x8000000000L) == 0L && (m.flags() & 0x8000000000L) != 0L) {
            this.log.error(JavafxTreeInfo.diagnosticPositionFor(m, tree), "javafx.bound.override.meth", JavafxCheck.cannotOverride(m, other));
            return;
        }
        if ((other.flags() & 0x8000000000L) != 0L && (m.flags() & 0x8000000000L) == 0L) {
            this.log.error(JavafxTreeInfo.diagnosticPositionFor(m, tree), "javafx.non.bound.override.meth", JavafxCheck.cannotOverride(m, other));
            return;
        }
        if ((m.owner.flags() & 0x2000L) != 0L) {
            return;
        }
        Type mt = this.types.memberType(origin.type, m);
        Type ot = this.types.memberType(origin.type, other);
        List<Type> mtvars = mt.getTypeArguments();
        List<Type> otvars = ot.getTypeArguments();
        Type mtres = mt.getReturnType();
        Type otres = this.types.subst(ot.getReturnType(), otvars, mtvars);
        this.overrideWarner.warned = false;
        boolean resultTypesOK = this.types.returnTypeSubstitutable(mt, ot, otres, this.overrideWarner);
        if (!resultTypesOK) {
            if (this.source.allowCovariantReturns() || m.owner == origin || !m.owner.isSubClass(other.owner, this.types)) {
                this.typeError(JavafxTreeInfo.diagnosticPositionFor(m, tree), JCDiagnostic.fragment("override.incompatible.ret", JavafxCheck.cannotOverride(m, other)), mtres, otres);
                return;
            }
        } else if (this.overrideWarner.warned) {
            this.warnUnchecked(JavafxTreeInfo.diagnosticPositionFor(m, tree), "prob.found.req", JCDiagnostic.fragment("override.unchecked.ret", JavafxCheck.uncheckedOverrides(m, other)), mtres, otres);
        }
        List<Type> otthrown = this.types.subst(ot.getThrownTypes(), otvars, mtvars);
        List<Type> unhandled = this.unHandled(mt.getThrownTypes(), otthrown);
        if (unhandled.nonEmpty()) {
            this.log.error(JavafxTreeInfo.diagnosticPositionFor(m, tree), "override.meth.doesnt.throw", JavafxCheck.cannotOverride(m, other), unhandled.head);
            return;
        }
        if (((m.flags() ^ other.flags()) & 0x400000000L) != 0L && this.lint.isEnabled(Lint.LintCategory.OVERRIDES)) {
            this.log.warning(JavafxTreeInfo.diagnosticPositionFor(m, tree), (m.flags() & 0x400000000L) != 0L ? "override.varargs.missing" : "override.varargs.extra", JavafxCheck.varargsOverrides(m, other));
        }
        if ((other.flags() & 0x80000000L) != 0L) {
            this.log.warning(JavafxTreeInfo.diagnosticPositionFor(m, tree), "override.bridge", JavafxCheck.uncheckedOverrides(m, other));
        }
        if ((other.flags() & 0x20000L) != 0L && (m.flags() & 0x20000L) == 0L && m.outermostClass() != other.outermostClass() && !this.isDeprecatedOverrideIgnorable(other, origin)) {
            this.warnDeprecated(JavafxTreeInfo.diagnosticPositionFor(m, tree), other);
        }
    }

    private boolean isDeprecatedOverrideIgnorable(Symbol.MethodSymbol m, Symbol.ClassSymbol origin) {
        Symbol.ClassSymbol mc = m.enclClass();
        Type st = this.types.supertype(origin.type);
        if (st.tag != 10) {
            return true;
        }
        Symbol.MethodSymbol stimpl = this.types.implementation(m, (Symbol.ClassSymbol)st.tsym, false);
        if (mc != null && (mc.flags() & 0x200L) != 0L) {
            List<Type> intfs = this.types.interfaces(origin.type);
            return intfs.contains(mc.type) ? false : stimpl != null;
        }
        return stimpl != m;
    }

    private void checkCompatibleConcretes(JCDiagnostic.DiagnosticPosition pos, Type site) {
        Type sup = this.types.supertype(site);
        if (sup.tag != 10) {
            return;
        }
        Type t1 = sup;
        while (t1.tsym.type.isParameterized()) {
            Scope.Entry e1 = t1.tsym.members().elems;
            while (e1 != null) {
                Symbol s1 = e1.sym;
                if (s1.kind == 16 && (s1.flags() & 0x80001008L) == 0L && s1.isInheritedIn(site.tsym, this.types) && this.types.implementation((Symbol.MethodSymbol)s1, site.tsym, true) == s1) {
                    Type st1 = this.types.memberType(t1, s1);
                    int s1ArgsLength = st1.getParameterTypes().length();
                    if (st1 != s1.type) {
                        Type t2 = sup;
                        while (t2.tag == 10) {
                            Scope.Entry e2 = t1.tsym.members().lookup(s1.name);
                            while (e2.scope != null) {
                                Type st2;
                                Symbol s2 = e2.sym;
                                if (s2 != s1 && s2.kind == 16 && (s2.flags() & 0x80001008L) == 0L && s2.type.getParameterTypes().length() == s1ArgsLength && s2.isInheritedIn(site.tsym, this.types) && this.types.implementation((Symbol.MethodSymbol)s2, site.tsym, true) == s2 && this.types.overrideEquivalent(st1, st2 = this.types.memberType(t2, s2))) {
                                    this.log.error(pos, "concrete.inheritance.conflict", s1, t1, s2, t2, sup);
                                }
                                e2 = e2.next();
                            }
                            t2 = this.types.supertype(t2);
                        }
                    }
                }
                e1 = e1.sibling;
            }
            t1 = this.types.supertype(t1);
        }
    }

    private boolean checkCompatibleAbstracts(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2) {
        return this.checkCompatibleAbstracts(pos, t1, t2, this.types.makeCompoundType(t1, t2));
    }

    private boolean checkCompatibleAbstracts(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2, Type site) {
        Symbol sym = this.firstIncompatibility(t1, t2, site);
        if (sym != null) {
            this.log.error(pos, "types.incompatible.diff.ret", t1, t2, sym.name + "(" + this.types.memberType(t2, sym).getParameterTypes() + ")");
            return false;
        }
        return true;
    }

    private Symbol firstIncompatibility(Type t1, Type t2, Type site) {
        HashMap<Symbol.TypeSymbol, Type> interfaces2;
        HashMap<Symbol.TypeSymbol, Type> interfaces1 = new HashMap<Symbol.TypeSymbol, Type>();
        this.closure(t1, interfaces1);
        if (t1 == t2) {
            interfaces2 = interfaces1;
        } else {
            interfaces2 = new HashMap<Symbol.TypeSymbol, Type>();
            this.closure(t2, interfaces1, interfaces2);
        }
        for (Type t3 : interfaces1.values()) {
            for (Type t4 : interfaces2.values()) {
                Symbol s = this.firstDirectIncompatibility(t3, t4, site);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    private void closure(Type t, Map<Symbol.TypeSymbol, Type> typeMap) {
        if (t.tag != 10) {
            return;
        }
        if (typeMap.put(t.tsym, t) == null) {
            this.closure(this.types.supertype(t), typeMap);
            for (Type i : this.types.interfaces(t)) {
                this.closure(i, typeMap);
            }
        }
    }

    private void closure(Type t, Map<Symbol.TypeSymbol, Type> typesSkip, Map<Symbol.TypeSymbol, Type> typeMap) {
        if (t.tag != 10) {
            return;
        }
        if (typesSkip.get(t.tsym) != null) {
            return;
        }
        if (typeMap.put(t.tsym, t) == null) {
            this.closure(this.types.supertype(t), typesSkip, typeMap);
            for (Type i : this.types.interfaces(t)) {
                this.closure(i, typesSkip, typeMap);
            }
        }
    }

    private Symbol firstDirectIncompatibility(Type t1, Type t2, Type site) {
        Scope.Entry e1 = t1.tsym.members().elems;
        while (e1 != null) {
            Symbol.MethodSymbol impl;
            Symbol s1 = e1.sym;
            Type st1 = null;
            if (s1.kind == 16 && s1.name != this.defs.internalRunFunctionName && s1.isInheritedIn(site.tsym, this.types) && ((impl = this.types.implementation((Symbol.MethodSymbol)s1, site.tsym, false)) == null || (impl.flags() & 0x400L) != 0L)) {
                Scope.Entry e2 = t2.tsym.members().lookup(s1.name);
                while (e2.scope != null) {
                    Symbol s2 = e2.sym;
                    if (s1 != s2 && s2.kind == 16 && s2.isInheritedIn(site.tsym, this.types)) {
                        Type st2;
                        if (st1 == null) {
                            st1 = this.types.memberType(t1, s1);
                        }
                        if (this.types.overrideEquivalent(st1, st2 = this.types.memberType(t2, s2))) {
                            Type rt2;
                            boolean compat;
                            List<Type> tvars1 = st1.getTypeArguments();
                            List<Type> tvars2 = st2.getTypeArguments();
                            Type rt1 = st1.getReturnType();
                            boolean bl = compat = this.types.isSameType(rt1, rt2 = this.types.subst(st2.getReturnType(), tvars2, tvars1)) || rt1.tag >= 10 && rt2.tag >= 10 && (this.types.covariantReturnType(rt1, rt2, Warner.noWarnings) || this.types.covariantReturnType(rt2, rt1, Warner.noWarnings));
                            if (!compat) {
                                return s2;
                            }
                        }
                    }
                    e2 = e2.next();
                }
            }
            e1 = e1.sibling;
        }
        return null;
    }

    void checkOverride(JFXTree tree, Symbol.MethodSymbol m) {
        boolean declaredOverride;
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)m.owner;
        boolean doesOverride = false;
        if ((origin.flags() & 0x4000L) != 0L && this.names.finalize.equals(m.name) && m.overrides(this.syms.enumFinalFinalize, origin, this.types, false)) {
            this.log.error(tree.pos(), "enum.no.finalize", new Object[0]);
            return;
        }
        ListBuffer<Type> supertypes = ListBuffer.lb();
        HashSet<Type> superSet = new HashSet<Type>();
        this.types.getSupertypes(origin, supertypes, superSet);
        for (Type t : supertypes) {
            if (t.tag != 10) continue;
            Symbol.TypeSymbol c = t.tsym;
            Scope.Entry e = c.members().lookup(m.name);
            while (e.scope != null) {
                e.sym.complete();
                if (m.overrides(e.sym, origin, this.types, false)) {
                    this.checkOverride(tree, m, (Symbol.MethodSymbol)e.sym, origin);
                    doesOverride = true;
                }
                e = e.next();
            }
        }
        boolean bl = declaredOverride = (m.flags() & 0x10000000000L) != 0L;
        if (doesOverride) {
            if (!declaredOverride && (m.flags() & 0x1008L) == 0L) {
                this.log.warning(tree.pos(), "javafx.function.overrides.another.should.be.declared.override", m);
            }
        } else if (declaredOverride) {
            this.log.error(tree.pos(), "javafx.function.declared.overrride.does.not.override", m);
        }
    }

    void checkAllDefined(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        try {
            Symbol.MethodSymbol undef = this.firstUndef(c, c);
            if (undef != null) {
                if ((c.flags() & 0x4000L) != 0L && this.types.supertype((Type)c.type).tsym == this.syms.enumSym && (c.flags() & 0x10L) == 0L) {
                    c.flags_field |= 0x400L;
                } else {
                    Symbol.MethodSymbol undef1 = new Symbol.MethodSymbol(undef.flags(), undef.name, this.types.memberType(c.type, undef), undef.owner);
                    this.log.error(pos, "does.not.override.abstract", c, undef1, undef1.location());
                }
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(pos, ex);
        }
    }

    private Symbol.MethodSymbol firstUndef(Symbol.ClassSymbol impl, Symbol.ClassSymbol c) {
        Symbol.MethodSymbol undef = null;
        if (c == impl || (c.flags() & 0x600L) != 0L) {
            Scope s = c.members();
            Scope.Entry e = s.elems;
            while (undef == null && e != null) {
                Symbol.MethodSymbol absmeth;
                Symbol.MethodSymbol implmeth;
                if (e.sym.kind == 16 && (e.sym.flags() & 0x200400L) == 1024L && ((implmeth = this.types.implementation(absmeth = (Symbol.MethodSymbol)e.sym, impl, true)) == null || implmeth == absmeth)) {
                    undef = absmeth;
                }
                e = e.sibling;
            }
            if (undef == null) {
                Type st = this.types.supertype(c.type);
                if (st.tag == 10) {
                    undef = this.firstUndef(impl, (Symbol.ClassSymbol)st.tsym);
                }
            }
            List<Type> l = this.types.interfaces(c.type);
            while (undef == null && l.nonEmpty()) {
                undef = this.firstUndef(impl, (Symbol.ClassSymbol)((Type)l.head).tsym);
                l = l.tail;
            }
        }
        return undef;
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition pos, Type t) {
        this.checkNonCyclicInternal(pos, t);
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition pos, Type.TypeVar t) {
        this.checkNonCyclic1(pos, t, new HashSet<Type.TypeVar>());
    }

    private void checkNonCyclic1(JCDiagnostic.DiagnosticPosition pos, Type t, Set<Type.TypeVar> seen) {
        if (seen.contains(t)) {
            Type.TypeVar tv = (Type.TypeVar)t;
            tv.bound = new Type.ErrorType();
            this.log.error(pos, "cyclic.inheritance", t);
        } else if (t.tag == 14) {
            Type.TypeVar tv = (Type.TypeVar)t;
            seen.add(tv);
            for (Type b : this.types.getBounds(tv)) {
                this.checkNonCyclic1(pos, b, seen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNonCyclicInternal(JCDiagnostic.DiagnosticPosition pos, Type t) {
        boolean complete = true;
        Symbol.TypeSymbol c = t.tsym;
        if ((c.flags_field & 0x40000000L) != 0L) {
            return true;
        }
        if ((c.flags_field & 0x8000000L) != 0L) {
            this.noteCyclic(pos, (Symbol.ClassSymbol)c);
        } else if (!c.type.isErroneous()) {
            try {
                c.flags_field |= 0x8000000L;
                if (c.type.tag == 10) {
                    Type st;
                    Type.ClassType clazz = (Type.ClassType)c.type;
                    if (clazz.interfaces_field != null) {
                        List<Type> l = clazz.interfaces_field;
                        while (l.nonEmpty()) {
                            complete &= this.checkNonCyclicInternal(pos, (Type)l.head);
                            l = l.tail;
                        }
                    }
                    if (clazz.supertype_field != null && (st = clazz.supertype_field) != null && st.tag == 10) {
                        complete &= this.checkNonCyclicInternal(pos, st);
                    }
                    if (c.owner.kind == 2) {
                        complete &= this.checkNonCyclicInternal(pos, c.owner.type);
                    }
                }
            }
            finally {
                c.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
        }
        if (complete) {
            boolean bl = complete = (c.flags_field & 0x10000000L) == 0L && c.completer == null;
        }
        if (complete) {
            c.flags_field |= 0x40000000L;
        }
        return complete;
    }

    private void noteCyclic(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        this.log.error(pos, "cyclic.inheritance", c);
        List<Type> l = this.types.interfaces(c.type);
        while (l.nonEmpty()) {
            l.head = new Type.ErrorType((Symbol.ClassSymbol)((Type)l.head).tsym);
            l = l.tail;
        }
        Type st = this.types.supertype(c.type);
        if (st.tag == 10) {
            ((Type.ClassType)c.type).supertype_field = new Type.ErrorType((Symbol.ClassSymbol)st.tsym);
        }
        c.type = new Type.ErrorType(c);
        c.flags_field |= 0x40000000L;
    }

    void checkImplementations(JFXClassDeclaration tree) {
        this.checkImplementations(tree, tree.sym);
    }

    void checkImplementations(JFXClassDeclaration tree, Symbol.ClassSymbol ic) {
        Symbol.ClassSymbol origin = tree.sym;
        List<Type> l = this.types.closure(ic.type);
        while (l.nonEmpty()) {
            Symbol.ClassSymbol lc = (Symbol.ClassSymbol)((Type)l.head).tsym;
            if ((this.allowGenerics || origin != lc) && (lc.flags() & 0x400L) != 0L) {
                Scope.Entry e = lc.members().elems;
                while (e != null) {
                    Symbol.MethodSymbol absmeth;
                    Symbol.MethodSymbol implmeth;
                    if (e.sym.kind == 16 && (e.sym.flags() & 0x408L) == 1024L && (implmeth = this.types.implementation(absmeth = (Symbol.MethodSymbol)e.sym, origin, false)) != null && implmeth != absmeth && (implmeth.owner.flags() & 0x200L) == (origin.flags() & 0x200L)) {
                        this.checkOverride(tree, implmeth, absmeth, origin);
                    }
                    e = e.sibling;
                }
            }
            l = l.tail;
        }
    }

    void checkCompatibleSupertypes(JCDiagnostic.DiagnosticPosition pos, Type c) {
        List<Type> supertypes = this.types.interfaces(c);
        Type supertype = this.types.supertype(c);
        if (supertype.tag == 10 && (supertype.tsym.flags() & 0x400L) != 0L) {
            supertypes = supertypes.prepend(supertype);
        }
        List<Type> l = supertypes;
        while (l.nonEmpty()) {
            if (this.allowGenerics && !((Type)l.head).getTypeArguments().isEmpty() && !this.checkCompatibleAbstracts(pos, (Type)l.head, (Type)l.head, c)) {
                return;
            }
            List<Type> m = supertypes;
            while (m != l) {
                if (!this.checkCompatibleAbstracts(pos, (Type)l.head, (Type)m.head, c)) {
                    return;
                }
                m = m.tail;
            }
            l = l.tail;
        }
        this.checkCompatibleConcretes(pos, c);
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition pos, Type type) {
        this.checkClassBounds(pos, new HashMap<Symbol.TypeSymbol, Type>(), type);
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition pos, Map<Symbol.TypeSymbol, Type> seensofar, Type type) {
        if (type.isErroneous()) {
            return;
        }
        List<Type> l = this.types.interfaces(type);
        while (l.nonEmpty()) {
            List<Type> newparams;
            List<Type> oldparams;
            Type it = (Type)l.head;
            Type oldit = seensofar.put(it.tsym, it);
            if (oldit != null && !this.types.containsTypeEquivalent(oldparams = oldit.allparams(), newparams = it.allparams())) {
                this.log.error(pos, "cant.inherit.diff.arg", it.tsym, Type.toString(oldparams), Type.toString(newparams));
            }
            this.checkClassBounds(pos, seensofar, it);
            l = l.tail;
        }
        Type st = this.types.supertype(type);
        if (st != null) {
            this.checkClassBounds(pos, seensofar, st);
        }
    }

    void checkNotRepeated(JCDiagnostic.DiagnosticPosition pos, Type it, Set<Type> its) {
        if (its.contains(it)) {
            this.log.error(pos, "repeated.interface", new Object[0]);
        } else {
            its.add(it);
        }
    }

    int checkOperator(JCDiagnostic.DiagnosticPosition pos, Symbol.OperatorSymbol operator, JavafxTag tag, Type left, Type right) {
        if (operator.opcode == 277) {
            this.log.error(pos, "operator.cant.be.applied", this.treeinfo.operatorName(tag), left + "," + right);
        }
        return operator.opcode;
    }

    void checkDivZero(JCDiagnostic.DiagnosticPosition pos, Symbol operator, Type operand) {
        int opc;
        if (operand.constValue() != null && this.lint.isEnabled(Lint.LintCategory.DIVZERO) && operand.tag <= 5 && ((Number)operand.constValue()).longValue() == 0L && ((opc = ((Symbol.OperatorSymbol)operator).opcode) == 108 || opc == 112 || opc == 109 || opc == 113)) {
            this.log.warning(pos, "div.zero", new Object[0]);
        }
    }

    boolean checkUnique(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s) {
        if (sym.type != null && sym.type.isErroneous()) {
            return true;
        }
        if (sym.owner.name == this.names.any) {
            return false;
        }
        Scope.Entry e = s.lookup(sym.name);
        while (e.scope == s) {
            sym.complete();
            if (sym != e.sym && sym.kind == e.sym.kind && sym.name != this.names.error && (sym.kind != 16 || this.types.overrideEquivalent(sym.type, e.sym.type))) {
                if ((sym.flags() & 0x400000000L) != (e.sym.flags() & 0x400000000L)) {
                    this.varargsDuplicateError(pos, sym, e.sym);
                } else {
                    this.duplicateError(pos, e.sym);
                }
                return false;
            }
            e = e.next();
        }
        return true;
    }

    boolean checkUniqueImport(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s) {
        return this.checkUniqueImport(pos, sym, s, false);
    }

    boolean checkUniqueStaticImport(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s) {
        return this.checkUniqueImport(pos, sym, s, true);
    }

    private boolean checkUniqueImport(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s, boolean staticImport) {
        Scope.Entry e = s.lookup(sym.name);
        while (e.scope != null) {
            boolean isClassDecl;
            boolean bl = isClassDecl = e.scope == s;
            if ((isClassDecl || sym != e.sym) && sym.kind == e.sym.kind && sym.name != this.names.error) {
                if (!e.sym.type.isErroneous()) {
                    String what = e.sym.toString();
                    if (!isClassDecl) {
                        if (staticImport) {
                            this.log.error(pos, "already.defined.static.single.import", what);
                        } else {
                            this.log.error(pos, "already.defined.single.import", what);
                        }
                    } else if (sym != e.sym) {
                        this.log.error(pos, "already.defined.this.unit", what);
                    }
                }
                return false;
            }
            e = e.next();
        }
        return true;
    }

    public void checkCanonical(JFXTree tree) {
        if (!this.isCanonical(tree)) {
            this.log.error(tree.pos(), "import.requires.canonical", JavafxTreeInfo.symbol(tree));
        }
    }

    private boolean isCanonical(JFXTree tree) {
        while (tree.getFXTag() == JavafxTag.SELECT) {
            JFXSelect s = (JFXSelect)tree;
            if (s.sym.owner != JavafxTreeInfo.symbol(s.selected)) {
                return false;
            }
            tree = s.selected;
        }
        return true;
    }

    public Warner castWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type expected) {
        return new ConversionWarner(pos, "unchecked.cast.to.type", found, expected);
    }

    public Warner convertWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type expected) {
        return new ConversionWarner(pos, "unchecked.assign", found, expected);
    }

    public void warnEmptyRangeLiteral(JCDiagnostic.DiagnosticPosition pos, JFXLiteral lower, JFXLiteral upper, JFXLiteral step, boolean isExclusive) {
        double stepValue;
        double lowerValue = ((Number)lower.getValue()).doubleValue();
        double upperValue = ((Number)upper.getValue()).doubleValue();
        double d = stepValue = step != null ? ((Number)step.getValue()).doubleValue() : 1.0;
        if (stepValue > 0.0 && lowerValue > upperValue || stepValue < 0.0 && lowerValue < upperValue || isExclusive && lowerValue == upperValue) {
            this.log.warning(pos, "javafx.range.literal.empty", new Object[0]);
        }
    }

    public Type checkFunctionType(JCDiagnostic.DiagnosticPosition pos, Type.MethodType m) {
        if (m.argtypes.length() > 8) {
            this.log.error(pos, "javafx.too.many.parameters", new Object[0]);
            return this.syms.errType;
        }
        return this.syms.makeFunctionType(m);
    }

    private class ConversionWarner
    extends Warner {
        final String key;
        final Type found;
        final Type expected;

        public ConversionWarner(JCDiagnostic.DiagnosticPosition pos, String key, Type found, Type expected) {
            super(pos);
            this.key = key;
            this.found = found;
            this.expected = expected;
        }

        public void warnUnchecked() {
            boolean localWarned = this.warned;
            super.warnUnchecked();
            if (localWarned) {
                return;
            }
            JCDiagnostic problem = JCDiagnostic.fragment(this.key, new Object[0]);
            JavafxCheck.this.warnUnchecked(this.pos(), "prob.found.req", problem, this.found, this.expected);
        }
    }

    class Validator
    extends JavafxTreeScanner {
        Validator() {
        }

        public void visitSelect(JFXSelect tree) {
            if (tree.type.tag == 10) {
                this.visitSelectInternal(tree);
                if (tree.selected.type.isParameterized() && tree.type.tsym.type.getTypeArguments().nonEmpty()) {
                    JavafxCheck.this.log.error(tree.pos(), "improperly.formed.type.param.missing", new Object[0]);
                }
            }
        }

        public void visitSelectInternal(JFXSelect tree) {
            if (tree.type.getEnclosingType().tag != 10 && tree.selected.type.isParameterized()) {
                JavafxCheck.this.log.error(tree.pos(), "cant.select.static.class.from.param.type", new Object[0]);
            } else {
                JavafxCheck.this.validate(tree.selected);
            }
        }

        public void visitTree(JFXTree tree) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WriteKind {
        ASSIGN,
        INIT_NON_BIND,
        INIT_BIND,
        VAR_QUERY;

    }
}

