/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.code.JavafxClassSymbol;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.comp.JavafxDefs;
import com.sun.tools.javafx.main.JavafxCompiler;
import java.util.IdentityHashMap;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxClassReader
extends ClassReader {
    protected static final Context.Key<ClassReader> backendClassReaderKey = new Context.Key();
    private final JavafxDefs defs;
    public ClassReader jreader;
    private final Name functionClassPrefixName;
    private Context ctx;
    IdentityHashMap<Object, Object> typeMap = new IdentityHashMap();

    public static void registerBackendReader(Context context, ClassReader jreader) {
        context.put(backendClassReaderKey, jreader);
    }

    public static void preRegister(Context context, ClassReader jreader) {
        JavafxClassReader.registerBackendReader(context, jreader);
        JavafxClassReader.preRegister(context);
    }

    public static void preRegister(final Context context) {
        context.put(classReaderKey, new Context.Factory<ClassReader>(){

            @Override
            public JavafxClassReader make() {
                JavafxClassReader reader = new JavafxClassReader(context, true);
                reader.jreader = context.get(backendClassReaderKey);
                return reader;
            }
        });
    }

    public static JavafxClassReader instance(Context context) {
        JavafxClassReader instance = (JavafxClassReader)context.get(classReaderKey);
        if (instance == null) {
            instance = new JavafxClassReader(context, true);
        }
        return instance;
    }

    protected JavafxClassReader(Context context, boolean definitive) {
        super(context, definitive);
        this.defs = JavafxDefs.instance(context);
        this.functionClassPrefixName = this.names.fromString("com.sun.javafx.functions.Function");
        this.ctx = context;
    }

    public Name.Table getNames() {
        return this.names;
    }

    void fixupFullname(JavafxClassSymbol cSym, Symbol.ClassSymbol jsymbol) {
        if (cSym.fullname != jsymbol.fullname && cSym.owner.kind == 1 && jsymbol.owner.kind == 2) {
            cSym.owner.members().remove(cSym);
            cSym.name = jsymbol.name;
            Symbol.ClassSymbol owner = this.enterClass(((Symbol.ClassSymbol)jsymbol.owner).flatname);
            cSym.owner = owner;
            cSym.fullname = Symbol.ClassSymbol.formFullName(cSym.name, owner);
        }
    }

    public JavafxClassSymbol enterClass(Symbol.ClassSymbol jsymbol) {
        Name className = jsymbol.flatname;
        boolean compound = className.endsWith(this.defs.interfaceSuffixName);
        if (compound) {
            className = className.subName(0, className.len - this.defs.interfaceSuffixName.len);
        }
        JavafxClassSymbol cSym = (JavafxClassSymbol)this.enterClass(className);
        if (compound) {
            cSym.flags_field |= 0x800000000000L;
        } else {
            this.fixupFullname(cSym, jsymbol);
            cSym.jsymbol = jsymbol;
        }
        return cSym;
    }

    @Override
    public Symbol.ClassSymbol defineClass(Name name, Symbol owner) {
        JavafxClassSymbol c = new JavafxClassSymbol(0L, name, owner);
        if (owner.kind == 1) assert (this.classes.get(c.flatname) == null) : c;
        c.completer = this;
        return c;
    }

    List<Type> translateTypes(List<Type> types) {
        if (types == null) {
            return null;
        }
        List<Type> ts = (List<Type>)this.typeMap.get(types);
        if (ts != null) {
            return ts;
        }
        ListBuffer<Type> rs = new ListBuffer<Type>();
        List<Type> t = types;
        while (t.tail != null) {
            rs.append(this.translateType((Type)t.head));
            t = t.tail;
        }
        ts = rs.toList();
        this.typeMap.put(types, ts);
        return ts;
    }

    Type translateType(Type type) {
        if (type == null) {
            return null;
        }
        Type t = (Type)this.typeMap.get(type);
        if (t != null) {
            return t;
        }
        switch (type.tag) {
            case 9: {
                t = this.syms.voidType;
                break;
            }
            case 8: {
                t = this.syms.booleanType;
                break;
            }
            case 2: {
                t = this.syms.charType;
                break;
            }
            case 1: {
                t = this.syms.byteType;
                break;
            }
            case 3: {
                t = this.syms.shortType;
                break;
            }
            case 4: {
                t = this.syms.intType;
                break;
            }
            case 5: {
                t = this.syms.longType;
                break;
            }
            case 7: {
                t = this.syms.doubleType;
                break;
            }
            case 6: {
                t = this.syms.floatType;
                break;
            }
            case 14: {
                Type.TypeVar tv = (Type.TypeVar)type;
                Type.TypeVar tx = new Type.TypeVar(null, (Type)null, (Type)null);
                this.typeMap.put(type, tx);
                tx.bound = this.translateType(tv.bound);
                tx.lower = this.translateType(tv.lower);
                tx.tsym = new Symbol.TypeSymbol(0L, tv.tsym.name, tx, this.translateSymbol(tv.tsym.owner));
                return tx;
            }
            case 16: {
                Type.ForAll tf = (Type.ForAll)type;
                t = new Type.ForAll(this.translateTypes(tf.tvars), this.translateType(tf.qtype));
                break;
            }
            case 15: {
                Type.WildcardType wt = (Type.WildcardType)type;
                t = new Type.WildcardType(this.translateType(wt.type), wt.kind, this.translateTypeSymbol(wt.tsym));
                break;
            }
            case 10: {
                Symbol.TypeSymbol tsym = type.tsym;
                if (!(tsym instanceof Symbol.ClassSymbol)) break;
                if (tsym.name.endsWith(this.defs.interfaceSuffixName)) {
                    t = this.enterClass((Symbol.ClassSymbol)((Symbol.ClassSymbol)tsym)).type;
                    break;
                }
                final Type.ClassType ctype = (Type.ClassType)type;
                if (ctype.isCompound()) {
                    t = this.types.makeCompoundType(this.translateTypes(ctype.interfaces_field), this.translateType(ctype.supertype_field));
                    break;
                }
                Name flatname = ((Symbol.ClassSymbol)tsym).flatname;
                Type deloc = this.defs.delocationize(flatname);
                if (deloc != null) {
                    if (deloc == this.syms.intType || deloc == this.syms.doubleType || deloc == this.syms.booleanType) {
                        return deloc;
                    }
                    if (ctype.typarams_field != null && ctype.typarams_field.size() == 1) {
                        if (deloc == this.syms.objectType) {
                            return this.translateType((Type)ctype.typarams_field.head);
                        }
                        if (deloc == ((JavafxSymtab)this.syms).javafx_SequenceType) {
                            Type tparam = this.translateType((Type)ctype.typarams_field.head);
                            Type.WildcardType tpType = new Type.WildcardType(tparam, BoundKind.EXTENDS, tparam.tsym);
                            t = new Type.ClassType(Type.noType, List.of(tpType), ((JavafxSymtab)this.syms).javafx_SequenceType.tsym);
                            break;
                        }
                    }
                }
                if (flatname.startsWith(this.functionClassPrefixName) && flatname != this.functionClassPrefixName) {
                    t = ((JavafxSymtab)this.syms).makeFunctionType(this.translateTypes(ctype.typarams_field));
                    break;
                }
                Symbol.TypeSymbol sym = this.translateTypeSymbol(tsym);
                Type.ClassType ntype = tsym.type == type ? (Type.ClassType)sym.type : new Type.ClassType(Type.noType, List.nil(), sym){
                    boolean completed;
                    {
                        super(x0, x1, x2);
                        this.completed = false;
                    }

                    public Type getEnclosingType() {
                        if (!this.completed) {
                            this.completed = true;
                            this.tsym.complete();
                            super.setEnclosingType(JavafxClassReader.this.translateType(ctype.getEnclosingType()));
                        }
                        return super.getEnclosingType();
                    }

                    public void setEnclosingType(Type outer) {
                        throw new UnsupportedOperationException();
                    }

                    public boolean equals(Object t) {
                        return super.equals(t);
                    }

                    public int hashCode() {
                        return super.hashCode();
                    }
                };
                this.typeMap.put(type, ntype);
                ntype.typarams_field = this.translateTypes(type.getTypeArguments());
                return ntype;
            }
            case 11: {
                t = new Type.ArrayType(this.translateType(((Type.ArrayType)type).elemtype), (Symbol.TypeSymbol)this.syms.arrayClass);
                break;
            }
            case 12: {
                t = new Type.MethodType(this.translateTypes(type.getParameterTypes()), this.translateType(type.getReturnType()), this.translateTypes(type.getThrownTypes()), this.syms.methodClass);
                break;
            }
            default: {
                t = type;
            }
        }
        this.typeMap.put(type, t);
        return t;
    }

    Symbol.TypeSymbol translateTypeSymbol(Symbol.TypeSymbol tsym) {
        if (tsym == this.syms.predefClass) {
            return tsym;
        }
        Symbol.ClassSymbol csym = (Symbol.ClassSymbol)tsym;
        return this.enterClass(csym);
    }

    Symbol translateSymbol(Symbol sym) {
        if (sym == null) {
            return null;
        }
        Symbol s = (Symbol)this.typeMap.get(sym);
        if (s != null) {
            return s;
        }
        if (sym instanceof Symbol.PackageSymbol) {
            s = this.enterPackage(((Symbol.PackageSymbol)sym).fullname);
        } else if (sym instanceof Symbol.MethodSymbol) {
            Name name = sym.name;
            long flags = sym.flags_field;
            Symbol owner = this.translateSymbol(sym.owner);
            Type type = this.translateType(sym.type);
            String nameString = name.toString();
            int boundStringIndex = nameString.indexOf("$$bound$");
            if (boundStringIndex != -1) {
                name = this.names.fromString(nameString.substring(0, boundStringIndex));
                flags |= 0x8000000000L;
            }
            Symbol.MethodSymbol m = new Symbol.MethodSymbol(flags, name, type, owner);
            ((Symbol.ClassSymbol)owner).members_field.enter(m);
            s = m;
        } else {
            s = this.translateTypeSymbol((Symbol.TypeSymbol)sym);
        }
        this.typeMap.put(sym, s);
        return s;
    }

    @Override
    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (this.jreader.sourceCompleter == null) {
            this.jreader.sourceCompleter = JavafxCompiler.instance(this.ctx);
        }
        if (sym instanceof Symbol.PackageSymbol) {
            Symbol.PackageSymbol psym = (Symbol.PackageSymbol)sym;
            Symbol.PackageSymbol jpackage = psym == this.syms.unnamedPackage ? this.jreader.syms.unnamedPackage : this.jreader.enterPackage(psym.fullname);
            jpackage.complete();
            if (psym.members_field == null) {
                psym.members_field = new Scope(psym);
            }
            Scope.Entry e = jpackage.members_field.elems;
            while (e != null) {
                if (e.sym instanceof Symbol.ClassSymbol) {
                    Symbol.ClassSymbol jsym = (Symbol.ClassSymbol)e.sym;
                    if (!jsym.name.endsWith(this.defs.interfaceSuffixName)) {
                        JavafxClassSymbol csym = this.enterClass(jsym);
                        psym.members_field.enter(csym);
                        csym.classfile = jsym.classfile;
                        csym.jsymbol = jsym;
                    }
                }
                e = e.sibling;
            }
            if (jpackage.exists()) {
                psym.flags_field |= 0x800000L;
            }
        } else {
            Type itype;
            List<Type> it;
            sym.owner.complete();
            JavafxClassSymbol csym = (JavafxClassSymbol)sym;
            Symbol.ClassSymbol jsymbol = csym.jsymbol;
            if (jsymbol != null && jsymbol.classfile != null && jsymbol.classfile.getKind() == JavaFileObject.Kind.SOURCE && jsymbol.classfile.getName().endsWith(".fx")) {
                JavafxCompiler fxSourceCompleter = JavafxCompiler.instance(this.ctx);
                fxSourceCompleter.complete(csym);
                return;
            }
            csym.jsymbol = jsymbol = this.jreader.loadClass(csym.flatname);
            this.fixupFullname(csym, jsymbol);
            this.typeMap.put(jsymbol, csym);
            jsymbol.classfile = ((Symbol.ClassSymbol)sym).classfile;
            Type.ClassType ct = (Type.ClassType)csym.type;
            Type.ClassType jt = (Type.ClassType)jsymbol.type;
            csym.members_field = new Scope(csym);
            csym.flags_field = this.flagsFromAnnotationsAndFlags(jsymbol);
            ct.typarams_field = this.translateTypes(jt.typarams_field);
            ct.setEnclosingType(this.translateType(jt.getEnclosingType()));
            ct.supertype_field = this.translateType(jt.supertype_field);
            ListBuffer<Type> interfaces = new ListBuffer<Type>();
            Type iface = null;
            if (jt.interfaces_field != null) {
                it = jt.interfaces_field;
                while (it.tail != null) {
                    itype = (Type)it.head;
                    if (((Symbol.ClassSymbol)itype.tsym).flatname == this.defs.fxObjectName) {
                        csym.flags_field |= 0x1000000000000L;
                    } else if (csym.fullname.len + this.defs.interfaceSuffixName.len == ((Symbol.ClassSymbol)itype.tsym).fullname.len && ((Symbol.ClassSymbol)itype.tsym).fullname.startsWith(csym.fullname) && itype.tsym.name.endsWith(this.defs.interfaceSuffixName)) {
                        iface = itype;
                        iface.tsym.complete();
                        csym.flags_field |= 0x800000000000L;
                    } else {
                        itype = this.translateType(itype);
                        interfaces.append(itype);
                    }
                    it = it.tail;
                }
            }
            if (iface != null) {
                it = ((Type.ClassType)iface.tsym.type).interfaces_field;
                while (it.tail != null) {
                    itype = (Type)it.head;
                    if (((Symbol.ClassSymbol)itype.tsym).flatname == this.defs.fxObjectName) {
                        csym.flags_field |= 0x1000000000000L;
                    } else {
                        itype = this.translateType(itype);
                        interfaces.append(itype);
                        csym.addSuperType(itype);
                    }
                    it = it.tail;
                }
            }
            ct.interfaces_field = interfaces.toList();
            List<Symbol> syms = List.nil();
            Scope.Entry e = jsymbol.members_field.elems;
            while (e != null) {
                if ((e.sym.flags_field & 0x1000L) == 0L) {
                    syms = syms.prepend(e.sym);
                }
                e = e.sibling;
            }
            List<Symbol> l = syms;
            while (l.nonEmpty()) {
                block38: {
                    Name name = ((Symbol)l.head).name;
                    long flags = this.flagsFromAnnotationsAndFlags((Symbol)l.head);
                    if ((flags & 2L) == 0L) {
                        boolean sawSourceNameAnnotation = false;
                        JavafxSymtab javafxSyms = (JavafxSymtab)this.syms;
                        for (Attribute.Compound a : ((Symbol)l.head).getAnnotationMirrors()) {
                            if (a.type.tsym.flatName() == javafxSyms.javafx_staticAnnotationType.tsym.flatName()) {
                                flags |= 8L;
                                continue;
                            }
                            if (a.type.tsym.flatName() == javafxSyms.javafx_defAnnotationType.tsym.flatName()) {
                                flags |= 0x20000000000L;
                                continue;
                            }
                            if (a.type.tsym.flatName() == javafxSyms.javafx_publicInitAnnotationType.tsym.flatName()) {
                                flags |= 0x80000000000L;
                                continue;
                            }
                            if (a.type.tsym.flatName() == javafxSyms.javafx_publicReadAnnotationType.tsym.flatName()) {
                                flags |= 0x40000000000L;
                                continue;
                            }
                            if (a.type.tsym.flatName() != javafxSyms.javafx_inheritedAnnotationType.tsym.flatName()) {
                                Attribute aa;
                                Object sourceName;
                                if (a.type.tsym.flatName() != javafxSyms.javafx_sourceNameAnnotationType.tsym.flatName() || !((sourceName = (aa = a.member(name.table.value)).getValue()) instanceof String)) continue;
                                name = this.names.fromString((String)sourceName);
                                sawSourceNameAnnotation = true;
                                continue;
                            }
                            break block38;
                        }
                        if (l.head instanceof Symbol.MethodSymbol) {
                            if (sawSourceNameAnnotation || name != this.defs.internalRunFunctionName && name != this.defs.initializeName && name != this.defs.postInitName && name != this.defs.userInitName && name != this.defs.addTriggersName && name != this.names.clinit && !name.startsWith(this.defs.attributeGetPrefixName) && !name.startsWith(this.defs.attributeSetPrefixName) && !name.startsWith(this.defs.applyDefaultsPrefixName) && !name.endsWith(this.defs.implFunctionSuffixName)) {
                                Type type = this.translateType(((Symbol)l.head).type);
                                String nameString = name.toString();
                                int boundStringIndex = nameString.indexOf("$$bound$");
                                if (boundStringIndex != -1) {
                                    name = this.names.fromString(nameString.substring(0, boundStringIndex));
                                    flags |= 0x8000000000L;
                                }
                                Symbol.MethodSymbol m = new Symbol.MethodSymbol(flags, name, type, csym);
                                csym.members_field.enter(m);
                            }
                        } else if (l.head instanceof Symbol.VarSymbol) {
                            if (!name.endsWith(this.defs.needsDefaultSuffixName)) {
                                Type otype = ((Symbol)l.head).type;
                                if (otype.tag == 10) {
                                    Symbol.TypeSymbol tsym = otype.tsym;
                                    Name flatname = ((Symbol.ClassSymbol)tsym).flatname;
                                    Type deloc = this.defs.delocationize(flatname);
                                    if (deloc != null) {
                                        flags |= 0x800000000000000L;
                                    }
                                }
                                Type type = this.translateType(otype);
                                Symbol.VarSymbol v = new Symbol.VarSymbol(flags |= 0x1000000000000000L, name, type, csym);
                                csym.members_field.enter(v);
                            }
                        } else {
                            ((Symbol)l.head).flags_field = flags;
                            csym.members_field.enter(this.translateSymbol((Symbol)l.head));
                        }
                    }
                }
                l = l.tail;
            }
        }
    }

    private long flagsFromAnnotationsAndFlags(Symbol sym) {
        long initialFlags = sym.flags_field;
        long nonAccessFlags = initialFlags & 0xFFFFDFFFFFFFFFF8L;
        long accessFlags = initialFlags & 0x200000000007L;
        JavafxSymtab javafxSyms = (JavafxSymtab)this.syms;
        for (Attribute.Compound a : sym.getAnnotationMirrors()) {
            if (a.type.tsym.flatName() == javafxSyms.javafx_privateAnnotationType.tsym.flatName()) {
                accessFlags = 2L;
                continue;
            }
            if (a.type.tsym.flatName() == javafxSyms.javafx_protectedAnnotationType.tsym.flatName()) {
                accessFlags = 4L;
                continue;
            }
            if (a.type.tsym.flatName() == javafxSyms.javafx_packageAnnotationType.tsym.flatName()) {
                accessFlags = 0L;
                continue;
            }
            if (a.type.tsym.flatName() == javafxSyms.javafx_publicAnnotationType.tsym.flatName()) {
                accessFlags = 1L;
                continue;
            }
            if (a.type.tsym.flatName() != javafxSyms.javafx_scriptPrivateAnnotationType.tsym.flatName()) continue;
            accessFlags = 0x200000000000L;
        }
        if (accessFlags == 0L) {
            accessFlags = 0x100000000000L;
        }
        return nonAccessFlags | accessFlags;
    }
}

