/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.code.JavafxTypes;
import com.sun.tools.javafx.comp.JavafxAnnotate;
import com.sun.tools.javafx.comp.JavafxAttrContext;
import com.sun.tools.javafx.comp.JavafxCheck;
import com.sun.tools.javafx.comp.JavafxEnv;
import com.sun.tools.javafx.comp.JavafxMemberEnter;
import com.sun.tools.javafx.comp.JavafxScriptClassBuilder;
import com.sun.tools.javafx.comp.JavafxTodo;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxTreeInfo;
import com.sun.tools.javafx.tree.JavafxTreeMaker;
import com.sun.tools.javafx.tree.JavafxTreeScanner;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxEnter
extends JavafxTreeScanner {
    protected static final Context.Key<JavafxEnter> javafxEnterKey = new Context.Key();
    private final Log log;
    private final JavafxSymtab syms;
    private final JavafxCheck chk;
    private final JavafxTreeMaker fxmake;
    private final ClassReader reader;
    private final JavafxAnnotate annotate;
    private final JavafxMemberEnter memberEnter;
    private final Lint lint;
    private final JavaFileManager fileManager;
    private final JavafxTodo todo;
    private final JavafxTypes types;
    private JavafxScriptClassBuilder javafxModuleBuilder;
    Map<Symbol.TypeSymbol, JavafxEnv<JavafxAttrContext>> typeEnvs = new HashMap<Symbol.TypeSymbol, JavafxEnv<JavafxAttrContext>>();
    protected ListBuffer<Symbol.ClassSymbol> uncompleted;
    private JFXClassDeclaration predefClassDef;
    protected JavafxEnv<JavafxAttrContext> env;
    protected Type result;

    public static JavafxEnter instance(Context context) {
        JavafxEnter instance = context.get(javafxEnterKey);
        if (instance == null) {
            instance = new JavafxEnter(context);
        }
        return instance;
    }

    protected JavafxEnter(Context context) {
        context.put(javafxEnterKey, this);
        this.log = Log.instance(context);
        this.reader = ClassReader.instance(context);
        this.fxmake = JavafxTreeMaker.instance(context);
        this.syms = (JavafxSymtab)JavafxSymtab.instance(context);
        this.chk = JavafxCheck.instance(context);
        this.memberEnter = JavafxMemberEnter.instance(context);
        this.annotate = JavafxAnnotate.instance(context);
        this.lint = Lint.instance(context);
        this.javafxModuleBuilder = JavafxScriptClassBuilder.instance(context);
        this.predefClassDef = this.fxmake.ClassDeclaration(this.fxmake.Modifiers(1L), this.syms.predefClass.name, List.<JFXExpression>nil(), null);
        this.predefClassDef.sym = this.syms.predefClass;
        this.todo = JavafxTodo.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.types = JavafxTypes.instance(context);
    }

    @Override
    public void scan(JFXTree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    @Override
    public void scan(List<? extends JFXTree> trees) {
        if (trees != null) {
            List<JFXTree> l = trees;
            while (l.nonEmpty()) {
                this.scan((JFXTree)l.head);
                l = l.tail;
            }
        }
    }

    public JavafxEnv<JavafxAttrContext> getEnv(Symbol.TypeSymbol sym) {
        return this.typeEnvs.get(sym);
    }

    public JavafxEnv<JavafxAttrContext> getClassEnv(Symbol.TypeSymbol sym) {
        JavafxEnv<JavafxAttrContext> localEnv;
        JavafxEnv<JavafxAttrContext> lintEnv = localEnv = this.getEnv(sym);
        while (((JavafxAttrContext)lintEnv.info).lint == null) {
            lintEnv = lintEnv.next;
        }
        ((JavafxAttrContext)localEnv.info).lint = ((JavafxAttrContext)lintEnv.info).lint.augment(sym.attributes_field, sym.flags());
        return localEnv;
    }

    public static JavafxEnv<JavafxAttrContext> classEnv(JFXClassDeclaration tree, JavafxEnv<JavafxAttrContext> env) {
        JavafxEnv<JavafxAttrContext> localEnv = env.dup(tree, ((JavafxAttrContext)env.info).dup(new Scope(tree.sym)));
        localEnv.enclClass = tree;
        localEnv.outer = env;
        ((JavafxAttrContext)localEnv.info).isSelfCall = false;
        ((JavafxAttrContext)localEnv.info).lint = null;
        return localEnv;
    }

    JavafxEnv<JavafxAttrContext> topLevelEnv(JFXScript tree) {
        JavafxEnv<JavafxAttrContext> localEnv = new JavafxEnv<JavafxAttrContext>(tree, new JavafxAttrContext());
        localEnv.toplevel = tree;
        localEnv.enclClass = this.predefClassDef;
        tree.namedImportScope = new Scope.ImportScope(tree.packge);
        tree.starImportScope = new Scope.ImportScope(tree.packge);
        ((JavafxAttrContext)localEnv.info).scope = tree.namedImportScope;
        ((JavafxAttrContext)localEnv.info).lint = this.lint;
        return localEnv;
    }

    public JavafxEnv<JavafxAttrContext> getTopLevelEnv(JFXScript tree) {
        JavafxEnv<JavafxAttrContext> localEnv = new JavafxEnv<JavafxAttrContext>(tree, new JavafxAttrContext());
        localEnv.toplevel = tree;
        localEnv.enclClass = this.predefClassDef;
        ((JavafxAttrContext)localEnv.info).scope = tree.namedImportScope;
        ((JavafxAttrContext)localEnv.info).lint = this.lint;
        return localEnv;
    }

    public static Scope enterScope(JavafxEnv<JavafxAttrContext> env) {
        return env.tree.getFXTag() == JavafxTag.CLASS_DEF ? ((JFXClassDeclaration)env.tree).sym.members_field : ((JavafxAttrContext)env.info).scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type classEnter(JFXTree tree, JavafxEnv<JavafxAttrContext> env) {
        JavafxEnv<JavafxAttrContext> prevEnv = this.env;
        try {
            this.env = env;
            if (tree != null) {
                tree.accept(this);
            }
            Type type = this.result;
            return type;
        }
        catch (Symbol.CompletionFailure ex) {
            Type type = this.chk.completionError(tree.pos(), ex);
            return type;
        }
        finally {
            this.env = prevEnv;
        }
    }

    protected <T extends JFXTree> List<Type> classEnter(List<T> trees, JavafxEnv<JavafxAttrContext> env) {
        ListBuffer<Type> ts = new ListBuffer<Type>();
        List<Object> l = trees;
        while (l.nonEmpty()) {
            ts.append(this.classEnter((JFXTree)l.head, env));
            l = l.tail;
        }
        return ts.toList();
    }

    @Override
    public void visitScript(JFXScript tree) {
        JavaFileObject prev = this.log.useSource(tree.sourcefile);
        boolean isPkgInfo = tree.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
        Name packageName = JavafxTreeInfo.fullName(tree.pid);
        tree.packge = packageName != null ? this.reader.enterPackage(packageName) : this.syms.unnamedPackage;
        tree.packge.complete();
        JavafxEnv<JavafxAttrContext> localEnv = this.topLevelEnv(tree);
        this.javafxModuleBuilder.preProcessJfxTopLevel(tree);
        if (isPkgInfo) {
            JavafxEnv<JavafxAttrContext> env0 = this.typeEnvs.get(tree.packge);
            if (env0 == null) {
                this.typeEnvs.put(tree.packge, localEnv);
            } else {
                JFXScript tree0 = env0.toplevel;
                if (!this.fileManager.isSameFile(tree.sourcefile, tree0.sourcefile)) {
                    this.log.warning(tree.pid != null ? tree.pid.pos() : null, "pkg-info.already.seen", tree.packge);
                }
            }
        }
        this.classEnter(tree.defs, localEnv);
        this.log.useSource(prev);
        this.result = null;
    }

    @Override
    public void visitClassDeclaration(JFXClassDeclaration tree) {
        Symbol.ClassSymbol c;
        Symbol owner = ((JavafxAttrContext)this.env.info).scope.owner;
        Scope enclScope = JavafxEnter.enterScope(this.env);
        if (owner.kind == 1) {
            Symbol.PackageSymbol packge;
            Symbol q = packge = (Symbol.PackageSymbol)owner;
            while (q != null && q.kind == 1) {
                q.flags_field |= 0x800000L;
                q = q.owner;
            }
            c = this.reader.enterClass(tree.getName(), packge);
            packge.members().enterIfAbsent(c);
        } else {
            if (tree.getName().len != 0 && !this.chk.checkUniqueClassName(tree.pos(), tree.getName(), enclScope)) {
                this.result = null;
                return;
            }
            if (owner.kind == 2) {
                c = this.reader.enterClass(tree.getName(), (Symbol.TypeSymbol)owner);
                if ((owner.flags_field & 0x200L) != 0L) {
                    tree.mods.flags |= 9L;
                }
            } else {
                c = this.reader.defineClass(tree.getName(), owner);
                c.flatname = this.chk.localClassName(c);
                if (c.name.len != 0) {
                    this.chk.checkTransparentClass(tree.pos(), c, ((JavafxAttrContext)this.env.info).scope);
                }
            }
        }
        tree.sym = c;
        if (this.chk.compiled.get(c.flatname) != null) {
            this.duplicateClass(tree.pos(), c);
            this.result = new Type.ErrorType(tree.getName(), (Symbol.TypeSymbol)owner);
            tree.sym = (Symbol.ClassSymbol)this.result.tsym;
            return;
        }
        this.chk.compiled.put(c.flatname, c);
        enclScope.enter(c);
        JavafxEnv<JavafxAttrContext> localEnv = JavafxEnter.classEnv(tree, this.env);
        this.typeEnvs.put(c, localEnv);
        c.completer = this.memberEnter;
        c.flags_field = this.chk.checkFlags(tree.pos(), tree.mods.flags, c, tree);
        c.sourcefile = this.env.toplevel.sourcefile;
        c.members_field = new Scope(c);
        Type.ClassType ct = (Type.ClassType)c.type;
        if (owner.kind != 1 && (c.flags_field & 8L) == 0L) {
            Symbol owner1 = owner;
            while ((owner1.kind & 0x14) != 0 && (owner1.flags_field & 8L) == 0L) {
                owner1 = owner1.owner;
            }
            if (owner1.kind == 2) {
                ct.setEnclosingType(owner1.type);
            }
        }
        if (!c.isLocal() && this.uncompleted != null) {
            this.uncompleted.append(c);
        }
        this.classEnter(tree.getMembers(), localEnv);
        this.types.addFxClass(c, tree);
        this.result = c.type;
    }

    protected void duplicateClass(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        this.log.error(pos, "duplicate.class", c.fullname);
    }

    public void main(List<JFXScript> trees) {
        this.complete(trees, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(List<JFXScript> trees, Symbol.ClassSymbol c) {
        this.annotate.enterStart();
        ListBuffer<Symbol.ClassSymbol> prevUncompleted = this.uncompleted;
        if (this.memberEnter.completionEnabled) {
            this.uncompleted = new ListBuffer();
        }
        try {
            this.classEnter(trees, null);
            if (this.memberEnter.completionEnabled) {
                while (this.uncompleted.nonEmpty()) {
                    Symbol.ClassSymbol clazz = this.uncompleted.next();
                    if (c == null || c == clazz || prevUncompleted == null) {
                        clazz.complete();
                        continue;
                    }
                    prevUncompleted.append(clazz);
                }
                for (JFXScript tree : trees) {
                    if (tree.starImportScope.elems != null) continue;
                    JavaFileObject prev = this.log.useSource(tree.sourcefile);
                    JavafxEnv<JavafxAttrContext> localEnv = this.typeEnvs.get(tree.packge);
                    if (localEnv == null) {
                        localEnv = this.topLevelEnv(tree);
                    }
                    this.memberEnter.memberEnter(tree, localEnv);
                    this.log.useSource(prev);
                }
            }
        }
        finally {
            this.uncompleted = prevUncompleted;
            this.annotate.enterDone();
        }
    }
}

