/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Warner;
import com.sun.tools.javafx.code.FunctionType;
import com.sun.tools.javafx.code.JavafxClassSymbol;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.code.JavafxTypes;
import com.sun.tools.javafx.comp.JavafxAttrContext;
import com.sun.tools.javafx.comp.JavafxCheck;
import com.sun.tools.javafx.comp.JavafxClassReader;
import com.sun.tools.javafx.comp.JavafxEnv;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxTreeInfo;
import java.util.HashSet;
import javax.lang.model.element.ElementVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxResolve {
    protected static final Context.Key<JavafxResolve> javafxResolveKey = new Context.Key();
    Name.Table names;
    Log log;
    Symtab syms;
    JavafxCheck chk;
    Infer infer;
    JavafxClassReader reader;
    JavafxTreeInfo treeinfo;
    JavafxTypes types;
    public final boolean boxingEnabled;
    public final boolean varargsEnabled;
    private final boolean debugResolve;
    final ResolveError varNotFound;
    final ResolveError wrongMethod;
    final ResolveError wrongMethods;
    final ResolveError methodNotFound;
    final ResolveError typeNotFound;
    Warner noteWarner = new Warner();

    public static JavafxResolve instance(Context context) {
        JavafxResolve instance = context.get(javafxResolveKey);
        if (instance == null) {
            instance = new JavafxResolve(context);
        }
        return instance;
    }

    protected JavafxResolve(Context context) {
        context.put(javafxResolveKey, this);
        this.syms = Symtab.instance(context);
        this.varNotFound = new ResolveError(68, this.syms.errSymbol, "variable not found");
        this.wrongMethod = new ResolveError(70, this.syms.errSymbol, "method not found");
        this.wrongMethods = new ResolveError(69, this.syms.errSymbol, "wrong methods");
        this.methodNotFound = new ResolveError(71, this.syms.errSymbol, "method not found");
        this.typeNotFound = new ResolveError(72, this.syms.errSymbol, "type not found");
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.chk = JavafxCheck.instance(context);
        this.infer = Infer.instance(context);
        this.reader = JavafxClassReader.instance(context);
        this.treeinfo = JavafxTreeInfo.instance(context);
        this.types = JavafxTypes.instance(context);
        Source source = Source.instance(context);
        this.boxingEnabled = source.allowBoxing();
        this.varargsEnabled = source.allowVarargs();
        Options options = Options.instance(context);
        this.debugResolve = options.get("debugresolve") != null;
    }

    public static boolean isStatic(JavafxEnv<JavafxAttrContext> env) {
        return ((JavafxAttrContext)env.info).staticLevel > ((JavafxAttrContext)env.outer.info).staticLevel;
    }

    static boolean isInitializer(JavafxEnv<JavafxAttrContext> env) {
        Symbol owner = ((JavafxAttrContext)env.info).scope.owner;
        return owner.isConstructor() || owner.owner.kind == 2 && (owner.kind == 4 || owner.kind == 16 && (owner.flags() & 0x100000L) != 0L) && (owner.flags() & 8L) == 0L;
    }

    public boolean isAccessible(JavafxEnv<JavafxAttrContext> env, Symbol.TypeSymbol c) {
        switch ((short)(c.flags() & 7L)) {
            case 2: {
                return env.enclClass.sym.outermostClass() == c.owner.outermostClass();
            }
            case 0: {
                if ((c.flags() & 0x200000000000L) != 0L) {
                    return env.enclClass.sym.outermostClass() == c.outermostClass();
                }
                return env.toplevel.packge == c.owner || env.toplevel.packge == c.packge() || env.enclMethod != null && (env.enclMethod.mods.flags & 0x20000000L) != 0L;
            }
            default: {
                return true;
            }
            case 4: 
        }
        return env.toplevel.packge == c.owner || env.toplevel.packge == c.packge() || this.isInnerSubClass(env.enclClass.sym, c.owner);
    }

    private boolean isInnerSubClass(Symbol.ClassSymbol c, Symbol base) {
        while (c != null && !c.isSubClass(base, this.types)) {
            c = c.owner.enclClass();
        }
        return c != null;
    }

    boolean isAccessible(JavafxEnv<JavafxAttrContext> env, Type t) {
        return t.tag == 11 ? this.isAccessible(env, this.types.elemtype(t)) : this.isAccessible(env, t.tsym);
    }

    public boolean isAccessible(JavafxEnv<JavafxAttrContext> env, Type site, Symbol sym) {
        if (sym.name == this.names.init && sym.owner != site.tsym) {
            return false;
        }
        if ((sym.flags() & 0xC0000000000L) != 0L) {
            return this.isAccessible(env, site);
        }
        return this.isAccessibleForWrite(env, site, sym);
    }

    public boolean isAccessibleForWrite(JavafxEnv<JavafxAttrContext> env, Type site, Symbol sym) {
        if (sym.name == this.names.init && sym.owner != site.tsym) {
            return false;
        }
        switch ((short)(sym.flags() & 7L)) {
            case 2: {
                return (env.enclClass.sym == sym.owner || env.enclClass.sym.outermostClass() == sym.owner.outermostClass()) && this.isInheritedIn(sym, site.tsym, this.types);
            }
            case 0: {
                if ((sym.flags() & 0x200000000000L) != 0L) {
                    Symbol.ClassSymbol ownerOuter;
                    if (env.enclClass.sym == sym.owner) {
                        return true;
                    }
                    Symbol.ClassSymbol enclOuter = env.enclClass.sym.outermostClass();
                    return enclOuter == (ownerOuter = sym.owner.outermostClass());
                }
                Symbol.PackageSymbol pkg = env.toplevel.packge;
                boolean samePkg = pkg == sym.owner.owner || pkg == sym.packge();
                boolean typeAccessible = this.isAccessible(env, site);
                return samePkg && typeAccessible;
            }
            case 4: {
                return (env.toplevel.packge == sym.owner.owner || env.toplevel.packge == sym.packge() || this.isProtectedAccessible(sym, env.enclClass.sym, site) || ((JavafxAttrContext)env.info).selectSuper && (sym.flags() & 8L) == 0L && sym.kind != 2) && this.isAccessible(env, site) && (sym.kind != 16 || sym.isConstructor() || this.types.implementation((Symbol.MethodSymbol)sym, site.tsym, true) == sym);
            }
        }
        return this.isAccessible(env, site);
    }

    private boolean isProtectedAccessible(Symbol sym, Symbol.ClassSymbol c, Type site) {
        while (c != null && (!c.isSubClass(sym.owner, this.types) || (c.flags() & 0x200L) != 0L || (sym.flags() & 8L) == 0L && sym.kind != 2 && !site.tsym.isSubClass(c, this.types))) {
            c = c.owner.enclClass();
        }
        return c != null;
    }

    Type rawInstantiate(JavafxEnv<JavafxAttrContext> env, Symbol m, Type mt, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, Warner warn) throws Infer.NoInstanceException {
        if (useVarargs && (m.flags() & 0x400000000L) == 0L) {
            return null;
        }
        m.complete();
        List<Type> tvars = ((JavafxAttrContext)env.info).tvars;
        if (typeargtypes == null) {
            typeargtypes = List.nil();
        }
        if (mt.tag == 16 || !typeargtypes.nonEmpty()) {
            Type.ForAll pmt;
            if (mt.tag == 16 && typeargtypes.nonEmpty()) {
                pmt = (Type.ForAll)mt;
                if (typeargtypes.length() != pmt.tvars.length()) {
                    return null;
                }
                List<Type> formals = pmt.tvars;
                List<Type> actuals = typeargtypes;
                while (formals.nonEmpty() && actuals.nonEmpty()) {
                    List<Type> bounds = this.types.subst(this.types.getBounds((Type.TypeVar)formals.head), pmt.tvars, typeargtypes);
                    while (bounds.nonEmpty()) {
                        if (!this.types.isSubtypeUnchecked((Type)actuals.head, (Type)bounds.head, warn)) {
                            return null;
                        }
                        bounds = bounds.tail;
                    }
                    formals = formals.tail;
                    actuals = actuals.tail;
                }
                mt = this.types.subst(pmt.qtype, pmt.tvars, typeargtypes);
            } else if (mt.tag == 16) {
                pmt = (Type.ForAll)mt;
                List<Type> tvars1 = this.types.newInstances(pmt.tvars);
                tvars = tvars.appendList(tvars1);
                mt = this.types.subst(pmt.qtype, pmt.tvars, tvars1);
            }
        }
        boolean instNeeded = tvars.tail != null;
        List<Type> l = argtypes;
        while (l.tail != null && !instNeeded) {
            if (((Type)l.head).tag == 16) {
                instNeeded = true;
            }
            l = l.tail;
        }
        if (instNeeded) {
            return this.infer.instantiateMethod(tvars, (Type.MethodType)mt, argtypes, allowBoxing, useVarargs, warn);
        }
        return this.argumentsAcceptable(argtypes, mt.getParameterTypes(), allowBoxing, useVarargs, warn) ? mt : null;
    }

    Type instantiate(JavafxEnv<JavafxAttrContext> env, Type site, Symbol m, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, Warner warn) {
        try {
            return this.rawInstantiate(env, m, this.types.memberType(site, m), argtypes, typeargtypes, allowBoxing, useVarargs, warn);
        }
        catch (Infer.NoInstanceException ex) {
            return null;
        }
    }

    boolean argumentsAcceptable(List<Type> argtypes, List<Type> formals, boolean allowBoxing, boolean useVarargs, Warner warn) {
        Type varargsFormal;
        Type type = varargsFormal = useVarargs ? formals.last() : null;
        while (argtypes.nonEmpty() && formals.head != varargsFormal) {
            boolean works;
            boolean bl = works = allowBoxing ? this.types.isConvertible((Type)argtypes.head, (Type)formals.head, warn) : this.types.isSubtypeUnchecked((Type)argtypes.head, (Type)formals.head, warn);
            if (!works) {
                return false;
            }
            argtypes = argtypes.tail;
            formals = formals.tail;
        }
        if (formals.head != varargsFormal) {
            return false;
        }
        if (!useVarargs) {
            return argtypes.isEmpty();
        }
        Type elt = this.types.elemtype(varargsFormal);
        while (argtypes.nonEmpty()) {
            if (!this.types.isConvertible((Type)argtypes.head, elt, warn)) {
                return false;
            }
            argtypes = argtypes.tail;
        }
        return true;
    }

    public Symbol findField(JavafxEnv<JavafxAttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym;
        Symbol bestSoFar = this.varNotFound;
        Scope.Entry e = c.members().lookup(name);
        while (e.scope != null) {
            if ((e.sym.kind & 0x14) != 0 && (e.sym.flags_field & 0x1000L) == 0L) {
                Symbol symbol = sym = this.isAccessible(env, site, e.sym) ? e.sym : new AccessError(env, site, e.sym);
                if (bestSoFar.kind < 65 && sym.kind < 65 && sym.owner != bestSoFar.owner) {
                    bestSoFar = new AmbiguityError(bestSoFar, sym);
                } else if (sym.kind < bestSoFar.kind) {
                    bestSoFar = sym;
                }
            }
            e = e.next();
        }
        if (bestSoFar != this.varNotFound) {
            return bestSoFar;
        }
        Type st = this.types.supertype(c.type);
        if (st != null && st.tag == 10) {
            sym = this.findField(env, site, name, st.tsym);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if (bestSoFar.kind > 65 && c instanceof JavafxClassSymbol) {
            List<Type> supertypes = ((JavafxClassSymbol)c).getSuperTypes();
            for (Type tp : supertypes) {
                if (tp == null || tp.tag != 10) continue;
                sym = this.findField(env, site, name, tp.tsym);
                if (sym.kind < bestSoFar.kind) {
                    bestSoFar = sym;
                }
                if (bestSoFar.kind >= 65) continue;
                break;
            }
        }
        List<Type> l = this.types.interfaces(c.type);
        while (bestSoFar.kind != 65 && l.nonEmpty()) {
            sym = this.findField(env, site, name, ((Type)l.head).tsym);
            if (bestSoFar.kind < 65 && sym.kind < 65 && sym.owner != bestSoFar.owner) {
                bestSoFar = new AmbiguityError(bestSoFar, sym);
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            l = l.tail;
        }
        return bestSoFar;
    }

    public Symbol.VarSymbol resolveInternalField(JCDiagnostic.DiagnosticPosition pos, JavafxEnv<JavafxAttrContext> env, Type site, Name name) {
        Symbol sym = this.findField(env, site, name, site.tsym);
        if (sym.kind == 4) {
            return (Symbol.VarSymbol)sym;
        }
        throw new FatalError(JCDiagnostic.fragment("fatal.err.cant.locate.field", name));
    }

    Symbol findVar(JavafxEnv<JavafxAttrContext> env, Name name, int kind, Type expected) {
        Object origin;
        Symbol sym;
        boolean checkArgs;
        Symbol bestSoFar = this.varNotFound;
        JavafxEnv<JavafxAttrContext> env1 = env;
        boolean staticOnly = false;
        boolean innerAccess = false;
        Type mtype = expected;
        if (mtype instanceof FunctionType) {
            mtype = mtype.asMethodType();
        }
        boolean bl = checkArgs = mtype instanceof Type.MethodType || mtype instanceof Type.ForAll;
        while (env1 != null) {
            Type envClass;
            Scope sc = ((JavafxAttrContext)env1.info).scope;
            if (env1.tree instanceof JFXClassDeclaration) {
                JFXClassDeclaration cdecl = (JFXClassDeclaration)env1.tree;
                if (cdecl.runMethod != null && name != this.names._this && name != this.names._super) {
                    envClass = null;
                    sc = cdecl.runBodyScope;
                    innerAccess = true;
                }
                envClass = cdecl.sym.type;
            } else {
                envClass = null;
            }
            if (envClass != null && (sym = this.findMember(env1, envClass, name, expected, true, false, false)).exists()) {
                if (staticOnly && sym.owner != null && !sym.isStatic()) {
                    return new StaticError(sym);
                }
                return sym;
            }
            if (sc != null) {
                Scope.Entry e = sc.lookup(name);
                while (e.scope != null) {
                    if ((e.sym.flags_field & 0x1000L) == 0L && (e.sym.kind & 0x14) != 0) {
                        if (innerAccess) {
                            e.sym.flags_field |= 0x40000000000000L;
                        }
                        if (checkArgs) {
                            return this.checkArgs(e.sym, mtype);
                        }
                        return e.sym;
                    }
                    e = e.next();
                }
            }
            if (env1.tree instanceof JFXFunctionDefinition) {
                innerAccess = true;
            }
            if (env1.outer != null && JavafxResolve.isStatic(env1)) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        Scope.Entry e = env.toplevel.namedImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            origin = e.getOrigin().owner.type;
            if ((sym.kind & 0x14) != 0) {
                if (e.sym.owner.type != origin) {
                    sym = sym.clone(e.getOrigin().owner);
                }
                return this.isAccessible(env, (Type)origin, sym) ? sym : new AccessError(env, (Type)origin, sym);
            }
            e = e.next();
        }
        origin = null;
        e = env.toplevel.starImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            if ((sym.kind & 0x14) != 0) {
                if (bestSoFar.kind < 65 && sym.owner != bestSoFar.owner) {
                    return new AmbiguityError(bestSoFar, sym);
                }
                if (bestSoFar.kind >= 4) {
                    origin = e.getOrigin().owner;
                    bestSoFar = this.isAccessible(env, ((Symbol)origin).type, sym) ? sym : new AccessError(env, ((Symbol)origin).type, sym);
                }
            }
            e = e.next();
        }
        if (name == this.names.fromString("__DIR__") || name == this.names.fromString("__FILE__")) {
            Type type = this.syms.stringType;
            return new Symbol.VarSymbol(1L, name, type, env.enclClass.sym);
        }
        if (bestSoFar.kind == 4 && bestSoFar.owner.type != ((Symbol)origin).type) {
            return bestSoFar.clone((Symbol)origin);
        }
        return bestSoFar;
    }

    private Symbol checkArgs(Symbol sym, Type mtype) {
        Type mt = sym.type;
        if (mt instanceof FunctionType) {
            mt = mt.asMethodType();
        }
        if (!(mt instanceof Type.MethodType) || !this.argumentsAcceptable(mtype.getParameterTypes(), mt.getParameterTypes(), true, false, Warner.noWarnings)) {
            return this.wrongMethod.setWrongSym(sym);
        }
        return sym;
    }

    Symbol selectBest(JavafxEnv<JavafxAttrContext> env, Type site, Type expected, Symbol sym, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs, boolean operator) {
        if (sym.kind == 31) {
            return bestSoFar;
        }
        if (!this.isInheritedIn(sym, site.tsym, this.types)) {
            return bestSoFar;
        }
        assert (sym.kind < 65);
        List<Type> argtypes = expected.getParameterTypes();
        List<Type> typeargtypes = expected.getTypeArguments();
        try {
            if (this.rawInstantiate(env, sym, this.types.memberType(site, sym), argtypes, typeargtypes, allowBoxing, useVarargs, Warner.noWarnings) == null) {
                switch (bestSoFar.kind) {
                    case 71: {
                        return this.wrongMethod.setWrongSym(sym);
                    }
                    case 70: {
                        return this.wrongMethods;
                    }
                }
                return bestSoFar;
            }
        }
        catch (Infer.NoInstanceException ex) {
            switch (bestSoFar.kind) {
                case 71: {
                    return this.wrongMethod.setWrongSym(sym, ex.getDiagnostic());
                }
                case 70: {
                    return this.wrongMethods;
                }
            }
            return bestSoFar;
        }
        if (!this.isAccessible(env, site, sym)) {
            return bestSoFar.kind == 71 ? new AccessError(env, site, sym) : bestSoFar;
        }
        return bestSoFar.kind > 65 ? sym : this.mostSpecific(sym, bestSoFar, env, site, allowBoxing && operator, useVarargs);
    }

    Symbol mostSpecific(Symbol m1, Symbol m2, JavafxEnv<JavafxAttrContext> env, Type site, boolean allowBoxing, boolean useVarargs) {
        switch (m2.kind) {
            case 16: {
                boolean m2SignatureMoreSpecific;
                if (m1 == m2) {
                    return m1;
                }
                Type mt1 = this.types.memberType(site, m1);
                this.noteWarner.unchecked = false;
                boolean m1SignatureMoreSpecific = (this.instantiate(env, site, m2, this.types.lowerBoundArgtypes(mt1), null, allowBoxing, false, this.noteWarner) != null || useVarargs && this.instantiate(env, site, m2, this.types.lowerBoundArgtypes(mt1), null, allowBoxing, true, this.noteWarner) != null) && !this.noteWarner.unchecked;
                Type mt2 = this.types.memberType(site, m2);
                this.noteWarner.unchecked = false;
                boolean bl = m2SignatureMoreSpecific = (this.instantiate(env, site, m1, this.types.lowerBoundArgtypes(mt2), null, allowBoxing, false, this.noteWarner) != null || useVarargs && this.instantiate(env, site, m1, this.types.lowerBoundArgtypes(mt2), null, allowBoxing, true, this.noteWarner) != null) && !this.noteWarner.unchecked;
                if (m1SignatureMoreSpecific && m2SignatureMoreSpecific) {
                    Symbol result;
                    boolean m2Abstract;
                    if (!this.types.overrideEquivalent(mt1, mt2)) {
                        return new AmbiguityError(m1, m2);
                    }
                    if ((m1.flags() & 0x80000000L) != (m2.flags() & 0x80000000L)) {
                        return (m1.flags() & 0x80000000L) != 0L ? m2 : m1;
                    }
                    Symbol.TypeSymbol m1Owner = (Symbol.TypeSymbol)m1.owner;
                    Symbol.TypeSymbol m2Owner = (Symbol.TypeSymbol)m2.owner;
                    if (this.types.asSuper(m1Owner.type, m2Owner) != null && ((m1.owner.flags_field & 0x200L) == 0L || (m2.owner.flags_field & 0x200L) != 0L) && m1.overrides(m2, m1Owner, this.types, false)) {
                        return m1;
                    }
                    if (this.types.asSuper(m2Owner.type, m1Owner) != null && ((m2.owner.flags_field & 0x200L) == 0L || (m1.owner.flags_field & 0x200L) != 0L) && m2.overrides(m1, m2Owner, this.types, false)) {
                        return m2;
                    }
                    boolean m1Abstract = (m1.flags() & 0x400L) != 0L;
                    boolean bl2 = m2Abstract = (m2.flags() & 0x400L) != 0L;
                    if (m1Abstract && !m2Abstract) {
                        return m2;
                    }
                    if (m2Abstract && !m1Abstract) {
                        return m1;
                    }
                    if (!m1Abstract && !m2Abstract) {
                        return new AmbiguityError(m1, m2);
                    }
                    if (!this.types.isSameType(m1.erasure(this.types), m2.erasure(this.types))) {
                        return new AmbiguityError(m1, m2);
                    }
                    Type result2 = mt2.getReturnType();
                    if (mt2.tag == 16) {
                        result2 = this.types.subst(result2, ((Type.ForAll)mt2).tvars, ((Type.ForAll)mt1).tvars);
                    }
                    if (this.types.isSubtype(mt1.getReturnType(), result2)) {
                        result = m1;
                    } else if (this.types.isSubtype(result2, mt1.getReturnType())) {
                        result = m2;
                    } else {
                        return new AmbiguityError(m1, m2);
                    }
                    result = result.clone(result.owner);
                    result.type = (Type)result.type.clone();
                    result.type.setThrown(this.chk.intersect(mt1.getThrownTypes(), mt2.getThrownTypes()));
                    return result;
                }
                if (m1SignatureMoreSpecific) {
                    return m1;
                }
                if (m2SignatureMoreSpecific) {
                    return m2;
                }
                return new AmbiguityError(m1, m2);
            }
            case 65: {
                AmbiguityError e = (AmbiguityError)m2;
                Symbol err1 = this.mostSpecific(m1, e.sym1, env, site, allowBoxing, useVarargs);
                Symbol err2 = this.mostSpecific(m1, e.sym2, env, site, allowBoxing, useVarargs);
                if (err1 == err2) {
                    return err1;
                }
                if (err1 == e.sym1 && err2 == e.sym2) {
                    return m2;
                }
                if (err1 instanceof AmbiguityError && err2 instanceof AmbiguityError && ((AmbiguityError)err1).sym1 == ((AmbiguityError)err2).sym1) {
                    return new AmbiguityError(m1, m2);
                }
                return new AmbiguityError(err1, err2);
            }
        }
        throw new AssertionError();
    }

    Symbol findMethod(JavafxEnv<JavafxAttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, boolean operator) {
        return this.findMember(env, site, name, this.newMethTemplate(argtypes, typeargtypes), site.tsym.type, this.methodNotFound, allowBoxing, useVarargs, operator);
    }

    Symbol findMember(JavafxEnv<JavafxAttrContext> env, Type site, Name name, Type expected, boolean allowBoxing, boolean useVarargs, boolean operator) {
        return this.findMember(env, site, name, expected, site.tsym.type, this.methodNotFound, allowBoxing, useVarargs, operator);
    }

    private Symbol findMember(JavafxEnv<JavafxAttrContext> env, Type site, Name name, Type expected, Type intype, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs, boolean operator) {
        Symbol best = this.findMemberWithoutAccessChecks(env, site, name, expected, intype, bestSoFar, allowBoxing, useVarargs, operator);
        if (!(best instanceof ResolveError) && !this.isAccessible(env, site, best)) {
            best = new AccessError(env, site, best);
        }
        return best;
    }

    private Symbol findMemberWithoutAccessChecks(JavafxEnv<JavafxAttrContext> env, Type site, Name name, Type expected, Type intype, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs, boolean operator) {
        Type mtype = expected;
        if (mtype instanceof FunctionType) {
            mtype = mtype.asMethodType();
        }
        boolean checkArgs = mtype instanceof Type.MethodType || mtype instanceof Type.ForAll;
        Type ct = intype;
        while (ct.tag == 10) {
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)ct.tsym;
            Scope.Entry e = c.members().lookup(name);
            while (e.scope != null) {
                if ((e.sym.kind & 0x14) != 0 && (e.sym.flags_field & 0x1000L) == 0L) {
                    e.sym.complete();
                    if (!checkArgs) {
                        if (bestSoFar.kind == 68 || bestSoFar.kind == 71) {
                            bestSoFar = e.sym;
                        } else if (e.sym != bestSoFar) {
                            bestSoFar = new AmbiguityError(bestSoFar, e.sym);
                        }
                    } else if (e.sym.kind == 16) {
                        if ((bestSoFar = this.selectBest(env, site, mtype, e.sym, bestSoFar, allowBoxing, useVarargs, operator)) != null && bestSoFar.kind < 65 && this.isExactMatch(mtype, bestSoFar)) {
                            return bestSoFar;
                        }
                    } else if ((e.sym.kind & 0x14) != 0 && bestSoFar == this.methodNotFound) {
                        Type mt = e.sym.type;
                        if (mt instanceof FunctionType) {
                            mt = mt.asMethodType();
                        }
                        if (!(mt instanceof Type.MethodType) || !this.argumentsAcceptable(mtype.getParameterTypes(), mt.getParameterTypes(), true, false, Warner.noWarnings)) {
                            return this.wrongMethod.setWrongSym(e.sym);
                        }
                        return e.sym;
                    }
                }
                e = e.next();
            }
            if (!checkArgs && bestSoFar.kind != 68 && bestSoFar.kind != 71) {
                return bestSoFar;
            }
            Symbol concrete = this.methodNotFound;
            if ((bestSoFar.flags() & 0x400L) == 0L) {
                concrete = bestSoFar;
            }
            List<Type> l = this.types.interfaces(c.type);
            while (l.nonEmpty()) {
                bestSoFar = this.findMemberWithoutAccessChecks(env, site, name, expected, (Type)l.head, bestSoFar, allowBoxing, useVarargs, operator);
                l = l.tail;
            }
            if (concrete != bestSoFar && concrete.kind < 31 && bestSoFar.kind < 31 && this.types.isSubSignature(concrete.type, bestSoFar.type)) {
                bestSoFar = concrete;
            }
            ct = this.types.supertype(ct);
        }
        if (bestSoFar.kind > 65 && intype.tsym instanceof JavafxClassSymbol) {
            List<Type> supertypes = ((JavafxClassSymbol)intype.tsym).getSuperTypes();
            for (Type tp : supertypes) {
                bestSoFar = this.findMemberWithoutAccessChecks(env, site, name, expected, tp, bestSoFar, allowBoxing, useVarargs, operator);
                if (bestSoFar.kind >= 65) continue;
                break;
            }
        }
        return bestSoFar;
    }

    private boolean isExactMatch(Type mtype, Symbol bestSoFar) {
        if (bestSoFar.kind == 16 && bestSoFar.type instanceof Type.MethodType && mtype.tag == 12) {
            java.util.List actuals = ((Type.MethodType)mtype).getParameterTypes();
            List formals = ((Type.MethodType)bestSoFar.type).getParameterTypes();
            if (actuals != null && formals != null && ((List)actuals).size() == formals.size()) {
                for (Type actual : actuals) {
                    if (actual != formals.head) {
                        return false;
                    }
                    formals = formals.tail;
                }
                return true;
            }
        }
        return false;
    }

    Type newMethTemplate(List<Type> argtypes, List<Type> typeargtypes) {
        Type.MethodType mt = new Type.MethodType(argtypes, null, null, this.syms.methodClass);
        return typeargtypes == null ? mt : new Type.ForAll(typeargtypes, (Type)mt);
    }

    Symbol loadClass(JavafxEnv<JavafxAttrContext> env, Name name) {
        try {
            Symbol.ClassSymbol c = this.reader.loadClass(name);
            return this.isAccessible(env, c) ? c : new AccessError(c);
        }
        catch (ClassReader.BadClassFile err) {
            throw err;
        }
        catch (Symbol.CompletionFailure ex) {
            return this.typeNotFound;
        }
    }

    public Symbol findMemberType(JavafxEnv<JavafxAttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        Scope.Entry e = c.members().lookup(name);
        while (e.scope != null) {
            if (e.sym.kind == 2) {
                return this.isAccessible(env, site, e.sym) ? e.sym : new AccessError(env, site, e.sym);
            }
            e = e.next();
        }
        Type st = this.types.supertype(c.type);
        if (st != null && st.tag == 10) {
            sym = this.findMemberType(env, site, name, st.tsym);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if (bestSoFar.kind > 65 && c instanceof JavafxClassSymbol) {
            List<Type> supertypes = ((JavafxClassSymbol)c).getSuperTypes();
            for (Type tp : supertypes) {
                if (tp == null || tp.tag != 10) continue;
                sym = this.findField(env, site, name, tp.tsym);
                if (sym.kind < bestSoFar.kind) {
                    bestSoFar = sym;
                }
                if (bestSoFar.kind >= 65) continue;
                break;
            }
        }
        List<Type> l = this.types.interfaces(c.type);
        while (bestSoFar.kind != 65 && l.nonEmpty()) {
            sym = this.findMemberType(env, site, name, ((Type)l.head).tsym);
            if (bestSoFar.kind < 65 && sym.kind < 65 && sym.owner != bestSoFar.owner) {
                bestSoFar = new AmbiguityError(bestSoFar, sym);
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            l = l.tail;
        }
        return bestSoFar;
    }

    Symbol findGlobalType(JavafxEnv<JavafxAttrContext> env, Scope scope, Name name) {
        Symbol bestSoFar = this.typeNotFound;
        Scope.Entry e = scope.lookup(name);
        while (e.scope != null) {
            Symbol sym = this.loadClass(env, e.sym.flatName());
            if (bestSoFar.kind == 2 && sym.kind == 2 && bestSoFar != sym) {
                return new AmbiguityError(bestSoFar, sym);
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            e = e.next();
        }
        return bestSoFar;
    }

    Symbol findType(JavafxEnv<JavafxAttrContext> env, Name name) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        boolean staticOnly = false;
        JavafxEnv<JavafxAttrContext> env1 = env;
        while (env1.outer != null) {
            JFXClassDeclaration encl;
            if (JavafxResolve.isStatic(env1)) {
                staticOnly = true;
            }
            Scope.Entry e = ((JavafxAttrContext)env1.info).scope.lookup(name);
            while (e.scope != null) {
                if (e.sym.kind == 2) {
                    if (staticOnly && e.sym.type.tag == 14 && e.sym.owner.kind == 2) {
                        return new StaticError(e.sym);
                    }
                    return e.sym;
                }
                e = e.next();
            }
            sym = this.findMemberType(env1, env1.enclClass.sym.type, name, env1.enclClass.sym);
            if (staticOnly && sym.kind == 2 && sym.type.tag == 10 && sym.type.getEnclosingType().tag == 10 && env1.enclClass.sym.type.isParameterized() && sym.type.getEnclosingType().isParameterized()) {
                return new StaticError(sym);
            }
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            JFXClassDeclaration jFXClassDeclaration = encl = env1.baseClause ? (JFXClassDeclaration)env1.tree : env1.enclClass;
            if ((encl.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        if (env.tree.getFXTag() != JavafxTag.IMPORT) {
            sym = this.findGlobalType(env, env.toplevel.namedImportScope, name);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((sym = this.findGlobalType(env, env.toplevel.packge.members(), name)).exists()) {
            return sym;
        }
        if (sym.kind < bestSoFar.kind) {
            bestSoFar = sym;
        }
        if (env.tree.getFXTag() != JavafxTag.IMPORT) {
            sym = this.findGlobalType(env, env.toplevel.starImportScope, name);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return bestSoFar;
    }

    Symbol findIdent(JavafxEnv<JavafxAttrContext> env, Name name, int kind, Type expected) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        if ((kind & 0x14) != 0) {
            sym = this.findVar(env, name, kind, expected);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 2) != 0) {
            sym = this.findType(env, name);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 1) != 0) {
            return this.reader.enterPackage(name);
        }
        return bestSoFar;
    }

    Symbol findIdentInPackage(JavafxEnv<JavafxAttrContext> env, Symbol.TypeSymbol pck, Name name, int kind) {
        Name fullname = Symbol.TypeSymbol.formFullName(name, pck);
        Symbol bestSoFar = this.typeNotFound;
        Symbol.PackageSymbol pack = null;
        if ((kind & 1) != 0 && (pack = this.reader.enterPackage(fullname)).exists()) {
            return pack;
        }
        if ((kind & 2) != 0) {
            Symbol sym = this.loadClass(env, fullname);
            if (sym.exists()) {
                if (name == sym.name) {
                    return sym;
                }
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return pack != null ? pack : bestSoFar;
    }

    Symbol findIdentInType(JavafxEnv<JavafxAttrContext> env, Type site, Name name, int kind) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        if ((kind & 0x14) != 0) {
            sym = this.findField(env, site, name, site.tsym);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 2) != 0) {
            sym = this.findMemberType(env, site, name, site.tsym);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return bestSoFar;
    }

    Symbol access(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, boolean qualified, List<Type> argtypes, List<Type> typeargtypes) {
        if (sym.kind >= 65) {
            if (!(site.isErroneous() || Type.isErroneous(argtypes) || typeargtypes != null && Type.isErroneous(typeargtypes))) {
                ((ResolveError)sym).report(this.log, pos, site, name, argtypes, typeargtypes);
            }
            do {
                sym = ((ResolveError)sym).sym;
            } while (sym.kind >= 65);
            if (sym == this.syms.errSymbol || (sym.kind & 0x40) == 0 && (sym.kind & 2) != 0) {
                sym = new Type.ErrorType((Name)name, (Symbol.TypeSymbol)(qualified ? site.tsym : this.syms.noSymbol)).tsym;
            }
        }
        return sym;
    }

    Symbol access(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, boolean qualified, Type expected) {
        return this.access(sym, pos, site, name, qualified, expected.getParameterTypes(), expected.getTypeArguments());
    }

    public Symbol access(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, boolean qualified) {
        if (sym.kind >= 65) {
            return this.access(sym, pos, site, name, qualified, List.<Type>nil(), null);
        }
        return sym;
    }

    void checkNonAbstract(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if ((sym.flags() & 0x400L) != 0L) {
            this.log.error(pos, "abstract.cant.be.accessed.directly", JavafxResolve.kindName(sym), sym, sym.location());
        }
    }

    public void printscopes(Scope s) {
        while (s != null) {
            if (s.owner != null) {
                System.err.print(s.owner + ": ");
            }
            Scope.Entry e = s.elems;
            while (e != null) {
                if ((e.sym.flags() & 0x400L) != 0L) {
                    System.err.print("abstract ");
                }
                System.err.print(e.sym + " ");
                e = e.sibling;
            }
            System.err.println();
            s = s.next;
        }
    }

    void printscopes(JavafxEnv<JavafxAttrContext> env) {
        while (env.outer != null) {
            System.err.println("------------------------------");
            this.printscopes(((JavafxAttrContext)env.info).scope);
            env = env.outer;
        }
    }

    public void printscopes(Type t) {
        while (t.tag == 10) {
            this.printscopes(t.tsym.members());
            t = this.types.supertype(t);
        }
    }

    Symbol resolveIdent(JCDiagnostic.DiagnosticPosition pos, JavafxEnv<JavafxAttrContext> env, Name name, int kind, Type pt) {
        Symbol sym = this.findIdent(env, name, kind, pt);
        if (sym.kind >= 65) {
            return this.access(sym, pos, env.enclClass.sym.type, name, false, pt);
        }
        return sym;
    }

    Symbol resolveQualifiedMethod(JCDiagnostic.DiagnosticPosition pos, JavafxEnv<JavafxAttrContext> env, Type site, Name name, Type expected) {
        ((JavafxAttrContext)env.info).varArgs = false;
        Symbol sym = this.findMember(env, site, name, expected, false, false, false);
        if (this.varargsEnabled && sym.kind >= 69) {
            sym = this.findMember(env, site, name, expected, true, false, false);
            if (sym.kind >= 69) {
                ((JavafxAttrContext)env.info).varArgs = true;
                sym = this.findMember(env, site, name, expected, true, true, false);
            }
        }
        if (sym.kind >= 65) {
            sym = this.access(sym, pos, site, name, true, expected);
        }
        return sym;
    }

    public Symbol.MethodSymbol resolveInternalMethod(JCDiagnostic.DiagnosticPosition pos, JavafxEnv<JavafxAttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        Symbol sym = this.resolveQualifiedMethod(pos, env, site, name, this.newMethTemplate(argtypes, typeargtypes));
        if (sym.kind == 16) {
            return (Symbol.MethodSymbol)sym;
        }
        throw new FatalError(JCDiagnostic.fragment("fatal.err.cant.locate.meth", name));
    }

    public Symbol resolveConstructor(JCDiagnostic.DiagnosticPosition pos, JavafxEnv<JavafxAttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        ((JavafxAttrContext)env.info).varArgs = false;
        Symbol sym = this.resolveConstructor(pos, env, site, argtypes, typeargtypes, false, false);
        if (this.varargsEnabled && sym.kind >= 69) {
            sym = this.resolveConstructor(pos, env, site, argtypes, typeargtypes, true, false);
            if (sym.kind >= 69) {
                ((JavafxAttrContext)env.info).varArgs = true;
                sym = this.resolveConstructor(pos, env, site, argtypes, typeargtypes, true, true);
            }
        }
        if (sym.kind >= 65) {
            sym = this.access(sym, pos, site, this.names.init, true, argtypes, typeargtypes);
        }
        return sym;
    }

    public Symbol resolveConstructor(JCDiagnostic.DiagnosticPosition pos, JavafxEnv<JavafxAttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Symbol sym = this.findMethod(env, site, this.names.init, argtypes, typeargtypes, allowBoxing, useVarargs, false);
        if ((sym.flags() & 0x20000L) != 0L && (((JavafxAttrContext)env.info).scope.owner.flags() & 0x20000L) == 0L && ((JavafxAttrContext)env.info).scope.owner.outermostClass() != sym.outermostClass()) {
            this.chk.warnDeprecated(pos, sym);
        }
        return sym;
    }

    public Symbol.MethodSymbol resolveInternalConstructor(JCDiagnostic.DiagnosticPosition pos, JavafxEnv<JavafxAttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        Symbol sym = this.resolveConstructor(pos, env, site, argtypes, typeargtypes);
        if (sym.kind == 16) {
            return (Symbol.MethodSymbol)sym;
        }
        throw new FatalError(JCDiagnostic.fragment("fatal.err.cant.locate.ctor", site));
    }

    Symbol resolveOperator(JCDiagnostic.DiagnosticPosition pos, JavafxTag optag, JavafxEnv<JavafxAttrContext> env, List<Type> argtypes) {
        Name name = this.treeinfo.operatorName(optag);
        Symbol sym = this.findMethod(env, this.syms.predefClass.type, name, argtypes, null, false, false, true);
        if (this.boxingEnabled && sym.kind >= 69) {
            sym = this.findMethod(env, this.syms.predefClass.type, name, argtypes, null, true, false, true);
        }
        return this.access(sym, pos, env.enclClass.sym.type, name, false, argtypes, null);
    }

    Symbol resolveUnaryOperator(JCDiagnostic.DiagnosticPosition pos, JavafxTag optag, JavafxEnv<JavafxAttrContext> env, Type arg) {
        if (this.types.isSameType(arg, ((JavafxSymtab)this.syms).javafx_DurationType)) {
            Symbol res = null;
            switch (optag) {
                case NEG: {
                    res = this.resolveMethod(pos, env, this.names.fromString("negate"), arg, List.<Type>nil());
                }
            }
            if (res != null && res.kind == 16) {
                return res;
            }
        }
        return this.resolveOperator(pos, optag, env, List.of(arg));
    }

    Symbol resolveBinaryOperator(JCDiagnostic.DiagnosticPosition pos, JavafxTag optag, JavafxEnv<JavafxAttrContext> env, Type left, Type right) {
        if (this.types.isSameType(left, ((JavafxSymtab)this.syms).javafx_DurationType) || this.types.isSameType(right, ((JavafxSymtab)this.syms).javafx_DurationType)) {
            Type dur = left;
            Symbol res = null;
            switch (optag) {
                case PLUS: {
                    res = this.resolveMethod(pos, env, this.names.fromString("add"), dur, List.of(right));
                    break;
                }
                case MINUS: {
                    res = this.resolveMethod(pos, env, this.names.fromString("sub"), dur, List.of(right));
                    break;
                }
                case MUL: {
                    if (!this.types.isSameType(left, ((JavafxSymtab)this.syms).javafx_DurationType)) {
                        left = right;
                        right = dur;
                        dur = left;
                    }
                    res = this.resolveMethod(pos, env, this.names.fromString("mul"), dur, List.of(right));
                    break;
                }
                case DIV: {
                    res = this.resolveMethod(pos, env, this.names.fromString("div"), dur, List.of(right));
                    break;
                }
                case LT: {
                    res = this.resolveMethod(pos, env, this.names.fromString("lt"), dur, List.of(right));
                    break;
                }
                case LE: {
                    res = this.resolveMethod(pos, env, this.names.fromString("le"), dur, List.of(right));
                    break;
                }
                case GT: {
                    res = this.resolveMethod(pos, env, this.names.fromString("gt"), dur, List.of(right));
                    break;
                }
                case GE: {
                    res = this.resolveMethod(pos, env, this.names.fromString("ge"), dur, List.of(right));
                }
            }
            if (res != null && res.kind == 16) {
                return res;
            }
        }
        return this.resolveOperator(pos, optag, env, List.of(left, right));
    }

    Symbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, JavafxEnv<JavafxAttrContext> env, Name name, Type type, List<Type> argtypes) {
        Symbol sym = this.findMethod(env, type, name, argtypes, null, true, false, false);
        if (sym.kind == 16) {
            return this.access(sym, pos, env.enclClass.sym.type, name, false, argtypes, null);
        }
        return sym;
    }

    public Symbol resolveSelf(JCDiagnostic.DiagnosticPosition pos, JavafxEnv<JavafxAttrContext> env, Symbol.TypeSymbol c, Name name) {
        JavafxEnv<JavafxAttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            Symbol sym;
            if (JavafxResolve.isStatic(env1)) {
                staticOnly = true;
            }
            if (env1.enclClass.sym == c && (sym = ((JavafxAttrContext)env1.info).scope.lookup((Name)name).sym) != null) {
                if (staticOnly) {
                    sym = new StaticError(sym);
                }
                return this.access(sym, pos, env.enclClass.sym.type, name, true);
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        this.log.error(pos, "not.encl.class", c);
        return this.syms.errSymbol;
    }

    Symbol resolveSelfContaining(JCDiagnostic.DiagnosticPosition pos, JavafxEnv<JavafxAttrContext> env, Symbol member) {
        Name name = this.names._this;
        JavafxEnv<JavafxAttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            Symbol sym;
            if (JavafxResolve.isStatic(env1)) {
                staticOnly = true;
            }
            if (env1.enclClass.sym.isSubClass(member.owner, this.types) && this.isAccessible(env, env1.enclClass.sym.type, member) && (sym = ((JavafxAttrContext)env1.info).scope.lookup((Name)name).sym) != null) {
                if (staticOnly) {
                    sym = new StaticError(sym);
                }
                return this.access(sym, pos, env.enclClass.sym.type, name, true);
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        this.log.error(pos, "encl.class.required", member);
        return this.syms.errSymbol;
    }

    public Type resolveImplicitThis(JCDiagnostic.DiagnosticPosition pos, JavafxEnv<JavafxAttrContext> env, Type t) {
        Type thisType = ((t.tsym.owner.kind & 0x14) != 0 ? this.resolveSelf((JCDiagnostic.DiagnosticPosition)pos, env, (Symbol.TypeSymbol)t.getEnclosingType().tsym, (Name)this.names._this) : this.resolveSelfContaining((JCDiagnostic.DiagnosticPosition)pos, env, (Symbol)t.tsym)).type;
        if (((JavafxAttrContext)env.info).isSelfCall && thisType.tsym == env.enclClass.sym) {
            this.log.error(pos, "cant.ref.before.ctor.called", "this");
        }
        return thisType;
    }

    public static JCDiagnostic kindName(int kind) {
        switch (kind) {
            case 1: {
                return JCDiagnostic.fragment("kindname.package", new Object[0]);
            }
            case 2: {
                return JCDiagnostic.fragment("kindname.class", new Object[0]);
            }
            case 4: {
                return JCDiagnostic.fragment("kindname.variable", new Object[0]);
            }
            case 12: {
                return JCDiagnostic.fragment("kindname.value", new Object[0]);
            }
            case 16: {
                return JCDiagnostic.fragment("kindname.method", new Object[0]);
            }
        }
        return JCDiagnostic.fragment("kindname", Integer.toString(kind));
    }

    static JCDiagnostic kindName(Symbol sym) {
        switch (sym.getKind()) {
            case PACKAGE: {
                return JCDiagnostic.fragment("kindname.package", new Object[0]);
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: 
            case CLASS: {
                return JCDiagnostic.fragment("kindname.class", new Object[0]);
            }
            case TYPE_PARAMETER: {
                return JCDiagnostic.fragment("kindname.type.variable", new Object[0]);
            }
            case ENUM_CONSTANT: 
            case FIELD: 
            case PARAMETER: 
            case LOCAL_VARIABLE: 
            case EXCEPTION_PARAMETER: {
                return JCDiagnostic.fragment("kindname.variable", new Object[0]);
            }
            case METHOD: 
            case CONSTRUCTOR: 
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                return JCDiagnostic.fragment("kindname.method", new Object[0]);
            }
        }
        if (sym.kind == 12) {
            return JCDiagnostic.fragment("kindname.value", new Object[0]);
        }
        return JCDiagnostic.fragment("kindname", new Object[]{sym.getKind()});
    }

    public static JCDiagnostic kindNames(int kind) {
        StringBuffer key = new StringBuffer();
        key.append("kindname");
        if ((kind & 0xC) != 0) {
            key.append((kind & 0xC) == 4 ? ".variable" : ".value");
        }
        if ((kind & 0x10) != 0) {
            key.append(".method");
        }
        if ((kind & 2) != 0) {
            key.append(".class");
        }
        if ((kind & 1) != 0) {
            key.append(".package");
        }
        return JCDiagnostic.fragment(key.toString(), kind);
    }

    static JCDiagnostic typeKindName(Type t) {
        if (t.tag == 14 || t.tag == 10 && (t.tsym.flags() & 0x1000000L) != 0L) {
            return JCDiagnostic.fragment("kindname.type.variable.bound", new Object[0]);
        }
        if (t.tag == 13) {
            return JCDiagnostic.fragment("kindname.package", new Object[0]);
        }
        if ((t.tsym.flags_field & 0x2000L) != 0L) {
            return JCDiagnostic.fragment("kindname.annotation", new Object[0]);
        }
        if ((t.tsym.flags_field & 0x200L) != 0L) {
            return JCDiagnostic.fragment("kindname.interface", new Object[0]);
        }
        return JCDiagnostic.fragment("kindname.class", new Object[0]);
    }

    static JCDiagnostic absentKindName(int kind) {
        switch (kind) {
            case 68: {
                return JCDiagnostic.fragment("kindname.variable", new Object[0]);
            }
            case 69: 
            case 70: 
            case 71: {
                return JCDiagnostic.fragment("kindname.method", new Object[0]);
            }
            case 72: {
                return JCDiagnostic.fragment("kindname.class", new Object[0]);
            }
        }
        return JCDiagnostic.fragment("kindname", kind);
    }

    public void logAccessError(JavafxEnv<JavafxAttrContext> env, JCTree tree, Type type) {
        AccessError error = new AccessError(env, type.getEnclosingType(), type.tsym);
        error.report(this.log, tree.pos(), type.getEnclosingType(), null, null, null);
    }

    public boolean isInheritedIn(Symbol sym, Symbol clazz, JavafxTypes types) {
        switch ((short)(sym.flags_field & 7L)) {
            default: {
                return true;
            }
            case 2: {
                return sym.owner == clazz;
            }
            case 4: {
                return (clazz.flags() & 0x200L) == 0L;
            }
            case 0: 
        }
        if ((sym.flags() & 0x200000000000L) != 0L) {
            // empty if block
        }
        ListBuffer<Type> supertypes = ListBuffer.lb();
        HashSet<Type> superSet = new HashSet<Type>();
        if (clazz.type != null) {
            supertypes.append(clazz.type);
            superSet.add(clazz.type);
        }
        types.getSupertypes(clazz, supertypes, superSet);
        boolean foundInherited = false;
        for (Type supType : supertypes.toList()) {
            if (supType.tsym == sym.owner) {
                foundInherited = true;
                break;
            }
            if (supType.isErroneous()) {
                return true;
            }
            if (supType.tsym != null && (supType.tsym.flags() & 0x1000000L) == 0L) continue;
        }
        return foundInherited && (clazz.flags() & 0x200L) == 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AmbiguityError
    extends ResolveError {
        Symbol sym1;
        Symbol sym2;

        AmbiguityError(Symbol sym1, Symbol sym2) {
            super(65, sym1, "ambiguity error");
            this.sym1 = sym1;
            this.sym2 = sym2;
        }

        @Override
        void report(Log log, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            AmbiguityError pair = this;
            while (true) {
                if (pair.sym1.kind == 65) {
                    pair = (AmbiguityError)pair.sym1;
                    continue;
                }
                if (pair.sym2.kind != 65) break;
                pair = (AmbiguityError)pair.sym2;
            }
            Name sname = pair.sym1.name;
            if (sname == sname.table.init) {
                sname = pair.sym1.owner.name;
            }
            log.error(pos, "ref.ambiguous", sname, JavafxResolve.kindName(pair.sym1), pair.sym1, JavafxResolve.this.types.location(pair.sym1, site), JavafxResolve.kindName(pair.sym2), pair.sym2, JavafxResolve.this.types.location(pair.sym2, site));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StaticError
    extends ResolveError {
        StaticError(Symbol sym) {
            super(67, sym, "static error");
        }

        @Override
        void report(Log log, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            String symstr = (this.sym.kind == 2 && this.sym.type.tag == 10 ? JavafxResolve.this.types.erasure(this.sym.type) : this.sym).toString();
            log.error(pos, "non-static.cant.be.ref", JavafxResolve.kindName(this.sym), symstr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AccessError
    extends ResolveError {
        private JavafxEnv<JavafxAttrContext> env;
        private Type site;

        AccessError(Symbol sym) {
            this(null, null, sym);
        }

        AccessError(JavafxEnv<JavafxAttrContext> env, Type site, Symbol sym) {
            super(66, sym, "access error");
            this.env = env;
            this.site = site;
            if (JavafxResolve.this.debugResolve) {
                JavafxResolve.this.log.error("proc.messager", sym + " @ " + site + " is inaccessible.");
            }
        }

        @Override
        void report(Log log, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (this.sym.owner.type.tag != 19) {
                if (this.sym.name == this.sym.name.table.init && this.sym.owner != site.tsym) {
                    new ResolveError(71, this.sym.owner, "absent method " + this.sym).report(log, pos, site, name, argtypes, typeargtypes);
                }
                if ((this.sym.flags() & 1L) != 0L || this.env != null && this.site != null && !JavafxResolve.this.isAccessible(this.env, this.site)) {
                    log.error(pos, "not.def.access.class.intf.cant.access", this.sym, this.sym.location());
                } else if ((this.sym.flags() & 0x200000000007L) == 0L) {
                    log.error(pos, "not.def.public.cant.access", this.sym, this.sym.location());
                } else {
                    log.error(pos, "report.access", this.sym, JavafxCheck.protectionString(this.sym.flags()), this.sym.location());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolveError
    extends Symbol {
        final String debugName;
        final Symbol sym;
        Symbol wrongSym;
        JCDiagnostic explanation;

        ResolveError(int kind, Symbol sym, String debugName) {
            super(kind, 0L, null, null, null);
            this.debugName = debugName;
            this.sym = sym;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            throw new AssertionError();
        }

        @Override
        public String toString() {
            return this.debugName + " wrongSym=" + this.wrongSym + " explanation=" + this.explanation;
        }

        ResolveError setWrongSym(Symbol sym, JCDiagnostic explanation) {
            this.wrongSym = sym;
            this.explanation = explanation;
            return this;
        }

        ResolveError setWrongSym(Symbol sym) {
            this.wrongSym = sym;
            this.explanation = null;
            return this;
        }

        @Override
        public boolean exists() {
            switch (this.kind) {
                case 66: 
                case 68: 
                case 71: 
                case 72: {
                    return false;
                }
            }
            return true;
        }

        void report(Log log, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (name != name.table.error) {
                JCDiagnostic kindname = JavafxResolve.absentKindName(this.kind);
                String idname = name.toString();
                String args = "";
                String typeargs = "";
                if (this.kind >= 69 && this.kind <= 71) {
                    if (this.isOperator(name)) {
                        log.error(pos, "operator.cant.be.applied", name, Type.toString(argtypes));
                        return;
                    }
                    if (name == name.table.init) {
                        kindname = JCDiagnostic.fragment("kindname.constructor", new Object[0]);
                        idname = site.tsym.name.toString();
                    }
                    args = "(" + Type.toString(argtypes) + ")";
                    if (typeargtypes != null && typeargtypes.nonEmpty()) {
                        typeargs = "<" + Type.toString(typeargtypes) + ">";
                    }
                }
                if (this.kind == 70) {
                    String wrongSymStr = this.wrongSym instanceof Symbol.MethodSymbol ? JavafxResolve.this.types.toJavaFXString((Symbol.MethodSymbol)this.wrongSym.asMemberOf(site, JavafxResolve.this.types), ((Symbol.MethodSymbol)this.wrongSym).params) : this.wrongSym.toString();
                    log.error(pos, "cant.apply.symbol" + (this.explanation != null ? ".1" : ""), wrongSymStr, JavafxResolve.this.types.location(this.wrongSym, site), typeargs, JavafxResolve.this.types.toJavaFXString(argtypes), this.explanation);
                } else if (site.tsym.name.len != 0) {
                    if (site.tsym.kind == 1 && !site.tsym.exists()) {
                        log.error(pos, "doesnt.exist", site.tsym);
                    } else {
                        log.error(pos, "cant.resolve.location", kindname, idname, args, typeargs, JavafxResolve.typeKindName(site), site);
                    }
                } else {
                    log.error(pos, "cant.resolve", kindname, idname, args, typeargs);
                }
            }
        }

        boolean isOperator(Name name) {
            int i;
            for (i = 0; i < name.len && "+-~!*/%&|^<>=".indexOf(name.byteAt(i)) >= 0; ++i) {
            }
            return i > 0 && i == name.len;
        }
    }
}

