/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.javafx.api.JavafxBindStatus;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.code.FunctionType;
import com.sun.tools.javafx.comp.JavafxOptimizationStatistics;
import com.sun.tools.javafx.comp.JavafxToJava;
import com.sun.tools.javafx.comp.JavafxTranslationSupport;
import com.sun.tools.javafx.comp.JavafxTypeMorpher;
import com.sun.tools.javafx.tree.JFXAssign;
import com.sun.tools.javafx.tree.JFXAssignOp;
import com.sun.tools.javafx.tree.JFXBinary;
import com.sun.tools.javafx.tree.JFXBlock;
import com.sun.tools.javafx.tree.JFXBreak;
import com.sun.tools.javafx.tree.JFXCatch;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXContinue;
import com.sun.tools.javafx.tree.JFXErroneous;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXForExpression;
import com.sun.tools.javafx.tree.JFXForExpressionInClause;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXFunctionInvocation;
import com.sun.tools.javafx.tree.JFXFunctionValue;
import com.sun.tools.javafx.tree.JFXIdent;
import com.sun.tools.javafx.tree.JFXIfExpression;
import com.sun.tools.javafx.tree.JFXImport;
import com.sun.tools.javafx.tree.JFXIndexof;
import com.sun.tools.javafx.tree.JFXInitDefinition;
import com.sun.tools.javafx.tree.JFXInstanceOf;
import com.sun.tools.javafx.tree.JFXInstanciate;
import com.sun.tools.javafx.tree.JFXInterpolateValue;
import com.sun.tools.javafx.tree.JFXKeyFrameLiteral;
import com.sun.tools.javafx.tree.JFXLiteral;
import com.sun.tools.javafx.tree.JFXModifiers;
import com.sun.tools.javafx.tree.JFXObjectLiteralPart;
import com.sun.tools.javafx.tree.JFXOnReplace;
import com.sun.tools.javafx.tree.JFXOverrideClassVar;
import com.sun.tools.javafx.tree.JFXParens;
import com.sun.tools.javafx.tree.JFXPostInitDefinition;
import com.sun.tools.javafx.tree.JFXReturn;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXSelect;
import com.sun.tools.javafx.tree.JFXSequenceDelete;
import com.sun.tools.javafx.tree.JFXSequenceEmpty;
import com.sun.tools.javafx.tree.JFXSequenceExplicit;
import com.sun.tools.javafx.tree.JFXSequenceIndexed;
import com.sun.tools.javafx.tree.JFXSequenceInsert;
import com.sun.tools.javafx.tree.JFXSequenceRange;
import com.sun.tools.javafx.tree.JFXSequenceSlice;
import com.sun.tools.javafx.tree.JFXSkip;
import com.sun.tools.javafx.tree.JFXStringExpression;
import com.sun.tools.javafx.tree.JFXThrow;
import com.sun.tools.javafx.tree.JFXTimeLiteral;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JFXTry;
import com.sun.tools.javafx.tree.JFXTypeAny;
import com.sun.tools.javafx.tree.JFXTypeCast;
import com.sun.tools.javafx.tree.JFXTypeClass;
import com.sun.tools.javafx.tree.JFXTypeFunctional;
import com.sun.tools.javafx.tree.JFXTypeUnknown;
import com.sun.tools.javafx.tree.JFXUnary;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JFXVarScriptInit;
import com.sun.tools.javafx.tree.JFXWhileLoop;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxToBound
extends JavafxTranslationSupport
implements JavafxVisitor {
    protected static final Context.Key<JavafxToBound> jfxToBoundKey = new Context.Key();
    private final JavafxToJava toJava;
    private final JavafxOptimizationStatistics optStat;
    private final Symbol doubleObjectTypeSymbol;
    private final Symbol intObjectTypeSymbol;
    private final Symbol booleanObjectTypeSymbol;
    private final Name param1Name;
    private final Name computeElementsName;
    private JavafxTypeMorpher.TypeMorphInfo tmiTarget = null;
    private static final String cBoundSequences = "com.sun.javafx.runtime.sequence.BoundSequences";
    private static final String cBoundOperators = "com.sun.javafx.runtime.location.BoundOperators";
    private static final String cLocations = "com.sun.javafx.runtime.location.Locations";
    private static final String cFunction0 = "com.sun.javafx.functions.Function0";
    private static final String cFunction1 = "com.sun.javafx.functions.Function1";

    public static JavafxToBound instance(Context context) {
        JavafxToBound instance = context.get(jfxToBoundKey);
        if (instance == null) {
            instance = new JavafxToBound(context);
        }
        return instance;
    }

    protected JavafxToBound(Context context) {
        super(context);
        context.put(jfxToBoundKey, this);
        this.toJava = JavafxToJava.instance(context);
        this.optStat = JavafxOptimizationStatistics.instance(context);
        this.doubleObjectTypeSymbol = this.types.boxedClass((Type)this.syms.doubleType).type.tsym;
        this.intObjectTypeSymbol = this.types.boxedClass((Type)this.syms.intType).type.tsym;
        this.booleanObjectTypeSymbol = this.types.boxedClass((Type)this.syms.booleanType).type.tsym;
        this.param1Name = this.names.fromString("x1$");
        this.computeElementsName = this.names.fromString("computeElements$");
    }

    private <TFX extends JFXExpression, TC extends JCTree> TC translateGeneric(TFX tree, JavafxTypeMorpher.TypeMorphInfo tmi) {
        JCTree ret;
        JavafxTypeMorpher.TypeMorphInfo tmiPrevTarget = this.tmiTarget;
        this.tmiTarget = tmi;
        if (tree == null) {
            ret = null;
        } else {
            JFXTree prevWhere = this.toJava.attrEnv.where;
            this.toJava.attrEnv.where = tree;
            tree.accept(this);
            this.toJava.attrEnv.where = prevWhere;
            ret = this.result;
            this.result = null;
        }
        this.tmiTarget = tmiPrevTarget;
        return (TC)ret;
    }

    public JCTree.JCExpression translate(JFXExpression tree) {
        return (JCTree.JCExpression)this.translateGeneric(tree);
    }

    public JCTree.JCExpression translate(JFXExpression tree, JavafxTypeMorpher.TypeMorphInfo tmi) {
        return (JCTree.JCExpression)this.translateGeneric(tree, tmi);
    }

    public JCTree.JCExpression translate(JFXExpression tree, Type type) {
        return (JCTree.JCExpression)this.translateGeneric(tree, type);
    }

    public <TFX extends JFXExpression, TC extends JCTree> TC translateGeneric(TFX tree, Type type) {
        return this.translateGeneric(tree, this.typeMorpher.typeMorphInfo(type));
    }

    public <TFX extends JFXExpression, TC extends JCTree> TC translateGeneric(TFX tree) {
        return this.translateGeneric(tree, (JavafxTypeMorpher.TypeMorphInfo)null);
    }

    private List<JCTree.JCExpression> translate(List<JFXExpression> trees, Type methType, boolean usesVarArgs) {
        return this.translateGeneric(trees, methType, usesVarArgs);
    }

    private <TFX extends JFXExpression, TC extends JCTree.JCExpression> List<TC> translateGeneric(List<TFX> trees, Type methType, boolean usesVarArgs) {
        ListBuffer translated = ListBuffer.lb();
        boolean handlingVarargs = false;
        Type formal = null;
        List<Type> t = methType.getParameterTypes();
        List<Object> l = trees;
        while (l.nonEmpty()) {
            JCTree.JCExpression tree;
            if (!handlingVarargs) {
                formal = (Type)t.head;
                t = t.tail;
                if (usesVarArgs && t.isEmpty()) {
                    formal = this.types.elemtype(formal);
                    handlingVarargs = true;
                }
            }
            if ((tree = (JCTree.JCExpression)this.translateGeneric((JFXExpression)l.head, formal)) != null) {
                if (tree.type == null) {
                    tree.type = formal;
                }
                translated.append(tree);
            }
            l = l.tail;
        }
        List args = translated.toList();
        return args;
    }

    private JCTree.JCExpression convert(Type inType, JCTree.JCExpression tree) {
        if (this.tmiTarget == null) {
            tree.type = inType;
            return tree;
        }
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        Type targetType = this.tmiTarget.getRealType();
        if (!this.types.isSameType(inType, targetType)) {
            if (this.types.isSequence(targetType) && this.types.isSequence(inType)) {
                Type targetElementType = this.tmiTarget.getElementType();
                if (targetElementType == null) {
                    tree.type = inType;
                    return tree;
                }
                Type inElementType = this.typeMorpher.typeMorphInfo(inType).getElementType();
                if (!this.types.isSameType(inElementType, targetElementType)) {
                    JCTree.JCExpression targetClass = this.makeElementClassObject(diagPos, targetElementType);
                    tree = this.runtime(diagPos, cBoundSequences, "upcast", List.of(targetClass, tree));
                }
            } else if (targetType == this.syms.doubleType) {
                tree = this.runtime(diagPos, cLocations, "asDoubleLocation", List.of(tree));
            } else if (targetType == this.syms.intType) {
                tree = this.runtime(diagPos, cLocations, "asIntLocation", List.of(tree));
            } else if (targetType == this.syms.booleanType) {
                tree = this.runtime(diagPos, cLocations, "asBooleanLocation", List.of(tree));
            } else if (this.tmiTarget.getTypeKind() == 0) {
                List<JCTree.JCExpression> typeArgs = List.of(this.makeTypeTree(diagPos, targetType, true), this.makeTypeTree(diagPos, this.syms.boxIfNeeded(inType), true));
                Type inRealType = this.typeMorpher.typeMorphInfo(inType).getRealType();
                JCTree.JCExpression inClass = this.makeElementClassObject(diagPos, inRealType);
                tree = this.runtime(diagPos, cLocations, "upcast", typeArgs, List.of(inClass, tree));
            }
        }
        tree.type = targetType;
        return tree;
    }

    private Type targetType(Type type) {
        return this.tmiTarget != null ? this.tmiTarget.getRealType() : type;
    }

    private JCTree.JCVariableDecl translateVar(JFXVar tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JFXModifiers mods = tree.getModifiers();
        long modFlags = mods == null ? 0L : mods.flags;
        JCTree.JCModifiers tmods = this.make.at(diagPos).Modifiers(modFlags |= 0x10L);
        JavafxTypeMorpher.VarMorphInfo vmi = this.typeMorpher.varMorphInfo(tree.sym);
        JCTree.JCExpression typeExpression = this.makeTypeTree(diagPos, vmi.getLocationType(), true);
        JCTree.JCExpression init = tree.init == null ? this.makeLocationAttributeVariable(vmi, diagPos) : this.translate(tree.init, vmi.getRealFXType());
        return this.make.at(diagPos).VarDef(tmods, tree.name, typeExpression, init);
    }

    private JCTree.JCStatement definitionalAssignmentToSet(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression init, JavafxBindStatus bindStatus, Symbol.VarSymbol vsym, Name instanceName, int milieu) {
        return this.make.at(diagPos).Exec(this.definitionalAssignmentToSetExpression(diagPos, init, bindStatus, vsym, instanceName, milieu));
    }

    private JCTree.JCExpression definitionalAssignmentToSetExpression(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression init, JavafxBindStatus bindStatus, Symbol.VarSymbol vsym, Name instanceName, int milieu) {
        JavafxTypeMorpher.VarMorphInfo vmi = this.typeMorpher.varMorphInfo(vsym);
        JCTree.JCExpression nonNullInit = init == null ? this.makeDefaultValue(diagPos, vmi) : init;
        return this.toJava.definitionalAssignmentToSetExpression(diagPos, nonNullInit, bindStatus, vsym, instanceName, vmi.getTypeKind(), milieu);
    }

    @Override
    public void visitInstanciate(final JFXInstanciate tree) {
        this.result = new BindingExpressionClosureTranslator(tree.pos(), tree.type){

            protected JCTree.JCExpression resultValue() {
                return new JavafxToJava.InstanciateTranslator(tree, this.toJava){

                    @Override
                    protected void processLocalVar(JFXVar var) {
                        JFXExpression init = var.getInitializer();
                        JCTree.JCExpression tinit = init == null ? JavafxToBound.this.makeLocationAttributeVariable(JavafxToBound.this.typeMorpher.varMorphInfo(var.sym), this.diagPos) : JavafxToBound.this.translate(init);
                        this.buildArgField(tinit, var.type, var.getName().toString(), true);
                    }

                    @Override
                    protected List<JCTree.JCExpression> translatedConstructorArgs() {
                        if (this.tree.getArgs().size() > 0) {
                            this.buildArgFields(JavafxToBound.this.translate(this.tree.getArgs(), this.tree.constructor.type, false), false);
                            return callArgs.toList();
                        }
                        return List.nil();
                    }

                    @Override
                    protected JCTree.JCStatement translateAttributeSet(JFXExpression init, JavafxBindStatus bindStatus, Symbol.VarSymbol vsym, Name instanceName) {
                        JCTree.JCExpression initRef = this.buildArgField(JavafxToBound.this.translate(init, vsym.type), vsym.type, vsym.name.toString() + "$attr", bindStatus.isBound());
                        return JavafxToBound.this.definitionalAssignmentToSet(this.diagPos, initRef, bindStatus, vsym, instanceName, 1);
                    }
                }.doit();
            }
        }.doit();
    }

    @Override
    public void visitStringExpression(final JFXStringExpression tree) {
        this.result = new BindingExpressionClosureTranslator(tree.pos(), this.syms.stringType){

            protected JCTree.JCExpression resultValue() {
                return new JavafxToJava.StringExpressionTranslator(tree, this.toJava){

                    protected JCTree.JCExpression translateArg(JFXExpression arg) {
                        return this.buildArgField(JavafxToBound.this.translate(arg), arg.type);
                    }
                }.doit();
            }
        }.doit();
    }

    @Override
    public void visitFunctionValue(JFXFunctionValue tree) {
        JFXFunctionDefinition def = tree.definition;
        this.result = this.makeConstantLocation(tree.pos(), this.targetType(tree.type), this.toJava.makeFunctionValue(this.make.Ident(this.defs.lambdaName), def, tree.pos(), (Type.MethodType)def.type));
    }

    @Override
    public void visitBlockExpression(JFXBlock tree) {
        assert (tree.type != this.syms.voidType) : "void block expressions should be not exist in bind expressions";
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JFXExpression value = tree.value;
        ListBuffer translatedVars = ListBuffer.lb();
        for (JFXExpression stmt : tree.getStmts()) {
            if (stmt.getFXTag() == JavafxTag.VAR_DEF) {
                JFXVar var = (JFXVar)stmt;
                translatedVars.append(this.translateVar(var));
                this.optStat.recordLocalVar(var.sym, true, true);
                continue;
            }
            this.log.error(diagPos, "javafx.not.allowed.in.bind.context", stmt.toString());
        }
        while (value.getFXTag() == JavafxTag.VAR_DEF) {
            value = ((JFXVar)value).getInitializer();
        }
        assert (value.getFXTag() != JavafxTag.RETURN);
        this.result = this.makeBlockExpression(diagPos, translatedVars.toList(), this.translate(value, this.tmiTarget));
    }

    @Override
    public void visitAssign(JFXAssign tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JavafxTypeMorpher.TypeMorphInfo tmi = this.typeMorpher.typeMorphInfo(tree.type);
        int typeKind = tmi.getTypeKind();
        JCTree.JCVariableDecl varDecl = this.makeTmpVar(diagPos, tmi.getLocationType(), this.translate(tree.rhs));
        JCTree.JCStatement setStmt = this.callStatement(diagPos, this.translate(tree.lhs), this.defs.locationSetMethodName[typeKind], (Object)this.callExpression(diagPos, (JCTree.JCExpression)this.make.at(diagPos).Ident(varDecl.name), this.defs.locationGetMethodName[typeKind]));
        this.result = this.makeBlockExpression(diagPos, List.of(varDecl, setStmt), (JCTree.JCExpression)this.make.at(diagPos).Ident(varDecl.name));
    }

    @Override
    public void visitAssignop(JFXAssignOp tree) {
        this.log.error(tree.pos(), "javafx.not.allowed.in.bind.context", "=");
    }

    private JCTree.JCExpression makeBoundSelect(JCDiagnostic.DiagnosticPosition diagPos, Type resultType, JCTree.JCExpression receiverExpr, Function1ClosureTranslator translator) {
        JavafxTypeMorpher.TypeMorphInfo tmi = this.tmiTarget != null ? this.tmiTarget : this.typeMorpher.typeMorphInfo(resultType);
        List<JCTree.JCExpression> args = List.of(this.makeLaziness(diagPos), receiverExpr, translator.doit());
        if (tmi.isSequence() || tmi.getTypeKind() == 0) {
            args = args.prepend(this.makeElementClassObject(diagPos, tmi.getElementType()));
        }
        return this.runtime(diagPos, cBoundOperators, "makeBoundSelect", args);
    }

    @Override
    public void visitSelect(final JFXSelect tree) {
        if (tree.type instanceof FunctionType && tree.sym.type instanceof Type.MethodType) {
            this.result = this.convert(tree.type, this.toJava.translate((JFXExpression)tree, JavafxToJava.Wrapped.InLocation));
            return;
        }
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        Symbol owner = tree.sym.owner;
        if (this.types.isJFXClass(owner) && this.typeMorpher.requiresLocation(tree.sym)) {
            if (tree.sym.isStatic()) {
                JCTree.JCExpression classRef = this.makeTypeTree(diagPos, this.types.erasure(tree.sym.owner.type), false);
                this.result = this.convert(tree.type, this.make.at(diagPos).Select(classRef, this.attributeFieldName(tree.sym)));
            } else {
                JFXExpression expr = tree.getExpression();
                this.result = this.makeBoundSelect(diagPos, tree.type, this.translate(expr), new Function1ClosureTranslator(diagPos, tree.type, expr.type){

                    protected JCTree.JCExpression makeInvokeMethodBody() {
                        return JavafxToBound.this.convert(tree.type, this.toJava.convertVariableReference(this.diagPos, JavafxToBound.this.make.at(this.diagPos).Select((JCTree.JCExpression)JavafxToBound.this.make.at(this.diagPos).Ident(JavafxToBound.this.param1Name), tree.getIdentifier()), tree.sym, true));
                    }
                });
            }
        } else {
            this.result = tree.sym.isStatic() ? this.makeUnboundLocation(diagPos, this.targetType(tree.type), this.toJava.translate((JFXExpression)tree, JavafxToJava.Wrapped.InNothing)) : new BindingExpressionClosureTranslator(diagPos, tree.type){
                private JFXExpression selector;
                private JavafxTypeMorpher.TypeMorphInfo tmiSelector;
                private Name selectorName;
                {
                    super(x0, x1);
                    this.selector = tree.getExpression();
                    this.tmiSelector = JavafxToBound.this.typeMorpher.typeMorphInfo(this.selector.type);
                    this.selectorName = JavafxToBound.this.getSyntheticName("selector");
                }

                protected JCTree.JCExpression resultValue() {
                    JCTree.JCExpression transSelector = this.makeGetField(this.selectorName, this.tmiSelector);
                    JCTree.JCExpression toTest = this.makeGetField(this.selectorName, this.tmiSelector);
                    JCTree.JCFieldAccess selectExpr = this.m().Select(transSelector, tree.getIdentifier());
                    JCTree.JCBinary cond = this.m().Binary(61, toTest, JavafxToBound.this.make.Literal(17, null));
                    JCTree.JCExpression defaultExpr = JavafxToBound.this.makeDefaultValue(this.diagPos, this.tmiResult);
                    return this.m().Conditional(cond, selectExpr, defaultExpr);
                }

                protected void buildFields() {
                    this.buildArgField(JavafxToBound.this.translate(this.selector), this.selector.type, this.selectorName.toString());
                }
            }.doit();
        }
    }

    @Override
    public void visitIdent(JFXIdent tree) {
        JCTree.JCExpression transId = this.toJava.translate((JFXExpression)tree, JavafxToJava.Wrapped.InLocation);
        this.result = this.convert(tree.type, transId);
    }

    @Override
    public void visitSequenceExplicit(JFXSequenceExplicit tree) {
        ListBuffer<JCTree.JCStatement> stmts = ListBuffer.lb();
        Type elemType = this.elementType(this.targetType(tree.type));
        JavafxToJava.UseSequenceBuilder builder = this.toJava.useBoundSequenceBuilder(tree.pos(), elemType);
        stmts.append(builder.makeBuilderVar());
        for (JFXExpression item : tree.getItems()) {
            stmts.append(builder.makeAdd(item));
        }
        this.result = this.makeBlockExpression(tree.pos(), stmts, builder.makeToSequence());
    }

    @Override
    public void visitSequenceRange(JFXSequenceRange tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        boolean toNumber = tree.getLower().type == this.syms.doubleType || tree.getUpper().type == this.syms.doubleType || tree.getStepOrNull() != null && tree.getStepOrNull().type == this.syms.doubleType;
        JavafxTypeMorpher.TypeMorphInfo tmi = this.typeMorpher.typeMorphInfo(toNumber ? this.syms.doubleType : this.syms.intType);
        ListBuffer<JCTree.JCExpression> args = ListBuffer.lb();
        args.append(this.translate(tree.getLower(), tmi));
        args.append(this.translate(tree.getUpper(), tmi));
        if (tree.getStepOrNull() != null) {
            args.append(this.translate(tree.getStepOrNull(), tmi));
        }
        if (tree.isExclusive()) {
            args.append(this.make.at(diagPos).Literal(8, 1));
        }
        this.result = this.convert(tree.type, this.runtime(diagPos, cBoundSequences, "range", args));
    }

    @Override
    public void visitSequenceEmpty(JFXSequenceEmpty tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        if (this.types.isSequence(tree.type)) {
            Type elemType = this.types.elementType(this.targetType(tree.type));
            this.result = this.runtime(diagPos, cBoundSequences, "empty", List.of(this.makeElementClassObject(diagPos, elemType)));
        } else {
            this.result = this.makeConstantLocation(diagPos, this.targetType(tree.type), this.makeNull(diagPos));
        }
    }

    @Override
    public void visitSequenceIndexed(JFXSequenceIndexed tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        this.result = this.convert(tree.type, this.runtime(diagPos, cBoundSequences, "element", List.of(this.translate(tree.getSequence()), this.translate(tree.getIndex(), this.syms.intType))));
    }

    @Override
    public void visitSequenceSlice(JFXSequenceSlice tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        this.result = this.runtime(diagPos, cBoundSequences, tree.getEndKind() == 1 ? "sliceExclusive" : "slice", List.of(this.makeElementClassObject(diagPos, this.types.elementType(this.targetType(tree.type))), this.translate(tree.getSequence()), this.translate(tree.getFirstIndex()), new JCTree.JCExpression[]{tree.getLastIndex() == null ? this.makeNull(diagPos) : this.translate(tree.getLastIndex())}));
    }

    @Override
    public void visitForExpression(final JFXForExpression tree) {
        this.result = new JavafxToJava.Translator(tree.pos(), this.toJava){
            private final JavafxTypeMorpher.TypeMorphInfo tmiResult;
            private final Type resultElementType;
            private final Type resultSequenceLocationType;
            private final boolean isSimple = false;
            {
                super(x0, x1);
                this.tmiResult = JavafxToBound.this.typeMorpher.typeMorphInfo(JavafxToBound.this.targetType(tree.type));
                this.resultElementType = this.tmiResult.getElementType();
                this.resultSequenceLocationType = JavafxToBound.this.typeMorpher.generifyIfNeeded(JavafxToBound.this.typeMorpher.locationType(4), this.tmiResult);
                this.isSimple = false;
            }

            private JCTree.JCExpression makeResultClass() {
                return JavafxToBound.this.makeElementClassObject(this.diagPos, this.resultElementType);
            }

            private JCTree.JCVariableDecl makeParam(Type type, Name name) {
                return JavafxToBound.this.make.at(this.diagPos).VarDef(JavafxToBound.this.make.Modifiers(0x200000010L), name, this.makeExpression(type), null);
            }

            private JCTree.JCExpression makeCore() {
                JCTree.JCExpression body = JavafxToBound.this.translate(tree.getBodyExpression());
                if (!this.types.isSequence(tree.getBodyExpression().type)) {
                    List<JCTree.JCExpression> args = List.of(this.makeResultClass(), body);
                    body = JavafxToBound.this.runtime(this.diagPos, JavafxToBound.cBoundSequences, "singleton", args);
                }
                JCTree.JCExpression whereTest = null;
                for (JFXForExpressionInClause clause : tree.getForExpressionInClauses()) {
                    JCTree.JCExpression where = JavafxToBound.this.translate(clause.getWhereExpression());
                    if (where == null) continue;
                    if (whereTest == null) {
                        whereTest = where;
                        continue;
                    }
                    whereTest = JavafxToBound.this.runtime(this.diagPos, JavafxToBound.cBoundOperators, "and_bb", List.of(whereTest, where));
                }
                if (whereTest != null) {
                    body = JavafxToBound.this.makeBoundConditional(this.diagPos, tree.type, body, JavafxToBound.this.runtime(this.diagPos, JavafxToBound.cBoundSequences, "empty", List.of(JavafxToBound.this.makeElementClassObject(this.diagPos, this.resultElementType))), whereTest);
                }
                return body;
            }

            private JCTree makeComputeElementsMethod(JFXForExpressionInClause clause, JCTree.JCExpression inner, JavafxTypeMorpher.TypeMorphInfo tmiInduction) {
                Type iVarType = tmiInduction.getLocationType();
                Type idxVarType = JavafxToBound.this.typeMorpher.locationType(3);
                Name computeName = JavafxToBound.this.computeElementsName;
                ListBuffer stmts = ListBuffer.lb();
                Name ivarName = clause.getVar().name;
                stmts.append(this.m().Return(inner));
                List<JCTree.JCVariableDecl> params = List.of(this.makeParam(iVarType, ivarName), this.makeParam(idxVarType, JavafxToBound.this.indexVarName(clause)));
                return this.m().MethodDef(this.m().Modifiers(4L), computeName, this.makeExpression(this.resultSequenceLocationType), List.<JCTree.JCTypeParameter>nil(), params, List.<JCTree.JCExpression>nil(), this.m().Block(0L, stmts.toList()), null);
            }

            private JCTree.JCExpression makeBoundComprehension(JFXForExpressionInClause clause, JCTree.JCExpression inner) {
                JFXExpression seq = clause.getSequenceExpression();
                JavafxTypeMorpher.TypeMorphInfo tmiSeq = JavafxToBound.this.typeMorpher.typeMorphInfo(seq.type);
                JavafxTypeMorpher.TypeMorphInfo tmiInduction = JavafxToBound.this.typeMorpher.typeMorphInfo(clause.getVar().type);
                Type elementType = tmiSeq.getElementType();
                JCTree.JCClassDecl classDecl = this.m().AnonymousClassDef(this.m().Modifiers(0L), List.of(this.makeComputeElementsMethod(clause, inner, tmiInduction)));
                List<JCTree.JCExpression> typeArgs = List.nil();
                boolean useIndex = clause.getIndexUsed();
                JCTree.JCExpression transSeq = JavafxToBound.this.translate(seq);
                if (!tmiSeq.isSequence()) {
                    transSeq = JavafxToBound.this.runtime(this.diagPos, JavafxToBound.cBoundSequences, "singleton", List.of(this.makeResultClass(), transSeq));
                }
                List<JCTree.JCExpression> constructorArgs = List.of(this.makeResultClass(), transSeq, this.m().Literal(8, useIndex ? 1 : 0));
                int typeKind = tmiInduction.getTypeKind();
                Type bcType = JavafxToBound.this.typeMorpher.boundComprehensionNCT[typeKind].type;
                JCTree.JCExpression clazz = this.makeExpression(this.types.erasure(bcType));
                ListBuffer typeParams = ListBuffer.lb();
                if (typeKind == 0) {
                    typeParams.append(this.makeExpression(elementType));
                }
                typeParams.append(this.makeExpression(this.resultElementType));
                clazz = this.m().TypeApply(clazz, typeParams.toList());
                return this.m().NewClass(null, typeArgs, clazz, constructorArgs, classDecl);
            }

            public JCTree.JCExpression doit() {
                List<JFXForExpressionInClause> clauses = tree.getForExpressionInClauses();
                JCTree.JCExpression expr = this.makeCore();
                for (int inx = clauses.size() - 1; inx >= 0; --inx) {
                    JFXForExpressionInClause clause = clauses.get(inx);
                    expr = this.makeBoundComprehension(clause, expr);
                }
                return expr;
            }
        }.doit();
    }

    @Override
    public void visitIndexof(JFXIndexof tree) {
        assert (tree.clause.getIndexUsed()) : "assert that index used is set correctly";
        JCTree.JCIdent transIndex = this.make.at(tree.pos()).Ident(this.indexVarName(tree.fname));
        Symbol.VarSymbol vsym = tree.clause.getVar().sym;
        this.result = this.toJava.requiresLocation(vsym) ? this.convert(tree.type, transIndex) : this.makeConstantLocation(tree.pos(), this.targetType(tree.type), transIndex);
    }

    private JCTree.JCExpression makeBoundConditional(JCDiagnostic.DiagnosticPosition diagPos, Type resultType, JCTree.JCExpression trueExpr, JCTree.JCExpression falseExpr, JCTree.JCExpression condExpr) {
        JavafxTypeMorpher.TypeMorphInfo tmi = this.tmiTarget != null ? this.tmiTarget : this.typeMorpher.typeMorphInfo(resultType);
        List<JCTree.JCExpression> args = List.of(this.makeLaziness(diagPos), condExpr, this.makeFunction0(resultType, trueExpr), new JCTree.JCExpression[]{this.makeFunction0(resultType, falseExpr)});
        if (tmi.isSequence()) {
            args = args.prepend(this.makeElementClassObject(diagPos, tmi.getElementType()));
        }
        return this.runtime(diagPos, cBoundOperators, "makeBoundIf", args);
    }

    private JCTree.JCExpression makeFunction0(Type resultType, final JCTree.JCExpression bodyExpr) {
        return new ClosureTranslator(bodyExpr.pos(), resultType){

            @Override
            protected List<JCTree> makeBody() {
                return List.of(this.makeClosureMethod("invoke", bodyExpr, null, this.tmiResult.getLocationType(), 1L));
            }

            @Override
            protected JCTree.JCExpression makeBaseClass() {
                JCTree.JCExpression objFactory = JavafxToBound.this.makeQualifiedTree(this.diagPos, JavafxToBound.cFunction0);
                Type clazzType = this.tmiResult.getLocationType();
                JCTree.JCExpression clazz = this.makeExpression(clazzType);
                return this.m().TypeApply(objFactory, List.of(clazz));
            }

            @Override
            protected List<JCTree.JCExpression> makeConstructorArgs() {
                return List.nil();
            }
        }.doit();
    }

    @Override
    public void visitIfExpression(JFXIfExpression tree) {
        Type targetType = this.targetType(tree.type);
        this.result = this.makeBoundConditional(tree.pos(), targetType, this.translate(tree.getTrueExpression(), targetType), this.translate(tree.getFalseExpression(), targetType), this.translate(tree.getCondition()));
    }

    @Override
    public void visitParens(JFXParens tree) {
        JCTree.JCExpression expr = this.translate(tree.expr);
        this.result = this.make.at(tree.pos).Parens(expr);
    }

    @Override
    public void visitInstanceOf(final JFXInstanceOf tree) {
        this.result = new BindingExpressionClosureTranslator(tree.pos(), tree.type){

            protected JCTree.JCExpression resultValue() {
                return this.m().TypeTest(this.buildArgField(JavafxToBound.this.translate(tree.expr), tree.expr.type, "toTest"), this.makeExpression(tree.clazz.type));
            }
        }.doit();
    }

    @Override
    public void visitTypeCast(final JFXTypeCast tree) {
        this.result = new BindingExpressionClosureTranslator(tree.pos(), tree.type){

            protected JCTree.JCExpression resultValue() {
                return JavafxToBound.this.makeTypeCast(tree.pos(), tree.clazz.type, tree.expr.type, this.buildArgField(JavafxToBound.this.translate(tree.expr), tree.expr.type, "toBeCast"));
            }
        }.doit();
    }

    @Override
    public void visitLiteral(JFXLiteral tree) {
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        if (tree.typetag == 17 && this.types.isSequence(tree.type)) {
            Type elemType = this.types.elementType(this.targetType(tree.type));
            this.result = this.runtime(diagPos, cBoundSequences, "empty", List.of(this.makeElementClassObject(diagPos, elemType)));
        } else {
            JCTree.JCLiteral unbound = this.make.at(diagPos).Literal(tree.typetag, tree.value);
            this.result = this.makeConstantLocation(diagPos, this.targetType(tree.type), unbound);
        }
    }

    @Override
    public void visitFunctionInvocation(final JFXFunctionInvocation tree) {
        this.result = new JavafxToJava.FunctionCallTranslator(tree, this.toJava){
            final List<JCTree.JCExpression> typeArgs;
            final List<JCTree.JCExpression> targs;
            {
                super(x0, x1);
                this.typeArgs = this.toJava.translateExpressions(tree.typeargs);
                this.targs = JavafxToBound.this.translate(tree.args, this.meth.type, this.usesVarArgs);
            }

            public JCTree.JCExpression doit() {
                if (this.callBound) {
                    if (this.selectorMutable) {
                        return JavafxToBound.this.makeBoundSelect(this.diagPos, tree.type, JavafxToBound.this.translate(this.selector), new Function1ClosureTranslator(this.diagPos, tree.type, this.selector.type){

                            protected JCTree.JCExpression makeInvokeMethodBody() {
                                this.buildArgFields(targs, true);
                                Name name = JavafxToBound.this.functionName(msym, false, callBound);
                                JCTree.JCExpression transSelect = this.makeGet(JavafxToBound.this.translate(selector), 0);
                                JCTree.JCMethodInvocation expr = this.m().Apply(typeArgs, this.m().Select(transSelect, name), this.callArgs.toList());
                                return JavafxToBound.this.convert(tree.type, expr);
                            }
                        });
                    }
                    List<JCTree.JCExpression> callArgs = this.targs;
                    if (this.superToStatic) {
                        callArgs = callArgs.prepend(JavafxToBound.this.make.Ident(this.defs.receiverName));
                    }
                    return JavafxToBound.this.convert(tree.type, this.m().Apply(this.typeArgs, this.transMeth(), callArgs));
                }
                if (this.selectorMutable) {
                    return new BindingExpressionClosureTranslator(this.diagPos, tree.type){
                        private JavafxTypeMorpher.TypeMorphInfo tmiSelector;
                        private Name selectorName;
                        {
                            this.tmiSelector = JavafxToBound.this.typeMorpher.typeMorphInfo(selector.type);
                            this.selectorName = JavafxToBound.this.getSyntheticName("selector");
                        }

                        protected JCTree.JCExpression resultValue() {
                            JCTree.JCExpression transSelector = this.makeGetField(this.selectorName, 0);
                            Name methName = ((JFXSelect)tree.meth).name;
                            JCTree.JCFieldAccess callMeth = this.m().Select(transSelector, methName);
                            JCTree.JCMethodInvocation call = this.m().Apply(typeArgs, callMeth, this.callArgs.toList());
                            if (this.tmiSelector.getTypeKind() == 0) {
                                JCTree.JCExpression toTest = this.makeGetField(this.selectorName, 0);
                                JCTree.JCBinary cond = this.m().Binary(61, toTest, JavafxToBound.this.make.Literal(17, null));
                                JCTree.JCExpression defaultExpr = JavafxToBound.this.makeDefaultValue(this.diagPos, this.tmiResult);
                                return this.m().Conditional(cond, call, defaultExpr);
                            }
                            return call;
                        }

                        protected void buildFields() {
                            this.buildArgFields(targs, false);
                            this.buildArgField(JavafxToBound.this.translate(selector), selector.type, this.selectorName.toString());
                        }
                    }.doit();
                }
                return new BindingExpressionClosureTranslator(this.diagPos, tree.type){

                    protected JCTree.JCExpression resultValue() {
                        if (superToStatic) {
                            this.callArgs.prepend(JavafxToBound.this.make.Ident(this.defs.receiverName));
                        }
                        JCTree.JCExpression transMeth = this.transMeth();
                        if (msym != null && (msym.flags() & 0xAL) == 2L && transMeth instanceof JCTree.JCFieldAccess) {
                            JCTree.JCFieldAccess selectTr = (JCTree.JCFieldAccess)transMeth;
                            this.callArgs.prepend(selectTr.getExpression());
                            JCTree.JCExpression receiverType = JavafxToBound.this.makeTypeTree(this.diagPos, msym.owner.type, false);
                            transMeth = JavafxToBound.this.make.at(transMeth).Select(receiverType, JavafxToBound.this.functionName(msym, true, false));
                        }
                        return this.m().Apply(null, transMeth, this.callArgs.toList());
                    }

                    protected void buildFields() {
                        this.buildArgFields(targs, false);
                    }
                }.doit();
            }

            public JCTree.JCExpression transMeth() {
                JCTree.JCExpression transMeth;
                if (this.renameToSuper) {
                    transMeth = this.m().Select((JCTree.JCExpression)this.m().Select(JavafxToBound.this.makeTypeTree(this.selector, this.toJava.attrEnv.enclClass.sym.type, false), JavafxToBound.this.names._super), this.msym);
                } else {
                    transMeth = this.toJava.translate(this.meth);
                    if (this.superToStatic || this.callBound) {
                        Name name = JavafxToBound.this.functionName(this.msym, this.superToStatic, this.callBound);
                        if (transMeth.getTag() == 35) {
                            transMeth = this.m().Ident(name);
                        } else if (transMeth.getTag() == 34) {
                            JCTree.JCExpression expr = this.superToStatic ? JavafxToBound.this.makeTypeTree(this.diagPos, this.msym.owner.type, false) : ((JCTree.JCFieldAccess)transMeth).getExpression();
                            transMeth = this.m().Select(expr, name);
                        }
                    }
                }
                if (this.useInvoke) {
                    transMeth = JavafxToBound.this.make.Select(transMeth, this.defs.invokeName);
                }
                return transMeth;
            }
        }.doit();
    }

    @Override
    public void visitBinary(JFXBinary tree) {
        JCTree.JCExpression res;
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JFXExpression l = tree.lhs;
        JFXExpression r = tree.rhs;
        switch (tree.getFXTag()) {
            case PLUS: {
                res = this.makeBinaryOperator(diagPos, "plus_", l, r);
                break;
            }
            case MINUS: {
                res = this.makeBinaryOperator(diagPos, "minus_", l, r);
                break;
            }
            case DIV: {
                res = this.makeBinaryOperator(diagPos, "divide_", l, r);
                break;
            }
            case MUL: {
                res = this.makeBinaryOperator(diagPos, "times_", l, r);
                break;
            }
            case MOD: {
                res = this.makeBinaryOperator(diagPos, "modulo_", l, r);
                break;
            }
            case EQ: {
                res = this.makeBinaryOperator(diagPos, "eq_", l, r);
                break;
            }
            case NE: {
                res = this.makeBinaryOperator(diagPos, "ne_", l, r);
                break;
            }
            case LT: {
                res = this.makeBinaryOperator(diagPos, "lt_", l, r);
                break;
            }
            case LE: {
                res = this.makeBinaryOperator(diagPos, "le_", l, r);
                break;
            }
            case GT: {
                res = this.makeBinaryOperator(diagPos, "gt_", l, r);
                break;
            }
            case GE: {
                res = this.makeBinaryOperator(diagPos, "ge_", l, r);
                break;
            }
            case AND: {
                res = this.makeBoundConditional(diagPos, this.syms.booleanType, this.translate(r, this.syms.booleanType), this.makeConstantLocation(diagPos, this.syms.booleanType, this.makeLit(diagPos, this.syms.booleanType, 0)), this.translate(l, this.syms.booleanType));
                break;
            }
            case OR: {
                res = this.makeBoundConditional(diagPos, this.syms.booleanType, this.makeConstantLocation(diagPos, this.syms.booleanType, this.makeLit(diagPos, this.syms.booleanType, 1)), this.translate(r, this.syms.booleanType), this.translate(l, this.syms.booleanType));
                break;
            }
            default: {
                assert (false) : "unhandled binary operator";
                res = this.translate(l);
            }
        }
        this.result = this.convert(tree.type, res);
    }

    private JCTree.JCExpression makeBinaryOperator(JCDiagnostic.DiagnosticPosition diagPos, String prefix, JFXExpression l, JFXExpression r) {
        JCTree.JCExpression lhs = this.translate(l);
        JCTree.JCExpression rhs = this.translate(r);
        String typeCode = this.typeCode(l.type) + this.typeCode(r.type);
        return this.runtime(diagPos, cBoundOperators, prefix + typeCode, List.of(lhs, rhs));
    }

    @Override
    public void visitUnary(JFXUnary tree) {
        JCTree.JCExpression res;
        JCDiagnostic.DiagnosticPosition diagPos = tree.pos();
        JFXExpression expr = tree.getExpression();
        JCTree.JCExpression transExpr = this.translate(expr);
        String typeCode = this.typeCode(expr.type);
        switch (tree.getFXTag()) {
            case SIZEOF: {
                res = this.runtime(diagPos, cBoundSequences, "sizeof", List.of(transExpr));
                break;
            }
            case REVERSE: {
                res = this.runtime(diagPos, cBoundSequences, "reverse", List.of(transExpr));
                break;
            }
            case NOT: {
                res = this.runtime(diagPos, cBoundOperators, "not_" + typeCode, List.of(transExpr));
                break;
            }
            case NEG: {
                if (this.types.isSameType(tree.type, this.syms.javafx_DurationType)) {
                    res = this.make.at(diagPos).Apply(null, this.make.at(diagPos).Select(this.translate(tree.arg), Name.fromString(this.names, "negate")), List.<JCTree.JCExpression>nil());
                    break;
                }
                res = this.runtime(diagPos, cBoundOperators, "negate_" + typeCode, List.of(transExpr));
                break;
            }
            case PREINC: {
                this.log.error(tree.pos(), "javafx.not.allowed.in.bind.context", "++");
                res = transExpr;
                break;
            }
            case PREDEC: {
                this.log.error(tree.pos(), "javafx.not.allowed.in.bind.context", "--");
                res = transExpr;
                break;
            }
            case POSTINC: {
                this.log.error(tree.pos(), "javafx.not.allowed.in.bind.context", "++");
                res = transExpr;
                break;
            }
            case POSTDEC: {
                this.log.error(tree.pos(), "javafx.not.allowed.in.bind.context", "--");
                res = transExpr;
                break;
            }
            default: {
                assert (false) : "unhandled unary operator";
                res = transExpr;
            }
        }
        this.result = this.convert(tree.type, res);
    }

    @Override
    public void visitTimeLiteral(JFXTimeLiteral tree) {
        JFXFunctionInvocation duration = this.timeLiteralToDuration(tree);
        this.visitFunctionInvocation(duration);
    }

    @Override
    public void visitInterpolateValue(JFXInterpolateValue tree) {
        this.result = this.toJava.translate((JFXExpression)tree, JavafxToJava.Wrapped.InLocation);
    }

    private String typeCode(Type type) {
        Symbol.TypeSymbol tsym = type.tsym;
        if (type.isPrimitive()) {
            if (tsym == this.syms.doubleType.tsym || tsym == this.syms.floatType.tsym) {
                return "d";
            }
            if (tsym == this.syms.intType.tsym || tsym == this.syms.byteType.tsym || tsym == this.syms.charType.tsym || tsym == this.syms.longType.tsym || tsym == this.syms.shortType.tsym) {
                return "i";
            }
            if (tsym == this.syms.booleanType.tsym) {
                return "b";
            }
            assert (false) : "should not reach here";
            return "X";
        }
        if (this.types.isSequence(type)) {
            return "s";
        }
        if (tsym == this.booleanObjectTypeSymbol) {
            return "B";
        }
        if (tsym == this.doubleObjectTypeSymbol) {
            return "D";
        }
        if (tsym == this.intObjectTypeSymbol) {
            return "I";
        }
        return "o";
    }

    @Override
    protected String getSyntheticPrefix() {
        return "bfx$";
    }

    @Override
    public void visitForExpressionInClause(JFXForExpressionInClause that) {
        assert (false) : "should be processed by parent tree";
    }

    @Override
    public void visitModifiers(JFXModifiers tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitSkip(JFXSkip tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitThrow(JFXThrow tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitTry(JFXTry tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitWhileLoop(JFXWhileLoop tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitOverrideClassVar(JFXOverrideClassVar tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitOnReplace(JFXOnReplace tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitScript(JFXScript tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitClassDeclaration(JFXClassDeclaration tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitInitDefinition(JFXInitDefinition tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitPostInitDefinition(JFXPostInitDefinition tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitFunctionDefinition(JFXFunctionDefinition tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitSequenceInsert(JFXSequenceInsert tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitSequenceDelete(JFXSequenceDelete tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitContinue(JFXContinue tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitReturn(JFXReturn tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitImport(JFXImport tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitBreak(JFXBreak tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitCatch(JFXCatch tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitTypeAny(JFXTypeAny that) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitTypeClass(JFXTypeClass that) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitTypeFunctional(JFXTypeFunctional that) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitTypeUnknown(JFXTypeUnknown that) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitObjectLiteralPart(JFXObjectLiteralPart that) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitVarScriptInit(JFXVarScriptInit tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitVar(JFXVar tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitKeyFrameLiteral(JFXKeyFrameLiteral tree) {
        assert (false) : "should not be processed as part of a binding";
    }

    @Override
    public void visitErroneous(JFXErroneous tree) {
        assert (false) : "erroneous nodes shouldn't have gotten this far";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class BindingExpressionClosureTranslator
    extends ClosureTranslator {
        BindingExpressionClosureTranslator(JCDiagnostic.DiagnosticPosition diagPos, Type resultType) {
            super(diagPos, resultType);
        }

        protected abstract JCTree.JCExpression resultValue();

        protected void buildFields() {
        }

        @Override
        protected List<JCTree> makeBody() {
            this.buildFields();
            JCTree.JCExpression resultVal = this.resultValue();
            Type locationType = JavafxToBound.this.typeMorpher.baseLocation.type;
            JCTree.JCNewArray depsArray = JavafxToBound.this.make.NewArray(this.makeExpression(locationType), List.<JCTree.JCExpression>nil(), this.dependents.toList());
            Type.ArrayType depsReturnType = new Type.ArrayType(locationType, (Symbol.TypeSymbol)this.syms.arrayClass);
            this.members.append(this.makeClosureMethod("getStaticDependents", depsArray, null, depsReturnType, 4L));
            this.members.append(this.makeClosureMethod("computeValue", resultVal, null, this.tmiResult.getRealFXType(), 1L));
            return this.completeMembers();
        }

        @Override
        protected JCTree.JCExpression makeBaseClass() {
            Type clazzType = JavafxToBound.this.typeMorpher.bindingExpressionType(this.typeKindResult);
            return this.makeBaseClass(clazzType, null);
        }

        @Override
        protected List<JCTree.JCExpression> makeConstructorArgs() {
            return List.nil();
        }

        @Override
        protected JCTree.JCExpression doit() {
            ListBuffer args = ListBuffer.lb();
            if (this.tmiResult.getTypeKind() == 0) {
                args.append(JavafxToBound.this.makeDefaultValue(this.diagPos, this.tmiResult));
            }
            args.append(JavafxToBound.this.makeLaziness(this.diagPos));
            args.append(this.buildClosure());
            return JavafxToBound.this.makeLocationLocalVariable(this.tmiResult, this.diagPos, args.toList());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Function1ClosureTranslator
    extends ClosureTranslator {
        final Type param1Type;

        Function1ClosureTranslator(JCDiagnostic.DiagnosticPosition diagPos, Type resultType, Type param1Type) {
            super(diagPos, resultType);
            this.param1Type = param1Type;
        }

        protected abstract JCTree.JCExpression makeInvokeMethodBody();

        @Override
        protected List<JCTree> makeBody() {
            List<JCTree.JCVariableDecl> params = List.of(this.makeParam(this.param1Type, JavafxToBound.this.param1Name));
            this.members.append(this.makeClosureMethod("invoke", this.makeInvokeMethodBody(), params, this.tmiResult.getLocationType(), 1L));
            return this.completeMembers();
        }

        @Override
        protected JCTree.JCExpression makeBaseClass() {
            JCTree.JCExpression objFactory = JavafxToBound.this.makeQualifiedTree(this.diagPos, JavafxToBound.cFunction1);
            Type clazzType = this.tmiResult.getLocationType();
            return this.m().TypeApply(objFactory, List.of(this.makeExpression(clazzType), this.makeExpression(this.param1Type)));
        }

        @Override
        protected List<JCTree.JCExpression> makeConstructorArgs() {
            return List.nil();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ClosureTranslator
    extends JavafxToJava.Translator {
        protected final JavafxTypeMorpher.TypeMorphInfo tmiResult;
        protected final int typeKindResult;
        protected final Type elementTypeResult;
        ListBuffer<JCTree> members;
        ListBuffer<JCTree.JCStatement> fieldInits;
        ListBuffer<JCTree.JCExpression> dependents;
        ListBuffer<JCTree.JCExpression> callArgs;
        int argNum;

        ClosureTranslator(JCDiagnostic.DiagnosticPosition diagPos, Type resultType) {
            this(diagPos, javafxToBound.toJava, javafxToBound.tmiTarget != null ? javafxToBound.tmiTarget : javafxToBound.typeMorpher.typeMorphInfo(resultType));
        }

        private ClosureTranslator(JCDiagnostic.DiagnosticPosition diagPos, JavafxToJava toJava, JavafxTypeMorpher.TypeMorphInfo tmiResult) {
            super(diagPos, toJava);
            this.members = ListBuffer.lb();
            this.fieldInits = ListBuffer.lb();
            this.dependents = ListBuffer.lb();
            this.callArgs = ListBuffer.lb();
            this.argNum = 0;
            this.tmiResult = tmiResult;
            this.typeKindResult = tmiResult.getTypeKind();
            this.elementTypeResult = JavafxToBound.this.elementType(tmiResult.getLocationType());
        }

        protected JCTree.JCVariableDecl makeParam(Type type, Name name) {
            return JavafxToBound.this.make.at(this.diagPos).VarDef(this.m().Modifiers(0x200000010L), name, this.makeExpression(type), null);
        }

        protected JCTree makeClosureMethod(String methName, JCTree.JCExpression expr, List<JCTree.JCVariableDecl> params, Type returnType, long flags) {
            return this.m().MethodDef(this.m().Modifiers(flags), JavafxToBound.this.names.fromString(methName), this.makeExpression(returnType), List.<JCTree.JCTypeParameter>nil(), params == null ? List.nil() : params, List.<JCTree.JCExpression>nil(), this.m().Block(0L, List.of(this.m().Return(expr))), null);
        }

        protected JCTree makeClosureMethod(String methName, JCTree.JCExpression expr, List<JCTree.JCVariableDecl> params) {
            return this.makeClosureMethod(methName, expr, params, this.tmiResult.getLocationType(), 4L);
        }

        protected abstract List<JCTree> makeBody();

        protected abstract JCTree.JCExpression makeBaseClass();

        protected JCTree.JCExpression makeBaseClass(Type clazzType, Type additionTypeParamOrNull) {
            JCTree.JCExpression clazz = this.makeExpression(this.types.erasure(clazzType));
            ListBuffer typeParams = ListBuffer.lb();
            if (this.typeKindResult == 0 || this.typeKindResult == 4) {
                typeParams.append(this.makeExpression(this.elementTypeResult));
            }
            if (additionTypeParamOrNull != null) {
                typeParams.append(this.makeExpression(additionTypeParamOrNull));
            }
            return typeParams.isEmpty() ? clazz : this.m().TypeApply(clazz, typeParams.toList());
        }

        protected abstract List<JCTree.JCExpression> makeConstructorArgs();

        protected JCTree.JCExpression buildClosure() {
            JCTree.JCClassDecl classDecl = this.m().AnonymousClassDef(this.m().Modifiers(0L), this.makeBody());
            List<JCTree.JCExpression> typeArgs = List.nil();
            return this.m().NewClass(null, typeArgs, this.makeBaseClass(), this.makeConstructorArgs(), classDecl);
        }

        @Override
        protected JCTree.JCExpression doit() {
            return this.buildClosure();
        }

        protected List<JCTree> completeMembers() {
            this.members.append(this.m().Block(0L, this.fieldInits.toList()));
            return this.members.toList();
        }

        protected JCTree.JCExpression makeGet(JCTree.JCExpression locExpr, int typeKind) {
            Name getMethodName = this.defs.locationGetMethodName[typeKind];
            JCTree.JCFieldAccess select = this.m().Select(locExpr, getMethodName);
            return this.m().Apply(null, select, List.<JCTree.JCExpression>nil());
        }

        protected JCTree.JCExpression makeGetField(Name fieldName, JavafxTypeMorpher.TypeMorphInfo tmiField) {
            return this.makeGetField(fieldName, tmiField.getTypeKind());
        }

        protected JCTree.JCExpression makeGetField(Name fieldName, int typeKind) {
            return this.makeGet(this.m().Ident(fieldName), typeKind);
        }

        protected JCTree makeLocationField(JCTree.JCExpression targ, Name argName, JavafxTypeMorpher.TypeMorphInfo tmiArg) {
            this.fieldInits.append(this.m().Exec(this.m().Assign(this.m().Ident(argName), targ)));
            return this.m().VarDef(this.m().Modifiers(2L), argName, this.makeExpression(tmiArg.getLocationType()), null);
        }

        protected JCTree.JCExpression buildArgField(JCTree.JCExpression arg, Type type) {
            return this.buildArgField(arg, type, false);
        }

        protected JCTree.JCExpression buildArgField(JCTree.JCExpression arg, Type type, boolean isBound) {
            return this.buildArgField(arg, type, "arg$" + this.argNum++, isBound);
        }

        protected JCTree.JCExpression buildArgField(JCTree.JCExpression arg, Type type, String argLabel) {
            return this.buildArgField(arg, type, argLabel, false);
        }

        protected JCTree.JCExpression buildArgField(JCTree.JCExpression arg, Type type, String argLabel, boolean isBound) {
            JavafxTypeMorpher.TypeMorphInfo tmiArg = JavafxToBound.this.typeMorpher.typeMorphInfo(type);
            Name argName = JavafxToBound.this.names.fromString(argLabel);
            this.members.append(this.makeLocationField(arg, argName, tmiArg));
            if (isBound) {
                return this.m().Ident(argName);
            }
            this.dependents.append(this.m().Ident(argName));
            return this.makeGetField(argName, tmiArg);
        }

        protected void buildArgFields(List<JCTree.JCExpression> targs, boolean isBound) {
            for (JCTree.JCExpression targ : targs) {
                assert (targ.type != null) : "caller is supposed to decorate the translated arg with its type";
                this.callArgs.append(this.buildArgField(targ, targ.type, isBound));
            }
        }
    }
}

