/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.code.JavafxTypes;
import com.sun.tools.javafx.comp.JavafxDefs;
import com.sun.tools.javafx.comp.JavafxResolve;
import com.sun.tools.javafx.comp.JavafxTypeMorpher;
import com.sun.tools.javafx.tree.BlockExprJCBlockExpression;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXForExpressionInClause;
import com.sun.tools.javafx.tree.JFXFunctionInvocation;
import com.sun.tools.javafx.tree.JFXIdent;
import com.sun.tools.javafx.tree.JFXSelect;
import com.sun.tools.javafx.tree.JFXTimeLiteral;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JavafxPretty;
import com.sun.tools.javafx.tree.JavafxTreeMaker;
import java.io.OutputStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavafxTranslationSupport {
    protected final JavafxDefs defs;
    protected final Log log;
    protected final JavafxTreeMaker fxmake;
    protected final TreeMaker make;
    protected final Name.Table names;
    protected final JavafxResolve rs;
    protected final JavafxSymtab syms;
    protected final JavafxTypes types;
    protected final JavafxTypeMorpher typeMorpher;
    protected static final String sequencesEmptyString = "com.sun.javafx.runtime.sequence.Sequences.emptySequence";
    private int syntheticNameCounter = 0;
    JCTree result;

    protected JavafxTranslationSupport(Context context) {
        this.make = TreeMaker.instance(context);
        this.fxmake = JavafxTreeMaker.instance(context);
        this.log = Log.instance(context);
        this.names = Name.Table.instance(context);
        this.types = JavafxTypes.instance(context);
        this.syms = (JavafxSymtab)JavafxSymtab.instance(context);
        this.typeMorpher = JavafxTypeMorpher.instance(context);
        this.rs = JavafxResolve.instance(context);
        this.defs = JavafxDefs.instance(context);
        this.syntheticNameCounter = 0;
    }

    protected Symbol expressionSymbol(JFXExpression tree) {
        switch (tree.getFXTag()) {
            case IDENT: {
                return ((JFXIdent)tree).sym;
            }
            case SELECT: {
                return ((JFXSelect)tree).sym;
            }
        }
        return null;
    }

    protected Type elementType(Type seqType) {
        Type elemType = (Type)seqType.getTypeArguments().head;
        if (elemType instanceof Type.CapturedType) {
            elemType = ((Type.CapturedType)elemType).wildcard;
        }
        if (elemType instanceof Type.WildcardType) {
            elemType = ((Type.WildcardType)elemType).type;
        }
        return elemType;
    }

    protected Name interfaceName(JFXClassDeclaration cDecl) {
        Name name = cDecl.getName();
        if (cDecl.generateClassOnly()) {
            return name;
        }
        return this.names.fromString(name.toString() + "$Intf");
    }

    protected JCTree.JCExpression makeIdentifier(JCDiagnostic.DiagnosticPosition diagPos, Name aName) {
        String str = aName.toString();
        if (str.indexOf(46) < 0 && str.indexOf(60) < 0) {
            return this.make.at(diagPos).Ident(aName);
        }
        return this.makeIdentifier(diagPos, str);
    }

    protected JCTree.JCExpression makeIdentifier(JCDiagnostic.DiagnosticPosition diagPos, String str) {
        int inx;
        assert (str.indexOf(60) < 0) : "attempt to parse a type with 'Identifier'.  Use TypeTree";
        JCTree.JCExpression tree = null;
        int lastInx = 0;
        do {
            int endInx = (inx = str.indexOf(46, lastInx)) < 0 ? str.length() : inx;
            String part = str.substring(lastInx, endInx);
            Name partName = Name.fromString(this.names, part);
            tree = tree == null ? this.make.at(diagPos).Ident(partName) : this.make.at(diagPos).Select(tree, partName);
            lastInx = endInx + 1;
        } while (inx >= 0);
        return tree;
    }

    protected JCTree.JCExpression makeLaziness(JCDiagnostic.DiagnosticPosition diagPos) {
        return this.make.at(diagPos).Literal(8, 0);
    }

    protected JCTree.JCExpression makeNull(JCDiagnostic.DiagnosticPosition diagPos) {
        return this.make.at(diagPos).Literal(17, null);
    }

    protected JCTree.JCExpression makeQualifiedTree(JCDiagnostic.DiagnosticPosition diagPos, String str) {
        int inx;
        JCTree.JCExpression tree = null;
        int lastInx = 0;
        do {
            int endInx = (inx = str.indexOf(46, lastInx)) < 0 ? str.length() : inx;
            String part = str.substring(lastInx, endInx);
            Name partName = Name.fromString(this.names, part);
            tree = tree == null ? this.make.at(diagPos).Ident(partName) : this.make.at(diagPos).Select(tree, partName);
            lastInx = endInx + 1;
        } while (inx >= 0);
        return tree;
    }

    protected JCTree.JCExpression makeTypeTree(JCDiagnostic.DiagnosticPosition diagPos, Type t) {
        return this.makeTypeTree(diagPos, t, true);
    }

    protected JCTree.JCExpression makeTypeTree(JCDiagnostic.DiagnosticPosition diagPos, Type t, boolean makeIntf) {
        while (t instanceof Type.CapturedType) {
            Type.WildcardType wtype = ((Type.CapturedType)t).wildcard;
            t = wtype.kind == BoundKind.EXTENDS ? wtype.type : wtype;
        }
        return this.makeTypeTreeInner(diagPos, t, makeIntf);
    }

    private JCTree.JCExpression makeTypeTreeInner(JCDiagnostic.DiagnosticPosition diagPos, Type t, boolean makeIntf) {
        while (t instanceof Type.CapturedType) {
            t = ((Type.CapturedType)t).wildcard;
        }
        switch (t.tag) {
            case 10: {
                JCTree.JCExpression texp = null;
                if (makeIntf && this.types.isCompoundClass(t.tsym)) {
                    texp = this.makeQualifiedTree(diagPos, t.tsym.getQualifiedName().toString() + "$Intf");
                } else {
                    if (t.isCompound()) {
                        t = this.syms.objectType;
                    }
                    texp = this.makeQualifiedTree(diagPos, t.tsym.getQualifiedName().toString());
                }
                if (!t.getTypeArguments().isEmpty()) {
                    List<JCTree.JCExpression> targs = List.nil();
                    for (Type ta : t.getTypeArguments()) {
                        targs = targs.append(this.makeTypeTreeInner(diagPos, ta, makeIntf));
                    }
                    texp = this.make.at(diagPos).TypeApply(texp, targs);
                }
                return texp;
            }
            case 17: {
                return this.makeQualifiedTree(diagPos, this.syms.objectType.tsym.getQualifiedName().toString());
            }
            case 15: {
                Type.WildcardType wtype = (Type.WildcardType)t;
                return this.make.at(diagPos).Wildcard(this.make.TypeBoundKind(wtype.kind), wtype.kind == BoundKind.UNBOUND ? null : this.makeTypeTreeInner(diagPos, wtype.type, makeIntf));
            }
            case 11: {
                return this.make.at(diagPos).TypeArray(this.makeTypeTreeInner(diagPos, this.types.elemtype(t), makeIntf));
            }
        }
        return this.make.at(diagPos).Type(t);
    }

    public JCTree.JCExpression makeReturnTypeTree(JCDiagnostic.DiagnosticPosition diagPos, Symbol.MethodSymbol mth, boolean isBound) {
        Type returnType = mth.getReturnType();
        if (isBound) {
            JavafxTypeMorpher.VarMorphInfo vmi = this.typeMorpher.varMorphInfo(mth);
            returnType = vmi.getLocationType();
        }
        return this.makeTypeTree(diagPos, returnType);
    }

    JCTree.JCExpression makeTypeCast(JCDiagnostic.DiagnosticPosition diagPos, Type clazztype, Type exprtype, JCTree.JCExpression translatedExpr) {
        JCTree.JCExpression clazz;
        if (this.types.isSameType(clazztype, exprtype)) {
            return translatedExpr;
        }
        Type castType = clazztype;
        if (castType.isPrimitive() && !exprtype.isPrimitive()) {
            castType = this.types.boxedClass((Type)castType).type;
        }
        if (castType.isPrimitive() && exprtype.isPrimitive()) {
            clazz = this.makeTypeTree(diagPos, exprtype, true);
            translatedExpr = this.make.at(diagPos).TypeCast(clazz, translatedExpr);
        }
        clazz = this.makeTypeTree(diagPos, castType, true);
        return this.make.at(diagPos).TypeCast(clazz, translatedExpr);
    }

    JCTree.JCVariableDecl makeReceiverParam(JFXClassDeclaration cDecl) {
        return this.make.VarDef(this.make.Modifiers(0x200000010L), this.defs.receiverName, this.make.Ident(this.interfaceName(cDecl)), null);
    }

    JCTree.JCExpression makeDefaultValue(JCDiagnostic.DiagnosticPosition diagPos, JavafxTypeMorpher.TypeMorphInfo tmi) {
        return tmi.getTypeKind() == 4 ? this.makeEmptySequenceCreator(diagPos, tmi.getElementType()) : (tmi.getRealType() == this.syms.javafx_StringType ? this.make.Literal("") : (tmi.getRealType() == this.syms.javafx_DurationType ? this.makeTimeDefaultValue(diagPos) : this.makeLit(diagPos, tmi.getRealType(), tmi.getDefaultValue())));
    }

    JCTree.JCExpression makeTimeDefaultValue(JCDiagnostic.DiagnosticPosition diagPos) {
        return this.makeDurationLiteral(diagPos, this.makeLit(diagPos, this.syms.javafx_NumberType, 0));
    }

    JCTree.JCExpression makeLit(JCDiagnostic.DiagnosticPosition diagPos, Type type, Object value) {
        int tag = value == null ? 17 : type.tag;
        return this.make.at(diagPos).Literal(tag, value).setType(type.constType(value));
    }

    JCTree.JCExpression makeLocationLocalVariable(JavafxTypeMorpher.TypeMorphInfo tmi, JCDiagnostic.DiagnosticPosition diagPos, List<JCTree.JCExpression> makeArgs) {
        return this.makeLocationVariable(tmi, diagPos, makeArgs, this.defs.makeMethodName);
    }

    JCTree.JCExpression makeLocationAttributeVariable(JavafxTypeMorpher.TypeMorphInfo tmi, JCDiagnostic.DiagnosticPosition diagPos) {
        Name makeMethod;
        List<JCTree.JCExpression> makeArgs;
        if (tmi.getTypeKind() == 0 && (tmi.getRealType() == this.syms.javafx_StringType || tmi.getRealType() == this.syms.javafx_DurationType)) {
            makeArgs = List.of(this.makeDefaultValue(diagPos, tmi));
            makeMethod = this.defs.makeWithDefaultMethodName;
        } else {
            makeArgs = List.nil();
            makeMethod = this.defs.makeMethodName;
        }
        return this.makeLocationVariable(tmi, diagPos, makeArgs, makeMethod);
    }

    JCTree.JCExpression makeLocationVariable(JavafxTypeMorpher.TypeMorphInfo tmi, JCDiagnostic.DiagnosticPosition diagPos, List<JCTree.JCExpression> makeArgs, Name makeMethod) {
        Name locName = this.typeMorpher.variableNCT[tmi.getTypeKind()].name;
        JCTree.JCExpression locationTypeExp = this.makeIdentifier(diagPos, locName);
        JCTree.JCFieldAccess makeSelect = this.make.at(diagPos).Select(locationTypeExp, makeMethod);
        List<JCTree.JCExpression> typeArgs = null;
        switch (tmi.getTypeKind()) {
            case 0: {
                typeArgs = List.of(this.makeTypeTree(diagPos, tmi.getRealType(), true));
                break;
            }
            case 4: {
                typeArgs = List.of(this.makeTypeTree(diagPos, tmi.getElementType(), true));
                makeArgs = makeArgs.prepend(this.makeElementClassObject(diagPos, tmi.getElementType()));
            }
        }
        return this.make.at(diagPos).Apply(typeArgs, makeSelect, makeArgs);
    }

    JCTree.JCExpression makeConstantLocation(JCDiagnostic.DiagnosticPosition diagPos, Type type, JCTree.JCExpression expr) {
        JavafxTypeMorpher.TypeMorphInfo tmi = this.typeMorpher.typeMorphInfo(type);
        List<JCTree.JCExpression> makeArgs = List.of(expr);
        JCTree.JCExpression locationTypeExp = this.makeTypeTree(diagPos, tmi.getConstantLocationType(), true);
        JCTree.JCFieldAccess makeSelect = this.make.at(diagPos).Select(locationTypeExp, this.defs.makeMethodName);
        List<JCTree.JCExpression> typeArgs = null;
        if (tmi.getTypeKind() == 0 || tmi.getTypeKind() == 4) {
            typeArgs = List.of(this.makeTypeTree(diagPos, tmi.getElementType(), true));
        }
        return this.make.at(diagPos).Apply(typeArgs, makeSelect, makeArgs);
    }

    JCTree.JCExpression makeUnboundLocation(JCDiagnostic.DiagnosticPosition diagPos, JavafxTypeMorpher.TypeMorphInfo tmi, JCTree.JCExpression expr) {
        List<JCTree.JCExpression> makeArgs = List.of(expr);
        return this.makeLocationLocalVariable(tmi, diagPos, makeArgs);
    }

    protected JCTree.JCExpression makeUnboundLocation(JCDiagnostic.DiagnosticPosition diagPos, Type type, JCTree.JCExpression expr) {
        return this.makeUnboundLocation(diagPos, this.typeMorpher.typeMorphInfo(type), expr);
    }

    protected JCTree.JCExpression runtime(JCDiagnostic.DiagnosticPosition diagPos, String cString, String methString) {
        return this.runtime(diagPos, cString, methString, null, List.<JCTree.JCExpression>nil());
    }

    protected JCTree.JCExpression runtime(JCDiagnostic.DiagnosticPosition diagPos, String cString, String methString, List<JCTree.JCExpression> args) {
        return this.runtime(diagPos, cString, methString, null, args);
    }

    protected JCTree.JCExpression runtime(JCDiagnostic.DiagnosticPosition diagPos, String cString, String methString, List<JCTree.JCExpression> typeArgs, List<JCTree.JCExpression> args) {
        JCTree.JCFieldAccess meth = this.make.at(diagPos).Select(this.makeQualifiedTree(diagPos, cString), this.names.fromString(methString));
        return this.make.at(diagPos).Apply(typeArgs, meth, args);
    }

    protected JCTree.JCExpression runtime(JCDiagnostic.DiagnosticPosition diagPos, String cString, String methString, ListBuffer<JCTree.JCExpression> args) {
        return this.runtime(diagPos, cString, methString, null, args.toList());
    }

    JCTree.JCMethodInvocation callExpression(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression receiver, Name methodName) {
        return this.callExpression(diagPos, receiver, methodName, null);
    }

    JCTree.JCMethodInvocation callExpression(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression receiver, Name methodName, Object args) {
        JCTree.JCExpression expr = null;
        expr = receiver == null ? this.make.at(diagPos).Ident(methodName) : this.make.at(diagPos).Select(receiver, methodName);
        return this.make.at(diagPos).Apply(List.<JCTree.JCExpression>nil(), expr, args == null ? List.nil() : (args instanceof List ? (List)args : (args instanceof ListBuffer ? ((ListBuffer)args).toList() : (args instanceof JCTree.JCExpression ? List.of((JCTree.JCExpression)args) : null))));
    }

    JCTree.JCMethodInvocation callExpression(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression receiver, String method) {
        return this.callExpression(diagPos, receiver, method, null);
    }

    JCTree.JCMethodInvocation callExpression(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression receiver, String method, Object args) {
        return this.callExpression(diagPos, receiver, this.names.fromString(method), args);
    }

    JCTree.JCStatement callStatement(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression receiver, Name methodName) {
        return this.callStatement(diagPos, receiver, methodName, null);
    }

    JCTree.JCStatement callStatement(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression receiver, Name methodName, Object args) {
        return this.make.at(diagPos).Exec(this.callExpression(diagPos, receiver, methodName, args));
    }

    JCTree.JCStatement callStatement(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression receiver, String method) {
        return this.callStatement(diagPos, receiver, method, null);
    }

    JCTree.JCStatement callStatement(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression receiver, String method, Object args) {
        return this.make.at(diagPos).Exec(this.callExpression(diagPos, receiver, method, args));
    }

    Name functionInterfaceName(Symbol.MethodSymbol sym, boolean isBound) {
        return this.functionName(sym, isBound);
    }

    Name functionName(Symbol.MethodSymbol sym) {
        return this.functionName(sym, false);
    }

    Name functionName(Symbol.MethodSymbol sym, String full, boolean markAsImpl, boolean isBound) {
        if (markAsImpl) {
            full = full + "$impl";
        }
        if (isBound) {
            full = full + "$$bound$" + this.getParameterTypeSuffix(sym);
        }
        return this.names.fromString(full);
    }

    Name functionName(Symbol.MethodSymbol sym, boolean isBound) {
        return this.functionName(sym, false, isBound);
    }

    Name functionName(Symbol.MethodSymbol sym, boolean markAsImpl, boolean isBound) {
        if (!markAsImpl && !isBound) {
            return sym.name;
        }
        return this.functionName(sym, sym.name.toString(), markAsImpl, isBound);
    }

    Name attributeFieldName(Symbol sym) {
        return this.prefixedAttributeName(sym, "$");
    }

    Name attributeGetterName(Symbol sym) {
        return this.prefixedAttributeName(sym, "get$");
    }

    Name attributeSetterName(Symbol sym) {
        return this.prefixedAttributeName(sym, "set$");
    }

    Name attributeApplyDefaultsName(Symbol sym) {
        return this.prefixedAttributeName(sym, "applyDefaults$");
    }

    private Name prefixedAttributeName(Symbol sym, String prefix) {
        Symbol owner = sym.owner;
        if (!this.types.isJFXClass(owner)) {
            return sym.name;
        }
        String sname = sym.name.toString();
        long privateAccess = sym.flags() & 0x200000000002L;
        if ((sym.flags() & 8L) == 0L && privateAccess != 0L && this.types.isCompoundClass(owner)) {
            sname = owner.toString().replace('.', '$') + '$' + sname;
        }
        return this.names.fromString(prefix + sname);
    }

    private String getParameterTypeSuffix(Symbol.MethodSymbol sym) {
        StringBuilder sb = new StringBuilder();
        if (sym != null && sym.type != null) {
            Type mtype = sym.type;
            if (sym.type.tag == 16) {
                mtype = ((Type.ForAll)mtype).asMethodType();
            }
            if (mtype.tag == 12) {
                java.util.List argtypes = ((Type.MethodType)mtype).getParameterTypes();
                int argtypesCount = ((List)argtypes).length();
                int counter = 0;
                for (Type argtype : argtypes) {
                    sb.append(this.escapeTypeName(this.types.erasure(argtype)));
                    if (counter < argtypesCount - 1) {
                        sb.append(this.defs.escapeTypeChar);
                        sb.append(this.defs.escapeTypeChar);
                    }
                    ++counter;
                }
            }
        }
        return sb.toString();
    }

    JCTree.JCExpression makeEmptySequenceCreator(JCDiagnostic.DiagnosticPosition diagPos, Type elemType) {
        JCTree.JCExpression meth = this.makeQualifiedTree(diagPos, sequencesEmptyString);
        ListBuffer args = ListBuffer.lb();
        args.append(this.makeElementClassObject(diagPos, elemType));
        List<JCTree.JCExpression> typeArgs = List.of(this.makeTypeTree(diagPos, elemType, true));
        return this.make.at(diagPos).Apply(typeArgs, meth, args.toList());
    }

    private String escapeTypeName(Type type) {
        return type.toString().replace(this.defs.typeCharToEscape, this.defs.escapeTypeChar);
    }

    JCTree.JCExpression makeElementClassObject(JCDiagnostic.DiagnosticPosition diagPos, Type elemType) {
        return this.make.at(diagPos).Select(this.makeTypeTree(diagPos, this.syms.boxIfNeeded(elemType), true), this.names._class);
    }

    private JCTree.JCExpression primitiveTypeInfo(JCDiagnostic.DiagnosticPosition diagPos, Name typeName) {
        return this.make.at(diagPos).Select(this.makeQualifiedTree(diagPos, "com.sun.javafx.runtime.TypeInfo"), typeName);
    }

    JCTree.JCExpression makeTypeInfo(JCDiagnostic.DiagnosticPosition diagPos, Type type) {
        Type ubType = this.types.unboxedType(type);
        if (ubType.tag != 18) {
            type = ubType;
        }
        if (this.types.isSameType(type, this.syms.javafx_NumberType)) {
            return this.primitiveTypeInfo(diagPos, this.names.fromString("Double"));
        }
        if (this.types.isSameType(type, this.syms.javafx_IntegerType)) {
            return this.primitiveTypeInfo(diagPos, this.syms.integerTypeName);
        }
        if (this.types.isSameType(type, this.syms.javafx_BooleanType)) {
            return this.primitiveTypeInfo(diagPos, this.syms.booleanTypeName);
        }
        if (this.types.isSameType(type, this.syms.javafx_StringType)) {
            return this.primitiveTypeInfo(diagPos, this.syms.stringTypeName);
        }
        if (this.types.isSameType(type, this.syms.longType)) {
            return this.primitiveTypeInfo(diagPos, this.names.fromString("Long"));
        }
        if (this.types.isSameType(type, this.syms.javafx_DurationType)) {
            JCTree.JCFieldAccess fieldRef = this.make.at(diagPos).Select(this.makeTypeTree(diagPos, type), this.defs.defaultingTypeInfoFieldName);
            return fieldRef;
        }
        if (type.isPrimitive()) {
            type = this.types.boxedClass((Type)type).type;
        }
        List<JCTree.JCExpression> typeArgs = List.of(this.makeTypeTree(diagPos, type, true));
        return this.runtime(diagPos, "com.sun.javafx.runtime.TypeInfo", "getTypeInfo", typeArgs, List.<JCTree.JCExpression>nil());
    }

    protected abstract String getSyntheticPrefix();

    Name getSyntheticName(String kind) {
        return Name.fromString(this.names, this.getSyntheticPrefix() + this.syntheticNameCounter++ + kind);
    }

    public Name indexVarName(JFXForExpressionInClause clause) {
        return this.indexVarName(clause.getVar().getName());
    }

    public Name indexVarName(JFXIdent var) {
        return this.indexVarName(var.getName());
    }

    private Name indexVarName(Name name) {
        return this.names.fromString("$indexof$" + name.toString());
    }

    JCTree.JCExpression getLocationValue(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression expr, int typeKind) {
        JCTree.JCFieldAccess getSelect = this.make.at(diagPos).Select(expr, this.defs.locationGetMethodName[typeKind]);
        List<JCTree.JCExpression> getArgs = List.nil();
        return this.make.at(diagPos).Apply(null, getSelect, getArgs);
    }

    JCTree.JCExpression makeAttributeAccess(JCDiagnostic.DiagnosticPosition diagPos, Symbol attribSym, Name instanceName) {
        JCTree.JCIdent instanceIdent;
        JCTree.JCIdent jCIdent = instanceIdent = instanceName == null ? null : this.make.at(diagPos).Ident(instanceName);
        if (attribSym.isStatic()) {
            Name fieldName = this.attributeFieldName(attribSym);
            return instanceIdent == null ? this.make.at(diagPos).Ident(fieldName) : this.make.at(diagPos).Select((JCTree.JCExpression)instanceIdent, fieldName);
        }
        return this.callExpression(diagPos, (JCTree.JCExpression)instanceIdent, this.attributeGetterName(attribSym));
    }

    BlockExprJCBlockExpression makeBlockExpression(JCDiagnostic.DiagnosticPosition diagPos, List<JCTree.JCStatement> stmts, JCTree.JCExpression value) {
        BlockExprJCBlockExpression bexpr = new BlockExprJCBlockExpression(0L, stmts, value);
        bexpr.pos = diagPos == null ? -1 : diagPos.getStartPosition();
        return bexpr;
    }

    BlockExprJCBlockExpression makeBlockExpression(JCDiagnostic.DiagnosticPosition diagPos, ListBuffer<JCTree.JCStatement> stmts, JCTree.JCExpression value) {
        return this.makeBlockExpression(diagPos, stmts.toList(), value);
    }

    JCTree.JCVariableDecl makeTmpVar(JCDiagnostic.DiagnosticPosition diagPos, String rootName, Type type, JCTree.JCExpression value) {
        return this.make.at(diagPos).VarDef(this.make.at(diagPos).Modifiers(16L), this.getSyntheticName(rootName), this.makeTypeTree(diagPos, type), value);
    }

    JCTree.JCVariableDecl makeTmpVar(JCDiagnostic.DiagnosticPosition diagPos, Type type, JCTree.JCExpression value) {
        return this.makeTmpVar(diagPos, "tmp", type, value);
    }

    protected JCTree.JCModifiers addAccessAnnotationModifiers(JCDiagnostic.DiagnosticPosition diagPos, long flags, JCTree.JCModifiers mods, List<JCTree.JCAnnotation> annotations) {
        this.make.at(diagPos);
        JCTree.JCModifiers ret = mods;
        annotations = (flags & 1L) != 0L ? annotations.prepend(this.make.Annotation(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.annotation.Public"), List.<JCTree.JCExpression>nil())) : ((flags & 2L) != 0L ? annotations.prepend(this.make.Annotation(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.annotation.Private"), List.<JCTree.JCExpression>nil())) : ((flags & 4L) != 0L ? annotations.prepend(this.make.Annotation(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.annotation.Protected"), List.<JCTree.JCExpression>nil())) : ((flags & 0x200000000000L) != 0L ? annotations.prepend(this.make.Annotation(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.annotation.ScriptPrivate"), List.<JCTree.JCExpression>nil())) : annotations.prepend(this.make.Annotation(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.annotation.Package"), List.<JCTree.JCExpression>nil())))));
        if ((flags & 0x80000000000L) != 0L) {
            annotations = annotations.prepend(this.make.Annotation(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.annotation.PublicInitable"), List.<JCTree.JCExpression>nil()));
        }
        if ((flags & 0x40000000000L) != 0L) {
            annotations = annotations.prepend(this.make.Annotation(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.annotation.PublicReadable"), List.<JCTree.JCExpression>nil()));
        }
        if ((flags & 0x20000000000L) != 0L) {
            annotations = annotations.prepend(this.make.Annotation(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.annotation.Def"), List.<JCTree.JCExpression>nil()));
        }
        if ((flags & 8L) != 0L) {
            annotations = annotations.prepend(this.make.Annotation(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.annotation.Static"), List.<JCTree.JCExpression>nil()));
        }
        if (annotations.nonEmpty()) {
            ret = this.make.Modifiers(mods.flags, annotations);
        }
        return ret;
    }

    protected JCTree.JCModifiers addAccessAnnotationModifiers(JCDiagnostic.DiagnosticPosition diagPos, long flags, JCTree.JCModifiers mods) {
        return this.addAccessAnnotationModifiers(diagPos, flags, mods, List.<JCTree.JCAnnotation>nil());
    }

    protected JCTree.JCModifiers addInheritedAnnotationModifiers(JCDiagnostic.DiagnosticPosition diagPos, long flags, JCTree.JCModifiers mods) {
        return this.make.Modifiers(mods.flags, List.of(this.make.Annotation(this.makeIdentifier(diagPos, "com.sun.javafx.runtime.annotation.Inherited"), List.<JCTree.JCExpression>nil())));
    }

    protected void pretty(JCTree tree) {
        OutputStreamWriter osw = new OutputStreamWriter(System.out);
        Pretty pretty = new Pretty(osw, false);
        try {
            pretty.println();
            pretty.print("+++++++++++++++++++++++++++++++++");
            pretty.println();
            pretty.printExpr(tree);
            pretty.println();
            pretty.print("---------------------------------");
            pretty.println();
            osw.flush();
        }
        catch (Exception ex) {
            System.err.println("Pretty print got: " + ex);
        }
    }

    protected void fxPretty(JFXTree tree) {
        OutputStreamWriter osw = new OutputStreamWriter(System.out);
        JavafxPretty pretty = new JavafxPretty(osw, false);
        try {
            pretty.println();
            pretty.print("+++++++++++++++++++++++++++++++++");
            pretty.println();
            pretty.printExpr(tree);
            pretty.println();
            pretty.print("---------------------------------");
            pretty.println();
            osw.flush();
        }
        catch (Exception ex) {
            System.err.println("Pretty print got: " + ex);
        }
    }

    protected JFXFunctionInvocation timeLiteralToDuration(JFXTimeLiteral tree) {
        JFXSelect clsname = (JFXSelect)this.fxmake.at(tree.pos()).Type(this.syms.javafx_DurationType);
        clsname.sym = this.syms.javafx_DurationType.tsym;
        Name valueOf = this.names.fromString("valueOf");
        JFXSelect meth = this.fxmake.at(tree.pos).Select((JFXExpression)clsname, valueOf);
        meth.sym = this.syms.javafx_DurationType.tsym.members().lookup((Name)valueOf).sym;
        meth.type = meth.sym.type;
        List<JFXExpression> args = List.of(tree.value);
        JFXFunctionInvocation apply = this.fxmake.at(tree.pos).Apply(List.<JFXExpression>nil(), meth, args);
        apply.type = clsname.type;
        return apply;
    }

    protected JCTree.JCExpression makeDurationLiteral(JCDiagnostic.DiagnosticPosition diagPos, JCTree.JCExpression value) {
        JCTree.JCExpression clsname = this.makeTypeTree(diagPos, this.syms.javafx_DurationType);
        Name valueOf = this.names.fromString("valueOf");
        JCTree.JCFieldAccess meth = this.make.at(diagPos).Select(clsname, valueOf);
        List<JCTree.JCExpression> args = List.of(value);
        JCTree.JCMethodInvocation apply = this.make.at(diagPos).Apply(List.<JCTree.JCExpression>nil(), meth, args);
        return apply;
    }
}

