/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.code.JavafxClassSymbol;
import com.sun.tools.javafx.code.JavafxSymtab;
import com.sun.tools.javafx.code.JavafxTypes;
import com.sun.tools.javafx.code.JavafxVarSymbol;
import com.sun.tools.javafx.comp.JavafxClassReader;
import com.sun.tools.javafx.comp.JavafxDefs;
import com.sun.tools.javafx.comp.JavafxToJava;
import java.util.HashMap;
import java.util.Map;

public class JavafxTypeMorpher {
    protected static final Context.Key<JavafxTypeMorpher> typeMorpherKey = new Context.Key();
    private final JavafxDefs defs;
    private final Name.Table names;
    final JavafxClassReader reader;
    private final JavafxSymtab syms;
    private final JavafxToJava toJava;
    private final JavafxTypes types;
    public final LocationNameSymType[] bindingNCT;
    public final LocationNameSymType[] locationNCT;
    public final LocationNameSymType[] variableNCT;
    public final LocationNameSymType[] boundComprehensionNCT;
    public final LocationNameSymType[] constantLocationNCT;
    public final LocationNameSymType baseLocation;
    private final Object[] defaultValueByKind;
    private Map<Symbol, VarMorphInfo> vmiMap = new HashMap<Symbol, VarMorphInfo>();

    VarMorphInfo varMorphInfo(Symbol sym) {
        VarMorphInfo vmi = this.vmiMap.get(sym);
        if (vmi == null) {
            vmi = new VarMorphInfo(sym);
            this.vmiMap.put(sym, vmi);
        }
        return vmi;
    }

    TypeMorphInfo typeMorphInfo(Type type) {
        return new TypeMorphInfo(type);
    }

    public static JavafxTypeMorpher instance(Context context) {
        JavafxTypeMorpher instance = context.get(typeMorpherKey);
        if (instance == null) {
            instance = new JavafxTypeMorpher(context);
        }
        return instance;
    }

    protected JavafxTypeMorpher(Context context) {
        context.put(typeMorpherKey, this);
        this.defs = JavafxDefs.instance(context);
        this.syms = (JavafxSymtab)JavafxSymtab.instance(context);
        this.types = JavafxTypes.instance(context);
        this.names = Name.Table.instance(context);
        this.reader = JavafxClassReader.instance(context);
        this.toJava = JavafxToJava.instance(context);
        this.variableNCT = new LocationNameSymType[5];
        this.locationNCT = new LocationNameSymType[5];
        this.bindingNCT = new LocationNameSymType[5];
        this.boundComprehensionNCT = new LocationNameSymType[5];
        this.constantLocationNCT = new LocationNameSymType[5];
        for (int kind = 0; kind < 5; ++kind) {
            this.variableNCT[kind] = new LocationNameSymType(this.defs.locationVariableName[kind]);
            this.locationNCT[kind] = new LocationNameSymType(this.defs.locationInterfaceName[kind]);
            this.bindingNCT[kind] = new LocationNameSymType(JavafxVarSymbol.getTypePrefix(kind) + "BindingExpression");
            this.boundComprehensionNCT[kind] = new LocationNameSymType("com.sun.javafx.runtime.sequence", JavafxVarSymbol.getTypePrefix(kind) + "BoundComprehension");
            this.constantLocationNCT[kind] = new LocationNameSymType(JavafxVarSymbol.getTypePrefix(kind) + "Constant");
        }
        this.baseLocation = new LocationNameSymType("Location");
        this.defaultValueByKind = new Object[5];
        this.defaultValueByKind[0] = null;
        this.defaultValueByKind[1] = 0.0;
        this.defaultValueByKind[2] = 0;
        this.defaultValueByKind[3] = 0;
        this.defaultValueByKind[4] = null;
    }

    private boolean computeRequiresLocation(Symbol sym) {
        if (sym.kind == 4) {
            boolean isAssignedTo;
            Symbol owner = sym.owner;
            long flags = sym.flags();
            boolean isClassVar = owner.kind == 2;
            boolean bl = isAssignedTo = (flags & 0xC000000000000L) != 0L;
            if (sym.flatName() == this.names._super || sym.flatName() == this.names._this) {
                return false;
            }
            if (isClassVar && !this.types.isJFXClass(owner)) {
                assert (false) : "should be handled by ClassReader";
                return false;
            }
            if (isAssignedTo && !isClassVar && (flags & 0x40000000000000L) != 0L) {
                return true;
            }
            if ((flags & 0x200000000L) != 0L) {
                return (flags & 0x800000000000L) != 0L;
            }
            if ((flags & 0x83800000000000L) != 0L) {
                return true;
            }
            if (this.types.isSequence(sym.type)) {
                return true;
            }
            if (sym.type instanceof Type.MethodType) {
                return true;
            }
            if ((flags & 0x180000000000000L) != 0L) {
                return true;
            }
            if (isClassVar) {
                return (flags & 0x1C0000000005L) != 0L;
            }
        }
        return false;
    }

    public boolean requiresLocation(Symbol sym) {
        if ((sym.flags_field & 0x1000000000000000L) == 0L) {
            if (this.computeRequiresLocation(sym)) {
                sym.flags_field |= 0x800000000000000L;
            }
            sym.flags_field |= 0x1000000000000000L;
        }
        return (sym.flags_field & 0x800000000000000L) != 0L;
    }

    Type variableType(int typeKind) {
        return this.variableNCT[typeKind].type;
    }

    Type locationType(int typeKind) {
        return this.locationNCT[typeKind].type;
    }

    Type bindingExpressionType(int typeKind) {
        return this.bindingNCT[typeKind].type;
    }

    Type generifyIfNeeded(Type aLocationType, TypeMorphInfo tmi) {
        Type newType;
        Type elemType = tmi.getElementType();
        if (tmi.getTypeKind() == 0 || tmi.getTypeKind() == 4) {
            if (elemType == null) {
                elemType = this.syms.objectType;
            }
            List<Type> actuals = List.of(elemType);
            Type clazzOuter = this.variableType(tmi.getTypeKind()).getEnclosingType();
            List<Type> newActuals = List.nil();
            for (Type t : actuals) {
                if (t.tsym instanceof Symbol.ClassSymbol && (t.tsym.flags_field & 0x800000000000L) != 0L) {
                    String str = t.tsym.name.toString().replace("$", ".");
                    JavafxClassSymbol csym = new JavafxClassSymbol(0L, this.names.fromString(str), t.tsym.owner);
                    csym.flags_field |= 0x800000000000L;
                    Type.ClassType tp = new Type.ClassType(Type.noType, List.<Type>nil(), csym);
                    newActuals = newActuals.append(tp);
                    break;
                }
                newActuals = newActuals.append(t);
            }
            newType = new Type.ClassType(clazzOuter, newActuals, aLocationType.tsym);
        } else {
            newType = aLocationType;
        }
        return newType;
    }

    public class TypeMorphInfo {
        private Type realType;
        private final Type morphedVariableType;
        private final Type morphedLocationType;
        private int typeKind;
        private Type elementType = null;

        TypeMorphInfo(Type symType) {
            Symbol.TypeSymbol realTsym = symType.tsym;
            assert (realTsym != JavafxTypeMorpher.this.variableNCT[0].sym && realTsym != JavafxTypeMorpher.this.variableNCT[4].sym && realTsym != JavafxTypeMorpher.this.variableNCT[2].sym && realTsym != JavafxTypeMorpher.this.variableNCT[1].sym && realTsym != JavafxTypeMorpher.this.variableNCT[3].sym) : "Locations should have been converted";
            this.realType = symType;
            if (symType.isPrimitive()) {
                if (realTsym == ((JavafxTypeMorpher)JavafxTypeMorpher.this).syms.doubleType.tsym) {
                    this.typeKind = 1;
                } else if (realTsym == ((JavafxTypeMorpher)JavafxTypeMorpher.this).syms.intType.tsym) {
                    this.typeKind = 3;
                } else if (realTsym == ((JavafxTypeMorpher)JavafxTypeMorpher.this).syms.booleanType.tsym) {
                    this.typeKind = 2;
                } else {
                    this.elementType = this.realType = ((JavafxTypeMorpher)JavafxTypeMorpher.this).types.boxedClass((Type)this.realType).type;
                    this.typeKind = 0;
                }
            } else if (this.isSequence()) {
                this.typeKind = 4;
                this.elementType = JavafxTypeMorpher.this.toJava.elementType(symType);
            } else {
                this.typeKind = 0;
                this.elementType = this.realType;
            }
            this.morphedVariableType = symType == ((JavafxTypeMorpher)JavafxTypeMorpher.this).syms.voidType ? symType : JavafxTypeMorpher.this.generifyIfNeeded(JavafxTypeMorpher.this.variableType(this.typeKind), this);
            this.morphedLocationType = symType == ((JavafxTypeMorpher)JavafxTypeMorpher.this).syms.voidType ? symType : JavafxTypeMorpher.this.generifyIfNeeded(JavafxTypeMorpher.this.locationType(this.typeKind), this);
        }

        protected boolean isSequence() {
            return JavafxTypeMorpher.this.types.isSequence(this.realType);
        }

        public Type getRealType() {
            return this.realType;
        }

        public Type getRealBoxedType() {
            return this.realType.isPrimitive() ? ((JavafxTypeMorpher)JavafxTypeMorpher.this).types.boxedClass((Type)this.realType).type : this.realType;
        }

        public Type getRealFXType() {
            return this.realType.isPrimitive() && this.typeKind == 0 ? ((JavafxTypeMorpher)JavafxTypeMorpher.this).types.boxedClass((Type)this.realType).type : this.realType;
        }

        public Type getLocationType() {
            return this.morphedLocationType;
        }

        public Type getVariableType() {
            return this.morphedVariableType;
        }

        public Type getConstantLocationType() {
            return JavafxTypeMorpher.this.generifyIfNeeded(JavafxTypeMorpher.this.constantLocationNCT[this.typeKind].type, this);
        }

        public Object getDefaultValue() {
            return JavafxTypeMorpher.this.defaultValueByKind[this.typeKind];
        }

        public Type getElementType() {
            return this.elementType;
        }

        public int getTypeKind() {
            return this.typeKind;
        }
    }

    public class VarMorphInfo
    extends TypeMorphInfo {
        private final Symbol sym;

        VarMorphInfo(Symbol sym) {
            super(sym.kind == 16 ? ((Type.MethodType)sym.type).getReturnType() : sym.type);
            this.sym = sym;
        }

        public Symbol getSymbol() {
            return this.sym;
        }
    }

    public class LocationNameSymType {
        public final Name name;
        public final Symbol.ClassSymbol sym;
        public final Type type;

        private LocationNameSymType(Name name) {
            this.name = name;
            this.sym = JavafxTypeMorpher.this.reader.jreader.enterClass(name);
            this.type = this.sym.type;
        }

        private LocationNameSymType(String which) {
            this("com.sun.javafx.runtime.location", which);
        }

        private LocationNameSymType(String pkg, String which) {
            this(Name.fromString(javafxTypeMorpher.names, pkg + "." + which));
        }
    }
}

