/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javafx.comp.JavafxAttrContext;
import com.sun.tools.javafx.comp.JavafxEnv;
import com.sun.tools.javafx.comp.JavafxTypeMorpher;
import com.sun.tools.javafx.tree.JFXAssign;
import com.sun.tools.javafx.tree.JFXAssignOp;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXFunctionInvocation;
import com.sun.tools.javafx.tree.JFXFunctionValue;
import com.sun.tools.javafx.tree.JFXIdent;
import com.sun.tools.javafx.tree.JFXInitDefinition;
import com.sun.tools.javafx.tree.JFXInstanciate;
import com.sun.tools.javafx.tree.JFXInterpolateValue;
import com.sun.tools.javafx.tree.JFXObjectLiteralPart;
import com.sun.tools.javafx.tree.JFXOverrideClassVar;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXSelect;
import com.sun.tools.javafx.tree.JFXSequenceIndexed;
import com.sun.tools.javafx.tree.JFXSequenceSlice;
import com.sun.tools.javafx.tree.JFXUnary;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JFXVarScriptInit;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxTreeScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxVarUsageAnalysis
extends JavafxTreeScanner {
    protected static final Context.Key<JavafxVarUsageAnalysis> varUsageKey = new Context.Key();
    private final JavafxTypeMorpher typeMorpher;
    private boolean inLHS;
    private boolean inInitBlock;
    private boolean inBindContext;

    public static JavafxVarUsageAnalysis instance(Context context) {
        JavafxVarUsageAnalysis instance = context.get(varUsageKey);
        if (instance == null) {
            instance = new JavafxVarUsageAnalysis(context);
        }
        return instance;
    }

    JavafxVarUsageAnalysis(Context context) {
        context.put(varUsageKey, this);
        this.typeMorpher = JavafxTypeMorpher.instance(context);
        this.inLHS = false;
        this.inInitBlock = false;
        this.inBindContext = false;
    }

    public void analyzeVarUse(JavafxEnv<JavafxAttrContext> attrEnv) {
        this.scan(attrEnv.tree);
    }

    private void mark(Symbol sym, long flag) {
        sym.flags_field |= flag;
    }

    private void markVarAccess(Symbol sym) {
        if (sym instanceof Symbol.VarSymbol) {
            if (this.inBindContext) {
                this.mark(sym, 0x2000000000000L);
            } else {
                if (this.inLHS) {
                    if (this.inInitBlock) {
                        this.mark(sym, 0x8000000000000L);
                    } else {
                        this.mark(sym, 0x4000000000000L);
                    }
                }
                if ((sym.flags_field & 0x400000000000000L) != 0L) {
                    this.mark(sym, 0x80000000000000L);
                }
            }
        }
    }

    private void markDefinition(Symbol sym) {
        if (this.inBindContext) {
            this.mark(sym, 0x800000000000L);
        }
    }

    @Override
    public void visitScript(JFXScript tree) {
        this.inInitBlock = false;
        this.inLHS = false;
        this.inBindContext = false;
        super.visitScript(tree);
    }

    @Override
    public void visitVarScriptInit(JFXVarScriptInit tree) {
    }

    @Override
    public void visitVar(JFXVar tree) {
        boolean wasInBindContext = this.inBindContext;
        this.inBindContext |= tree.isBound();
        this.markDefinition(tree.sym);
        tree.sym.flags_field |= 0x400000000000000L;
        this.scan(tree.getInitializer());
        tree.sym.flags_field &= 0xFBFFFFFFFFFFFFFFL;
        if (tree.getInitializer() != null && tree.getInitializer().getFXTag() != JavafxTag.LITERAL) {
            this.mark(tree.sym, 0x200000000000000L);
        }
        this.inBindContext = wasInBindContext;
        if (tree.getOnReplace() != null) {
            this.mark(tree.sym, 0x1000000000000L);
            this.scan(tree.getOnReplace());
        }
    }

    @Override
    public void visitOverrideClassVar(JFXOverrideClassVar tree) {
        boolean wasInBindContext = this.inBindContext;
        this.inBindContext |= tree.isBound();
        this.markDefinition(tree.sym);
        this.mark(tree.sym, 0x20000000000000L);
        tree.sym.flags_field |= 0x400000000000000L;
        this.scan(tree.getInitializer());
        tree.sym.flags_field &= 0xFBFFFFFFFFFFFFFFL;
        this.inBindContext = wasInBindContext;
        if (tree.getOnReplace() != null) {
            this.mark(tree.sym, 0x1000000000000L);
            this.scan(tree.getOnReplace());
        }
    }

    @Override
    public void visitClassDeclaration(JFXClassDeclaration tree) {
        boolean wasLHS = this.inLHS;
        boolean wasInBindContext = this.inBindContext;
        boolean wasInInitBlock = this.inInitBlock;
        this.inInitBlock = false;
        this.inLHS = false;
        this.inBindContext = false;
        super.visitClassDeclaration(tree);
        this.inInitBlock = wasInInitBlock;
        this.inBindContext = wasInBindContext;
        this.inLHS = wasLHS;
    }

    @Override
    public void visitFunctionDefinition(JFXFunctionDefinition tree) {
        boolean wasLHS = this.inLHS;
        boolean wasInBindContext = this.inBindContext;
        boolean wasInInitBlock = this.inInitBlock;
        this.inInitBlock = false;
        this.inLHS = false;
        this.inBindContext = tree.isBound();
        for (JFXVar param : tree.getParams()) {
            this.scan(param);
        }
        this.scan(tree.getBodyExpression());
        this.inInitBlock = wasInInitBlock;
        this.inBindContext = wasInBindContext;
        this.inLHS = wasLHS;
    }

    @Override
    public void visitFunctionValue(JFXFunctionValue tree) {
        boolean wasLHS = this.inLHS;
        boolean wasInBindContext = this.inBindContext;
        boolean wasInInitBlock = this.inInitBlock;
        this.inInitBlock = false;
        this.inLHS = false;
        this.inBindContext = false;
        super.visitFunctionValue(tree);
        this.inInitBlock = wasInInitBlock;
        this.inBindContext = wasInBindContext;
        this.inLHS = wasLHS;
    }

    @Override
    public void visitFunctionInvocation(JFXFunctionInvocation tree) {
        super.visitFunctionInvocation(tree);
        Symbol msym = this.expressionSymbol(tree.meth);
        if (msym != null && msym instanceof Symbol.MethodSymbol && (msym.flags_field & 0x800000000000L) != 0L) {
            Symbol asym = this.expressionSymbol((JFXExpression)tree.args.head);
            asym.flags_field |= 0x100000000000000L;
        }
    }

    @Override
    public void visitObjectLiteralPart(JFXObjectLiteralPart tree) {
        boolean wasInBindContext = this.inBindContext;
        this.inBindContext |= tree.isBound();
        this.markDefinition(tree.sym);
        this.mark(tree.sym, 0x10000000000000L);
        this.scan(tree.getExpression());
        this.inBindContext = wasInBindContext;
    }

    @Override
    public void visitInstanciate(JFXInstanciate tree) {
        super.visitInstanciate(tree);
        for (JFXVar var : tree.getLocalvars()) {
            this.mark(var.sym, 0x40000000000000L);
        }
    }

    @Override
    public void visitAssign(JFXAssign tree) {
        boolean wasLHS = this.inLHS;
        this.inLHS = true;
        this.scan(tree.lhs);
        this.inLHS = wasLHS;
        this.scan(tree.rhs);
    }

    @Override
    public void visitAssignop(JFXAssignOp tree) {
        boolean wasLHS = this.inLHS;
        this.inLHS = true;
        this.scan(tree.lhs);
        this.inLHS = wasLHS;
        this.scan(tree.rhs);
    }

    @Override
    public void visitUnary(JFXUnary tree) {
        boolean wasLHS = this.inLHS;
        switch (tree.getFXTag()) {
            case PREINC: 
            case PREDEC: 
            case POSTINC: 
            case POSTDEC: {
                this.inLHS = true;
            }
        }
        this.scan(tree.arg);
        this.inLHS = wasLHS;
    }

    @Override
    public void visitIdent(JFXIdent tree) {
        this.markVarAccess(tree.sym);
    }

    @Override
    public void visitInitDefinition(JFXInitDefinition that) {
        assert (!this.inInitBlock) : "cannot have nested init blocks without intervening class";
        assert (!this.inLHS) : "cannot have init blocks on LHS";
        assert (!this.inBindContext) : "cannot have init blocks on bind";
        this.inInitBlock = true;
        this.scan(that.getBody());
        that.sym.owner.flags_field |= 0x2000000000000L;
        this.inInitBlock = false;
    }

    @Override
    public void visitInterpolateValue(JFXInterpolateValue tree) {
        boolean wasInBindContext = this.inBindContext;
        this.inBindContext = true;
        super.visitInterpolateValue(tree);
        this.inBindContext = wasInBindContext;
    }

    @Override
    public void visitSelect(JFXSelect tree) {
        boolean wasLHS = this.inLHS;
        this.inLHS = false;
        this.scan(tree.selected);
        this.inLHS = wasLHS;
        this.markVarAccess(tree.sym);
    }

    @Override
    public void visitSequenceIndexed(JFXSequenceIndexed tree) {
        boolean wasLHS = this.inLHS;
        this.inLHS = false;
        super.visitSequenceIndexed(tree);
        this.inLHS = wasLHS;
    }

    @Override
    public void visitSequenceSlice(JFXSequenceSlice tree) {
        boolean wasLHS = this.inLHS;
        this.inLHS = false;
        super.visitSequenceSlice(tree);
        this.inLHS = wasLHS;
    }

    private Symbol expressionSymbol(JFXExpression tree) {
        switch (tree.getFXTag()) {
            case IDENT: {
                return ((JFXIdent)tree).sym;
            }
            case SELECT: {
                return ((JFXSelect)tree).sym;
            }
        }
        return null;
    }
}

