/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.main;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacFileManager;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Messages;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import com.sun.tools.javafx.code.BlockExprSymtab;
import com.sun.tools.javafx.code.JavafxLint;
import com.sun.tools.javafx.comp.BlockExprAttr;
import com.sun.tools.javafx.comp.BlockExprEnter;
import com.sun.tools.javafx.comp.BlockExprGen;
import com.sun.tools.javafx.comp.BlockExprLower;
import com.sun.tools.javafx.comp.BlockExprMemberEnter;
import com.sun.tools.javafx.comp.BlockExprResolve;
import com.sun.tools.javafx.comp.JavafxClassReader;
import com.sun.tools.javafx.comp.JavafxFlow;
import com.sun.tools.javafx.main.CommandLine;
import com.sun.tools.javafx.main.JavafxCompiler;
import com.sun.tools.javafx.main.JavafxJavaCompiler;
import com.sun.tools.javafx.main.JavafxOption;
import com.sun.tools.javafx.main.RecognizedOptions;
import com.sun.tools.javafx.util.JavafxFileManager;
import com.sun.tools.javafx.util.PlatformPlugin;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    String ownName;
    PrintWriter out;
    boolean fatalErrors;
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private JavafxOption.Option[] recognizedOptions = RecognizedOptions.getJavaCompilerOptions(new RecognizedOptions.OptionHelper(){

        public void setOut(PrintWriter out) {
            Main.this.out = out;
        }

        public void error(String key, Object ... args) {
            Main.this.error(key, args);
        }

        public void printVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("version", Main.this.ownName, JavafxCompiler.version()));
        }

        public void printFullVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("fullVersion", Main.this.ownName, JavafxCompiler.fullVersion()));
        }

        public void printHelp() {
            Main.this.help();
        }

        public void printXhelp() {
            Main.this.xhelp();
        }

        public void addFile(File f) {
            if (!Main.this.filenames.contains(f)) {
                Main.this.filenames.append(f);
            }
        }

        public void addClassName(String s) {
            Main.this.classnames.append(s);
        }
    });
    private Options options = null;
    public ListBuffer<File> filenames = null;
    public ListBuffer<String> classnames = null;
    private JavaFileManager fileManager;
    private static final String javacBundleName = "com.sun.tools.javac.resources.javac";
    private static final String javafxBundleName = "com.sun.tools.javafx.resources.javafxcompiler";
    private static Messages messages;

    public Main(String name) {
        this(name, new PrintWriter(System.err, true));
    }

    public Main(String name, PrintWriter out) {
        this.ownName = name;
        this.out = out;
    }

    void help() {
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.header", this.ownName));
        for (int i = 0; i < this.recognizedOptions.length; ++i) {
            this.recognizedOptions[i].help(this.out);
        }
        this.out.println();
    }

    void xhelp() {
        for (int i = 0; i < this.recognizedOptions.length; ++i) {
            this.recognizedOptions[i].xhelp(this.out);
        }
        this.out.println();
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.nonstandard.footer", new Object[0]));
    }

    void error(String key, Object ... args) {
        if (this.fatalErrors) {
            String msg = Main.getLocalizedString(key, args);
            throw new PropagatedException(new IllegalStateException(msg));
        }
        this.warning(key, args);
        Log.printLines(this.out, Main.getLocalizedString("msg.usage", this.ownName));
    }

    void warning(String key, Object ... args) {
        Log.printLines(this.out, this.ownName + ": " + Main.getLocalizedString(key, args));
    }

    public JavafxOption.Option getOption(String flag) {
        for (JavafxOption.Option option : this.recognizedOptions) {
            if (!option.matches(flag)) continue;
            return option;
        }
        return null;
    }

    public void setOptions(Options options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.options = options;
    }

    public void setFatalErrors(boolean fatalErrors) {
        this.fatalErrors = fatalErrors;
    }

    public List<File> processArgs(String[] flags) {
        Target target;
        int ac = 0;
        while (ac < flags.length) {
            int firstOptionToCheck;
            int j;
            String flag = flags[ac];
            ++ac;
            for (j = firstOptionToCheck = flag.charAt(0) == '-' ? 0 : this.recognizedOptions.length - 1; j < this.recognizedOptions.length && !this.recognizedOptions[j].matches(flag); ++j) {
            }
            if (j == this.recognizedOptions.length) {
                this.error("err.invalid.flag", flag);
                return null;
            }
            JavafxOption.Option option = this.recognizedOptions[j];
            if (option.hasArg()) {
                if (ac == flags.length) {
                    this.error("err.req.arg", flag);
                    return null;
                }
                String operand = flags[ac];
                ++ac;
                if (!option.process(this.options, flag, operand)) continue;
                return null;
            }
            if (!option.process(this.options, flag)) continue;
            return null;
        }
        if (!this.checkDirectory("-d")) {
            return null;
        }
        if (!this.checkDirectory("-s")) {
            return null;
        }
        String sourceString = this.options.get("-source");
        Source source = sourceString != null ? Source.lookup(sourceString) : Source.DEFAULT;
        String targetString = this.options.get("-target");
        Target target2 = target = targetString != null ? Target.lookup(targetString) : Target.DEFAULT;
        if (Character.isDigit(target.name.charAt(0))) {
            if (target.compareTo(source.requiredTarget()) < 0) {
                if (targetString != null) {
                    if (sourceString == null) {
                        this.warning("warn.target.default.source.conflict", targetString, source.requiredTarget().name);
                    } else {
                        this.warning("warn.source.target.conflict", sourceString, source.requiredTarget().name);
                    }
                    return null;
                }
                this.options.put("-target", source.requiredTarget().name);
            } else if (targetString == null && !source.allowGenerics()) {
                this.options.put("-target", Target.JDK1_4.name);
            }
        }
        return this.filenames.toList();
    }

    private boolean checkDirectory(String optName) {
        String value = this.options.get(optName);
        if (value == null) {
            return true;
        }
        File file = new File(value);
        if (!file.exists()) {
            this.error("err.dir.not.found", value);
            return false;
        }
        if (!file.isDirectory()) {
            this.error("err.file.not.directory", value);
            return false;
        }
        return true;
    }

    public int compile(String[] args) {
        Context context = new Context();
        int result = this.compile(args, context, List.<JavaFileObject>nil());
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).close();
        }
        return result;
    }

    public void registerServices(Context context, String[] args) {
        Context backEndContext = new Context();
        backEndContext.put(DiagnosticListener.class, new DiagnosticForwarder(context));
        this.options = Options.instance(backEndContext);
        this.options.put("-target", Target.JDK1_5.name);
        try {
            String[] allArgs = CommandLine.parse(args);
            for (int i = 0; i < allArgs.length; ++i) {
                String opt = allArgs[i];
                if (opt.equals("-g") || opt.startsWith("-g:")) {
                    this.options.put(opt, opt);
                }
                if (opt.equals("-Xjcov")) {
                    this.options.put(opt, opt);
                }
                if (!opt.endsWith("-target") || ++i >= allArgs.length) continue;
                this.options.put("-target", allArgs[i]);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.options = null;
        this.filenames = null;
        JavafxFlow.preRegister(backEndContext);
        JavafxLint.preRegister(backEndContext);
        BlockExprSymtab.preRegister(backEndContext);
        BlockExprAttr.preRegister(backEndContext);
        BlockExprEnter.preRegister(backEndContext);
        BlockExprMemberEnter.preRegister(backEndContext);
        BlockExprResolve.preRegister(backEndContext);
        BlockExprLower.preRegister(backEndContext);
        BlockExprGen.preRegister(backEndContext);
        JavaFileManager currentFileManager = context.get(JavaFileManager.class);
        if (currentFileManager == null) {
            JavafxFileManager.preRegister(backEndContext);
        } else {
            backEndContext.put(JavaFileManager.class, currentFileManager);
        }
        JavafxJavaCompiler javafxJavaCompiler = JavafxJavaCompiler.instance(backEndContext);
        context.put(JavafxJavaCompiler.javafxJavaCompilerKey, javafxJavaCompiler);
        context.put(Name.Table.namesKey, backEndContext.get(Name.Table.namesKey));
        context.put(Options.optionsKey, (Options)null);
        context.put(Options.optionsKey, backEndContext.get(Options.optionsKey));
        ClassReader jreader = ClassReader.instance(backEndContext);
        JavafxClassReader.preRegister(context, jreader);
        if (currentFileManager == null) {
            JavafxFileManager.preRegister(context);
        }
        JavafxLint.preRegister(context);
    }

    private void loadPlatformPlugin(Context context, Options options) {
        String platform = options.get("-platform");
        if (platform == null) {
            return;
        }
        String path = this.getClass().getCanonicalName();
        path = path.substring(path.lastIndexOf(46) + 1);
        path = this.getClass().getResource(path + ".class").toString();
        path = path.substring(0, path.lastIndexOf(".jar!"));
        path = path.substring("jar:file:".length(), path.lastIndexOf("/"));
        File dir = new File(path);
        File[] jars = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        PlatformPlugin plugin = null;
        URL[] urls = new URL[1];
        for (File jar : jars) {
            try {
                plugin = null;
                urls[0] = jar.toURI().toURL();
                URLClassLoader loader = new URLClassLoader(urls);
                InputStream stream = loader.getResourceAsStream("META-INF/services/com.sun.tools.javafx.util.PlatformPlugin");
                if (stream == null) continue;
                InputStreamReader reader = new InputStreamReader(stream);
                String pname = Main.readServiceProvider(reader);
                try {
                    ((Reader)reader).close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (pname == null) {
                    Log.instance(context).warning("plugin.cannot.load.plugin", urls[0].getPath());
                    continue;
                }
                Class<?> pclass = loader.loadClass(pname);
                plugin = (PlatformPlugin)pclass.newInstance();
                if (!plugin.isSupported(platform)) continue;
                try {
                    Class<?> mclass = loader.loadClass("com.sun.tools.javafx.resources.platformplugin");
                    ResourceBundle msgs = (ResourceBundle)mclass.newInstance();
                    Messages.instance(context).add(msgs);
                }
                catch (ClassNotFoundException cnfe) {
                }
                catch (InstantiationException ie) {
                    // empty catch block
                }
                plugin.initialize(options, Log.instance(context));
                context.put(PlatformPlugin.pluginKey, plugin);
                break;
            }
            catch (MalformedURLException murle) {
            }
            catch (ClassNotFoundException cnfe) {
                Log.instance(context).warning("plugin.cannot.load.plugin", urls[0].getPath());
            }
            catch (InstantiationException ie) {
                Log.instance(context).warning("plugin.cannot.load.plugin", urls[0].getPath());
            }
            catch (IllegalAccessException iae) {
                Log.instance(context).warning("plugin.cannot.load.plugin", urls[0].getPath());
            }
        }
        if (plugin == null) {
            Log.instance(context).error("plugin.cannot.find.plugin", platform);
        }
    }

    private static String readServiceProvider(Reader reader) {
        StringBuffer name = new StringBuffer(128);
        int st = 0;
        try {
            int ch;
            block17: while ((ch = reader.read()) >= 0) {
                switch (st) {
                    case 0: {
                        switch (ch) {
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                continue block17;
                            }
                            case 35: {
                                st = 1;
                                continue block17;
                            }
                        }
                        name.append((char)ch);
                        st = 2;
                        continue block17;
                    }
                    case 1: {
                        switch (ch) {
                            case 10: 
                            case 13: {
                                st = 0;
                                continue block17;
                            }
                        }
                        continue block17;
                    }
                    case 2: {
                        switch (ch) {
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: 
                            case 35: {
                                return name.toString();
                            }
                        }
                        name.append((char)ch);
                        continue block17;
                    }
                }
                return null;
            }
        }
        catch (IOException ioe) {
            return null;
        }
        return st == 2 ? name.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(String[] args, Context context, List<JavaFileObject> fileObjects) {
        int n;
        this.registerServices(context, args);
        if (this.options == null) {
            this.options = Options.instance(context);
        }
        this.filenames = new ListBuffer();
        this.classnames = new ListBuffer();
        JavafxCompiler comp = null;
        try {
            boolean forceStdOut;
            if (args.length == 0 && fileObjects.isEmpty()) {
                this.help();
                int n2 = 2;
                return n2;
            }
            List<File> fnames = this.processArgs(CommandLine.parse(args));
            if (fnames == null) {
                int n3 = 2;
                return n3;
            }
            if (fnames.isEmpty() && fileObjects.isEmpty() && this.classnames.isEmpty()) {
                if (this.options.get("-help") != null || this.options.get("-X") != null || this.options.get("-version") != null || this.options.get("-fullversion") != null) {
                    int n4 = 0;
                    return n4;
                }
                this.error("err.no.source.files", new Object[0]);
                int n5 = 2;
                return n5;
            }
            boolean bl = forceStdOut = this.options.get("stdout") != null;
            if (forceStdOut) {
                this.out.flush();
                this.out = new PrintWriter(System.out, true);
            }
            context.put(Log.outKey, this.out);
            this.fileManager = context.get(JavaFileManager.class);
            comp = JavafxCompiler.instance(context);
            if (comp == null) {
                int n6 = 3;
                return n6;
            }
            this.loadPlatformPlugin(context, this.options);
            if (!fnames.isEmpty()) {
                comp = JavafxCompiler.instance(context);
                List<JavaFileObject> otherFiles = List.nil();
                JavacFileManager dfm = (JavacFileManager)this.fileManager;
                for (JavaFileObject javaFileObject : dfm.getJavaFileObjectsFromFiles(fnames)) {
                    otherFiles = otherFiles.prepend(javaFileObject);
                }
                for (JavaFileObject javaFileObject : otherFiles) {
                    fileObjects = fileObjects.prepend(javaFileObject);
                }
            }
            comp.compile(fileObjects, this.classnames.toList());
            if (comp.errorCount() != 0 || this.options.get("-Werror") != null && comp.warningCount() != 0) {
                int n7 = 1;
                return n7;
            }
        }
        catch (IOException ex) {
            this.ioMessage(ex);
            n = 3;
            return n;
        }
        catch (OutOfMemoryError ex) {
            this.resourceMessage(ex);
            n = 3;
            return n;
        }
        catch (StackOverflowError ex) {
            this.resourceMessage(ex);
            n = 3;
            return n;
        }
        catch (FatalError ex) {
            this.feMessage(ex);
            n = 3;
            return n;
        }
        catch (ClientCodeException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (PropagatedException ex) {
            throw ex.getCause();
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || this.options == null || this.options.get("dev") != null) {
                this.bugMessage(ex);
            }
            n = 4;
            return n;
        }
        finally {
            if (comp != null) {
                comp.close();
            }
            this.filenames = null;
            this.options = null;
        }
        return 0;
    }

    void bugMessage(Throwable ex) {
        Log.printLines(this.out, Main.getJavafxLocalizedString("javafx.msg.bug", JavafxCompiler.version()));
        ex.printStackTrace(this.out);
    }

    void feMessage(Throwable ex) {
        Log.printLines(this.out, ex.getMessage());
    }

    void ioMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.io", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void resourceMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.resource", new Object[0]));
        ex.printStackTrace(this.out);
    }

    public static String getLocalizedString(String key, Object ... args) {
        try {
            if (messages == null) {
                messages = new Messages(javacBundleName);
            }
            return messages.getLocalizedString("javac." + key, args);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal Error: Resource for javac is missing", e);
        }
    }

    public static String getJavafxLocalizedString(String key, Object ... args) {
        try {
            Messages fxmessages = new Messages(javafxBundleName);
            return fxmessages.getLocalizedString(key, args);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal Error: Resource for javac is missing", e);
        }
    }

    public static void useRawMessages(boolean enable) {
        messages = enable ? new Messages(javacBundleName){

            public String getLocalizedString(String key, Object ... args) {
                return key;
            }
        } : new Messages(javacBundleName);
    }

    static {
        ClassLoader loader = Main.class.getClassLoader();
        if (loader != null) {
            loader.setPackageAssertionStatus("com.sun.tools.javafx", true);
            loader.setPackageAssertionStatus("com.sun.tools.javac", true);
        }
    }

    private static class DiagnosticForwarder
    implements DiagnosticListener {
        Context otherContext;

        public DiagnosticForwarder(Context context) {
            this.otherContext = context;
        }

        public void report(Diagnostic diag) {
            Log log = Log.instance(this.otherContext);
            log.report((JCDiagnostic)diag);
        }
    }
}

