/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.script;

import com.sun.javafx.api.JavafxcTask;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javafx.api.JavafxcTool;
import com.sun.tools.javafx.script.MemoryFileManager;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFXScriptCompiler {
    private JavafxcTool tool;
    private StandardJavaFileManager stdManager;
    private ClassLoader parentClassLoader;

    public JavaFXScriptCompiler(ClassLoader parent) {
        this.parentClassLoader = parent;
        this.tool = JavafxcTool.create();
    }

    public Map<String, byte[]> compile(String filename, String source) {
        PrintWriter err = new PrintWriter(System.err);
        return this.compile(filename, source, err, null, null);
    }

    public Map<String, byte[]> compile(String fileName, String source, Writer err) {
        return this.compile(fileName, source, err, null, null);
    }

    public Map<String, byte[]> compile(String fileName, String source, Writer err, String sourcePath) {
        return this.compile(fileName, source, err, sourcePath, null);
    }

    public Map<String, byte[]> compile(String fileName, String source, Writer err, String sourcePath, String classPath) {
        return this.compile(fileName, source, err, sourcePath, classPath, new DiagnosticCollector<JavaFileObject>(), true);
    }

    public Map<String, byte[]> compile(String filename) throws IOException {
        String source = this.readFully(new FileReader(filename));
        PrintWriter err = new PrintWriter(System.err);
        return this.compile(filename, source, err, null, null);
    }

    public Map<String, byte[]> compile(String fileName, String source, Writer err, String sourcePath, String classPath, DiagnosticListener<JavaFileObject> diagnostics, boolean printDiagnostics) {
        if (this.stdManager == null) {
            this.stdManager = this.tool.getStandardFileManager(diagnostics, (Locale)null, (Charset)null);
        }
        MemoryFileManager manager = new MemoryFileManager(this.stdManager, this.parentClassLoader);
        ArrayList<JavaFileObject> compUnits = new ArrayList<JavaFileObject>(1);
        compUnits.add(manager.makeStringSource(fileName, source));
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Xlint:all-unchecked");
        options.add("-g");
        options.add("-deprecation");
        if (sourcePath != null) {
            options.add("-sourcepath");
            options.add(sourcePath);
        }
        if (classPath != null) {
            options.add("-classpath");
            options.add(classPath);
        }
        options.add("-target");
        options.add("1.5");
        options.add("-XDdumpfx=" + System.getProperty("java.io.tmpdir"));
        JavafxcTask task = this.tool.getTask(err, manager, diagnostics, options, compUnits);
        if (!task.call().booleanValue()) {
            if (printDiagnostics && diagnostics instanceof DiagnosticCollector) {
                JavaFXScriptCompiler.printDiagnostics((DiagnosticCollector)diagnostics, err);
            }
            return null;
        }
        Map<String, byte[]> classBytes = manager.getClassBytes();
        try {
            manager.close();
        }
        catch (IOException exp) {
            // empty catch block
        }
        return classBytes;
    }

    static void printDiagnostics(DiagnosticCollector<JavaFileObject> diagnostics, Writer err) {
        Context context = new Context();
        Options options = Options.instance(context);
        options.put("diags", "%l: %t%m|%p%m");
        PrintWriter perr = new PrintWriter(err);
        RedirectedLog log = new RedirectedLog(context, perr);
        for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
            log.report((JCDiagnostic)diagnostic);
        }
    }

    private String readFully(Reader reader) throws IOException {
        int numChars;
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
            buf.append(arr, 0, numChars);
        }
        return buf.toString();
    }

    private static class RedirectedLog
    extends Log {
        RedirectedLog(Context context, PrintWriter writer) {
            super(context, writer);
        }
    }
}

