/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.script;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryFileManager
extends ForwardingJavaFileManager {
    private ClassLoader parentClassLoader;
    List<SimpleJavaFileObject> buffers = new ArrayList<SimpleJavaFileObject>();
    private static final String EXT = ".fx";
    private Map<String, byte[]> classBytes = new HashMap<String, byte[]>();

    public MemoryFileManager(JavaFileManager fileManager, ClassLoader cl) {
        super(fileManager);
        this.parentClassLoader = cl;
    }

    public Map<String, byte[]> getClassBytes() {
        return this.classBytes;
    }

    @Override
    public void close() throws IOException {
        this.classBytes = new HashMap<String, byte[]>();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return super.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        URL res;
        if (kind == JavaFileObject.Kind.CLASS && (res = this.parentClassLoader.getResource(className.replace('.', '/') + ".class")) != null) {
            return new ClassResource(res);
        }
        return super.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            ClassOutputBuffer buf = new ClassOutputBuffer(className);
            this.buffers.add(buf);
            return buf;
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    public Iterable list(JavaFileManager.Location location, String packageName, Set kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
        LinkedList<JavaFileObject> results = new LinkedList<JavaFileObject>();
        for (JavaFileObject o : result) {
            results.add(o);
        }
        String prefix = packageName.equals("") ? "" : packageName + ".";
        for (SimpleJavaFileObject b : this.buffers) {
            String name = b.getName().replace("/", ".");
            name = name.substring(1, name.length() - (name.endsWith(EXT) ? EXT.length() : 0));
            if (prefix.length() == 0) {
                if (name.contains(".")) continue;
                results.add(b);
                continue;
            }
            if (!name.startsWith(prefix) || (name = name.substring(prefix.length())).contains(".")) continue;
            results.add(b);
        }
        return results;
    }

    JavaFileObject makeStringSource(String name, String code) {
        StringInputBuffer buffer = new StringInputBuffer(name, code);
        this.buffers.add(buffer);
        return buffer;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof StringInputBuffer) {
            return ((StringInputBuffer)file).getBinaryName();
        }
        if (file instanceof ClassOutputBuffer) {
            return ((ClassOutputBuffer)file).getBinaryName();
        }
        return super.inferBinaryName(location, file);
    }

    static URI toURI(String name) {
        File file = new File(name);
        if (file.exists()) {
            return file.toURI();
        }
        try {
            StringBuilder newUri = new StringBuilder();
            newUri.append("mfm:///");
            newUri.append(name.replace('.', '/'));
            if (name.endsWith(EXT)) {
                newUri.replace(newUri.length() - EXT.length(), newUri.length(), EXT);
            }
            return URI.create(newUri.toString());
        }
        catch (Exception exp) {
            return URI.create("mfm:///com/sun/tools/javafx/script/javafx_source");
        }
    }

    private class ClassOutputBuffer
    extends SimpleJavaFileObject {
        private String name;

        ClassOutputBuffer(String name) {
            super(MemoryFileManager.toURI(name), JavaFileObject.Kind.CLASS);
            this.name = name;
        }

        public String getBinaryName() {
            return this.name;
        }

        public OutputStream openOutputStream() {
            return new FilterOutputStream(new ByteArrayOutputStream()){

                public void close() throws IOException {
                    this.out.close();
                    ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                    MemoryFileManager.this.classBytes.put(ClassOutputBuffer.this.name, bos.toByteArray());
                }
            };
        }
    }

    private static class StringInputBuffer
    extends SimpleJavaFileObject {
        final String code;
        final boolean isFXSourceFile;
        String binaryName;

        public String getBinaryName() {
            return this.binaryName.equals("__FX_SCRIPT__.fx") ? "__FX_SCRIPT__" : this.binaryName;
        }

        StringInputBuffer(String name, String code) {
            super(MemoryFileManager.toURI(name), JavaFileObject.Kind.SOURCE);
            this.code = code;
            this.binaryName = name;
            this.isFXSourceFile = name.endsWith(MemoryFileManager.EXT);
        }

        public CharBuffer getCharContent(boolean ignoreEncodingErrors) {
            return CharBuffer.wrap(this.code);
        }

        public Reader openReader() {
            return new StringReader(this.code);
        }

        public JavaFileObject.Kind getKind() {
            return JavaFileObject.Kind.SOURCE;
        }

        public String getName() {
            return super.getName();
        }

        public NestingKind getNestingKind() {
            return super.getNestingKind();
        }

        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return super.isNameCompatible(simpleName, kind);
        }

        public InputStream openInputStream() throws IOException {
            return super.openInputStream();
        }

        public OutputStream openOutputStream() throws IOException {
            return super.openOutputStream();
        }

        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return super.openReader(ignoreEncodingErrors);
        }

        public Writer openWriter() throws IOException {
            return super.openWriter();
        }
    }

    private static class ClassResource
    extends SimpleJavaFileObject {
        URL url;

        static URI toURI(URL u) {
            try {
                return u.toURI();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public ClassResource(URL u) {
            super(ClassResource.toURI(u), JavaFileObject.Kind.CLASS);
            this.url = u;
        }

        public InputStream openInputStream() throws IOException {
            return this.url.openStream();
        }
    }
}

