/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.tree;

import com.sun.javafx.api.tree.CompoundAssignmentTree;
import com.sun.javafx.api.tree.JavaFXTreeVisitor;
import com.sun.javafx.api.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxTreeInfo;
import com.sun.tools.javafx.tree.JavafxVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFXAssignOp
extends JFXExpression
implements CompoundAssignmentTree {
    private JavafxTag opcode;
    public JFXExpression lhs;
    public JFXExpression rhs;
    public Symbol operator;

    protected JFXAssignOp(JavafxTag opcode, JFXExpression lhs, JFXExpression rhs, Symbol operator) {
        this.opcode = opcode;
        this.lhs = lhs;
        this.rhs = rhs;
        this.operator = operator;
    }

    @Override
    public void accept(JavafxVisitor v) {
        v.visitAssignop(this);
    }

    @Override
    public Tree.JavaFXKind getJavaFXKind() {
        return JavafxTreeInfo.tagToKind(this.getFXTag());
    }

    @Override
    public JFXExpression getVariable() {
        return this.lhs;
    }

    @Override
    public JFXExpression getExpression() {
        return this.rhs;
    }

    public Symbol getOperator() {
        return this.operator;
    }

    @Override
    public <R, D> R accept(JavaFXTreeVisitor<R, D> v, D d) {
        return v.visitCompoundAssignment(this, d);
    }

    @Override
    public JavafxTag getFXTag() {
        return this.opcode;
    }

    public JavafxTag getNormalOperatorFXTag() {
        switch (this.opcode) {
            case PLUS_ASG: {
                return JavafxTag.PLUS;
            }
            case MINUS_ASG: {
                return JavafxTag.MINUS;
            }
            case MUL_ASG: {
                return JavafxTag.MUL;
            }
            case DIV_ASG: {
                return JavafxTag.DIV;
            }
        }
        throw new RuntimeException("bad assign op tag: " + (Object)((Object)this.opcode));
    }

    public int getOperatorTag() {
        return this.opcode.asOperatorTag();
    }
}

