/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.tree;

import com.sun.javafx.api.tree.JavaFXTreeVisitor;
import com.sun.javafx.api.tree.LiteralTree;
import com.sun.javafx.api.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javafx.tree.JFXExpression;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFXLiteral
extends JFXExpression
implements LiteralTree {
    public int typetag;
    public Object value;

    protected JFXLiteral(int typetag, Object value) {
        this.typetag = typetag;
        this.value = value;
    }

    @Override
    public void accept(JavafxVisitor v) {
        v.visitLiteral(this);
    }

    @Override
    public Tree.JavaFXKind getJavaFXKind() {
        switch (this.typetag) {
            case 4: {
                return Tree.JavaFXKind.INT_LITERAL;
            }
            case 5: {
                return Tree.JavaFXKind.FLOAT_LITERAL;
            }
            case 7: {
                return Tree.JavaFXKind.DOUBLE_LITERAL;
            }
            case 8: {
                return Tree.JavaFXKind.BOOLEAN_LITERAL;
            }
            case 10: {
                return Tree.JavaFXKind.STRING_LITERAL;
            }
            case 17: {
                return Tree.JavaFXKind.NULL_LITERAL;
            }
        }
        throw new AssertionError((Object)("unknown literal kind " + this));
    }

    @Override
    public Object getValue() {
        switch (this.typetag) {
            case 8: {
                int bi = (Integer)this.value;
                return bi != 0;
            }
            case 2: {
                int ci = (Integer)this.value;
                char c = (char)ci;
                if (c != ci) {
                    throw new AssertionError((Object)"bad value for char literal");
                }
                return Character.valueOf(c);
            }
        }
        return this.value;
    }

    @Override
    public <R, D> R accept(JavaFXTreeVisitor<R, D> v, D d) {
        return v.visitLiteral(this, d);
    }

    @Override
    public JFXLiteral setType(Type type) {
        super.setType(type);
        return this;
    }

    @Override
    public JavafxTag getFXTag() {
        return JavafxTag.LITERAL;
    }
}

