/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.tree;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.comp.JavafxDefs;
import com.sun.tools.javafx.tree.BlockExprJCBlockExpression;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;

public class JavaPretty
extends Pretty {
    private HashSet<Name> importedPackages = new HashSet();
    private HashSet<Name> importedClasses = new HashSet();

    public JavaPretty(Writer out, boolean sourceOutput, Context context) {
        super(out, sourceOutput);
        JavafxDefs defs = JavafxDefs.instance(context);
        this.importedPackages.add(defs.runtimePackageName);
        this.importedPackages.add(defs.annotationPackageName);
        this.importedPackages.add(defs.locationPackageName);
        this.importedPackages.add(defs.sequencePackageName);
        this.importedPackages.add(defs.functionsPackageName);
        this.importedPackages.add(defs.javaLangPackageName);
    }

    public void visitBlockExpression(BlockExprJCBlockExpression tree) {
        JavaPretty.visitBlockExpression(this, tree);
    }

    public static void visitBlockExpression(Pretty pretty, BlockExprJCBlockExpression tree) {
        try {
            pretty.printFlags(tree.flags);
            pretty.print("{");
            pretty.println();
            pretty.indent();
            pretty.printStats(tree.stats);
            if (tree.value != null) {
                pretty.align();
                pretty.printExpr(tree.value);
            }
            pretty.undent();
            pretty.println();
            pretty.align();
            pretty.print("}");
        }
        catch (IOException e) {
            throw new Pretty.UncheckedIOException(e);
        }
    }

    public void visitImport(JCTree.JCImport tree) {
        super.visitImport(tree);
        Name name = TreeInfo.name(tree.qualid);
        if (name == name.table.asterisk) {
            if (tree.qualid.getTag() == 34) {
                this.importedPackages.add(TreeInfo.fullName(((JCTree.JCFieldAccess)tree.qualid).selected));
            }
        } else if (!name.contentEquals("**")) {
            this.importedClasses.add(TreeInfo.fullName(tree.qualid));
        }
    }

    public void visitSelect(JCTree.JCFieldAccess tree) {
        try {
            if (!this.importedPackages.contains(TreeInfo.fullName(tree.selected)) && !this.importedClasses.contains(TreeInfo.fullName(tree))) {
                this.printExpr(tree.selected, 15);
                this.print(".");
            }
            this.print(tree.name);
        }
        catch (IOException e) {
            throw new Pretty.UncheckedIOException(e);
        }
    }
}

