/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.tree;

import com.sun.javafx.api.tree.Tree;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javafx.tree.JFXAssign;
import com.sun.tools.javafx.tree.JFXAssignOp;
import com.sun.tools.javafx.tree.JFXBinary;
import com.sun.tools.javafx.tree.JFXBlock;
import com.sun.tools.javafx.tree.JFXClassDeclaration;
import com.sun.tools.javafx.tree.JFXForExpression;
import com.sun.tools.javafx.tree.JFXForExpressionInClause;
import com.sun.tools.javafx.tree.JFXFunctionDefinition;
import com.sun.tools.javafx.tree.JFXFunctionInvocation;
import com.sun.tools.javafx.tree.JFXIdent;
import com.sun.tools.javafx.tree.JFXInitDefinition;
import com.sun.tools.javafx.tree.JFXInstanceOf;
import com.sun.tools.javafx.tree.JFXObjectLiteralPart;
import com.sun.tools.javafx.tree.JFXOnReplace;
import com.sun.tools.javafx.tree.JFXOverrideClassVar;
import com.sun.tools.javafx.tree.JFXParens;
import com.sun.tools.javafx.tree.JFXPostInitDefinition;
import com.sun.tools.javafx.tree.JFXScript;
import com.sun.tools.javafx.tree.JFXSelect;
import com.sun.tools.javafx.tree.JFXSequenceIndexed;
import com.sun.tools.javafx.tree.JFXSequenceSlice;
import com.sun.tools.javafx.tree.JFXStringExpression;
import com.sun.tools.javafx.tree.JFXTree;
import com.sun.tools.javafx.tree.JFXTry;
import com.sun.tools.javafx.tree.JFXTypeClass;
import com.sun.tools.javafx.tree.JFXUnary;
import com.sun.tools.javafx.tree.JFXVar;
import com.sun.tools.javafx.tree.JFXVarScriptInit;
import com.sun.tools.javafx.tree.JavafxTag;
import com.sun.tools.javafx.tree.JavafxTreeScanner;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxTreeInfo {
    protected Name[] opname = new Name[JavafxTag.MOD.ordinal() - JavafxTag.NEG.ordinal() + 1];
    protected static final Context.Key<JavafxTreeInfo> fxTreeInfoKey = new Context.Key();
    public static final int notExpression = -1;
    public static final int noPrec = 0;
    public static final int assignPrec = 1;
    public static final int assignopPrec = 2;
    public static final int orPrec = 3;
    public static final int andPrec = 4;
    public static final int eqPrec = 5;
    public static final int ordPrec = 6;
    public static final int addPrec = 7;
    public static final int mulPrec = 8;
    public static final int prefixPrec = 9;
    public static final int postfixPrec = 10;
    public static final int precCount = 11;

    public static JavafxTreeInfo instance(Context context) {
        JavafxTreeInfo instance = context.get(fxTreeInfoKey);
        if (instance == null) {
            instance = new JavafxTreeInfo(context);
        }
        return instance;
    }

    protected JavafxTreeInfo(Context context) {
        Name.Table names = Name.Table.instance(context);
        int base = JavafxTag.NEG.ordinal();
        this.opname = new Name[JavafxTag.JFX_OP_LAST.ordinal() - base + 1];
        this.opname[JavafxTag.NEG.ordinal() - base] = names.hyphen;
        this.opname[JavafxTag.NOT.ordinal() - base] = names.fromString("!");
        this.opname[JavafxTag.PREINC.ordinal() - base] = names.fromString("++");
        this.opname[JavafxTag.PREDEC.ordinal() - base] = names.fromString("--");
        this.opname[JavafxTag.POSTINC.ordinal() - base] = names.fromString("++");
        this.opname[JavafxTag.POSTDEC.ordinal() - base] = names.fromString("--");
        this.opname[JavafxTag.NULLCHK.ordinal() - base] = names.fromString("<*nullchk*>");
        this.opname[JavafxTag.OR.ordinal() - base] = names.fromString("or");
        this.opname[JavafxTag.AND.ordinal() - base] = names.fromString("and");
        this.opname[JavafxTag.EQ.ordinal() - base] = names.fromString("==");
        this.opname[JavafxTag.NE.ordinal() - base] = names.fromString("<>");
        this.opname[JavafxTag.LT.ordinal() - base] = names.fromString("<");
        this.opname[JavafxTag.GT.ordinal() - base] = names.fromString(">");
        this.opname[JavafxTag.LE.ordinal() - base] = names.fromString("<=");
        this.opname[JavafxTag.GE.ordinal() - base] = names.fromString(">=");
        this.opname[JavafxTag.PLUS.ordinal() - base] = names.fromString("+");
        this.opname[JavafxTag.MINUS.ordinal() - base] = names.hyphen;
        this.opname[JavafxTag.MUL.ordinal() - base] = names.asterisk;
        this.opname[JavafxTag.DIV.ordinal() - base] = names.slash;
        this.opname[JavafxTag.MOD.ordinal() - base] = names.fromString("%");
        this.opname[JavafxTag.XOR.ordinal() - base] = names.fromString("xor");
        this.opname[JavafxTag.SIZEOF.ordinal() - base] = names.fromString("sizeof");
        this.opname[JavafxTag.INDEXOF.ordinal() - base] = names.fromString("indexof");
        this.opname[JavafxTag.REVERSE.ordinal() - base] = names.fromString("reverse");
    }

    public Name operatorName(JavafxTag tag) {
        return this.opname[tag.ordinal() - JavafxTag.NEG.ordinal()];
    }

    public static JCDiagnostic.DiagnosticPosition diagEndPos(final JFXTree tree) {
        final int endPos = JavafxTreeInfo.endPos(tree);
        return new JCDiagnostic.DiagnosticPosition(){

            @Override
            public JFXTree getTree() {
                return tree;
            }

            @Override
            public int getStartPosition() {
                return JavafxTreeInfo.getStartPos(tree);
            }

            @Override
            public int getPreferredPosition() {
                return endPos;
            }

            @Override
            public int getEndPosition(Map<JCTree, Integer> endPosTable) {
                return JavafxTreeInfo.getEndPos(tree, endPosTable);
            }
        };
    }

    public static JCDiagnostic.DiagnosticPosition diagnosticPositionFor(Symbol sym, JFXTree tree) {
        JFXTree decl = JavafxTreeInfo.declarationFor(sym, tree);
        return (decl != null ? decl : tree).pos();
    }

    public static JFXTree declarationFor(Symbol sym, JFXTree tree) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DeclScanner
        extends JavafxTreeScanner {
            JFXTree result = null;
            final /* synthetic */ Symbol val$sym;

            DeclScanner(Symbol symbol) {
                this.val$sym = symbol;
            }

            @Override
            public void scan(JFXTree tree) {
                if (tree != null && this.result == null) {
                    tree.accept(this);
                }
            }

            @Override
            public void visitScript(JFXScript that) {
                if (that.packge == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitScript(that);
                }
            }

            @Override
            public void visitFunctionDefinition(JFXFunctionDefinition that) {
                if (that.sym == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitFunctionDefinition(that);
                }
            }

            @Override
            public void visitVar(JFXVar that) {
                if (that.sym == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitVar(that);
                }
            }
        }
        DeclScanner s = new DeclScanner(sym);
        tree.accept(s);
        return s.result;
    }

    public static List<JFXTree> pathFor(JFXTree node, JFXScript unit) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Result
        extends Error {
            static final long serialVersionUID = -5942088234594905625L;
            List<JFXTree> path;

            Result(List<JFXTree> path) {
                this.path = path;
            }
        }
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class PathFinder
            extends JavafxTreeScanner {
                List<JFXTree> path = List.nil();
                final /* synthetic */ JFXTree val$node;

                PathFinder(JFXTree jFXTree) {
                    this.val$node = jFXTree;
                }

                @Override
                public void scan(JFXTree tree) {
                    if (tree != null) {
                        this.path = this.path.prepend(tree);
                        if (tree == this.val$node) {
                            throw new Result(this.path);
                        }
                        super.scan(tree);
                        this.path = this.path.tail;
                    }
                }
            }
            new PathFinder(node).scan(unit);
        }
        catch (Result result) {
            return result.path;
        }
        return List.nil();
    }

    public static long firstFlag(long flags) {
        for (int i = 0; i < 63; ++i) {
            long flag = 1L << i;
            if ((flag & flags) == 0L) continue;
            return flag;
        }
        throw new AssertionError();
    }

    public static String flagNames(long flags) {
        StringBuffer fsb = new StringBuffer(Flags.toString(flags));
        if ((flags & 0x100000000000L) != 0L) {
            fsb.append("package ");
        }
        if ((flags & 0x200000000000L) != 0L) {
            fsb.append("script only (default) ");
        }
        if ((flags & 0x40000000000L) != 0L) {
            fsb.append("public-read ");
        }
        if ((flags & 0x80000000000L) != 0L) {
            fsb.append("public-init ");
        }
        if ((flags & 0x8000000000L) != 0L) {
            fsb.append("bound ");
        }
        if ((flags & 0x10000000000L) != 0L) {
            fsb.append("override ");
        }
        return fsb.toString().trim();
    }

    public static int opPrec(JavafxTag op) {
        switch (op) {
            case ASSIGN: {
                return 1;
            }
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: {
                return 2;
            }
            case OR: 
            case XOR: {
                return 3;
            }
            case AND: {
                return 4;
            }
            case EQ: 
            case NE: {
                return 5;
            }
            case LT: 
            case GT: 
            case LE: 
            case GE: {
                return 6;
            }
            case PLUS: 
            case MINUS: {
                return 7;
            }
            case MUL: 
            case DIV: 
            case MOD: {
                return 8;
            }
            case TYPETEST: {
                return 6;
            }
            case NEG: 
            case NOT: 
            case PREINC: 
            case PREDEC: 
            case REVERSE: 
            case INDEXOF: 
            case SIZEOF: {
                return 9;
            }
            case POSTINC: 
            case POSTDEC: 
            case NULLCHK: {
                return 10;
            }
        }
        throw new AssertionError((Object)("Unexpected operator precidence request: " + (Object)((Object)op)));
    }

    static Tree.JavaFXKind tagToKind(JavafxTag tag) {
        switch (tag) {
            case POSTINC: {
                return Tree.JavaFXKind.POSTFIX_INCREMENT;
            }
            case POSTDEC: {
                return Tree.JavaFXKind.POSTFIX_DECREMENT;
            }
            case PREINC: {
                return Tree.JavaFXKind.PREFIX_INCREMENT;
            }
            case PREDEC: {
                return Tree.JavaFXKind.PREFIX_DECREMENT;
            }
            case NEG: {
                return Tree.JavaFXKind.UNARY_MINUS;
            }
            case NOT: {
                return Tree.JavaFXKind.LOGICAL_COMPLEMENT;
            }
            case MUL: {
                return Tree.JavaFXKind.MULTIPLY;
            }
            case DIV: {
                return Tree.JavaFXKind.DIVIDE;
            }
            case MOD: {
                return Tree.JavaFXKind.REMAINDER;
            }
            case PLUS: {
                return Tree.JavaFXKind.PLUS;
            }
            case MINUS: {
                return Tree.JavaFXKind.MINUS;
            }
            case LT: {
                return Tree.JavaFXKind.LESS_THAN;
            }
            case GT: {
                return Tree.JavaFXKind.GREATER_THAN;
            }
            case LE: {
                return Tree.JavaFXKind.LESS_THAN_EQUAL;
            }
            case GE: {
                return Tree.JavaFXKind.GREATER_THAN_EQUAL;
            }
            case EQ: {
                return Tree.JavaFXKind.EQUAL_TO;
            }
            case NE: {
                return Tree.JavaFXKind.NOT_EQUAL_TO;
            }
            case AND: {
                return Tree.JavaFXKind.CONDITIONAL_AND;
            }
            case OR: {
                return Tree.JavaFXKind.CONDITIONAL_OR;
            }
            case MUL_ASG: {
                return Tree.JavaFXKind.MULTIPLY_ASSIGNMENT;
            }
            case DIV_ASG: {
                return Tree.JavaFXKind.DIVIDE_ASSIGNMENT;
            }
            case PLUS_ASG: {
                return Tree.JavaFXKind.PLUS_ASSIGNMENT;
            }
            case MINUS_ASG: {
                return Tree.JavaFXKind.MINUS_ASSIGNMENT;
            }
            case NULLCHK: {
                return Tree.JavaFXKind.OTHER;
            }
            case SIZEOF: {
                return Tree.JavaFXKind.OTHER;
            }
            case REVERSE: {
                return Tree.JavaFXKind.OTHER;
            }
        }
        return null;
    }

    public static Symbol symbol(JFXTree tree) {
        tree = JavafxTreeInfo.skipParens(tree);
        switch (tree.getFXTag()) {
            case IDENT: {
                return ((JFXIdent)tree).sym;
            }
            case SELECT: {
                return ((JFXSelect)tree).sym;
            }
            case SEQUENCE_INDEXED: {
                return JavafxTreeInfo.symbol(((JFXSequenceIndexed)tree).getSequence());
            }
            case SEQUENCE_SLICE: {
                return JavafxTreeInfo.symbol(((JFXSequenceSlice)tree).getSequence());
            }
        }
        return null;
    }

    public static JFXTree skipParens(JFXTree tree) {
        if (tree == null) {
            return tree;
        }
        if (tree.getFXTag() == JavafxTag.PARENS) {
            return JavafxTreeInfo.skipParens((JFXParens)tree);
        }
        return tree;
    }

    public static Name fullName(JFXTree tree) {
        if (tree == null) {
            return null;
        }
        tree = JavafxTreeInfo.skipParens(tree);
        switch (tree.getFXTag()) {
            case IDENT: {
                return ((JFXIdent)tree).name;
            }
            case SELECT: {
                Name sname = JavafxTreeInfo.fullName(((JFXSelect)tree).selected);
                return sname == null ? null : sname.append('.', JavafxTreeInfo.name(tree));
            }
        }
        return null;
    }

    public static Name name(JFXTree tree) {
        switch (tree.getFXTag()) {
            case IDENT: {
                return ((JFXIdent)tree).name;
            }
            case SELECT: {
                return ((JFXSelect)tree).name;
            }
        }
        return null;
    }

    public static Symbol symbolFor(JFXTree node) {
        if (node == null) {
            return null;
        }
        node = JavafxTreeInfo.skipParens(node);
        switch (node.getFXTag()) {
            case VAR_DEF: {
                return ((JFXVar)node).sym;
            }
            case VAR_SCRIPT_INIT: {
                return ((JFXVarScriptInit)node).getSymbol();
            }
            case CLASS_DEF: {
                return ((JFXClassDeclaration)node).sym;
            }
            case FUNCTION_DEF: {
                return ((JFXFunctionDefinition)node).sym;
            }
            case OBJECT_LITERAL_PART: {
                return ((JFXObjectLiteralPart)node).sym;
            }
            case TYPECLASS: {
                return JavafxTreeInfo.symbolFor(((JFXTypeClass)node).getTypeExpression());
            }
            case IDENT: {
                return ((JFXIdent)node).sym;
            }
            case SELECT: {
                return ((JFXSelect)node).sym;
            }
            case APPLY: {
                return JavafxTreeInfo.symbolFor(((JFXFunctionInvocation)node).meth);
            }
            case TOPLEVEL: {
                return ((JFXScript)node).packge;
            }
        }
        return null;
    }

    public static int getStartPos(JFXTree tree) {
        if (tree == null) {
            return -1;
        }
        switch (tree.getFXTag()) {
            case APPLY: {
                return JavafxTreeInfo.getStartPos(((JFXFunctionInvocation)tree).meth);
            }
            case ASSIGN: {
                return JavafxTreeInfo.getStartPos(((JFXAssign)tree).lhs);
            }
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: {
                return JavafxTreeInfo.getStartPos(((JFXAssignOp)tree).lhs);
            }
            case OR: 
            case AND: 
            case EQ: 
            case NE: 
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case PLUS: 
            case MINUS: 
            case MUL: 
            case DIV: 
            case MOD: {
                return JavafxTreeInfo.getStartPos(((JFXBinary)tree).lhs);
            }
            case SELECT: {
                return JavafxTreeInfo.getStartPos(((JFXSelect)tree).selected);
            }
            case TYPETEST: {
                return JavafxTreeInfo.getStartPos(((JFXInstanceOf)tree).expr);
            }
            case POSTINC: 
            case POSTDEC: {
                return JavafxTreeInfo.getStartPos(((JFXUnary)tree).arg);
            }
            case ERRONEOUS: {
                return tree.pos;
            }
        }
        return tree.pos;
    }

    public static int endPos(JFXTree tree) {
        if (tree.getFXTag() == JavafxTag.BLOCK_EXPRESSION && ((JFXBlock)tree).endpos != -1) {
            return ((JFXBlock)tree).endpos;
        }
        if (tree.getFXTag() == JavafxTag.TRY) {
            JFXTry t = (JFXTry)tree;
            return JavafxTreeInfo.endPos(t.finalizer != null ? t.finalizer : t.catchers.last().body);
        }
        return tree.pos;
    }

    public static int getEndPos(JFXTree tree, Map<JCTree, Integer> endPositions) {
        if (tree == null) {
            return -1;
        }
        if (endPositions == null) {
            return tree instanceof JFXBlock ? ((JFXBlock)tree).endpos : JavafxTreeInfo.endPos(tree);
        }
        Integer mapPos = endPositions.get(tree);
        if (mapPos != null) {
            return mapPos;
        }
        switch (tree.getFXTag()) {
            case INIT_DEF: {
                return JavafxTreeInfo.getEndPos(((JFXInitDefinition)tree).getBody(), endPositions);
            }
            case POSTINIT_DEF: {
                return JavafxTreeInfo.getEndPos(((JFXPostInitDefinition)tree).getBody(), endPositions);
            }
            case OVERRIDE_ATTRIBUTE_DEF: {
                JFXOverrideClassVar t = (JFXOverrideClassVar)tree;
                if (t.getOnReplace() != null) {
                    return JavafxTreeInfo.getEndPos(t.getOnReplace(), endPositions);
                }
                return JavafxTreeInfo.getEndPos(t.getInitializer(), endPositions);
            }
            case ON_REPLACE: {
                return JavafxTreeInfo.getEndPos(((JFXOnReplace)tree).getBody(), endPositions);
            }
            case OBJECT_LITERAL_PART: {
                return JavafxTreeInfo.getEndPos(((JFXObjectLiteralPart)tree).getExpression(), endPositions);
            }
            case STRING_EXPRESSION: {
                return tree.pos + ((JFXStringExpression)tree).translationKey.length();
            }
            case FOR_EXPRESSION: {
                return JavafxTreeInfo.getEndPos(((JFXForExpression)tree).getBodyExpression(), endPositions);
            }
            case FOR_EXPRESSION_IN_CLAUSE: {
                return JavafxTreeInfo.getEndPos(((JFXForExpressionInClause)tree).getWhereExpression(), endPositions);
            }
            case TYPECLASS: {
                return JavafxTreeInfo.getEndPos(((JFXTypeClass)tree).getClassName(), endPositions);
            }
            case TIME_LITERAL: {
                return tree.pos + tree.toString().length();
            }
        }
        return JavafxTreeInfo.getStartPos(tree);
    }
}

