/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.util;

import com.sun.tools.javac.util.BaseFileObject;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacFileManager;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavafxFileManager
extends JavacFileManager {
    public static final String FX_SOURCE_SUFFIX = ".fx";
    private static final boolean fileSystemIsCaseSensitive = File.separatorChar == '/';
    private final Set<JavaFileObject.Kind> sourceOrClass = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);

    public static void preRegister(final Context context) {
        context.put(JavaFileManager.class, new Context.Factory<JavaFileManager>(){

            @Override
            public JavaFileManager make() {
                return new JavafxFileManager(context, true, null);
            }
        });
    }

    public JavafxFileManager(Context context, boolean register, Charset charset) {
        super(context, register, charset);
    }

    @Override
    protected JavaFileObject.Kind getKind(String extension) {
        if (extension.equals(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (extension.equals(FX_SOURCE_SUFFIX)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (extension.equals(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Override
    public JavaFileObject getRegularFile(File file) {
        return new DelegateJavaFileObject(super.getRegularFile(file));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        Iterable<? extends JavaFileObject> objs = super.getJavaFileObjectsFromFiles(files);
        ArrayList<DelegateJavaFileObject> result = new ArrayList<DelegateJavaFileObject>();
        for (JavaFileObject javaFileObject : objs) {
            result.add(new DelegateJavaFileObject(javaFileObject));
        }
        return result;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavafxFileManager.nullCheck(location);
        JavafxFileManager.nullCheck(className);
        JavafxFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        String name = JavafxFileManager.externalizeFileName(className, kind);
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        for (File file : path) {
            if (file.isDirectory()) {
                File f = new File(file, name.replace('/', File.separatorChar));
                if (!f.exists()) continue;
                return new DelegateJavaFileObject(this.getRegularFile(f));
            }
            JavacFileManager.Archive a = this.openArchive(file);
            if (!a.contains(name)) continue;
            int i = name.lastIndexOf(47);
            String dirname = name.substring(0, i + 1);
            String basename = name.substring(i + 1);
            return new DelegateJavaFileObject(a.getFileObject(dirname, basename));
        }
        return null;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (!kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
            return super.list(location, packageName, kinds, recurse);
        }
        JavafxFileManager.nullCheck(packageName);
        JavafxFileManager.nullCheck(kinds);
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return List.nil();
        }
        String subdirectory = packageName.replace('.', File.separatorChar);
        ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        for (File file : path) {
            this.listDirectory(file, subdirectory, kinds, recurse, results);
        }
        return results.toList();
    }

    private static <T> T nullCheck(T o) {
        o.getClass();
        return o;
    }

    private static String externalizeFileName(CharSequence name, JavaFileObject.Kind kind) {
        String basename = ((Object)name).toString().replace('.', File.separatorChar);
        String suffix = kind == JavaFileObject.Kind.SOURCE ? FX_SOURCE_SUFFIX : kind.extension;
        return basename + suffix;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (sibling != null && sibling instanceof DelegateJavaFileObject) {
            sibling = ((DelegateJavaFileObject)sibling).delegate;
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    private void listDirectory(File directory, String subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> l) {
        block15: {
            File d;
            block14: {
                List<String> files;
                boolean isFile = directory.isFile();
                if (!isFile) break block14;
                JavacFileManager.Archive archive = null;
                try {
                    archive = this.openArchive(directory);
                }
                catch (IOException ex) {
                    this.log.error("error.reading.file", directory, ex.getLocalizedMessage());
                    return;
                }
                if (subdirectory.length() != 0) {
                    if (!(subdirectory = subdirectory.replace('\\', '/')).endsWith("/")) {
                        subdirectory = subdirectory + "/";
                    }
                } else {
                    subdirectory = File.separatorChar == '/' ? subdirectory.replace('\\', '/') : subdirectory.replace('/', '\\');
                    if (!subdirectory.endsWith(File.separator)) {
                        subdirectory = subdirectory + File.separator;
                    }
                }
                if ((files = archive.getFiles(subdirectory)) != null) {
                    while (!files.isEmpty()) {
                        String file = (String)files.head;
                        if (this.isValidFile(file, fileKinds)) {
                            l.append(archive.getFileObject(subdirectory, file));
                        }
                        files = files.tail;
                    }
                }
                if (!recurse) break block15;
                for (String s : archive.getSubdirectories()) {
                    if (!s.startsWith(subdirectory) || s.equals(subdirectory)) continue;
                    this.listDirectory(directory, s, fileKinds, false, l);
                }
                break block15;
            }
            File file = d = subdirectory.length() != 0 ? new File(directory, subdirectory) : directory;
            if (!this.caseMapCheck(d, subdirectory)) {
                return;
            }
            File[] files = d.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                String fname = f.getName();
                if (f.isDirectory()) {
                    if (!recurse || !SourceVersion.isIdentifier(fname)) continue;
                    this.listDirectory(directory, subdirectory + File.separator + fname, fileKinds, recurse, l);
                    continue;
                }
                if (!this.isValidFile(fname, fileKinds)) continue;
                DelegateJavaFileObject fe = new DelegateJavaFileObject(super.getRegularFile(new File(d, fname)));
                l.append(fe);
            }
        }
    }

    private boolean isValidFile(String s, Set<JavaFileObject.Kind> fileKinds) {
        int lastDot = s.lastIndexOf(".");
        String extn = lastDot == -1 ? s : s.substring(lastDot);
        JavaFileObject.Kind kind = this.getKind(extn);
        return fileKinds.contains((Object)kind);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        file.getClass();
        location.getClass();
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        if (file instanceof DelegateJavaFileObject) {
            DelegateJavaFileObject r = (DelegateJavaFileObject)file;
            String rPath = r.getPath();
            for (File file2 : path) {
                String dPath = file2.getPath();
                if (!dPath.endsWith(File.separator)) {
                    dPath = dPath + File.separator;
                }
                if (!rPath.regionMatches(true, 0, dPath, 0, dPath.length()) || !new File(rPath.substring(0, dPath.length())).equals(new File(dPath))) continue;
                String relativeName = rPath.substring(dPath.length());
                return JavafxFileManager.removeExtension(relativeName).replace(File.separatorChar, '.');
            }
        }
        return super.inferBinaryName(location, file);
    }

    private static String removeExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        return lastDot == -1 ? fileName : fileName.substring(0, lastDot);
    }

    private boolean caseMapCheck(File f, String name) {
        String path;
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException ex) {
            return false;
        }
        char[] pcs = path.toCharArray();
        char[] ncs = name.toCharArray();
        int i = pcs.length - 1;
        int j = ncs.length - 1;
        while (i >= 0 && j >= 0) {
            while (i >= 0 && pcs[i] == File.separatorChar) {
                --i;
            }
            while (j >= 0 && ncs[j] == File.separatorChar) {
                --j;
            }
            if (i < 0 || j < 0) continue;
            if (pcs[i] != ncs[j]) {
                return false;
            }
            --i;
            --j;
        }
        return j < 0;
    }

    private static class DelegateJavaFileObject
    extends BaseFileObject {
        JavaFileObject delegate;
        boolean isFXSourceFile;

        DelegateJavaFileObject(JavaFileObject jfo) {
            this.delegate = jfo;
            this.isFXSourceFile = jfo.getName().endsWith(JavafxFileManager.FX_SOURCE_SUFFIX);
        }

        public JavaFileObject.Kind getKind() {
            return this.isFXSourceFile ? JavaFileObject.Kind.SOURCE : this.delegate.getKind();
        }

        public boolean isNameCompatible(String cn, JavaFileObject.Kind kind) {
            cn.getClass();
            if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
                return false;
            }
            String suffix = kind == JavaFileObject.Kind.SOURCE ? JavafxFileManager.FX_SOURCE_SUFFIX : kind.extension;
            String n = cn + suffix;
            if (this.delegate.getName().equals(n)) {
                return true;
            }
            if (this.getName().equalsIgnoreCase(n)) {
                try {
                    File f = new File(this.getPath());
                    return f.getCanonicalFile().getName().equals(n);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return false;
        }

        public NestingKind getNestingKind() {
            return this.delegate.getNestingKind();
        }

        public Modifier getAccessLevel() {
            return this.delegate.getAccessLevel();
        }

        public URI toUri() {
            return this.delegate.toUri();
        }

        public String getName() {
            return this.delegate.getName();
        }

        @Deprecated
        public String getPath() {
            return this.delegate instanceof BaseFileObject ? ((BaseFileObject)this.delegate).getPath() : this.getName();
        }

        public InputStream openInputStream() throws IOException {
            return this.delegate.openInputStream();
        }

        public OutputStream openOutputStream() throws IOException {
            return this.delegate.openOutputStream();
        }

        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return this.delegate.openReader(ignoreEncodingErrors);
        }

        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.delegate.getCharContent(ignoreEncodingErrors);
        }

        public Writer openWriter() throws IOException {
            return this.delegate.openWriter();
        }

        public long getLastModified() {
            return this.delegate.getLastModified();
        }

        public boolean delete() {
            return this.delegate.delete();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

