/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import javafx.reflect.FXType;

public class FXFunctionType
extends FXType {
    protected int minArgs;
    protected FXType[] argTypes;
    protected boolean varArgs;
    protected FXType returnType;

    FXFunctionType() {
    }

    FXFunctionType(FXType[] argTypes, FXType returnType) {
        this.argTypes = argTypes;
        this.minArgs = argTypes.length;
        this.returnType = returnType;
    }

    public int minArgs() {
        return this.minArgs;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public FXType getArgumentType(int i) {
        return this.argTypes[this.varArgs && i >= this.minArgs ? this.minArgs : i];
    }

    public FXType getReturnType() {
        return this.returnType;
    }

    public boolean equals(FXFunctionType ftype) {
        if (this.minArgs != ftype.minArgs || this.varArgs != ftype.varArgs || !this.returnType.equals(ftype.returnType)) {
            return false;
        }
        int i = this.minArgs;
        while (--i >= 0) {
            if (this.argTypes[i].equals(ftype.argTypes[i])) continue;
            return false;
        }
        return true;
    }

    public void toStringRaw(StringBuilder sb) {
        sb.append('(');
        int n = this.minArgs();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            this.getArgumentType(i).toStringTerse(sb);
        }
        sb.append(')');
        sb.append(':');
        this.returnType.toStringTerse(sb);
    }

    protected void toStringTerse(StringBuilder sb) {
        sb.append("function");
        this.toStringRaw(sb);
    }
}

