/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import com.sun.javafx.functions.Function;
import com.sun.javafx.functions.Function0;
import com.sun.javafx.functions.Function1;
import com.sun.javafx.functions.Function2;
import com.sun.javafx.functions.Function3;
import com.sun.javafx.functions.Function4;
import com.sun.javafx.functions.Function5;
import com.sun.javafx.functions.Function6;
import com.sun.javafx.functions.Function7;
import com.sun.javafx.functions.Function8;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.annotation.Inherited;
import com.sun.javafx.runtime.annotation.SourceName;
import com.sun.javafx.runtime.location.AbstractVariable;
import com.sun.javafx.runtime.location.BooleanVariable;
import com.sun.javafx.runtime.location.DoubleVariable;
import com.sun.javafx.runtime.location.IntVariable;
import com.sun.javafx.runtime.location.ObjectLocation;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javafx.reflect.FXBooleanValue;
import javafx.reflect.FXClassType;
import javafx.reflect.FXContext;
import javafx.reflect.FXFunctionMember;
import javafx.reflect.FXFunctionType;
import javafx.reflect.FXFunctionValue;
import javafx.reflect.FXIntegerValue;
import javafx.reflect.FXJavaArrayType;
import javafx.reflect.FXLocation;
import javafx.reflect.FXMemberFilter;
import javafx.reflect.FXNumberValue;
import javafx.reflect.FXObjectValue;
import javafx.reflect.FXPrimitiveType;
import javafx.reflect.FXSequenceType;
import javafx.reflect.FXSequenceValue;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;
import javafx.reflect.FXVarMember;
import javafx.reflect.FXVarMemberLocation;

public class FXLocal {
    public static Context getContext() {
        return Context.instance;
    }

    public static class VarMemberLocation
    extends FXVarMemberLocation {
        VarMember var;

        public VarMemberLocation(FXObjectValue object, VarMember var) {
            super(object, var);
            this.var = var;
        }

        public AbstractVariable getAbstractVariable(FXObjectValue obj) {
            try {
                Object val;
                Object robj;
                Object object = robj = obj == null ? null : ((ObjectValue)obj).obj;
                if (this.var.getter != null && (val = this.var.getter.invoke(robj, new Object[0])) instanceof AbstractVariable) {
                    return (AbstractVariable)val;
                }
                return null;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class FunctionValue
    extends FXFunctionValue
    implements Value {
        Function val;
        FXFunctionType ftype;
        Context context;

        public FunctionValue(Function val, FXFunctionType ftype, Context context) {
            this.val = val;
            this.ftype = ftype;
            this.context = context;
        }

        public FXValue apply(FXValue ... arg) {
            Object result;
            int nargs = arg.length;
            Object[] rargs = new Object[nargs];
            for (int i = 0; i < nargs; ++i) {
                rargs[i] = ((Value)((Object)arg[i])).asObject();
            }
            switch (nargs) {
                case 0: {
                    result = ((Function0)this.val).invoke();
                    break;
                }
                case 1: {
                    result = ((Function1)this.val).invoke(rargs[0]);
                    break;
                }
                case 2: {
                    result = ((Function2)this.val).invoke(rargs[0], rargs[1]);
                    break;
                }
                case 3: {
                    result = ((Function3)this.val).invoke(rargs[0], rargs[1], rargs[2]);
                    break;
                }
                case 4: {
                    result = ((Function4)this.val).invoke(rargs[0], rargs[1], rargs[2], rargs[3]);
                    break;
                }
                case 5: {
                    result = ((Function5)this.val).invoke(rargs[0], rargs[1], rargs[2], rargs[3], rargs[4]);
                    break;
                }
                case 6: {
                    result = ((Function6)this.val).invoke(rargs[0], rargs[1], rargs[2], rargs[3], rargs[4], rargs[5]);
                    break;
                }
                case 7: {
                    result = ((Function7)this.val).invoke(rargs[0], rargs[1], rargs[2], rargs[3], rargs[4], rargs[5], rargs[6]);
                    break;
                }
                case 8: {
                    result = ((Function8)this.val).invoke(rargs[0], rargs[1], rargs[2], rargs[3], rargs[4], rargs[5], rargs[6], rargs[7]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return this.context.mirrorOf(result, this.ftype.getReturnType());
        }

        public FXFunctionType getType() {
            return this.ftype;
        }

        public boolean isNull() {
            return false;
        }

        public String getValueString() {
            return this.ftype.toString() + "{...}";
        }

        public Function asObject() {
            return this.val;
        }
    }

    static class SequenceValue
    extends FXSequenceValue
    implements Value {
        Sequence seq;
        Context context;

        public SequenceValue(FXValue[] values, int nvalues, FXType elementType, Context context) {
            super(values, nvalues, elementType);
            this.context = context;
        }

        public SequenceValue(Sequence seq, FXSequenceType sequenceType, Context context) {
            super(seq.size(), sequenceType);
            this.seq = seq;
            this.context = context;
        }

        public FXValue getItem(int index) {
            if (index < 0 || index >= this.nvalues) {
                return null;
            }
            if (this.values == null) {
                this.values = new FXValue[this.nvalues];
            }
            if (this.values[index] == null && this.seq != null) {
                this.values[index] = this.context.mirrorOf(this.seq.get(index), this.type.getComponentType());
            }
            return this.values[index];
        }

        public Sequence asObject() {
            if (this.seq == null) {
                FXType elementType = this.type.getComponentType();
                Object[] objs = new Object[this.nvalues];
                for (int i = 0; i < this.nvalues; ++i) {
                    objs[i] = ((Value)((Object)this.values[i])).asObject();
                }
                return Sequences.make(TypeInfo.getTypeInfo(Context.asClass(elementType)), objs);
            }
            return this.seq;
        }
    }

    public static class ObjectValue
    extends FXObjectValue
    implements Value {
        Object obj;
        ClassType type;
        ClassType classType;

        public ObjectValue(Object obj, Context context) {
            this.type = context.makeClassRef(obj.getClass());
            this.obj = obj;
        }

        public ObjectValue(Object obj, ClassType type) {
            this.type = type;
            this.obj = obj;
        }

        public FXClassType getType() {
            return this.type;
        }

        public FXClassType getClassType() {
            if (this.classType == null) {
                if (this.obj == null) {
                    this.classType = this.type;
                } else {
                    Class<?> cls = this.obj.getClass();
                    this.classType = this.type.getJavaImplementationClass() == cls ? this.type : this.type.getReflectionContext().makeClassRef(this.obj.getClass());
                }
            }
            return this.classType;
        }

        public boolean isNull() {
            return this.obj == null;
        }

        public String getValueString() {
            if (this.obj == null) {
                return null;
            }
            return this.obj.toString();
        }

        public ObjectValue initialize() {
            if (this.obj instanceof FXObject) {
                ((FXObject)this.obj).initialize$();
            }
            return this;
        }

        public Object asObject() {
            return this.obj;
        }
    }

    static class MiscValue
    extends FXValue
    implements Value {
        Object val;
        FXType type;

        public MiscValue(Object value, FXType type) {
            this.val = value;
            this.type = type;
        }

        public String getValueString() {
            return this.val == null ? "(null)" : this.val.toString();
        }

        public FXType getType() {
            return this.type;
        }

        public boolean isNull() {
            return this.val == null;
        }

        public Object asObject() {
            return this.val;
        }
    }

    public static interface Value {
        public Object asObject();
    }

    static class FunctionMember
    extends FXFunctionMember {
        Method method;
        FXClassType owner;
        String name;
        FXFunctionType type;

        FunctionMember(Method method, ClassType owner, FXFunctionType type) {
            this.method = method;
            this.owner = owner;
            this.name = method.getName();
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public FXClassType getDeclaringClass() {
            return this.owner;
        }

        public boolean isStatic() {
            return (this.method.getModifiers() & 8) != 0;
        }

        public FXFunctionType getType() {
            return this.type;
        }

        Object unwrap(FXValue value) {
            if (value == null) {
                return null;
            }
            return ((Value)((Object)value)).asObject();
        }

        public FXValue invoke(FXObjectValue obj, FXValue ... arg) {
            int alen = arg.length;
            Object[] rargs = new Object[alen];
            for (int i = 0; i < alen; ++i) {
                rargs[i] = this.unwrap(arg[i]);
            }
            try {
                Object result = this.method.invoke(this.unwrap(obj), rargs);
                Context context = (Context)this.owner.getReflectionContext();
                if (result == null && this.getType().getReturnType() == FXPrimitiveType.voidType) {
                    return null;
                }
                return context.mirrorOf(result, this.getType().getReturnType());
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static class VarMember
    extends FXVarMember {
        Method accessMethod;
        Field fld;
        Method getter;
        Method setter;
        FXType type;
        String name;
        FXClassType owner;
        static final Object[] noObjects = new Object[0];

        public VarMember(String name, ClassType owner, FXType type) {
            this.name = name;
            this.type = type;
            this.owner = owner;
        }

        public FXType getType() {
            return this.type;
        }

        public FXValue getValue(FXObjectValue obj) {
            Object robj = obj == null ? null : ((ObjectValue)obj).obj;
            try {
                if (this.fld != null || this.getter != null) {
                    Context context = (Context)this.owner.getReflectionContext();
                    Object val = this.getter != null ? this.getter.invoke(robj, new Object[0]) : this.fld.get(robj);
                    if (val instanceof ObjectLocation) {
                        val = ((ObjectLocation)val).get();
                    }
                    return context.mirrorOf(val, this.type);
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            throw new UnsupportedOperationException("Not supported yet - " + this.type + "[" + this.type.getClass().getName() + "]");
        }

        public FXLocation getLocation(FXObjectValue obj) {
            return new VarMemberLocation(obj, this);
        }

        protected void initVar(FXObjectValue instance, FXValue value) {
            try {
                Object robj = ((ObjectValue)instance).obj;
                Object loc = this.getter != null ? this.getter.invoke(robj, noObjects) : this.fld.get(robj);
                if (loc instanceof IntVariable) {
                    ((IntVariable)loc).setAsIntFromLiteral(((FXIntegerValue)value).intValue());
                    return;
                }
                if (loc instanceof BooleanVariable) {
                    ((BooleanVariable)loc).setAsBooleanFromLiteral(((FXBooleanValue)value).booleanValue());
                    return;
                }
                if (loc instanceof DoubleVariable) {
                    ((DoubleVariable)loc).setAsDoubleFromLiteral(((FXNumberValue)value).doubleValue());
                    return;
                }
                if (loc instanceof AbstractVariable) {
                    ((AbstractVariable)loc).setFromLiteral(((ObjectValue)value).asObject());
                    return;
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            throw new UnsupportedOperationException("unimplemented: initVar");
        }

        public void setValue(FXObjectValue obj, FXValue newValue) {
            Object robj = obj == null ? null : ((ObjectValue)obj).obj;
            try {
                if (this.fld != null || this.getter != null || this.setter != null) {
                    Object newVal = ((Value)((Object)newValue)).asObject();
                    if (this.setter != null) {
                        this.setter.invoke(robj, newVal);
                    } else {
                        Object val = this.getter != null ? this.getter.invoke(robj, noObjects) : this.fld.get(robj);
                        if (val instanceof ObjectLocation) {
                            ((ObjectLocation)val).set(newVal);
                        } else if (this.fld != null) {
                            this.fld.set(robj, newVal);
                        }
                    }
                    return;
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void initValue(FXObjectValue obj, FXValue ref) {
            this.setValue(obj, ref);
        }

        public String getName() {
            return this.name;
        }

        public FXClassType getDeclaringClass() {
            return this.owner;
        }

        public boolean isStatic() {
            int mods = this.getter != null ? this.getter.getModifiers() : this.fld.getModifiers();
            return (mods & 8) != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SortedClassArray
    extends AbstractList<FXClassType> {
        ClassType[] buffer = new ClassType[4];
        int sz;

        SortedClassArray() {
        }

        @Override
        public FXClassType get(int index) {
            if (index >= this.sz) {
                throw new IndexOutOfBoundsException();
            }
            return this.buffer[index];
        }

        @Override
        public int size() {
            return this.sz;
        }

        boolean insert(ClassType cl) {
            ClassType c;
            int cmp;
            int i;
            String clname = cl.getName();
            for (i = 0; i < this.sz && (cmp = (c = this.buffer[i]).getName().compareTo(clname)) <= 0; ++i) {
                if (cmp != 0) continue;
                if (c.refClass != cl.refClass) break;
                return false;
            }
            if (this.sz == this.buffer.length) {
                ClassType[] tmp = new ClassType[2 * this.sz];
                System.arraycopy(this.buffer, 0, tmp, 0, this.sz);
                this.buffer = tmp;
            }
            System.arraycopy(this.buffer, i, this.buffer, i + 1, this.sz - i);
            this.buffer[i] = cl;
            ++this.sz;
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassType
    extends FXClassType {
        Class refClass;
        Class refInterface;

        public ClassType(Context context, int modifiers, Class refClass, Class refInterface) {
            super(context, modifiers);
            this.refClass = refClass;
            this.refInterface = refInterface;
            this.name = refClass.getCanonicalName();
        }

        public Class getJavaImplementationClass() {
            return this.refClass;
        }

        public Class getJavaInterfaceClass() {
            return this.refInterface;
        }

        @Override
        public Context getReflectionContext() {
            return (Context)super.getReflectionContext();
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ClassType && this.refClass == ((ClassType)obj).refClass;
        }

        void getSuperClasses(boolean all, SortedClassArray result) {
            ClassType cl;
            Class s;
            boolean isCompound = this.isCompoundClass();
            Class cls = isCompound ? this.refInterface : this.refClass;
            Class<?>[] interfaces = cls.getInterfaces();
            Context context = this.getReflectionContext();
            if (!isCompound && (s = cls.getSuperclass()) != null && result.insert(cl = context.makeClassRef(s)) && all) {
                cl.getSuperClasses(all, result);
            }
            for (int i = 0; i < interfaces.length; ++i) {
                ClassType cl2;
                Class<?> iface = interfaces[i];
                if (iface.getName().equals("com.sun.javafx.runtime.FXObject") || !result.insert(cl2 = context.makeClassRef(iface)) || !all) continue;
                cl2.getSuperClasses(all, result);
            }
        }

        @Override
        public List<FXClassType> getSuperClasses(boolean all) {
            SortedClassArray result = new SortedClassArray();
            if (all) {
                result.insert(this);
            }
            this.getSuperClasses(all, result);
            return result;
        }

        @Override
        public FXFunctionMember getFunction(String name, FXType ... argType) {
            int nargs = argType.length;
            Class[] ctypes = new Class[nargs];
            for (int i = 0; i < nargs; ++i) {
                ctypes[i] = Context.asClass(argType[i]);
            }
            try {
                Method meth = (this.isCompoundClass() ? this.refInterface : this.refClass).getMethod(name, ctypes);
                return this.asFunctionMember(meth, this.getReflectionContext());
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private Method[] filter(Method[] methods, Class declaringClass) {
            ArrayList<Method> result = new ArrayList<Method>();
            for (Method m : methods) {
                if (m.getDeclaringClass() != declaringClass) continue;
                result.add(m);
            }
            return result.toArray(new Method[0]);
        }

        @Override
        protected void getFunctions(FXMemberFilter filter, FXClassType.SortedMemberArray<? super FXFunctionMember> result) {
            Method[] methods;
            boolean isCompound = this.isCompoundClass();
            Class cls = this.refClass;
            Context context = this.getReflectionContext();
            try {
                methods = cls.getDeclaredMethods();
            }
            catch (SecurityException e) {
                methods = this.filter(cls.getMethods(), cls);
            }
            for (int i = 0; i < methods.length; ++i) {
                String mname;
                Method m = methods[i];
                if (m.isSynthetic() || m.getAnnotation(Inherited.class) != null || "userInit$".equals(mname = m.getName()) || "postInit$".equals(mname) || "addTriggers$".equals(mname) || "initialize$".equals(mname) || "javafx$run$".equals(mname) || mname.endsWith("$impl") || mname.startsWith("get$") || mname.startsWith("set$") || mname.startsWith("applyDefaults$")) continue;
                if (this.isCompoundClass()) {
                    try {
                        m = this.refInterface.getDeclaredMethod(m.getName(), m.getParameterTypes());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                FXFunctionMember mref = this.asFunctionMember(m, context);
                if (filter == null || !filter.accept(mref)) continue;
                result.insert(mref);
            }
        }

        FXFunctionMember asFunctionMember(Method m, Context context) {
            Type[] ptypes = m.getGenericParameterTypes();
            if (m.isVarArgs()) {
                // empty if block
            }
            FXType[] prtypes = new FXType[ptypes.length];
            for (int j = 0; j < ptypes.length; ++j) {
                prtypes[j] = context.makeTypeRef(ptypes[j]);
            }
            Type gret = m.getGenericReturnType();
            FXFunctionType type = new FXFunctionType(prtypes, context.makeTypeRef(gret));
            return new FunctionMember(m, this, type);
        }

        private Field[] filter(Field[] fields, Class declaringClass) {
            ArrayList<Field> result = new ArrayList<Field>();
            for (Field f : fields) {
                if (f.getDeclaringClass() != declaringClass) continue;
                result.add(f);
            }
            return result.toArray(new Field[0]);
        }

        @Override
        protected void getVariables(FXMemberFilter filter, FXClassType.SortedMemberArray<? super FXVarMember> result) {
            Field[] fields;
            Context context = this.getReflectionContext();
            Class cls = this.refClass;
            Class[] noClasses = new Class[]{};
            String requiredName = filter.getRequiredName();
            try {
                fields = cls.getDeclaredFields();
            }
            catch (SecurityException e) {
                fields = this.filter(cls.getFields(), cls);
            }
            for (int i = 0; i < fields.length; ++i) {
                Field fld = fields[i];
                if (fld.isSynthetic() || fld.getAnnotation(Inherited.class) != null) continue;
                String name = fld.getName();
                SourceName sourceName = fld.getAnnotation(SourceName.class);
                if (sourceName != null) {
                    name = sourceName.value();
                }
                if (requiredName != null && !requiredName.equals(name) || name.endsWith("$needs_default$")) continue;
                Type gtype = fld.getGenericType();
                FXType tr = context.makeTypeRef(gtype);
                VarMember ref = new VarMember(name, this, tr);
                ref.fld = fld;
                if (this.isCompoundClass()) {
                    String getterName = "get$" + name;
                    Method getter = null;
                    try {
                        getter = this.refInterface.getMethod(getterName, noClasses);
                        ref.fld = null;
                        ref.getter = getter;
                    }
                    catch (NoSuchMethodException ex) {
                        try {
                            getterName = "get" + fld.getName();
                            getter = this.refInterface.getMethod(getterName, noClasses);
                            ref.fld = null;
                            ref.getter = getter;
                        }
                        catch (NoSuchMethodException ex2) {
                            // empty catch block
                        }
                    }
                    if (getter != null) {
                        Class<?> type = getter.getReturnType();
                        String setName = "set$" + name;
                        try {
                            Method setter = this.refInterface.getMethod(setName, type);
                            ref.fld = null;
                            ref.setter = setter;
                        }
                        catch (NoSuchMethodException ex) {
                            try {
                                setName = "set" + fld.getName();
                                Method setter = this.refInterface.getMethod(setName, type);
                                ref.fld = null;
                                ref.setter = setter;
                            }
                            catch (NoSuchMethodException ex2) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (filter == null || !filter.accept(ref)) continue;
                result.insert(ref);
            }
        }

        @Override
        public FXObjectValue allocate() {
            Class cls = this.refClass;
            Context context = this.getReflectionContext();
            try {
                Object instance;
                if (this.isJfxType()) {
                    Constructor cons = cls.getDeclaredConstructor(Boolean.TYPE);
                    instance = cons.newInstance(Boolean.TRUE);
                } else {
                    instance = cls.newInstance();
                }
                return new ObjectValue(instance, this);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public FXClassType getDeclaringClass() {
            return null;
        }

        @Override
        public boolean isStatic() {
            return true;
        }
    }

    public static class JavaArrayType
    extends FXJavaArrayType {
        Class cls;

        JavaArrayType(FXType componentType, Class cls) {
            super(componentType);
            this.cls = cls;
        }

        public Class getJavaClass() {
            return this.cls;
        }
    }

    public static class Context
    extends FXContext {
        static Context instance = new Context();

        private Context() {
        }

        public static Context getInstance() {
            return instance;
        }

        public FXObjectValue mirrorOf(Object obj) {
            return new ObjectValue(obj, this);
        }

        public FXValue mirrorOf(Object val, FXType type) {
            if (type instanceof ClassType) {
                return new ObjectValue(val, (ClassType)type);
            }
            if (type instanceof FXPrimitiveType) {
                if (type == FXPrimitiveType.integerType) {
                    return this.mirrorOf((Integer)val);
                }
                if (type == FXPrimitiveType.booleanType) {
                    return this.mirrorOf((Boolean)val);
                }
                return this.mirrorOf((Double)val);
            }
            if (type instanceof FXSequenceType && val instanceof Sequence) {
                Sequence seq = (Sequence)val;
                return new SequenceValue(seq, (FXSequenceType)type, this);
            }
            if (type instanceof FXFunctionType && val instanceof Function) {
                FXFunctionType ftype = (FXFunctionType)type;
                return new FunctionValue((Function)val, ftype, this);
            }
            return new MiscValue(val, type);
        }

        public ObjectValue mirrorOf(String val) {
            return new ObjectValue((Object)val, this);
        }

        public FXClassType findClass(String cname) {
            ClassLoader loader;
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException ex) {
                loader = this.getClass().getClassLoader();
            }
            return this.findClass(cname, loader);
        }

        public FXClassType findClass(String cname, ClassLoader loader) {
            String n = cname;
            Exception ex0 = null;
            while (true) {
                try {
                    Class<?> cl = Class.forName(n, false, loader);
                    return this.makeClassRef(cl);
                }
                catch (Exception ex) {
                    int dot;
                    if (ex0 == null) {
                        ex0 = ex;
                    }
                    if ((dot = n.lastIndexOf(46)) >= 0) {
                        n = n.substring(0, dot) + '$' + n.substring(dot + 1);
                        continue;
                    }
                    throw new RuntimeException(ex0);
                }
                break;
            }
        }

        public FXType makeTypeRef(Type typ) {
            Class clas;
            String rawName;
            if (typ instanceof ParameterizedType) {
                ParameterizedType ptyp = (ParameterizedType)typ;
                Type raw = ptyp.getRawType();
                Type[] targs = ptyp.getActualTypeArguments();
                if (raw instanceof Class) {
                    rawName = ((Class)raw).getName();
                    if ("com.sun.javafx.runtime.sequence.Sequence".equals(rawName) && targs.length == 1) {
                        return new FXSequenceType(this.makeTypeRef(targs[0]));
                    }
                    if ("com.sun.javafx.runtime.location.ObjectVariable".equals(rawName) && targs.length == 1) {
                        return this.makeTypeRef(targs[0]);
                    }
                    if ("com.sun.javafx.runtime.location.SequenceVariable".equals(rawName) && targs.length == 1) {
                        return new FXSequenceType(this.makeTypeRef(targs[0]));
                    }
                    if (rawName.startsWith("com.sun.javafx.functions.Function")) {
                        FXType[] prtypes = new FXType[targs.length - 1];
                        int i = prtypes.length;
                        while (--i >= 0) {
                            prtypes[i] = this.makeTypeRef(targs[i + 1]);
                        }
                        return new FXFunctionType(prtypes, this.makeTypeRef(targs[0]));
                    }
                }
                typ = raw;
            }
            if (typ instanceof WildcardType) {
                WildcardType wtyp = (WildcardType)typ;
                Type[] upper = wtyp.getUpperBounds();
                Type[] lower = wtyp.getLowerBounds();
                typ = lower.length > 0 ? lower[0] : wtyp.getUpperBounds()[0];
                rawName = ((Class)typ).getName();
                if (rawName.equals("java.lang.Boolean")) {
                    return this.getBooleanType();
                }
                if (rawName.equals("java.lang.Integer")) {
                    return this.getIntegerType();
                }
                if (rawName.equals("java.lang.Double")) {
                    return this.getNumberType();
                }
                return this.makeTypeRef((Type)typ);
            }
            if (typ instanceof GenericArrayType) {
                FXType elType = this.makeTypeRef(((GenericArrayType)typ).getGenericComponentType());
                return new FXJavaArrayType(elType);
            }
            if (typ instanceof TypeVariable) {
                typ = Object.class;
            }
            if ((clas = (Class)typ).isArray()) {
                FXType elType = this.makeTypeRef(clas.getComponentType());
                return new FXJavaArrayType(elType);
            }
            String rawName2 = ((Class)typ).getName();
            if ("com.sun.javafx.runtime.location.DoubleVariable".equals(rawName2) || typ == Double.TYPE) {
                return this.getNumberType();
            }
            if ("com.sun.javafx.runtime.location.IntVariable".equals(rawName2) || typ == Integer.TYPE) {
                return this.getIntegerType();
            }
            if (typ == Byte.TYPE) {
                return FXPrimitiveType.byteType;
            }
            if (typ == Short.TYPE) {
                return FXPrimitiveType.shortType;
            }
            if (typ == Long.TYPE) {
                return FXPrimitiveType.longType;
            }
            if (typ == Float.TYPE) {
                return FXPrimitiveType.floatType;
            }
            if (typ == Character.TYPE) {
                return FXPrimitiveType.charType;
            }
            if ("com.sun.javafx.runtime.location.BooleanVariable".equals(rawName2) || typ == Boolean.TYPE) {
                return FXPrimitiveType.booleanType;
            }
            if (typ == Void.TYPE) {
                return FXPrimitiveType.voidType;
            }
            return this.makeClassRef((Class)typ);
        }

        public ClassType makeClassRef(Class cls) {
            int modifiers = 0;
            try {
                String cname = cls.getName();
                Class<?> clsInterface = null;
                if (cname.endsWith("$Intf")) {
                    clsInterface = cls;
                    cname = cname.substring(0, cname.length() - "$Intf".length());
                    cls = Class.forName(cname, false, cls.getClassLoader());
                    modifiers = 3;
                    return new ClassType(this, modifiers, cls, clsInterface);
                }
                Class<?>[] interfaces = cls.getInterfaces();
                String intfName = cname + "$Intf";
                for (int i = 0; i < interfaces.length; ++i) {
                    String iname = interfaces[i].getName();
                    if (iname.equals("com.sun.javafx.runtime.FXObject")) {
                        modifiers |= 2;
                        continue;
                    }
                    if (!iname.equals(intfName)) continue;
                    clsInterface = interfaces[i];
                    modifiers |= 1;
                }
                return new ClassType(this, modifiers, cls, clsInterface);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public static Class asClass(FXType type) {
            if (type instanceof FXPrimitiveType) {
                return ((FXPrimitiveType)type).clas;
            }
            if (type instanceof JavaArrayType) {
                return ((JavaArrayType)type).getJavaClass();
            }
            ClassType ctyp = (ClassType)type;
            return ctyp.isCompoundClass() ? ctyp.refInterface : ctyp.refClass;
        }

        public FXValue makeSequenceValue(FXValue[] values, int nvalues, FXType elementType) {
            return new SequenceValue(values, nvalues, elementType, this);
        }
    }
}

