/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import javafx.reflect.FXContext;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;

public class FXSequenceBuilder {
    FXValue[] values = new FXValue[16];
    int nvalues;
    FXValue sequence;
    FXType elementType;
    FXContext context;

    protected FXSequenceBuilder(FXContext context, FXType elementType) {
        this.elementType = elementType;
        this.context = context;
    }

    public void append(FXValue value) {
        if (this.sequence != null) {
            throw new IllegalStateException("appending to SequenceBuilder after getSequence");
        }
        int nitems = value.getItemCount();
        if (this.nvalues + nitems > this.values.length) {
            int newSize;
            for (newSize = this.values.length; this.nvalues + nitems > newSize; newSize = 2 * newSize) {
            }
            FXValue[] newValues = new FXValue[newSize];
            System.arraycopy(this.values, 0, newValues, 0, this.nvalues);
            this.values = newValues;
        }
        for (int i = 0; i < nitems; ++i) {
            FXValue item = value.getItem(i);
            if ((item = this.elementType.coerceOrNull(item)) == null) {
                throw new ClassCastException("cannot coerce to " + this.elementType);
            }
            this.values[this.nvalues++] = item;
        }
    }

    public FXValue getSequence() {
        if (this.sequence == null) {
            this.sequence = this.context.makeSequenceValue(this.values, this.nvalues, this.elementType);
            this.values = null;
        }
        return this.sequence;
    }
}

