/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eclipse.editor.simple;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.IColorManagerExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

class TokenConvertor {
    private final IColorManager cm;
    private final IPreferenceStore fPreferenceStore;
    private Map<String, IToken> fTokenMap = new HashMap<String, IToken>();
    private static final TextAttribute DEFAULT_TEXT_ATTRIBUTE = null;
    private static final String WHITESPACE_TOKEN = "java_whitespace";
    private static final String JAVA_NUMBER_PREFIX = "semanticHighlighting.number";
    private static final String JAVA_NUMBER = "semanticHighlighting.number.color";
    private static final String[] tokenTypes = new String[]{"java_keyword", "java_string", "java_default", "java_keyword_return", "java_operator", "java_bracket"};

    TokenConvertor(IColorManager cm, IPreferenceStore fPreferenceStore) {
        this.cm = cm;
        this.fPreferenceStore = fPreferenceStore;
        this.initialize();
    }

    public final void initialize() {
        String[] fPropertyNamesColor = this.getTokenProperties();
        int length = fPropertyNamesColor.length;
        int i = 0;
        while (i < length) {
            String colorKey = fPropertyNamesColor[i];
            this.addToken(colorKey, this.getBoldKey(colorKey), this.getItalicKey(colorKey), this.getStrikethroughKey(colorKey), this.getUnderlineKey(colorKey), false);
            ++i;
        }
        this.addToken(WHITESPACE_TOKEN, this.getBoldKey(WHITESPACE_TOKEN), this.getItalicKey(WHITESPACE_TOKEN), this.getStrikethroughKey(WHITESPACE_TOKEN), this.getUnderlineKey(WHITESPACE_TOKEN), true);
        this.addToken(JAVA_NUMBER, "semanticHighlighting.number.bold", "semanticHighlighting.number.italic", "semanticHighlighting.number.strikethrough", "semanticHighlighting.number.underline", true);
    }

    protected String getBoldKey(String colorKey) {
        return String.valueOf(colorKey) + "_bold";
    }

    protected String getItalicKey(String colorKey) {
        return String.valueOf(colorKey) + "_italic";
    }

    protected String getStrikethroughKey(String colorKey) {
        return String.valueOf(colorKey) + "_strikethrough";
    }

    protected String getUnderlineKey(String colorKey) {
        return String.valueOf(colorKey) + "_underline";
    }

    IToken convert(org.antlr.runtime.Token t) {
        if (t == org.antlr.runtime.Token.EOF_TOKEN) {
            return Token.EOF;
        }
        return this.getToken(t);
    }

    private IToken getToken(org.antlr.runtime.Token t) {
        switch (t.getType()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 136: {
                return this.getTokenImpl("java_keyword");
            }
            case 111: 
            case 113: 
            case 115: 
            case 116: 
            case 118: {
                return this.getTokenImpl("java_string");
            }
            case 121: 
            case 122: 
            case 125: 
            case 127: {
                return this.getTokenImpl(JAVA_NUMBER);
            }
            case 132: 
            case 133: {
                return this.getTokenImpl("java_multi_line_comment");
            }
            case 134: {
                return this.getTokenImpl("java_single_line_comment");
            }
            case 131: {
                return this.getTokenImpl(WHITESPACE_TOKEN);
            }
        }
        return this.getTokenImpl("java_default");
    }

    private IToken getTokenImpl(String keyword) {
        if (this.fTokenMap.containsKey(keyword)) {
            return this.fTokenMap.get(keyword);
        }
        return new MyToken(false, DEFAULT_TEXT_ATTRIBUTE);
    }

    private void addToken(String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey, boolean whitespace) {
        if (this.cm != null && colorKey != null && this.cm.getColor(colorKey) == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            if (this.cm instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)this.cm;
                ext.unbindColor(colorKey);
                ext.bindColor(colorKey, rgb);
            }
        }
        this.fTokenMap.put(colorKey, new MyToken(whitespace, this.createTextAttribute(colorKey, boldKey, italicKey, strikethroughKey, underlineKey)));
    }

    private TextAttribute createTextAttribute(String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        int style;
        Color color = null;
        if (colorKey != null) {
            color = this.cm.getColor(colorKey);
        }
        int n = style = this.fPreferenceStore.getBoolean(boldKey) ? 1 : 0;
        if (this.fPreferenceStore.getBoolean(italicKey)) {
            style |= 2;
        }
        if (this.fPreferenceStore.getBoolean(strikethroughKey)) {
            style |= 0x20000000;
        }
        if (this.fPreferenceStore.getBoolean(underlineKey)) {
            style |= 0x40000000;
        }
        return new TextAttribute(color, null, style);
    }

    public String[] getTokenProperties() {
        return tokenTypes;
    }

    private static class MyToken
    implements IToken {
        private final TextAttribute data;
        private final boolean whitespace;

        private MyToken(boolean whitespace, TextAttribute data) {
            this.whitespace = whitespace;
            this.data = data;
        }

        public boolean isUndefined() {
            return false;
        }

        public boolean isWhitespace() {
            return this.whitespace;
        }

        public boolean isEOF() {
            return false;
        }

        public boolean isOther() {
            return !this.isUndefined() && !this.isWhitespace() && !this.isEOF();
        }

        public Object getData() {
            return this.data;
        }
    }
}

