/*
 * Main.fx
 */

package rssdemo;

import java.lang.Exception;

import javafx.data.feed.rss.Channel;
import javafx.data.feed.rss.Item;
import javafx.data.feed.rss.RssTask;

import javafx.data.pull.Event;

def MAX_POLLS = 3;

var counter = 0;

def task:RssTask = RssTask
{
    interval: 15s

    // The following location demonstrates a basic RSS newsfeed.

    location: "http://javajeff.mb.ca/rss/javajeff.xml"

    // The following location demonstrates onException().

    // location: "http://developers.sun.com/rss/sdn_features.xml"

    // The following location demonstrates onForeignEvent().

    // location: "http://feeds.dzone.com/javalobby/frontpage?format=xml"

    // The following location demonstrates IllegalArgumentException (must use
    // AtomTask for Atom feeds).

    // location: "http://feeds.sophos.com/en/atom1_0-sophos-company-news.xml"
  
    onStart: function (): Void
    {
        println ("Task is starting");

        if (++counter > MAX_POLLS)
        {
            task.stop ();
            FX.exit ()
        }
    }

    onChannel: function (c: Channel): Void
    {
        println ("Channel: {c}")
    }

    onItem: function (i: Item): Void
    {
        println ("Item: {i}")
    }

    onException: function (e: Exception): Void
    {
        println ("Exception: {e}");
        task.stop ();
        FX.exit ()
    }

    onForeignEvent: function (e: Event): Void
    {
        println ("Event: {e}")
    }

    onDone: function (): Void
    {
        println ("Completed poll #{counter}")
    }
}
task.start ()
