/*
 * Main.fx
 */

package atomdemo;

import java.lang.Exception;

import javafx.data.feed.atom.AtomTask;
import javafx.data.feed.atom.Entry;
import javafx.data.feed.atom.Feed;

import javafx.data.pull.Event;

def MAX_POLLS = 3;

var counter = 0;

def task:AtomTask = AtomTask
{
    interval: 15s

    // The following location demonstrates a basic Atom newsfeed.

    location: "http://photos.dailycamera.com/hack/feed.mg?Type=gallery&Data=9573834_9ysrR&format=atom10"
    
    // The following location demonstrates onForeignEvent().

    // location: "http://blogsearch.google.com/blogsearch/feeds?bc_lang=en&hl=en&output=atom"

    // The following location demonstrates IllegalArgumentException (must use
    // RssTask for RSS feeds).

    // location: "http://javajeff.mb.ca/rss/javajeff.xml"

    onStart: function (): Void
    {
        println ("Task is starting");

        if (++counter > MAX_POLLS)
        {
            task.stop ();
            FX.exit ()
        }
    }

    onFeed: function (f: Feed): Void
    {
        println ("Feed: {f}")
    }

    onEntry: function (e: Entry): Void
    {
        println ("Entry: {e}")
    }

    onException: function (e: Exception): Void
    {
        println ("Exception: {e}");
        task.stop ();
        FX.exit ()
    }

    onForeignEvent: function (e: Event): Void
    {
        println ("Event: {e}")
    }

    onDone: function (): Void
    {
        println ("Completed poll #{counter}")
    }
}
task.start ()