/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.Catalog;
import com.sun.pkg.client.Constraint;
import com.sun.pkg.client.DependAction;
import com.sun.pkg.client.DirAction;
import com.sun.pkg.client.FileList;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.GroupAction;
import com.sun.pkg.client.ImagePlanProgressTracker;
import com.sun.pkg.client.Manifest;
import com.sun.pkg.client.PkgProxySelector;
import com.sun.pkg.client.SystemInfo;
import com.sun.pkg.client.UserAction;
import com.sun.pkg.client.Version;
import com.sun.pkg.util.PEMUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image {
    public static final int IMG_ENTIRE = 0;
    public static final int IMG_PARTIAL = 1;
    public static final int IMG_USER = 2;
    static final String img_user_prefix = ".org.opensolaris,pkg";
    static final String img_root_prefix = "var/pkg";
    static final String os = System.getProperty("os.name").toLowerCase();
    static final String os_version = Image.getOSVersion();
    static final String arch = System.getProperty("os.arch").toLowerCase();
    private static final String PKG_DIR = "pkg";
    private static final String INSTALLED_FILE = "installed";
    private static final String ISTATE_DIR = "state" + File.separator + "installed";
    private static final String ISTATE_DIR_TMP = "state" + File.separator + "installed.build";
    static final String typeStr = "USER";
    private static String version = null;
    private static String defaultClientName = "pkg-java";
    static Logger log = Logger.getLogger("com.sun.pkg.client", "com/sun/pkg/client/messages");
    int type = 2;
    String clientname = defaultClientName;
    Map<String, Authority> authorities = new HashMap<String, Authority>();
    List<String> lines = new ArrayList<String>();
    private Map<String, String> properties = new HashMap<String, String>();
    String preferred_authority_name = null;
    File cfgfile;
    File imgdir;
    File metadir;
    Map<Authority, Catalog> catalogs = new HashMap<Authority, Catalog>();
    CatalogCache catalogCache = null;
    ProxySelector proxySel = SystemInfo.getProxySelector();
    Constraint.Set constraints = new Constraint.Set();
    String currentOperation = "unknown";
    Stack<Fmri> targetFmris = new Stack();
    Stack<String> targetReasons = new Stack();
    Map<Fmri, List<Fmri>> reqDependents = null;
    static final int wopkg = "pkg:/".length();

    public Image(String path) throws Exception {
        this(new File(path));
    }

    public Image(File path) throws Exception {
        this.imgdir = path;
        if (!this.imgdir.isDirectory()) {
            throw new Exception("image directory (" + path + ") doesn't exist");
        }
        this.metadir = new File(this.imgdir, img_user_prefix);
        if (!this.metadir.isDirectory()) {
            throw new Exception("invalid USER image directory");
        }
        this.loadConfig(new File(this.metadir, "cfg_cache"));
        for (Authority a : this.authorities.values()) {
            log.log(Level.CONFIG, "softwarerepo", a.origin);
            Catalog c = new Catalog(this, a.prefix);
            this.catalogs.put(a, c);
        }
        this.rebuildCatalogCache();
        this.saveConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image create(File path, String authName, URL origin) throws Exception {
        String[] required_dirs;
        path.mkdirs();
        if (!path.isDirectory()) {
            throw new Exception("unable to create image directory (" + path + ")");
        }
        File metadir = new File(path, img_user_prefix);
        for (String d : required_dirs = new String[]{"catalog", "file", PKG_DIR}) {
            new File(metadir, d).mkdirs();
        }
        FileWriter w = new FileWriter(new File(metadir, "cfg_cache"));
        try {
            w.write("[property]\npreferred-authority = " + authName + "\n" + "send-uuid = True\n" + "require-optional = False\n" + "flush-content-cache-on-success = False\n" + "display-copyrights = True\n" + "pursue-latest = True\n" + "\n" + "[filter]\n" + "\n");
        }
        finally {
            w.close();
        }
        Image img = new Image(path);
        img.startOperation("image-create");
        img.setAuthority(authName, origin, null);
        img.saveConfig();
        img.refreshCatalogs();
        return img;
    }

    private void rebuildCatalogCache() throws IOException {
        this.catalogCache = new CatalogCache();
        for (Map.Entry<Authority, Catalog> e : this.catalogs.entrySet()) {
            this.catalogCache.addCatalog(e.getValue(), e.getKey());
        }
        this.catalogCache.cacheInstalledPackages();
    }

    public File getRootDirectory() {
        return this.imgdir;
    }

    File getMetaDirectory() {
        return this.metadir;
    }

    Logger getLogger() {
        return log;
    }

    String getUserAgent() {
        return "pkg-java/" + Image.getVersion() + " (" + os + " " + arch + "; " + os_version + " " + System.getProperty("java.version") + "; " + typeStr + "; " + this.clientname + ")";
    }

    HttpURLConnection getRepositoryURLConnection(String resource, String authname) throws IOException {
        Authority a = this.authorities.get(authname);
        if (a == null) {
            throw new IllegalArgumentException("invalid authority name: " + authname);
        }
        String o = a.origin;
        if (o == null) {
            throw new IOException("undefined origin URL for publisher " + authname);
        }
        if (!o.endsWith("/")) {
            o = o + "/";
        }
        URL repo = new URL(o);
        URL u = new URL(repo, resource);
        try {
            URLConnection urlc;
            List<Proxy> pl = this.proxySel.select(u.toURI());
            Proxy p = pl.size() > 0 ? pl.get(0) : null;
            URLConnection uRLConnection = urlc = p == null ? u.openConnection() : u.openConnection(pl.get(0));
            if (!(urlc instanceof HttpURLConnection)) {
                throw new IOException("unrecognized repository URL type:" + a.origin);
            }
            if (urlc instanceof HttpsURLConnection && a.certFile != null && a.keyFile != null) {
                if (a.sslfactory == null) {
                    a.sslfactory = PEMUtil.getSSLSocketFactory(a.certFile, a.keyFile);
                }
                HttpsURLConnection sslurlc = (HttpsURLConnection)urlc;
                sslurlc.setSSLSocketFactory(a.sslfactory);
            }
            HttpURLConnection hurlc = (HttpURLConnection)urlc;
            hurlc.setRequestProperty("User-Agent", this.getUserAgent());
            hurlc.setRequestProperty("X-IPkg-UUID", a.uuid);
            return hurlc;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Image.class.getName()).log(Level.SEVERE, null, ex);
            IOException ioe = new IOException("invalid repository URL: " + u);
            ioe.initCause(ioe);
            throw ioe;
        }
    }

    HttpURLConnection getRepositoryURLConnection(String resource, Fmri f) throws IOException {
        String authname = f.getAuthority();
        if (authname.length() == 0) {
            throw new IOException("attempt to access a resource for an Fmri that has no authority: " + f);
        }
        return this.getRepositoryURLConnection(resource, authname);
    }

    void checkRepositoryConnection(HttpURLConnection urlc) throws IOException {
        int rc = urlc.getResponseCode();
        switch (rc) {
            case 200: {
                return;
            }
            case 504: {
                throw new IOException("" + rc + ": Connection through proxy timed out");
            }
        }
        throw new IOException("Connection failed for URL " + urlc.getURL() + ": " + rc + ": " + urlc.getResponseMessage());
    }

    public void hideMetaDirectory() throws IOException {
        if (os.indexOf("windows") == -1) {
            return;
        }
        String[] cmd = new String[]{"ATTRIB", "+H", this.getMetaDirectory().getCanonicalPath()};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new Error("ATTRIB failed: cannot hide meta data folder");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setProxy(Proxy p) {
        this.proxySel = new PkgProxySelector(p);
    }

    public void setClientName(String clientname) {
        this.clientname = clientname;
    }

    public static void setDefaultClientName(String clientname) {
        defaultClientName = clientname;
    }

    void loadConfig(File configFile) throws FileNotFoundException, IOException {
        String line;
        this.cfgfile = configFile;
        BufferedReader r = new BufferedReader(new FileReader(this.cfgfile));
        Authority curAuth = null;
        boolean inPolicy = false;
        boolean inProps = false;
        while ((line = r.readLine()) != null) {
            String fn;
            String[] tokens;
            this.lines.add(line);
            if (curAuth != null && line.startsWith("[")) {
                this.ensureUuidPresent(curAuth);
                this.authorities.put(curAuth.prefix, curAuth);
                curAuth = null;
            }
            if (inPolicy && line.startsWith("[")) {
                inPolicy = false;
            }
            if (inProps && line.startsWith("[")) {
                inProps = false;
            }
            if (line.startsWith("[authority") && line.endsWith("]")) {
                tokens = (line = line.substring(1, line.length() - 1)).split("_");
                if (tokens.length != 2) continue;
                curAuth = new Authority(tokens[1]);
                continue;
            }
            if (curAuth != null && line.startsWith("uuid")) {
                tokens = line.split("\\s*=\\s*", 2);
                if (tokens.length != 2) continue;
                curAuth.uuid = tokens[1].trim();
                continue;
            }
            if (curAuth != null && line.startsWith("origin-for-")) {
                String plat;
                tokens = line.split("\\s*=\\s*", 2);
                if (tokens.length != 2 || !this.isThisPlatform(plat = tokens[0].trim().substring(11))) continue;
                curAuth.origin = tokens[1].trim();
                continue;
            }
            if (curAuth != null && line.startsWith("origin")) {
                tokens = line.split("\\s*=\\s*", 2);
                if (curAuth.origin != null || tokens.length != 2) continue;
                curAuth.origin = tokens[1].trim();
                continue;
            }
            if (curAuth != null && line.startsWith("prefix")) {
                tokens = line.split("\\s*=\\s*", 2);
                if (tokens.length != 2) continue;
                curAuth.prefix = tokens[1].trim();
                continue;
            }
            if (curAuth != null && line.startsWith("ssl_key")) {
                tokens = line.split("\\s*=\\s*", 2);
                if (tokens.length != 2 || (fn = tokens[1].trim()).length() <= 0 || fn.equals("None")) continue;
                curAuth.keyFile = new File(fn);
                continue;
            }
            if (curAuth != null && line.startsWith("ssl_cert")) {
                tokens = line.split("\\s*=\\s*", 2);
                if (tokens.length != 2 || (fn = tokens[1].trim()).length() <= 0 || fn.equals("None")) continue;
                curAuth.certFile = new File(fn);
                continue;
            }
            if (line.startsWith("[policy]")) {
                inPolicy = true;
                continue;
            }
            if (line.startsWith("[property]")) {
                inProps = true;
                continue;
            }
            if (!inProps && !inPolicy || (tokens = line.split("\\s*=\\s*", 2)).length != 2) continue;
            this.setProperty(tokens[0].trim(), tokens[1]);
        }
        if (curAuth != null) {
            this.ensureUuidPresent(curAuth);
            this.authorities.put(curAuth.prefix, curAuth);
        }
        r.close();
    }

    private void ensureUuidPresent(Authority a) {
        if (a.uuid == null || a.uuid.equals("None")) {
            a.uuid = UUID.randomUUID().toString();
        }
    }

    public void saveConfig() throws IOException {
        PrintWriter w = new PrintWriter(new BufferedWriter(new FileWriter(this.cfgfile)));
        Authority curAuth = null;
        boolean inProps = false;
        boolean wroteUuid = false;
        HashSet<Authority> written = new HashSet<Authority>();
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            if (curAuth != null && line.startsWith("[")) {
                if (!wroteUuid && curAuth.uuid != null) {
                    w.println("uuid = " + curAuth.uuid);
                    w.println("");
                }
                curAuth = null;
                wroteUuid = false;
            }
            if (inProps && line.startsWith("[")) {
                inProps = false;
            }
            if (line.startsWith("[authority") && line.endsWith("]")) {
                String line1 = line.substring(1, line.length() - 1);
                String[] tokens = line1.split("_");
                if (tokens.length == 2 && (curAuth = this.authorities.get(tokens[1])) != null) {
                    written.add(curAuth);
                }
            } else if (curAuth != null && line.startsWith("uuid")) {
                line = "uuid = " + curAuth.uuid;
                wroteUuid = true;
            } else if (curAuth == null || !line.startsWith("origin-for-")) {
                if (curAuth != null && line.startsWith("origin")) {
                    line = "origin = " + curAuth.origin;
                } else if (line.startsWith("[property]")) {
                    inProps = true;
                }
            }
            if (inProps) continue;
            w.println(line);
        }
        if (curAuth != null && !wroteUuid && curAuth.uuid != null) {
            w.println("uuid = " + curAuth.uuid);
            w.println("");
        }
        for (Authority a : this.authorities.values()) {
            if (written.contains(a) || a.origin == null) continue;
            w.println("[authority_" + a.prefix + ']');
            w.println("origin = " + a.origin);
            w.println("prefix = " + a.prefix);
            if (a.uuid != null) {
                w.println("uuid = " + a.uuid);
            }
            w.println("mirrors = []");
        }
        w.println("[property]");
        for (String p : this.properties.keySet()) {
            w.println(p + " = " + this.properties.get(p));
        }
        w.close();
    }

    public String getPreferredAuthorityName() {
        return this.preferred_authority_name;
    }

    public String[] getAuthorityNames() {
        return this.authorities.keySet().toArray(new String[0]);
    }

    public void setAuthority(String authname, URL origin, String uuid) throws IOException {
        Authority a = this.authorities.get(authname);
        if (a == null && origin == null) {
            throw new IllegalArgumentException("Origin is required for a new authority");
        }
        if (a == null) {
            a = new Authority(authname);
            this.authorities.put(authname, a);
            this.catalogs.put(a, new Catalog(this, a.prefix));
        }
        if (origin != null) {
            a.origin = origin.toString();
        }
        if (uuid != null) {
            a.uuid = uuid;
        } else {
            this.ensureUuidPresent(a);
        }
    }

    public void setProperty(String pname, String pvalue) {
        this.properties.put(pname, pvalue);
        if (pname.equals("preferred-authority")) {
            this.preferred_authority_name = pvalue.trim();
        }
    }

    public void refreshCatalogs() throws IOException {
        for (Catalog c : this.catalogs.values()) {
            c.refresh();
        }
        this.rebuildCatalogCache();
    }

    public void refreshCatalog(String authname) throws IOException {
        Authority a = this.authorities.get(authname);
        if (a == null) {
            throw new IllegalArgumentException("unknown authority: " + authname);
        }
        Catalog c = this.catalogs.get(a);
        if (c == null) {
            throw new IllegalArgumentException("no catalog for authority: " + authname);
        }
        c.refresh();
        this.rebuildCatalogCache();
    }

    public List<FmriState> getInventory(String[] pkg_list, boolean all_known) {
        return this.catalogCache.getInventory(pkg_list, all_known);
    }

    boolean isInstalled(Fmri p) {
        try {
            File ifile = new File(p.getPkgVersionDir(new File(this.getMetaDirectory(), PKG_DIR)), INSTALLED_FILE);
            if (!ifile.exists()) {
                return false;
            }
            String auth = p.getAuthority();
            if (auth.length() == 0) {
                throw new IllegalArgumentException("Fmri must have authority set");
            }
            return auth.equals(this.getAuthorityForInstalledPkg((Fmri)p).prefix);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public ImagePlan makeInstallPlan(Collection<String> pkgNames) throws IOException, Constraint.ConstraintException {
        return this.makeInstallPlan(pkgNames.toArray(new String[pkgNames.size()]));
    }

    public ImagePlan makeInstallPlan(String ... pkgNames) throws IOException, Constraint.ConstraintException {
        this.startOperation("install");
        this.loadConstraints();
        List<String> incList = this.getInstalledUnboundIncorporationList();
        ArrayList<String> head = new ArrayList<String>();
        ArrayList<String> tail = new ArrayList<String>();
        for (String pn : pkgNames) {
            if (incList.contains(pn)) {
                head.add(pn);
                continue;
            }
            tail.add(pn);
        }
        head.addAll(tail);
        ArrayList<String> pkgnl = head;
        ArrayList<Fmri> pkgs = new ArrayList<Fmri>();
        for (String p : pkgnl) {
            Fmri conp = this.constraints.applyConstraintsToFmri(new Fmri(p));
            Fmri f = this.catalogCache.getFirst(conp.toString());
            if (f == null) {
                throw new IllegalArgumentException("no matching package for: " + p);
            }
            pkgs.add(f);
        }
        return this.makeAndEvaluateImagePlan(pkgs);
    }

    public ImagePlan makeInstallPlan(List<Fmri> pkgs) throws IOException, Constraint.ConstraintException {
        this.startOperation("install");
        return this.makeAndEvaluateImagePlan(pkgs);
    }

    private ImagePlan makeAndEvaluateImagePlan(List<Fmri> pkgs) throws IOException, Constraint.ConstraintException {
        ImagePlan ip = new ImagePlan(false, null);
        for (Fmri pf : pkgs) {
            ip.proposeFmri(pf);
        }
        log.log(Level.FINER, "beforeeval", ip.toString());
        ip.evaluate();
        log.log(Level.FINER, "aftereval", ip.toString());
        return ip;
    }

    public ImagePlan makeUninstallPlan(Collection<Fmri> pkgs) throws IOException {
        this.startOperation("uninstall");
        ImagePlan ip = new ImagePlan(false, null);
        for (Fmri pf : pkgs) {
            ip.proposeFmriRemoval(pf);
        }
        log.log(Level.FINER, "beforeeval", ip.toString());
        ip.evaluate();
        log.log(Level.FINER, "aftereval", ip.toString());
        return ip;
    }

    public void installPackages(String ... pkgNames) throws IOException, Constraint.ConstraintException {
        ImagePlan ip = this.makeInstallPlan(pkgNames);
        if (ip.nothingToDo()) {
            return;
        }
        log.log(Level.FINE, "installing", Arrays.toString(ip.getProposedFmris()));
        ip.execute();
    }

    public void installPackages(List<Fmri> pkgs) throws IOException, Constraint.ConstraintException {
        ImagePlan ip = this.makeInstallPlan(pkgs);
        if (ip.nothingToDo()) {
            return;
        }
        log.log(Level.FINE, "installing", pkgs.toString());
        ip.execute();
    }

    public void uninstallPackages(String ... pkgNames) throws IOException {
        this.uninstallPackages(this.getVersionsInstalled(Arrays.asList(pkgNames)));
    }

    public void uninstallPackages(List<Fmri> pkgs) throws IOException {
        ImagePlan plan = this.makeUninstallPlan(pkgs);
        log.log(Level.FINE, "uninstalling", pkgs.toString());
        plan.execute();
    }

    public Manifest getManifest(Fmri fmri) throws IOException {
        return new Manifest(this, fmri);
    }

    private boolean fmriIsSamePackage(Fmri fmri, Fmri pf) {
        return fmri.isSamePackage(pf);
    }

    private boolean fmriIsSuccessor(Fmri fmri, Fmri pf) {
        return fmri.isSuccessor(pf);
    }

    private List<Fmri> getInstalledFmrisFromCache() {
        List<FmriState> lfs = this.catalogCache.getInventory(null, false);
        ArrayList<Fmri> installed = new ArrayList<Fmri>();
        for (FmriState fs : lfs) {
            installed.add(fs.fmri);
        }
        return installed;
    }

    private List<Fmri> getInstalledFmrisFromImage() throws IOException {
        File istatedir = new File(this.getMetaDirectory(), ISTATE_DIR);
        ArrayList<Fmri> installedPkgs = new ArrayList<Fmri>();
        if (!istatedir.exists()) {
            this.updateInstalledPackages();
        }
        for (File f : istatedir.listFiles()) {
            String fmristr = URLDecoder.decode(f.getName(), "UTF-8");
            Fmri fmri = new Fmri(fmristr);
            installedPkgs.add(fmri);
        }
        return installedPkgs;
    }

    boolean getPolicy(String pname) {
        String bstr = this.properties.get(pname);
        if (bstr != null) {
            Boolean b = Boolean.parseBoolean(bstr.trim());
            return b != null && b != false;
        }
        return false;
    }

    void setFmriDefaultAuthority(Fmri fmri) {
        if (fmri.getAuthority().length() == 0) {
            fmri.setAuthority(this.getPreferredAuthorityName());
        }
    }

    public Fmri getVersionInstalled(String pkgName) throws IOException {
        return this.getVersionInstalled(new Fmri(pkgName));
    }

    public List<Fmri> getVersionsInstalled(Collection<String> pkgNames) throws IOException {
        ArrayList<Fmri> r = new ArrayList<Fmri>();
        for (String pkgName : pkgNames) {
            Fmri f = this.getVersionInstalled(pkgName);
            if (f == null) continue;
            r.add(f);
        }
        return r;
    }

    private Fmri getVersionInstalled(Fmri fmri) throws IOException {
        File pd = fmri.getPkgDir(new File(this.getMetaDirectory(), PKG_DIR));
        File[] pkgDirs = pd.listFiles();
        if (pkgDirs == null) {
            return null;
        }
        ArrayList<File> installedPkgs = new ArrayList<File>();
        for (File f : pkgDirs) {
            File ifile = new File(f, INSTALLED_FILE);
            if (!ifile.exists()) continue;
            installedPkgs.add(f);
        }
        if (installedPkgs.size() == 0) {
            return null;
        }
        if (installedPkgs.size() > 1) {
            throw new RuntimeException("package installed more than once: " + fmri);
        }
        Fmri ifmri = new Fmri((File)installedPkgs.get(0));
        ifmri.setAuthority(this.getAuthorityForInstalledPkg((Fmri)ifmri).prefix);
        return ifmri;
    }

    private Fmri getInstalledOlderVersion(Fmri fmri) throws IOException {
        return this.getVersionInstalled(fmri);
    }

    private boolean hasVersionInstalled(Fmri fmri) throws IOException {
        Fmri f = this.getVersionInstalled(fmri);
        return f != null && this.fmriIsSuccessor(f, fmri);
    }

    private void startOperation(String op) {
        this.currentOperation = op;
        this.targetFmris = new Stack();
        this.targetReasons = new Stack();
    }

    private void endOperation() {
        this.currentOperation = "unknown";
    }

    private void pushTarget(Fmri fmri, String intent) {
        this.targetFmris.push(fmri);
        this.targetReasons.push(intent);
    }

    private void popTarget() {
        this.targetFmris.pop();
        this.targetReasons.pop();
    }

    String getIntent(Fmri pi) throws IOException {
        Fmri prior;
        String op = this.currentOperation;
        String reason = "info";
        String target_pkg = "";
        String initial_pkg = "";
        String needed_by_pkg = "";
        String current_auth = pi.getAuthority();
        if (!this.targetFmris.empty()) {
            Fmri target = this.targetFmris.peek();
            reason = this.targetReasons.peek();
            String na_current = pi.toStringWithoutAuthority();
            String na_target = pi.toStringWithoutAuthority();
            if (na_target.equals(na_current)) {
                target_pkg = target.getAuthority().equals(current_auth) ? na_target.substring(wopkg) : "unknown";
                Fmri initial = (Fmri)this.targetFmris.firstElement();
                String initial_auth = initial.getAuthority();
                if (initial_auth.equals(current_auth)) {
                    initial_pkg = initial.toStringWithoutAuthority().substring(wopkg);
                    if (target_pkg.equals(initial_pkg)) {
                        target_pkg = "";
                    }
                } else {
                    initial_pkg = "unknown";
                }
                if (this.targetFmris.size() > 1) {
                    Fmri needed_by = (Fmri)this.targetFmris.get(this.targetFmris.size() - 2);
                    String needed_by_auth = needed_by.getAuthority();
                    needed_by_pkg = needed_by_auth.equals(current_auth) ? needed_by.toStringWithoutAuthority().substring(wopkg) : "unknown";
                }
            }
        } else {
            initial_pkg = pi.toStringWithoutAuthority().substring(wopkg);
        }
        String prior_version = "";
        if (!reason.equals("info") && (prior = this.getVersionInstalled(pi)) != null) {
            String prior_auth = prior.getAuthority();
            prior_version = prior_auth.equals(current_auth) ? prior.getVersion().toString() : "unknown";
        }
        String[][] info = new String[][]{{"operation", op}, {"prior_version", prior_version}, {"reason", reason}, {"target", target_pkg}, {"initial_target", initial_pkg}, {"needed_by", needed_by_pkg}};
        StringBuffer infobuf = new StringBuffer();
        infobuf.append("(");
        boolean haveData = false;
        for (int i = 0; i < info.length; ++i) {
            if (info[i][1].length() == 0) continue;
            if (haveData) {
                infobuf.append(';');
            }
            haveData = true;
            infobuf.append(info[i][0]).append("=").append(info[i][1]);
        }
        infobuf.append(")");
        return infobuf.toString();
    }

    private void loadConstraints() throws IOException {
        for (Fmri fmri : this.getInstalledFmrisFromCache()) {
            if (!this.constraints.startLoading(fmri)) continue;
            Manifest m = this.getManifest(fmri);
            for (DependAction da : m.getActionsByType(DependAction.class)) {
                this.constraints.updateConstraints(da.getConstraint());
            }
            this.constraints.finishLoading(fmri);
        }
    }

    private List<String> getInstalledUnboundIncorporationList() throws IOException {
        TreeSet<String> dependents = new TreeSet<String>();
        ArrayList<String> inc = new ArrayList<String>();
        for (Fmri fmri : this.getInstalledFmrisFromCache()) {
            String fmriName = fmri.getName();
            Manifest m = this.getManifest(fmri);
            for (DependAction da : m.getActionsByType(DependAction.class)) {
                Fmri cfmri = da.getConstrainedFmri();
                if (cfmri == null) continue;
                String cName = cfmri.getName();
                dependents.add(cName);
                inc.add(fmriName);
            }
        }
        TreeSet<String> rv = new TreeSet<String>();
        for (String p : inc) {
            if (dependents.contains(p)) continue;
            rv.add(p);
        }
        return new ArrayList<String>(rv);
    }

    Map<Fmri, List<Fmri>> buildReqDependents() throws IOException {
        HashMap<Fmri, List<Fmri>> deps = new HashMap<Fmri, List<Fmri>>();
        for (Fmri fmri : this.getInstalledFmrisFromCache()) {
            Manifest m = this.getManifest(fmri);
            for (DependAction d : m.getActionsByType(DependAction.class)) {
                if (d.getType() != DependAction.Type.REQUIRED) continue;
                Fmri dfmri = d.getTargetFmri();
                ArrayList<Fmri> ldep = (ArrayList<Fmri>)deps.get(dfmri);
                if (ldep == null) {
                    ldep = new ArrayList<Fmri>();
                    deps.put(dfmri, ldep);
                }
                ldep.add(fmri);
            }
        }
        return deps;
    }

    private List<Fmri> getDependents(Fmri pfmri) throws IOException {
        if (this.reqDependents == null) {
            this.reqDependents = this.buildReqDependents();
        }
        ArrayList<Fmri> dependents = new ArrayList<Fmri>();
        for (Fmri f : this.reqDependents.keySet()) {
            if (!this.fmriIsSuccessor(pfmri, f)) continue;
            dependents.addAll((Collection<Fmri>)this.reqDependents.get(f));
        }
        return dependents;
    }

    private Authority getAuthorityForInstalledPkg(Fmri fmri) throws IOException {
        String pfx;
        String authname = null;
        File ifile = new File(fmri.getPkgVersionDir(new File(this.getMetaDirectory(), PKG_DIR)), INSTALLED_FILE);
        BufferedReader r = new BufferedReader(new FileReader(ifile));
        String line = r.readLine();
        authname = line != null && !line.equals("VERSION_1") ? line : ((line = r.readLine()).startsWith(pfx = "_PRE_") ? line.substring(pfx.length()) : line);
        r.close();
        Authority a = this.authorities.get(authname);
        if (a == null) {
            a = new Authority(authname);
            this.authorities.put(authname, a);
        }
        return a;
    }

    private void addInstallFile(Fmri fmri) throws IOException {
        File istatedir = new File(this.getMetaDirectory(), ISTATE_DIR);
        if (!istatedir.exists()) {
            this.updateInstalledPackages();
        }
        this.reqDependents = null;
        String authname = fmri.getAuthority();
        String prefpfx = "";
        String prefauth = this.getPreferredAuthorityName();
        if (authname.length() == 0 || authname.equals(prefauth)) {
            authname = prefauth;
            prefpfx = "_PRE_";
        }
        File ifile = new File(fmri.getPkgVersionDir(new File(this.getMetaDirectory(), PKG_DIR)), INSTALLED_FILE);
        FileWriter fw = new FileWriter(ifile);
        fw.write("VERSION_1\n" + prefpfx + authname);
        fw.close();
        File isfile = new File(istatedir, fmri.getLinkFileName());
        isfile.createNewFile();
    }

    private void removeInstallFile(Fmri fmri) throws IOException {
        File istatedir = new File(this.getMetaDirectory(), ISTATE_DIR);
        if (!istatedir.exists()) {
            this.updateInstalledPackages();
        }
        this.reqDependents = null;
        File ifile = new File(fmri.getPkgVersionDir(new File(this.getMetaDirectory(), PKG_DIR)), INSTALLED_FILE);
        ifile.delete();
        File isfile = new File(istatedir, fmri.getLinkFileName());
        isfile.delete();
    }

    private void updateInstalledPackages() throws IOException {
        File istatedir = new File(this.getMetaDirectory(), ISTATE_DIR);
        File tmpdir = new File(this.getMetaDirectory(), ISTATE_DIR_TMP);
        if (!tmpdir.mkdirs()) {
            throw new IOException("unable to create installed packages directory");
        }
        File proot = new File(this.getMetaDirectory(), PKG_DIR);
        for (File pd : proot.listFiles()) {
            for (File vd : pd.listFiles()) {
                File path = new File(vd, INSTALLED_FILE);
                if (!path.exists()) continue;
                String fmristr = URLDecoder.decode(pd.getName() + "@" + vd.getName(), "UTF-8");
                Fmri f = new Fmri(fmristr);
                File fi = new File(tmpdir, f.getLinkFileName());
                fi.createNewFile();
            }
        }
        if (!tmpdir.renameTo(istatedir)) {
            for (File f : tmpdir.listFiles()) {
                f.delete();
            }
            tmpdir.delete();
        }
    }

    static String getVersion() {
        if (version != null) {
            return version;
        }
        version = log.getResourceBundle().getString("version");
        if (version == null) {
            version = "0";
        }
        log.log(Level.FINE, "versionmsg", version);
        return version;
    }

    static String getOSVersion() {
        String osv = System.getProperty("os.version");
        if (os.equals("sunos")) {
            try {
                File f = new File("/etc/release");
                BufferedReader in = new BufferedReader(new FileReader(f));
                String line = in.readLine();
                Pattern p = Pattern.compile("^.*\\s(\\S+)\\s+\\S+$");
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    osv = osv + "-" + m.group(1);
                }
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return osv;
    }

    boolean isThisPlatform(String plat) {
        String[][] c = new String[][]{{"sunos-i386", "sunos", "x86"}, {"sunos-sparc", "sunos", "sparc"}, {"linux-i386", "linux", ""}, {"windows-i386", "windows", ""}, {"darwin-universal", "mac os x", ""}, {"hpux-ia64", "hp-ux", ""}, {"aix-powerpc", "aix", "ppc"}};
        for (int i = 0; i < c.length; ++i) {
            if (!plat.equals(c[i][0]) || os.indexOf(c[i][1]) == -1 || arch.indexOf(c[i][2]) == -1) continue;
            return true;
        }
        return false;
    }

    static void deleteTree(File file) {
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                Image.deleteTree(f);
            }
            file.delete();
        }
    }

    static class Authority {
        String prefix;
        String origin;
        String uuid;
        File certFile;
        File keyFile;
        SSLSocketFactory sslfactory = null;

        Authority(String name) {
            this.prefix = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CatalogCache {
        HashMap<String, CacheEntry> pkgs = new HashMap();

        CatalogCache() {
        }

        void cacheInstalledPackages() throws IOException {
            for (Fmri f : Image.this.getInstalledFmrisFromImage()) {
                Authority a = Image.this.getAuthorityForInstalledPkg(f);
                if (a == null) {
                    throw new RuntimeException("can't determine authority for installed package: " + f);
                }
                this.cacheFmri(f, a);
            }
        }

        void addCatalog(Catalog c, Authority a) {
            for (Fmri f : c.getFmris()) {
                this.cacheFmri(f, a);
            }
        }

        private void cacheFmri(Fmri f, Authority a) {
            String pname = f.getName();
            Version v = f.getVersion();
            CacheEntry ce = this.pkgs.get(pname);
            if (ce == null) {
                this.pkgs.put(pname, new CacheEntry(f, a));
            } else {
                SubCacheEntry sce = ce.versionInfo.get(v);
                if (sce == null) {
                    ce.versionInfo.put(v, new SubCacheEntry(f, a));
                    ce.versions.add(v);
                } else if (!sce.auths.contains(a)) {
                    sce.auths.add(a);
                }
            }
        }

        List<Fmri> multimatch(String pname, Fmri[] pkgFmris) {
            ArrayList<Fmri> matches = new ArrayList<Fmri>();
            pname = "/" + pname;
            for (Fmri f : pkgFmris) {
                if (!pname.endsWith("/" + f.getName())) continue;
                matches.add(f);
            }
            return matches;
        }

        List<FmriState> getInventory(String[] patternNames, boolean allKnown) {
            if (patternNames == null) {
                patternNames = new String[]{};
            }
            Fmri[] patternFmris = new Fmri[patternNames.length];
            for (int i = 0; i < patternNames.length; ++i) {
                patternFmris[i] = new Fmri(patternNames[i]);
            }
            ArrayList<FmriState> results = new ArrayList<FmriState>();
            String pauth = Image.this.getPreferredAuthorityName();
            for (String name : this.pkgs.keySet()) {
                List<Fmri> matches = this.multimatch(name, patternFmris);
                if (patternFmris.length > 0 && matches.size() == 0) continue;
                Version newest = this.pkgs.get((Object)name).versions.last();
                Version[] vlist = this.pkgs.get((Object)name).versions.toArray(new Version[0]);
                HashMap<Version, SubCacheEntry> vinfo = this.pkgs.get((Object)name).versionInfo;
                for (int i = vlist.length - 1; i >= 0; --i) {
                    ArrayList<Fmri> vmatches = new ArrayList<Fmri>();
                    for (Fmri m : matches) {
                        Version mv = m.getVersion();
                        if (!mv.isNull() && !vlist[i].isSuccessor(mv)) continue;
                        vmatches.add(m);
                    }
                    if (matches.size() > 0 && vmatches.size() == 0) continue;
                    List<Authority> authlist = vinfo.get((Object)vlist[i]).auths;
                    ArrayList<Fmri> amatches = new ArrayList<Fmri>();
                    for (Fmri m : vmatches) {
                        String mauth = m.getAuthority();
                        if (mauth.length() != 0 && !authlist.contains(Image.this.authorities.get(mauth))) continue;
                        amatches.add(m);
                    }
                    if (vmatches.size() > 0 && amatches.size() == 0) continue;
                    List<Authority> alist = null;
                    if (amatches.size() == 0) {
                        alist = authlist;
                    } else {
                        for (Fmri m : amatches) {
                            if (m.getAuthority().length() != 0) continue;
                            alist = authlist;
                            break;
                        }
                        if (alist == null) {
                            alist = new ArrayList<Authority>();
                            for (Authority a : authlist) {
                                for (Fmri m : amatches) {
                                    if (!a.prefix.equals(m.getAuthority())) continue;
                                    alist.add(a);
                                }
                            }
                        }
                    }
                    Fmri vfmri = vinfo.get((Object)vlist[i]).fmri;
                    for (Authority a : alist) {
                        FmriState fs = new FmriState();
                        fs.fmri = vfmri.clone();
                        fs.fmri.setAuthority(a.prefix);
                        fs.upgradable = !vlist[i].equals(newest);
                        fs.installed = Image.this.isInstalled(fs.fmri);
                        if (!allKnown && !fs.installed) continue;
                        results.add(fs);
                    }
                }
            }
            return results;
        }

        Fmri getFirst(String pattern) {
            String[] plist = new String[]{pattern};
            List<FmriState> lfs = this.getInventory(plist, true);
            String pauth = Image.this.getPreferredAuthorityName();
            Fmri firstNonPref = null;
            for (FmriState fs : lfs) {
                if (fs.fmri.getAuthority().equals(pauth)) {
                    return fs.fmri;
                }
                if (firstNonPref != null) continue;
                firstNonPref = fs.fmri;
            }
            return firstNonPref;
        }

        class CacheEntry {
            SortedSet<Version> versions = new TreeSet<Version>();
            HashMap<Version, SubCacheEntry> versionInfo = new HashMap();

            CacheEntry(Fmri f, Authority a) {
                Version v = f.getVersion();
                this.versions.add(v);
                this.versionInfo.put(v, new SubCacheEntry(f, a));
            }
        }

        class SubCacheEntry {
            Fmri fmri;
            List<Authority> auths = new ArrayList<Authority>();

            SubCacheEntry(Fmri f, Authority a) {
                this.fmri = f;
                this.auths.add(a);
            }
        }
    }

    static class Filter {
        Filter() {
        }
    }

    public static class FmriState {
        public Fmri fmri;
        public boolean installed = false;
        public boolean upgradable = false;
        public boolean frozen = false;
        public boolean incorporated = false;
        public boolean excludes = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ImagePlan {
        private PlanState state;
        private boolean recursiveRemoval;
        private List<Fmri> targetFmris = new ArrayList<Fmri>();
        private List<Fmri> targetRemFmris = new ArrayList<Fmri>();
        private List<PackagePlan> pkgPlans = new ArrayList<PackagePlan>();
        private List<String> directories = null;

        ImagePlan(boolean recursiveRemoval, Filter[] filters) {
            this.state = PlanState.UNEVALUATED;
            this.recursiveRemoval = recursiveRemoval;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            if (this.state == PlanState.UNEVALUATED) {
                s.append("UNEVALUTED:\n");
                for (Fmri t : this.targetFmris) {
                    s.append("+" + t + "\n");
                }
                for (Fmri t : this.targetRemFmris) {
                    s.append("-" + t + "\n");
                }
            } else {
                for (PackagePlan pp : this.pkgPlans) {
                    s.append(pp + "\n");
                }
            }
            return s.toString();
        }

        public Fmri[] getProposedFmris() {
            return this.targetFmris.toArray(new Fmri[this.targetFmris.size()]);
        }

        boolean isProposedFmri(Fmri fmri) {
            for (Fmri pf : this.targetFmris) {
                if (!Image.this.fmriIsSamePackage(fmri, pf)) continue;
                return !Image.this.fmriIsSuccessor(fmri, pf);
            }
            return false;
        }

        boolean isProposedRemFmri(Fmri fmri) {
            for (Fmri pf : this.targetRemFmris) {
                if (!Image.this.fmriIsSamePackage(fmri, pf)) continue;
                return true;
            }
            return false;
        }

        Fmri getProposedVersion(Fmri fmri) {
            for (Fmri p : this.targetFmris) {
                if (!fmri.getName().equals(p.getName())) continue;
                return p;
            }
            return null;
        }

        void proposeFmri(Fmri fmri) throws IOException, Constraint.ConstraintException {
            if (Image.this.hasVersionInstalled(fmri)) {
                return;
            }
            fmri = Image.this.constraints.applyConstraintsToFmri(fmri);
            Image.this.setFmriDefaultAuthority(fmri);
            for (Fmri p : this.targetFmris) {
                if (Image.this.fmriIsSuccessor(fmri, p)) {
                    this.targetFmris.remove(p);
                    break;
                }
                if (!Image.this.fmriIsSuccessor(p, fmri)) continue;
                return;
            }
            this.targetFmris.add(fmri);
        }

        boolean olderVersionProposed(Fmri fmri) {
            for (Fmri p : this.targetFmris) {
                if (!Image.this.fmriIsSuccessor(fmri, p)) continue;
                return true;
            }
            return false;
        }

        void proposeFmriRemoval(Fmri fmri) throws IOException {
            if (!Image.this.hasVersionInstalled(fmri)) {
                return;
            }
            for (Fmri p : this.targetRemFmris) {
                if (!Image.this.fmriIsSuccessor(fmri, p)) continue;
                this.targetRemFmris.remove(p);
                break;
            }
            this.targetRemFmris.add(fmri);
        }

        List<Fmri> genNewInstalledPackages() {
            if (this.state != PlanState.EVALUATED_OK) {
                throw new RuntimeException("invalid image plan state");
            }
            List fmriset = Image.this.getInstalledFmrisFromCache();
            for (PackagePlan p : this.pkgPlans) {
                p.updatePackageSet(fmriset);
            }
            return fmriset;
        }

        Collection<String> getDirectories() throws IOException {
            if (this.directories == null) {
                this.directories = new ArrayList<String>();
                this.directories.add(Image.img_root_prefix);
                this.directories.add("var/sadm/install");
                for (Fmri fmri : this.genNewInstalledPackages()) {
                    for (Action act : Image.this.getManifest(fmri).getActions()) {
                        List<String> dl = act.getReferencedDirectories();
                        if (dl == null) continue;
                        this.directories.addAll(dl);
                    }
                }
            }
            return this.directories;
        }

        void evaluateFmri(Fmri pfmri) throws IOException, Constraint.ConstraintException {
            Image.this.pushTarget(pfmri, "process");
            Image.this.setFmriDefaultAuthority(pfmri);
            Manifest m = Image.this.getManifest(pfmri);
            List<DependAction> lda = m.getActionsByType(DependAction.class);
            if (Image.this.constraints.startLoading(pfmri)) {
                for (DependAction da : lda) {
                    Image.this.constraints.updateConstraints(da.getConstraint());
                }
                Image.this.constraints.finishLoading(pfmri);
            }
            for (DependAction da : lda) {
                Fmri refFmri = this.getProposedVersion(da.getTargetFmri());
                if (refFmri == null) {
                    refFmri = Image.this.getVersionInstalled(da.getTargetFmri());
                }
                if (da.getConstraint().checkForWork(refFmri) == null) continue;
                Fmri daf = Image.this.constraints.applyConstraintsToFmri(da.getTargetFmri());
                Fmri cf = Image.this.catalogCache.getFirst(daf.toString());
                if (cf == null) {
                    throw new IOException("Unable to resolve dependency on package:" + da.keyValue());
                }
                this.proposeFmri(cf);
                this.evaluateFmri(cf);
            }
            Image.this.popTarget();
        }

        void addPackagePlan(Fmri pfmri) throws IOException {
            Manifest m = Image.this.getManifest(pfmri);
            PackagePlan pp = new PackagePlan();
            pp.proposeDestination(pfmri, m);
            pp.evaluate();
            this.pkgPlans.add(pp);
        }

        void evaluateFmriRemoval(Fmri pfmri) throws IOException {
            List dependents = Image.this.getDependents(pfmri);
            for (Fmri d : new ArrayList(dependents)) {
                if (!this.targetRemFmris.contains(d)) continue;
                dependents.remove(d);
            }
            if (dependents.size() > 0 && !this.recursiveRemoval) {
                StringBuffer msg = new StringBuffer();
                msg.append("Cannot remove '" + pfmri + "' due to the following packages that directly " + "depend on it:\n");
                for (Fmri d : dependents) {
                    msg.append(d.toString());
                    msg.append("\n");
                }
                throw new IllegalArgumentException(msg.toString());
            }
            Image.this.pushTarget(pfmri, "process");
            Manifest m = Image.this.getManifest(pfmri);
            PackagePlan pp = new PackagePlan();
            pp.proposeRemoval(pfmri, m);
            pp.evaluate();
            for (Fmri d : dependents) {
                if (this.isProposedRemFmri(d) || Image.this.hasVersionInstalled(d)) continue;
                this.targetRemFmris.add(d);
                this.evaluateFmriRemoval(d);
            }
            this.pkgPlans.add(pp);
            Image.this.popTarget();
        }

        void evaluate() throws IOException, Constraint.ConstraintException {
            ArrayList<Fmri> targetFmrisCopy = new ArrayList<Fmri>(this.targetFmris);
            for (Fmri f : targetFmrisCopy) {
                this.evaluateFmri(f);
            }
            for (Fmri f : this.targetFmris) {
                this.addPackagePlan(f);
            }
            for (Fmri f : this.targetRemFmris) {
                this.evaluateFmriRemoval(f);
            }
            this.state = PlanState.EVALUATED_OK;
        }

        boolean nothingToDo() {
            return this.pkgPlans.size() == 0;
        }

        public long computeTransferSize() {
            long r = 0L;
            for (PackagePlan p : this.pkgPlans) {
                r += p.computeTransferSize();
            }
            return r;
        }

        public int computeTransferFiles() {
            int r = 0;
            for (PackagePlan p : this.pkgPlans) {
                r += p.computeTransferFiles();
            }
            return r;
        }

        public void execute() throws IOException {
            this.execute(new ImagePlanProgressTracker());
        }

        public void execute(ImagePlanProgressTracker tracker) throws IOException {
            if (this.nothingToDo()) {
                this.state = PlanState.EXECUTED_OK;
                return;
            }
            int n = 0;
            for (PackagePlan pp : this.pkgPlans) {
                if (pp.flist.computeTransferFiles() <= 0) continue;
                ++n;
            }
            tracker.startDownloadPhase(n);
            for (PackagePlan p : this.pkgPlans) {
                p.preexecute(tracker);
            }
            tracker.endDownloadPhase();
            ArrayList<Action> removals = new ArrayList<Action>();
            for (PackagePlan pp : this.pkgPlans) {
                removals.addAll(pp.getRemovalActions());
            }
            Collection<String> imagedirs = this.getDirectories();
            for (Action a : new ArrayList(removals)) {
                if (!(a instanceof DirAction) || !imagedirs.contains(((DirAction)a).path)) continue;
                removals.remove(a);
            }
            ArrayList<Manifest.Difference.ActionPair> updates = new ArrayList<Manifest.Difference.ActionPair>();
            for (PackagePlan pp : this.pkgPlans) {
                updates.addAll(pp.getUpdateActions());
            }
            ArrayList<Action> installs = new ArrayList<Action>();
            for (PackagePlan pp : this.pkgPlans) {
                installs.addAll(pp.getInstallActions());
            }
            for (Action a : new ArrayList(installs)) {
                if (!(a instanceof UserAction) && !(a instanceof GroupAction)) continue;
                updates.add(new Manifest.Difference.ActionPair(null, a));
                installs.remove(a);
            }
            tracker.startActions(removals.size() + updates.size() + installs.size());
            Collections.sort(removals, Collections.reverseOrder());
            log.log(Level.FINE, "removalphase");
            tracker.startRemovalPhase(removals.size());
            for (Action a : removals) {
                tracker.onRemovalAction(a);
                a.remove();
            }
            tracker.endRemovalPhase();
            Collections.sort(updates, new Comparator<Manifest.Difference.ActionPair>(){

                @Override
                public int compare(Manifest.Difference.ActionPair o1, Manifest.Difference.ActionPair o2) {
                    return o1.to.compareTo(o2.to);
                }

                public boolean equals(Manifest.Difference.ActionPair o1, Manifest.Difference.ActionPair o2) {
                    return o1.to.equals(o2.to);
                }
            });
            log.log(Level.FINE, "updatephase");
            tracker.startUpdatePhase(updates.size());
            for (Manifest.Difference.ActionPair ap : updates) {
                tracker.onUpdateAction(ap.from, ap.to);
                ap.to.install(ap.from);
            }
            tracker.endUpdatePhase();
            Collections.sort(installs);
            log.log(Level.FINE, "installphase");
            tracker.startInstallPhase(installs.size());
            for (Action a : installs) {
                tracker.onInstallAction(a);
                a.install(null);
            }
            tracker.endInstallPhase();
            for (PackagePlan p : this.pkgPlans) {
                p.postExecute();
            }
            this.state = PlanState.EXECUTED_OK;
            Image.deleteTree(new File(Image.this.getMetaDirectory(), "index"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PackagePlan {
        private Fmri originFmri = null;
        private Fmri destFmri = null;
        private Manifest originManifest = Manifest.nullManifest;
        private Manifest destManifest = Manifest.nullManifest;
        private Manifest.Difference diff;
        private FileList flist;

        PackagePlan() {
        }

        public String toString() {
            return "" + this.originFmri + " -> " + this.destFmri;
        }

        void proposeDestination(Fmri pfmri, Manifest m) {
            this.destFmri = pfmri;
            this.destManifest = m;
            if (Image.this.isInstalled(pfmri)) {
                throw new IllegalArgumentException("already installed: " + pfmri);
            }
        }

        void proposeRemoval(Fmri pfmri, Manifest m) {
            this.originFmri = pfmri;
            this.originManifest = m;
            if (!Image.this.isInstalled(pfmri)) {
                throw new IllegalArgumentException("not installed: " + pfmri);
            }
        }

        void updatePackageSet(List<Fmri> fmriset) {
            if (this.originFmri != null) {
                fmriset.remove(this.originFmri);
            }
            if (this.destFmri != null) {
                fmriset.add(this.destFmri);
            }
        }

        void evaluate() throws IOException {
            Action[] dup;
            Fmri f;
            if (this.originFmri == null && (f = Image.this.getInstalledOlderVersion(this.destFmri)) != null) {
                this.originFmri = f;
                this.originManifest = Image.this.getManifest(f);
            }
            if (this.destManifest != null && (dup = this.destManifest.findDuplicates()) != null) {
                throw new IllegalArgumentException("manifest of " + this.destFmri + " has duplicates: " + dup[0] + " & " + dup[1]);
            }
            this.diff = this.destManifest.getDifference(this.originManifest);
            this.flist = new FileList(Image.this, this.destFmri);
            for (Action a : this.diff.added) {
                a.buildFileList(null, this.flist);
            }
            for (Manifest.Difference.ActionPair ap : this.diff.changed) {
                ap.to.buildFileList(ap.from, this.flist);
            }
        }

        void preexecute(ImagePlanProgressTracker tracker) throws IOException {
            if (this.destFmri == null) {
                Image.this.removeInstallFile(this.originFmri);
            }
            for (Action a : this.diff.removed) {
                a.preremove();
            }
            for (Manifest.Difference.ActionPair ap : this.diff.changed) {
                ap.from.preremove();
            }
            this.flist.download(tracker);
        }

        List<Action> getInstallActions() {
            return this.diff.added;
        }

        List<Action> getRemovalActions() {
            return this.diff.removed;
        }

        List<Manifest.Difference.ActionPair> getUpdateActions() {
            return this.diff.changed;
        }

        long computeTransferSize() {
            return this.flist.computeTransferSize();
        }

        int computeTransferFiles() {
            return this.flist.computeTransferFiles();
        }

        void postExecute() throws IOException {
            for (Action a : this.diff.added) {
                a.postinstall(null);
            }
            for (Action a : this.diff.removed) {
                a.postremove();
            }
            for (Manifest.Difference.ActionPair ap : this.diff.changed) {
                ap.from.postremove();
                ap.to.postinstall(ap.from);
            }
            if (this.originFmri != null && this.destFmri != null) {
                Image.this.removeInstallFile(this.originFmri);
            }
            if (this.destFmri != null) {
                Image.this.addInstallFile(this.destFmri);
            }
            if (this.flist != null) {
                this.flist.cleanupDownload();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PlanState {
        UNEVALUATED,
        EVALUATED_OK,
        EVALUATED_ERROR,
        EXECUTED_OK,
        EXECUTED_ERROR;

    }
}

