/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.interceptor.model.InterceptorMetadata;
import org.jboss.interceptor.model.metadata.ClassReference;
import org.jboss.interceptor.registry.ClassMetadataReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorMetadataRegistry<T> {
    private final Map<Key, InterceptorMetadata> interceptorClassMetadataMap = new ConcurrentHashMap<Key, InterceptorMetadata>();
    private ClassMetadataReader classMetadataReader;
    private final Lock lock = new ReentrantLock();

    public InterceptorMetadataRegistry(ClassMetadataReader classMetadataReader) {
        this.classMetadataReader = classMetadataReader;
    }

    public InterceptorMetadata getInterceptorClassMetadata(ClassReference interceptorClass) {
        return this.getInterceptorClassMetadata(interceptorClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterceptorMetadata getInterceptorClassMetadata(ClassReference interceptorClass, boolean isInterceptorTargetClass) {
        Key key = new Key(interceptorClass, isInterceptorTargetClass);
        if (!this.interceptorClassMetadataMap.containsKey(key)) {
            try {
                this.lock.lock();
                if (!this.interceptorClassMetadataMap.containsKey(key)) {
                    this.interceptorClassMetadataMap.put(key, this.classMetadataReader.getInterceptorMetadata(interceptorClass, isInterceptorTargetClass));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.interceptorClassMetadataMap.get(key);
    }

    public void cleanup() {
        this.interceptorClassMetadataMap.clear();
    }

    public static final class Key {
        private String className;
        private boolean isInterceptorTargetClass;

        private Key(ClassReference clazz, boolean interceptorTargetClass) {
            this.className = clazz.getClassName();
            this.isInterceptorTargetClass = interceptorTargetClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.isInterceptorTargetClass != key.isInterceptorTargetClass) {
                return false;
            }
            return !(this.className != null ? !this.className.equals(key.className) : key.className != null);
        }

        public int hashCode() {
            int result = this.className != null ? this.className.hashCode() : 0;
            result = 31 * result + (this.isInterceptorTargetClass ? 1 : 0);
            return result;
        }
    }
}

