/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiejb;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.ActionReport;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.osgiejb.OSGiEJBDeploymentRequest;
import org.glassfish.osgiejb.OSGiEJBUndeploymentRequest;
import org.glassfish.osgijavaeebase.AbstractOSGiDeployer;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiDeploymentRequest;
import org.glassfish.osgijavaeebase.OSGiUndeploymentRequest;
import org.glassfish.server.ServerEnvironmentImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiEJBDeployer
extends AbstractOSGiDeployer {
    private static Logger logger = Logger.getLogger(OSGiEJBDeployer.class.getPackage().getName());
    private EJBTracker ejbTracker;
    private final InitialContext ic;

    public OSGiEJBDeployer(BundleContext ctx) {
        super(ctx, Integer.MIN_VALUE);
        try {
            this.ic = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        this.ejbTracker = new EJBTracker();
        this.ejbTracker.open(true);
    }

    public OSGiUndeploymentRequest createOSGiUndeploymentRequest(Deployment deployer, ServerEnvironmentImpl env, ActionReport reporter, OSGiApplicationInfo osgiAppInfo) {
        return new OSGiEJBUndeploymentRequest(deployer, env, reporter, osgiAppInfo);
    }

    public OSGiDeploymentRequest createOSGiDeploymentRequest(Deployment deployer, ArchiveFactory archiveFactory, ServerEnvironmentImpl env, ActionReport reporter, Bundle b) {
        return new OSGiEJBDeploymentRequest(deployer, archiveFactory, env, reporter, b);
    }

    public boolean handles(Bundle bundle) {
        return this.isEJBBundle(bundle);
    }

    private boolean isEJBBundle(Bundle b) {
        Dictionary headers = b.getHeaders();
        return headers.get("Export-EJB") != null && headers.get("Fragment-Host") == null;
    }

    class EJBTracker
    extends ServiceTracker {
        private final String JNDI_NAME_PROP = "jndi-name";
        private Map<Long, Collection<ServiceRegistration>> b2ss;
        private ServiceRegistration reg;

        EJBTracker() {
            super(OSGiEJBDeployer.this.getBundleContext(), OSGiApplicationInfo.class.getName(), null);
            this.JNDI_NAME_PROP = "jndi-name";
            this.b2ss = new ConcurrentHashMap<Long, Collection<ServiceRegistration>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference reference) {
            OSGiApplicationInfo osgiApplicationInfo = (OSGiApplicationInfo)OSGiApplicationInfo.class.cast(this.context.getService(reference));
            String exportEJB = (String)osgiApplicationInfo.getBundle().getHeaders().get("Export-EJB");
            if (exportEJB != null) {
                exportEJB = exportEJB.trim();
                ApplicationInfo ai = osgiApplicationInfo.getAppInfo();
                Application app = (Application)ai.getMetaData(Application.class);
                Vector ejbs = app.getEjbDescriptors();
                logger.info("addingService: Found " + ejbs.size() + " no. of EJBs");
                AbstractList ejbsToBeExported = new ArrayList();
                if ("ALL".equals(exportEJB)) {
                    ejbsToBeExported = ejbs;
                } else {
                    StringTokenizer st = new StringTokenizer(exportEJB, ",");
                    while (st.hasMoreTokens()) {
                        String next = st.nextToken();
                        for (EjbDescriptor ejb : ejbs) {
                            if (!next.equals(ejb.getName())) continue;
                            ejbsToBeExported.add(ejb);
                        }
                    }
                }
                this.b2ss.put(osgiApplicationInfo.getBundle().getBundleId(), new ArrayList());
                ClassLoader oldTCC = this.switchTCC(osgiApplicationInfo);
                try {
                    for (EjbDescriptor ejb : ejbsToBeExported) {
                        this.registerEjbAsService(ejb, osgiApplicationInfo.getBundle());
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldTCC);
                }
            }
            return osgiApplicationInfo;
        }

        private ClassLoader switchTCC(OSGiApplicationInfo osgiApplicationInfo) {
            ClassLoader newTCC = osgiApplicationInfo.getClassLoader();
            Thread thread = Thread.currentThread();
            ClassLoader oldTCC = thread.getContextClassLoader();
            thread.setContextClassLoader(newTCC);
            return oldTCC;
        }

        private void registerEjbAsService(EjbDescriptor ejb, Bundle bundle) {
            block7: {
                System.out.println(ejb);
                try {
                    if ("Session".equals(ejb.getType())) {
                        EjbSessionDescriptor sessionBean = (EjbSessionDescriptor)EjbSessionDescriptor.class.cast(ejb);
                        if ("Stateful".equals(sessionBean.getSessionType())) {
                            logger.warning("Stateful session bean can't be registered as OSGi service");
                            break block7;
                        }
                        BundleContext ejbBundleContext = bundle.getBundleContext();
                        for (String lbi : sessionBean.getLocalBusinessClassNames()) {
                            String jndiName = sessionBean.getPortableJndiName(lbi);
                            Object service = null;
                            try {
                                service = OSGiEJBDeployer.this.ic.lookup(jndiName);
                            }
                            catch (NamingException e) {
                                e.printStackTrace();
                            }
                            Properties props = new Properties();
                            props.put("jndi-name", jndiName);
                            this.reg = ejbBundleContext.registerService(lbi, service, (Dictionary)props);
                            this.b2ss.get(bundle.getBundleId()).add(this.reg);
                        }
                        break block7;
                    }
                    logger.warning("Only stateless bean or singleton beans can be registered as OSGi service");
                }
                catch (Exception e) {
                    logger.logp(Level.SEVERE, "OSGiEJBDeployer$EJBTracker", "registerEjbAsService", "Exception registering service for ejb by name", e);
                }
            }
        }

        public void removedService(ServiceReference reference, Object service) {
            OSGiApplicationInfo osgiApplicationInfo = (OSGiApplicationInfo)OSGiApplicationInfo.class.cast(service);
            ApplicationInfo ai = osgiApplicationInfo.getAppInfo();
            Application app = (Application)ai.getMetaData(Application.class);
            Vector ejbs = app.getEjbDescriptors();
            logger.info("removedService: Found " + ejbs.size() + " no. of EJBs");
            Collection<ServiceRegistration> regs = this.b2ss.get(osgiApplicationInfo.getBundle().getBundleId());
            if (regs != null) {
                for (ServiceRegistration reg : regs) {
                    if (reg == null) continue;
                    try {
                        reg.unregister();
                    }
                    catch (Exception e) {
                        logger.logp(Level.FINE, "OSGiEJBDeployer$EJBTracker", "removedService", "Exception unregistering " + reg, e);
                    }
                }
            }
            super.removedService(reference, service);
        }
    }
}

