/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs;

import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaSymbols;
import com.sun.org.apache.xerces.internal.impl.xs.SubstitutionGroupHandler;
import com.sun.org.apache.xerces.internal.impl.xs.XSAnnotationImpl;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.util.NSItemListImpl;
import com.sun.org.apache.xerces.internal.impl.xs.util.StringListImpl;
import com.sun.org.apache.xerces.internal.impl.xs.util.XSNamedMap4Types;
import com.sun.org.apache.xerces.internal.impl.xs.util.XSNamedMapImpl;
import com.sun.org.apache.xerces.internal.impl.xs.util.XSObjectListImpl;
import com.sun.org.apache.xerces.internal.util.SymbolHash;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xs.StringList;
import com.sun.org.apache.xerces.internal.xs.XSAttributeDeclaration;
import com.sun.org.apache.xerces.internal.xs.XSAttributeGroupDefinition;
import com.sun.org.apache.xerces.internal.xs.XSElementDeclaration;
import com.sun.org.apache.xerces.internal.xs.XSModel;
import com.sun.org.apache.xerces.internal.xs.XSModelGroupDefinition;
import com.sun.org.apache.xerces.internal.xs.XSNamedMap;
import com.sun.org.apache.xerces.internal.xs.XSNamespaceItemList;
import com.sun.org.apache.xerces.internal.xs.XSNotationDeclaration;
import com.sun.org.apache.xerces.internal.xs.XSObject;
import com.sun.org.apache.xerces.internal.xs.XSObjectList;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;
import java.util.Vector;

public class XSModelImpl
implements XSModel {
    private static final short MAX_COMP_IDX = 14;
    private static final boolean[] GLOBAL_COMP = new boolean[]{false, true, true, true, false, true, true, false, false, false, false, true, false, false, false, true, true};
    private int fGrammarCount;
    private String[] fNamespaces;
    private SchemaGrammar[] fGrammarList;
    private SymbolHash fGrammarMap;
    private SymbolHash fSubGroupMap;
    private XSNamedMap[] fGlobalComponents;
    private XSNamedMap[][] fNSComponents;
    private XSObjectListImpl fAnnotations = null;
    private boolean fHasIDC = false;

    public XSModelImpl(SchemaGrammar[] grammars) {
        int i;
        int len = grammars.length;
        this.fNamespaces = new String[Math.max(len + 1, 5)];
        this.fGrammarList = new SchemaGrammar[Math.max(len + 1, 5)];
        boolean hasS4S = false;
        for (int i2 = 0; i2 < len; ++i2) {
            this.fNamespaces[i2] = grammars[i2].getTargetNamespace();
            this.fGrammarList[i2] = grammars[i2];
            if (this.fNamespaces[i2] != SchemaSymbols.URI_SCHEMAFORSCHEMA) continue;
            hasS4S = true;
        }
        if (!hasS4S) {
            this.fNamespaces[len] = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            this.fGrammarList[len++] = SchemaGrammar.SG_SchemaNS;
        }
        for (i = 0; i < len; ++i) {
            int j;
            SchemaGrammar sg1 = this.fGrammarList[i];
            Vector gs = sg1.getImportedGrammars();
            int n = j = gs == null ? -1 : gs.size() - 1;
            while (j >= 0) {
                int k;
                SchemaGrammar sg2 = (SchemaGrammar)gs.elementAt(j);
                for (k = 0; k < len && sg2 != this.fGrammarList[k]; ++k) {
                }
                if (k == len) {
                    if (len == this.fGrammarList.length) {
                        String[] newSA = new String[len * 2];
                        System.arraycopy(this.fNamespaces, 0, newSA, 0, len);
                        this.fNamespaces = newSA;
                        SchemaGrammar[] newGA = new SchemaGrammar[len * 2];
                        System.arraycopy(this.fGrammarList, 0, newGA, 0, len);
                        this.fGrammarList = newGA;
                    }
                    this.fNamespaces[len] = sg2.getTargetNamespace();
                    this.fGrammarList[len] = sg2;
                    ++len;
                }
                --j;
            }
        }
        this.fGrammarMap = new SymbolHash(len * 2);
        for (i = 0; i < len; ++i) {
            this.fGrammarMap.put(XSModelImpl.null2EmptyString(this.fNamespaces[i]), this.fGrammarList[i]);
            if (!this.fGrammarList[i].hasIDConstraints()) continue;
            this.fHasIDC = true;
        }
        this.fGrammarCount = len;
        this.fGlobalComponents = new XSNamedMap[15];
        this.fNSComponents = new XSNamedMap[len][15];
        this.buildSubGroups();
    }

    private void buildSubGroups() {
        SubstitutionGroupHandler sgHandler = new SubstitutionGroupHandler(null);
        for (int i = 0; i < this.fGrammarCount; ++i) {
            sgHandler.addSubstitutionGroup(this.fGrammarList[i].getSubstitutionGroups());
        }
        XSNamedMap elements = this.getComponents((short)2);
        int len = elements.getLength();
        this.fSubGroupMap = new SymbolHash(len * 2);
        for (int i = 0; i < len; ++i) {
            XSElementDecl head = (XSElementDecl)elements.item(i);
            XSObject[] subGroup = sgHandler.getSubstitutionGroup(head);
            this.fSubGroupMap.put(head, new XSObjectListImpl(subGroup, subGroup.length));
        }
    }

    public StringList getNamespaces() {
        return new StringListImpl(this.fNamespaces, this.fGrammarCount);
    }

    public XSNamespaceItemList getNamespaceItems() {
        return new NSItemListImpl(this.fGrammarList, this.fGrammarCount);
    }

    public synchronized XSNamedMap getComponents(short objectType) {
        if (objectType <= 0 || objectType > 14 || !GLOBAL_COMP[objectType]) {
            return null;
        }
        SymbolHash[] tables = new SymbolHash[this.fGrammarCount];
        if (this.fGlobalComponents[objectType] == null) {
            block8: for (int i = 0; i < this.fGrammarCount; ++i) {
                switch (objectType) {
                    case 3: 
                    case 13: 
                    case 14: {
                        tables[i] = this.fGrammarList[i].fGlobalTypeDecls;
                        continue block8;
                    }
                    case 1: {
                        tables[i] = this.fGrammarList[i].fGlobalAttrDecls;
                        continue block8;
                    }
                    case 2: {
                        tables[i] = this.fGrammarList[i].fGlobalElemDecls;
                        continue block8;
                    }
                    case 5: {
                        tables[i] = this.fGrammarList[i].fGlobalAttrGrpDecls;
                        continue block8;
                    }
                    case 6: {
                        tables[i] = this.fGrammarList[i].fGlobalGroupDecls;
                        continue block8;
                    }
                    case 11: {
                        tables[i] = this.fGrammarList[i].fGlobalNotationDecls;
                    }
                }
            }
            this.fGlobalComponents[objectType] = objectType == 13 || objectType == 14 ? new XSNamedMap4Types(this.fNamespaces, tables, this.fGrammarCount, objectType) : new XSNamedMapImpl(this.fNamespaces, tables, this.fGrammarCount);
        }
        return this.fGlobalComponents[objectType];
    }

    public synchronized XSNamedMap getComponentsByNamespace(short objectType, String namespace) {
        int i;
        if (objectType <= 0 || objectType > 14 || !GLOBAL_COMP[objectType]) {
            return null;
        }
        for (i = 0; i < this.fGrammarCount && this.fNamespaces[i] != namespace; ++i) {
        }
        if (i == this.fGrammarCount) {
            return null;
        }
        if (this.fNSComponents[i][objectType] == null) {
            SymbolHash table = null;
            switch (objectType) {
                case 3: 
                case 13: 
                case 14: {
                    table = this.fGrammarList[i].fGlobalTypeDecls;
                    break;
                }
                case 1: {
                    table = this.fGrammarList[i].fGlobalAttrDecls;
                    break;
                }
                case 2: {
                    table = this.fGrammarList[i].fGlobalElemDecls;
                    break;
                }
                case 5: {
                    table = this.fGrammarList[i].fGlobalAttrGrpDecls;
                    break;
                }
                case 6: {
                    table = this.fGrammarList[i].fGlobalGroupDecls;
                    break;
                }
                case 11: {
                    table = this.fGrammarList[i].fGlobalNotationDecls;
                }
            }
            this.fNSComponents[i][objectType] = objectType == 13 || objectType == 14 ? new XSNamedMap4Types(namespace, table, objectType) : new XSNamedMapImpl(namespace, table);
        }
        return this.fNSComponents[i][objectType];
    }

    public XSTypeDefinition getTypeDefinition(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSTypeDefinition)sg.fGlobalTypeDecls.get(name);
    }

    public XSAttributeDeclaration getAttributeDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSAttributeDeclaration)sg.fGlobalAttrDecls.get(name);
    }

    public XSElementDeclaration getElementDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSElementDeclaration)sg.fGlobalElemDecls.get(name);
    }

    public XSAttributeGroupDefinition getAttributeGroup(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSAttributeGroupDefinition)sg.fGlobalAttrGrpDecls.get(name);
    }

    public XSModelGroupDefinition getModelGroupDefinition(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSModelGroupDefinition)sg.fGlobalGroupDecls.get(name);
    }

    public XSNotationDeclaration getNotationDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSNotationDeclaration)sg.fGlobalNotationDecls.get(name);
    }

    public synchronized XSObjectList getAnnotations() {
        if (this.fAnnotations != null) {
            return this.fAnnotations;
        }
        int totalAnnotations = 0;
        for (int i = 0; i < this.fGrammarCount; ++i) {
            totalAnnotations += this.fGrammarList[i].fNumAnnotations;
        }
        XSObject[] annotations = new XSAnnotationImpl[totalAnnotations];
        int currPos = 0;
        for (int i = 0; i < this.fGrammarCount; ++i) {
            SchemaGrammar currGrammar = this.fGrammarList[i];
            System.arraycopy(currGrammar.fAnnotations, 0, annotations, currPos, currGrammar.fNumAnnotations);
            currPos += currGrammar.fNumAnnotations;
        }
        this.fAnnotations = new XSObjectListImpl(annotations, annotations.length);
        return this.fAnnotations;
    }

    private static final String null2EmptyString(String str) {
        return str == null ? XMLSymbols.EMPTY_STRING : str;
    }

    public boolean hasIDConstraints() {
        return this.fHasIDC;
    }

    public XSObjectList getSubstitutionGroup(XSElementDeclaration head) {
        return (XSObjectList)this.fSubGroupMap.get(head);
    }
}

