/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.validation;

import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.dv.XSSimpleType;
import com.sun.org.apache.xerces.internal.impl.validation.ValidationManager;
import com.sun.org.apache.xerces.internal.impl.xs.XSMessageFormatter;
import com.sun.org.apache.xerces.internal.jaxp.validation.ErrorHandlerAdaptor;
import com.sun.org.apache.xerces.internal.jaxp.validation.InsulatedValidatorComponent;
import com.sun.org.apache.xerces.internal.jaxp.validation.WrappedSAXException;
import com.sun.org.apache.xerces.internal.jaxp.validation.XNI2SAXEx;
import com.sun.org.apache.xerces.internal.util.DraconianErrorHandler;
import com.sun.org.apache.xerces.internal.util.LocatorWrapper;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLAttributesImpl;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDocumentFilter;
import com.sun.org.apache.xerces.internal.xs.AttributePSVI;
import com.sun.org.apache.xerces.internal.xs.ElementPSVI;
import com.sun.org.apache.xerces.internal.xs.ItemPSVI;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

final class ValidatorHandlerImpl
extends ValidatorHandler {
    private final InsulatedValidatorComponent validator;
    private final XMLDocumentFilter validatorFilter;
    private final XNI2SAXEx xni2sax = new XNI2SAXEx();
    private final SymbolTable symbolTable = new SymbolTable();
    private final NamespaceSupport nsContext = new NamespaceSupport();
    private final ValidationManager validationManager = new ValidationManager();
    private final XMLEntityManager entityManager = new XMLEntityManager();
    private final XMLErrorReporter errorReporter = new XMLErrorReporter();
    private ErrorHandler errorHandler;
    private boolean inStartElement;
    private boolean namespacePrefixesFeature = false;
    private final ErrorHandlerAdaptor xercesErrorHandler = new ErrorHandlerAdaptor(){

        protected ErrorHandler getErrorHandler() {
            if (ValidatorHandlerImpl.this.errorHandler == null) {
                return DraconianErrorHandler.theInstance;
            }
            return ValidatorHandlerImpl.this.errorHandler;
        }
    };
    private LSResourceResolver resourceResolver;
    private final XMLComponentManager manager = new XMLComponentManager(){

        public Object getProperty(String propName) {
            if (propName.equals("http://apache.org/xml/properties/internal/symbol-table")) {
                return ValidatorHandlerImpl.this.symbolTable;
            }
            if (propName.equals("http://apache.org/xml/properties/internal/validation-manager")) {
                return ValidatorHandlerImpl.this.validationManager;
            }
            if (propName.equals("http://apache.org/xml/properties/internal/error-reporter")) {
                return ValidatorHandlerImpl.this.errorReporter;
            }
            if (propName.equals("http://apache.org/xml/properties/internal/error-handler")) {
                return ValidatorHandlerImpl.this.xercesErrorHandler;
            }
            if (propName.equals("http://apache.org/xml/properties/internal/entity-manager")) {
                return ValidatorHandlerImpl.this.entityManager;
            }
            if (propName.equals("http://apache.org/xml/properties/internal/entity-resolver")) {
                return ValidatorHandlerImpl.this.entityManager;
            }
            throw new XMLConfigurationException(0, propName);
        }

        public boolean getFeature(String propName) {
            if (propName.equals("http://xml.org/sax/features/validation")) {
                return true;
            }
            throw new XMLConfigurationException(0, propName);
        }
    };
    private Locator locator;
    private final TypeInfoProvider typeInfoProvider = new TypeInfoProvider(){

        private void checkState() {
            if (!ValidatorHandlerImpl.this.inStartElement) {
                throw new IllegalStateException();
            }
        }

        public TypeInfo getAttributeTypeInfo(int index) {
            this.checkState();
            return this.getAttributeType(index);
        }

        private XSTypeDefinition getAttributeType(int index) {
            this.checkState();
            XMLAttributes atts = ValidatorHandlerImpl.this.getCurrentAttributes();
            if (index < 0 || atts.getLength() <= index) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            Augmentations augs = atts.getAugmentations(index);
            if (augs == null) {
                return null;
            }
            AttributePSVI psvi = (AttributePSVI)augs.getItem("ATTRIBUTE_PSVI");
            return this.getTypeInfoFromPSVI(psvi);
        }

        public TypeInfo getAttributeTypeInfo(String attributeUri, String attributeLocalName) {
            this.checkState();
            return this.getAttributeTypeInfo(ValidatorHandlerImpl.this.getCurrentAttributes().getIndex(attributeUri, attributeLocalName));
        }

        public TypeInfo getAttributeTypeInfo(String attributeQName) {
            this.checkState();
            return this.getAttributeTypeInfo(ValidatorHandlerImpl.this.getCurrentAttributes().getIndex(attributeQName));
        }

        public TypeInfo getElementTypeInfo() {
            this.checkState();
            Augmentations augs = ValidatorHandlerImpl.this.getCurrentAugmentation();
            if (augs == null) {
                return null;
            }
            ElementPSVI psvi = (ElementPSVI)augs.getItem("ELEMENT_PSVI");
            return this.getTypeInfoFromPSVI(psvi);
        }

        private XSTypeDefinition getTypeInfoFromPSVI(ItemPSVI psvi) {
            XSTypeDefinition t;
            if (psvi == null) {
                return null;
            }
            if (psvi.getValidity() == 2 && (t = psvi.getMemberTypeDefinition()) != null) {
                return t;
            }
            t = psvi.getTypeDefinition();
            if (t != null) {
                return t;
            }
            return null;
        }

        public boolean isIdAttribute(int index) {
            this.checkState();
            XSSimpleType type = (XSSimpleType)this.getAttributeType(index);
            if (type == null) {
                return false;
            }
            return type.isIDType();
        }

        public boolean isSpecified(int index) {
            this.checkState();
            return ValidatorHandlerImpl.this.getCurrentAttributes().isSpecified(index);
        }
    };
    private final XMLAttributes xa = new XMLAttributesImpl();

    ValidatorHandlerImpl(InsulatedValidatorComponent validator) {
        this.validator = validator;
        this.validatorFilter = validator.getValidator();
        this.errorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
    }

    private final Augmentations getCurrentAugmentation() {
        return this.xni2sax.getCurrentAugmentation();
    }

    private final XMLAttributes getCurrentAttributes() {
        return this.xni2sax.getCurrentAttributes();
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return this.namespacePrefixesFeature;
        }
        return super.getFeature(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this.namespacePrefixesFeature = value;
            return;
        }
        super.setFeature(name, value);
    }

    public boolean isValidSoFar() {
        return !this.xercesErrorHandler.hadError();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setResourceResolver(LSResourceResolver entityResolver) {
        this.resourceResolver = entityResolver;
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public final void setContentHandler(ContentHandler result) {
        this.xni2sax.setContentHandler(result);
        if (result == null) {
            this.validatorFilter.setDocumentHandler(null);
        } else {
            this.validatorFilter.setDocumentHandler(this.xni2sax);
        }
    }

    public final ContentHandler getContentHandler() {
        return this.xni2sax.getContentHandler();
    }

    public void startDocument() throws SAXException {
        try {
            this.resetComponents();
            LocatorWrapper xmlLocator = this.locator == null ? null : new LocatorWrapper(this.locator);
            this.errorReporter.setDocumentLocator(xmlLocator);
            this.validatorFilter.startDocument(xmlLocator, null, this.nsContext, null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    private void resetComponents() {
        this.xercesErrorHandler.reset();
        this.nsContext.reset();
        this.errorReporter.reset(this.manager);
        this.validator.reset(this.manager);
    }

    public void endDocument() throws SAXException {
        try {
            this.validatorFilter.endDocument(null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    public void startElement(String uri, String local, String qname, Attributes att) throws SAXException {
        try {
            this.inStartElement = true;
            this.validatorFilter.startElement(this.createQName(uri, local, qname), this.createAttributes(att), null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
        finally {
            this.inStartElement = false;
        }
    }

    public void endElement(String uri, String local, String qname) throws SAXException {
        try {
            this.validatorFilter.endElement(this.createQName(uri, local, qname), null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        try {
            this.validatorFilter.characters(new XMLString(buf, offset, len), null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        try {
            this.validatorFilter.ignorableWhitespace(new XMLString(buf, offset, len), null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.nsContext.pushContext();
        this.nsContext.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.nsContext.popContext();
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.validatorFilter.processingInstruction(this.symbolize(target), this.createXMLString(data), null);
        }
        catch (WrappedSAXException e) {
            throw e.exception;
        }
    }

    public void skippedEntity(String name) {
        ContentHandler handler = this.getContentHandler();
        if (handler != null) {
            this.skippedEntity(name);
        }
    }

    public void setDocumentLocator(Locator _loc) {
        this.locator = _loc;
    }

    public TypeInfoProvider getTypeInfoProvider() {
        return this.typeInfoProvider;
    }

    private String symbolize(String s) {
        if (s == null) {
            return null;
        }
        return this.symbolTable.addSymbol(s);
    }

    private QName createQName(String uri, String local, String raw) {
        int idx;
        if (local.length() == 0) {
            uri = "";
            local = raw;
        }
        String prefix = (idx = raw.indexOf(58)) < 0 ? null : raw.substring(0, idx);
        if (uri != null && uri.length() == 0) {
            uri = null;
        }
        return new QName(this.symbolize(prefix), this.symbolize(local), this.symbolize(raw), this.symbolize(uri));
    }

    private XMLAttributes createAttributes(Attributes att) {
        this.xa.removeAllAttributes();
        int len = att.getLength();
        for (int i = 0; i < len; ++i) {
            int idx = this.xa.addAttribute(this.createQName(att.getURI(i), att.getLocalName(i), att.getQName(i)), att.getType(i), att.getValue(i));
            this.xa.setSpecified(idx, true);
        }
        return this.xa;
    }

    private XMLString createXMLString(String str) {
        return new XMLString(str.toCharArray(), 0, str.length());
    }

    public void reset() {
        this.resetComponents();
        this.errorHandler = null;
        this.resourceResolver = null;
    }
}

