/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.validation.xs;

import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaLoader;
import com.sun.org.apache.xerces.internal.impl.xs.XSMessageFormatter;
import com.sun.org.apache.xerces.internal.jaxp.validation.ReadonlyGrammarPool;
import com.sun.org.apache.xerces.internal.jaxp.validation.Util;
import com.sun.org.apache.xerces.internal.jaxp.validation.xs.SchemaImpl;
import com.sun.org.apache.xerces.internal.util.DOMEntityResolverWrapper;
import com.sun.org.apache.xerces.internal.util.ErrorHandlerWrapper;
import com.sun.org.apache.xerces.internal.util.SAXMessageFormatter;
import com.sun.org.apache.xerces.internal.util.SecurityManager;
import com.sun.org.apache.xerces.internal.util.XMLGrammarPoolImpl;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarDescription;
import java.io.IOException;
import java.util.Locale;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class SchemaFactoryImpl
extends SchemaFactory {
    private final XMLSchemaLoader loader = new XMLSchemaLoader();
    private static XSMessageFormatter messageFormatter = new XSMessageFormatter();
    private ErrorHandler errorHandler;
    private LSResourceResolver resourceResolver;
    private SAXParseException lastException;
    private final SecurityManager secureProcessing = new SecurityManager();
    private boolean enableSP;

    public SchemaFactoryImpl() {
        this.loader.setErrorHandler(new ErrorHandlerWrapper(new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
                if (SchemaFactoryImpl.this.errorHandler != null) {
                    SchemaFactoryImpl.this.errorHandler.warning(exception);
                }
            }

            public void error(SAXParseException exception) throws SAXException {
                SchemaFactoryImpl.this.lastException = exception;
                if (SchemaFactoryImpl.this.errorHandler == null) {
                    throw exception;
                }
                SchemaFactoryImpl.this.errorHandler.error(exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                SchemaFactoryImpl.this.lastException = exception;
                if (SchemaFactoryImpl.this.errorHandler == null) {
                    throw exception;
                }
                SchemaFactoryImpl.this.errorHandler.fatalError(exception);
            }
        }));
    }

    public boolean isSchemaLanguageSupported(String schemaLanguage) {
        if (schemaLanguage == null) {
            throw new NullPointerException(messageFormatter.formatMessage(Locale.getDefault(), "SchemaLanguageSupportedErrorWhenNull", new Object[]{this.getClass().getName()}));
        }
        if (schemaLanguage.length() == 0) {
            throw new IllegalArgumentException(messageFormatter.formatMessage(Locale.getDefault(), "SchemaLanguageSupportedErrorWhenLength", new Object[]{this.getClass().getName()}));
        }
        return schemaLanguage.equals("http://www.w3.org/2001/XMLSchema") || schemaLanguage.equals("http://relaxng.org/ns/structure/1.0");
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        this.loader.setEntityResolver(new DOMEntityResolverWrapper(resourceResolver));
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Schema newSchema(Source[] schemas) throws SAXException {
        this.lastException = null;
        XMLGrammarPoolImpl pool = new XMLGrammarPoolImpl();
        this.loader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", pool);
        this.loader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        if (this.enableSP) {
            this.loader.setProperty("http://apache.org/xml/properties/security-manager", this.secureProcessing);
        } else {
            this.loader.setProperty("http://apache.org/xml/properties/security-manager", null);
        }
        for (int i = 0; i < schemas.length; ++i) {
            try {
                this.loader.loadGrammar(schemas[i]);
                continue;
            }
            catch (XNIException e) {
                throw Util.toSAXException(e);
            }
            catch (IOException e) {
                SAXParseException se = new SAXParseException(e.getMessage(), null, e);
                this.errorHandler.error(se);
                throw se;
            }
        }
        if (this.lastException != null) {
            throw this.lastException;
        }
        return new SchemaImpl(new ReadonlyGrammarPool(pool), true);
    }

    public Schema newSchema() throws SAXException {
        return new SchemaImpl(new XMLGrammarPoolImpl(){

            public boolean equals(XMLGrammarDescription desc1, XMLGrammarDescription desc2) {
                String sid1 = desc1.getExpandedSystemId();
                String sid2 = desc2.getExpandedSystemId();
                if (sid1 != null && sid2 != null) {
                    return sid1.equals(sid2);
                }
                return sid1 == null && sid2 == null;
            }

            public int hashCode(XMLGrammarDescription desc) {
                String s = desc.getExpandedSystemId();
                if (s != null) {
                    return s.hashCode();
                }
                return 0;
            }
        }, false);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException(SAXMessageFormatter.formatMessage(Locale.getDefault(), "nullparameter", new Object[]{"setFeature(String,boolean)"}));
        }
        if (!name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), "feature-not-supported", new Object[]{name}));
        }
        this.enableSP = value;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException(SAXMessageFormatter.formatMessage(Locale.getDefault(), "nullparameter", new Object[]{"getFeature(String)"}));
        }
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.enableSP;
        }
        throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), "feature-not-supported", new Object[]{name}));
    }
}

