/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.dom.DOMErrorImpl;
import com.sun.org.apache.xerces.internal.dom.DOMLocatorImpl;
import com.sun.org.apache.xerces.internal.util.XMLErrorCode;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLErrorHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParseException;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;
import org.w3c.dom.Node;

public class DOMErrorHandlerWrapper
implements XMLErrorHandler,
DOMErrorHandler {
    private static Hashtable fgDOMErrorTypeTable = new Hashtable();
    protected DOMErrorHandler fDomErrorHandler;
    boolean eStatus = true;
    protected PrintWriter fOut;
    public Node fCurrentNode;
    protected final XMLErrorCode fErrorCode = new XMLErrorCode(null, null);
    protected final DOMErrorImpl fDOMError = new DOMErrorImpl();

    public DOMErrorHandlerWrapper() {
        this.fOut = new PrintWriter(System.err);
    }

    public DOMErrorHandlerWrapper(DOMErrorHandler domErrorHandler) {
        this.fDomErrorHandler = domErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler errorHandler) {
        this.fDomErrorHandler = errorHandler;
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fDomErrorHandler;
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        this.fDOMError.fSeverity = 1;
        this.fDOMError.fException = exception;
        this.fDOMError.fType = key;
        this.fDOMError.fMessage = exception.getMessage();
        this.fDOMError.fRelatedData = this.fDOMError.fMessage;
        DOMLocatorImpl locator = this.fDOMError.fLocator;
        if (locator != null) {
            locator.fColumnNumber = exception.getColumnNumber();
            locator.fLineNumber = exception.getLineNumber();
            locator.fUri = exception.getExpandedSystemId();
            locator.fRelatedNode = this.fCurrentNode;
        }
        if (this.fDomErrorHandler != null) {
            this.fDomErrorHandler.handleError(this.fDOMError);
        }
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        this.fDOMError.fSeverity = (short)2;
        this.fDOMError.fException = exception;
        this.fDOMError.fType = key;
        this.fDOMError.fMessage = exception.getMessage();
        this.fDOMError.fRelatedData = this.fDOMError.fMessage;
        DOMLocatorImpl locator = this.fDOMError.fLocator;
        if (locator != null) {
            locator.fColumnNumber = exception.getColumnNumber();
            locator.fLineNumber = exception.getLineNumber();
            locator.fUri = exception.getExpandedSystemId();
            locator.fRelatedNode = this.fCurrentNode;
        }
        if (this.fDomErrorHandler != null) {
            this.fDomErrorHandler.handleError(this.fDOMError);
        }
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        this.fDOMError.fSeverity = (short)3;
        this.fDOMError.fException = exception;
        this.fErrorCode.setValues(domain, key);
        String domErrorType = (String)fgDOMErrorTypeTable.get(this.fErrorCode);
        this.fDOMError.fType = domErrorType != null ? domErrorType : key;
        this.fDOMError.fMessage = exception.getMessage();
        this.fDOMError.fRelatedData = this.fDOMError.fMessage;
        DOMLocatorImpl locator = this.fDOMError.fLocator;
        if (locator != null) {
            locator.fColumnNumber = exception.getColumnNumber();
            locator.fLineNumber = exception.getLineNumber();
            locator.fUri = exception.getExpandedSystemId();
            locator.fRelatedNode = this.fCurrentNode;
        }
        if (this.fDomErrorHandler != null) {
            this.fDomErrorHandler.handleError(this.fDOMError);
        }
    }

    public boolean handleError(DOMError error) {
        this.printError(error);
        return this.eStatus;
    }

    private void printError(DOMError error) {
        short severity = error.getSeverity();
        this.fOut.print("[");
        if (severity == 1) {
            this.fOut.print("Warning");
        } else if (severity == 2) {
            this.fOut.print("Error");
        } else {
            this.fOut.print("FatalError");
            this.eStatus = false;
        }
        this.fOut.print("] ");
        DOMLocator locator = error.getLocation();
        if (locator != null) {
            String systemId;
            this.fOut.print(locator.getLineNumber());
            this.fOut.print(":");
            this.fOut.print(locator.getColumnNumber());
            this.fOut.print(":");
            this.fOut.print(locator.getByteOffset());
            this.fOut.print(",");
            this.fOut.print(locator.getUtf16Offset());
            Node node = locator.getRelatedNode();
            if (node != null) {
                this.fOut.print("[");
                this.fOut.print(node.getNodeName());
                this.fOut.print("]");
            }
            if ((systemId = locator.getUri()) != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                this.fOut.print(": ");
                this.fOut.print(systemId);
            }
        }
        this.fOut.print(":");
        this.fOut.print(error.getMessage());
        this.fOut.println();
        this.fOut.flush();
    }

    static {
        fgDOMErrorTypeTable.put(new XMLErrorCode("http://www.w3.org/TR/1998/REC-xml-19980210", "DoctypeNotAllowed"), "doctype-not-allowed");
        fgDOMErrorTypeTable.put(new XMLErrorCode("http://www.w3.org/TR/1998/REC-xml-19980210", "ElementUnterminated"), "wf-invalid-character-in-node-name");
        fgDOMErrorTypeTable.put(new XMLErrorCode("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid"), "unsupported-encoding");
        fgDOMErrorTypeTable.put(new XMLErrorCode("http://www.w3.org/TR/1998/REC-xml-19980210", "EqRequiredInAttribute"), "wf-invalid-character-in-node-name");
        fgDOMErrorTypeTable.put(new XMLErrorCode("http://www.w3.org/TR/1998/REC-xml-19980210", "LessthanInAttValue"), "wf-invalid-character");
    }
}

