/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.gms.tools;

import com.sun.enterprise.gms.tools.MulticastTester;
import com.sun.enterprise.gms.tools.StringManager;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class MulticastSenderThread
extends Thread {
    static final StringManager sm = StringManager.getInstance();
    volatile boolean done = false;
    int mcPort;
    String mcAddress;
    String bindInterface;
    int ttl;
    long msgPeriodInMillis;
    boolean debug;
    String dataString;

    public MulticastSenderThread(int mcPort, String mcAddress, String bindInterface, int ttl, long msgPeriodInMillis, boolean debug, String dataString) {
        super("McastSender");
        this.mcPort = mcPort;
        this.mcAddress = mcAddress;
        this.bindInterface = bindInterface;
        this.ttl = ttl;
        this.msgPeriodInMillis = msgPeriodInMillis;
        this.debug = debug;
        this.dataString = dataString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block26: {
            DatagramSocket socket;
            InetAddress group;
            block27: {
                group = null;
                socket = null;
                byte[] data = this.dataString.getBytes();
                group = InetAddress.getByName(this.mcAddress);
                DatagramPacket datagramPacket = new DatagramPacket(data, data.length, group, this.mcPort);
                socket = new MulticastSocket(this.mcPort);
                if (this.bindInterface != null) {
                    ((MulticastSocket)socket).setInterface(InetAddress.getByName(this.bindInterface));
                }
                if (this.ttl != -1) {
                    try {
                        ((MulticastSocket)socket).setTimeToLive(this.ttl);
                    }
                    catch (Exception e) {
                        System.err.println(sm.get("could.not.set.ttl", e.getLocalizedMessage()));
                    }
                } else {
                    try {
                        int defaultTTL = ((MulticastSocket)socket).getTimeToLive();
                        if (defaultTTL < 4) {
                            this.log(String.format("The default TTL for the socket is %d. Setting it to minimum %d instead.", defaultTTL, 4));
                            ((MulticastSocket)socket).setTimeToLive(4);
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                this.log("setting loopback mode false on mcast socket");
                ((MulticastSocket)socket).setLoopbackMode(false);
                try {
                    this.log(String.format("socket time to live set to %s", ((MulticastSocket)socket).getTimeToLive()));
                }
                catch (IOException ioe) {
                    this.log(ioe.getLocalizedMessage());
                }
                this.log(String.format("joining group: %s", group.toString()));
                ((MulticastSocket)socket).joinGroup(group);
                if (!this.debug) {
                    this.dataString = MulticastTester.trimDataString(this.dataString);
                }
                System.out.println(sm.get("sending.message", this.dataString, this.msgPeriodInMillis));
                while (!this.done) {
                    socket.send(datagramPacket);
                    try {
                        Thread.sleep(this.msgPeriodInMillis);
                    }
                    catch (InterruptedException ie) {
                        this.log("interrupted");
                        break;
                    }
                }
                if (socket == null) break block26;
                if (group == null) break block27;
                this.log("socket leaving group");
                try {
                    ((MulticastSocket)socket).leaveGroup(group);
                }
                catch (IOException ioe) {
                    System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                }
            }
            this.log("closing socket");
            socket.close();
            break block26;
            catch (Exception e) {
                block28: {
                    try {
                        System.err.println(sm.get("whoops", e.toString()));
                        if (socket == null) break block26;
                        if (group == null) break block28;
                        this.log("socket leaving group");
                    }
                    catch (Throwable throwable) {
                        if (socket != null) {
                            if (group != null) {
                                this.log("socket leaving group");
                                try {
                                    ((MulticastSocket)socket).leaveGroup(group);
                                }
                                catch (IOException ioe) {
                                    System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                                }
                            }
                            this.log("closing socket");
                            socket.close();
                        }
                        throw throwable;
                    }
                    try {
                        ((MulticastSocket)socket).leaveGroup(group);
                    }
                    catch (IOException ioe) {
                        System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                    }
                }
                this.log("closing socket");
                socket.close();
            }
        }
    }

    private void log(String msg) {
        if (this.debug) {
            System.err.println(String.format("%s: %s", this.getName(), msg));
        }
    }
}

