/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.JAssignment;
import com.sun.codemodel.internal.JAssignmentTarget;
import com.sun.codemodel.internal.JBreak;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JConditional;
import com.sun.codemodel.internal.JContinue;
import com.sun.codemodel.internal.JDeclaration;
import com.sun.codemodel.internal.JDoLoop;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JForEach;
import com.sun.codemodel.internal.JForLoop;
import com.sun.codemodel.internal.JFormatter;
import com.sun.codemodel.internal.JGenerable;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JLabel;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JMods;
import com.sun.codemodel.internal.JReturn;
import com.sun.codemodel.internal.JStatement;
import com.sun.codemodel.internal.JSwitch;
import com.sun.codemodel.internal.JThrow;
import com.sun.codemodel.internal.JTryBlock;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import com.sun.codemodel.internal.JWhileLoop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBlock
implements JGenerable,
JStatement {
    private final List<Object> content = new ArrayList<Object>();
    private boolean bracesRequired = true;
    private boolean indentRequired = true;
    private int pos;

    public JBlock() {
        this(true, true);
    }

    public JBlock(boolean bl, boolean bl2) {
        this.bracesRequired = bl;
        this.indentRequired = bl2;
    }

    public List<Object> getContents() {
        return Collections.unmodifiableList(this.content);
    }

    private <T> T insert(T t) {
        this.content.add(this.pos, t);
        ++this.pos;
        return t;
    }

    public int pos() {
        return this.pos;
    }

    public int pos(int n) {
        int n2 = this.pos;
        if (n > this.content.size() || n < 0) {
            throw new IllegalArgumentException();
        }
        this.pos = n;
        return n2;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public JVar decl(JType jType, String string) {
        return this.decl(0, jType, string, null);
    }

    public JVar decl(JType jType, String string, JExpression jExpression) {
        return this.decl(0, jType, string, jExpression);
    }

    public JVar decl(int n, JType jType, String string, JExpression jExpression) {
        JVar jVar = new JVar(JMods.forVar(n), jType, string, jExpression);
        this.insert(jVar);
        this.bracesRequired = true;
        this.indentRequired = true;
        return jVar;
    }

    public JBlock assign(JAssignmentTarget jAssignmentTarget, JExpression jExpression) {
        this.insert(new JAssignment(jAssignmentTarget, jExpression));
        return this;
    }

    public JBlock assignPlus(JAssignmentTarget jAssignmentTarget, JExpression jExpression) {
        this.insert(new JAssignment(jAssignmentTarget, jExpression, "+"));
        return this;
    }

    public JInvocation invoke(JExpression jExpression, String string) {
        JInvocation jInvocation = new JInvocation(jExpression, string);
        this.insert(jInvocation);
        return jInvocation;
    }

    public JInvocation invoke(JExpression jExpression, JMethod jMethod) {
        return this.insert(new JInvocation(jExpression, jMethod));
    }

    public JInvocation staticInvoke(JClass jClass, String string) {
        return this.insert(new JInvocation(jClass, string));
    }

    public JInvocation invoke(String string) {
        return this.insert(new JInvocation((JExpression)null, string));
    }

    public JInvocation invoke(JMethod jMethod) {
        return this.insert(new JInvocation((JExpression)null, jMethod));
    }

    public JBlock add(JStatement jStatement) {
        this.insert(jStatement);
        return this;
    }

    public JConditional _if(JExpression jExpression) {
        return this.insert(new JConditional(jExpression));
    }

    public JForLoop _for() {
        return this.insert(new JForLoop());
    }

    public JWhileLoop _while(JExpression jExpression) {
        return this.insert(new JWhileLoop(jExpression));
    }

    public JSwitch _switch(JExpression jExpression) {
        return this.insert(new JSwitch(jExpression));
    }

    public JDoLoop _do(JExpression jExpression) {
        return this.insert(new JDoLoop(jExpression));
    }

    public JTryBlock _try() {
        return this.insert(new JTryBlock());
    }

    public void _return() {
        this.insert(new JReturn(null));
    }

    public void _return(JExpression jExpression) {
        this.insert(new JReturn(jExpression));
    }

    public void _throw(JExpression jExpression) {
        this.insert(new JThrow(jExpression));
    }

    public void _break() {
        this._break(null);
    }

    public void _break(JLabel jLabel) {
        this.insert(new JBreak(jLabel));
    }

    public JLabel label(String string) {
        JLabel jLabel = new JLabel(string);
        this.insert(jLabel);
        return jLabel;
    }

    public void _continue(JLabel jLabel) {
        this.insert(new JContinue(jLabel));
    }

    public void _continue() {
        this._continue(null);
    }

    public JBlock block() {
        JBlock jBlock = new JBlock();
        jBlock.bracesRequired = false;
        jBlock.indentRequired = false;
        return this.insert(jBlock);
    }

    public JStatement directStatement(final String string) {
        JStatement jStatement = new JStatement(){

            public void state(JFormatter jFormatter) {
                jFormatter.p(string).nl();
            }
        };
        this.add(jStatement);
        return jStatement;
    }

    @Override
    public void generate(JFormatter jFormatter) {
        if (this.bracesRequired) {
            jFormatter.p('{').nl();
        }
        if (this.indentRequired) {
            jFormatter.i();
        }
        this.generateBody(jFormatter);
        if (this.indentRequired) {
            jFormatter.o();
        }
        if (this.bracesRequired) {
            jFormatter.p('}');
        }
    }

    void generateBody(JFormatter jFormatter) {
        for (Object object : this.content) {
            if (object instanceof JDeclaration) {
                jFormatter.d((JDeclaration)object);
                continue;
            }
            jFormatter.s((JStatement)object);
        }
    }

    public JForEach forEach(JType jType, String string, JExpression jExpression) {
        return this.insert(new JForEach(jType, string, jExpression));
    }

    @Override
    public void state(JFormatter jFormatter) {
        jFormatter.g(this);
        if (this.bracesRequired) {
            jFormatter.nl();
        }
    }
}

