/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal.writer;

import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JPackage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class FileCodeWriter
extends CodeWriter {
    private final File target;
    private final boolean readOnly;
    private final Set<File> readonlyFiles = new HashSet<File>();

    public FileCodeWriter(File file) throws IOException {
        this(file, false);
    }

    public FileCodeWriter(File file, boolean bl) throws IOException {
        this.target = file;
        this.readOnly = bl;
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException(file + ": non-existent directory");
        }
    }

    public OutputStream openBinary(JPackage jPackage, String string) throws IOException {
        return new FileOutputStream(this.getFile(jPackage, string));
    }

    protected File getFile(JPackage jPackage, String string) throws IOException {
        File file;
        File file2 = jPackage.isUnnamed() ? this.target : new File(this.target, FileCodeWriter.toDirName(jPackage));
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if ((file = new File(file2, string)).exists() && !file.delete()) {
            throw new IOException(file + ": Can't delete previous version");
        }
        if (this.readOnly) {
            this.readonlyFiles.add(file);
        }
        return file;
    }

    public void close() throws IOException {
        for (File file : this.readonlyFiles) {
            file.setReadOnly();
        }
    }

    private static String toDirName(JPackage jPackage) {
        return jPackage.name().replace('.', File.separatorChar);
    }
}

