/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SourceToHTMLConverter {
    protected static final String BGCOLOR = "white";
    protected static final String LINE_NO_COLOR = "green";
    protected static final int NUM_BLANK_LINES = 60;

    private SourceToHTMLConverter() {
    }

    public static void convertRoot(Configuration configuration, RootDoc rootDoc, String string) {
        if (rootDoc == null || string == null) {
            return;
        }
        PackageDoc[] packageDocArray = rootDoc.specifiedPackages();
        for (int i = 0; i < packageDocArray.length; ++i) {
            SourceToHTMLConverter.convertPackage(configuration, packageDocArray[i], string);
        }
        ClassDoc[] classDocArray = rootDoc.specifiedClasses();
        for (int i = 0; i < classDocArray.length; ++i) {
            SourceToHTMLConverter.convertClass(configuration, classDocArray[i], SourceToHTMLConverter.getPackageOutputDir(string, classDocArray[i].containingPackage()));
        }
    }

    public static void convertPackage(Configuration configuration, PackageDoc packageDoc, String string) {
        if (packageDoc == null || string == null) {
            return;
        }
        String string2 = SourceToHTMLConverter.getPackageOutputDir(string, packageDoc);
        ClassDoc[] classDocArray = packageDoc.allClasses();
        for (int i = 0; i < classDocArray.length; ++i) {
            SourceToHTMLConverter.convertClass(configuration, classDocArray[i], string2);
        }
    }

    private static String getPackageOutputDir(String string, PackageDoc packageDoc) {
        return string + File.separator + DirectoryManager.getDirectoryPath(packageDoc) + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertClass(Configuration configuration, ClassDoc classDoc, String string) {
        File file;
        if (classDoc == null || string == null) {
            return;
        }
        SourcePosition sourcePosition = classDoc.position();
        if (sourcePosition == null || (file = sourcePosition.file()) == null) {
            return;
        }
        try {
            int n = 1;
            StringBuffer stringBuffer = new StringBuffer();
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            try {
                String string2;
                while ((string2 = lineNumberReader.readLine()) != null) {
                    stringBuffer.append(SourceToHTMLConverter.formatLine(string2, configuration.sourcetab, n));
                    ++n;
                }
            }
            finally {
                lineNumberReader.close();
            }
            stringBuffer = SourceToHTMLConverter.addLineNumbers(stringBuffer.toString());
            stringBuffer.insert(0, SourceToHTMLConverter.getHeader());
            stringBuffer.append(SourceToHTMLConverter.getFooter());
            SourceToHTMLConverter.writeToFile(stringBuffer.toString(), string, classDoc.name(), configuration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void writeToFile(String string, String string2, String string3, Configuration configuration) throws IOException {
        File file = new File(string2);
        file.mkdirs();
        File file2 = new File(file, string3 + ".html");
        configuration.message.notice("doclet.Generating_0", file2.getPath());
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        bufferedWriter.write(string);
        bufferedWriter.close();
        fileOutputStream.close();
    }

    private static StringBuffer addLineNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        int n = 1;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2.equals("\n") ? SourceToHTMLConverter.getHTMLLineNo(n) + string2 : SourceToHTMLConverter.getHTMLLineNo(n) + string2 + stringTokenizer.nextToken());
            ++n;
        }
        return stringBuffer;
    }

    protected static String getHeader() {
        StringBuffer stringBuffer = new StringBuffer("<HTML>" + DocletConstants.NL);
        stringBuffer.append("<BODY BGCOLOR=\"white\">" + DocletConstants.NL);
        stringBuffer.append("<PRE>" + DocletConstants.NL);
        return stringBuffer.toString();
    }

    protected static String getFooter() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 60; ++i) {
            stringBuffer.append(DocletConstants.NL);
        }
        stringBuffer.append("</PRE>" + DocletConstants.NL + "</BODY>" + DocletConstants.NL + "</HTML>" + DocletConstants.NL);
        return stringBuffer.toString();
    }

    protected static String getHTMLLineNo(int n) {
        StringBuffer stringBuffer = new StringBuffer("<FONT color=\"green\">");
        if (n < 10) {
            stringBuffer.append("00" + new Integer(n).toString());
        } else if (n < 100) {
            stringBuffer.append("0" + new Integer(n).toString());
        } else {
            stringBuffer.append(new Integer(n).toString());
        }
        stringBuffer.append("</FONT>    ");
        return stringBuffer.toString();
    }

    protected static String formatLine(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(Util.escapeHtmlChars(string));
        stringBuffer.append("<a name=\"line." + Integer.toString(n2) + "\"></a>");
        stringBuffer.append(DocletConstants.NL);
        Util.replaceTabs(n, stringBuffer);
        return stringBuffer.toString();
    }

    protected static void addToHash(Doc[] docArray, HashMap hashMap) {
        if (docArray == null) {
            return;
        }
        for (int i = 0; i < docArray.length; ++i) {
            hashMap.put(new Integer(docArray[i].position().line()), SourceToHTMLConverter.getAnchor(docArray[i]));
        }
    }

    protected static String getAnchor(Doc doc) {
        return "    <a name=\"" + SourceToHTMLConverter.getAnchorName(doc) + "\"></a>";
    }

    public static String getAnchorName(Doc doc) {
        return "line." + doc.position().line();
    }
}

