/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc.apt;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.MirroredTypesException;
import com.sun.mirror.type.TypeMirror;
import com.sun.xml.internal.bind.v2.model.annotation.AbstractInlineAnnotationReaderImpl;
import com.sun.xml.internal.bind.v2.model.annotation.Locatable;
import com.sun.xml.internal.bind.v2.model.annotation.LocatableAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InlineAnnotationReaderImpl
extends AbstractInlineAnnotationReaderImpl<TypeMirror, TypeDeclaration, FieldDeclaration, MethodDeclaration> {
    public static final InlineAnnotationReaderImpl theInstance = new InlineAnnotationReaderImpl();
    private static final Annotation[] EMPTY_ANNOTATION = new Annotation[0];

    private InlineAnnotationReaderImpl() {
    }

    public <A extends Annotation> A getClassAnnotation(Class<A> clazz, TypeDeclaration typeDeclaration, Locatable locatable) {
        return (A)LocatableAnnotation.create(typeDeclaration.getAnnotation(clazz), (Locatable)locatable);
    }

    public <A extends Annotation> A getFieldAnnotation(Class<A> clazz, FieldDeclaration fieldDeclaration, Locatable locatable) {
        return (A)LocatableAnnotation.create(fieldDeclaration.getAnnotation(clazz), (Locatable)locatable);
    }

    public boolean hasFieldAnnotation(Class<? extends Annotation> clazz, FieldDeclaration fieldDeclaration) {
        return fieldDeclaration.getAnnotation(clazz) != null;
    }

    public boolean hasClassAnnotation(TypeDeclaration typeDeclaration, Class<? extends Annotation> clazz) {
        return typeDeclaration.getAnnotation(clazz) != null;
    }

    public Annotation[] getAllFieldAnnotations(FieldDeclaration fieldDeclaration, Locatable locatable) {
        return this.getAllAnnotations(fieldDeclaration, locatable);
    }

    public <A extends Annotation> A getMethodAnnotation(Class<A> clazz, MethodDeclaration methodDeclaration, Locatable locatable) {
        return (A)LocatableAnnotation.create(methodDeclaration.getAnnotation(clazz), (Locatable)locatable);
    }

    public boolean hasMethodAnnotation(Class<? extends Annotation> clazz, MethodDeclaration methodDeclaration) {
        return methodDeclaration.getAnnotation(clazz) != null;
    }

    public Annotation[] getAllMethodAnnotations(MethodDeclaration methodDeclaration, Locatable locatable) {
        return this.getAllAnnotations(methodDeclaration, locatable);
    }

    private Annotation[] getAllAnnotations(Declaration declaration, Locatable locatable) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (AnnotationMirror annotationMirror : declaration.getAnnotationMirrors()) {
            try {
                String string = annotationMirror.getAnnotationType().getDeclaration().getQualifiedName();
                Class<Annotation> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(string).asSubclass(Annotation.class);
                Annotation annotation2 = declaration.getAnnotation(clazz);
                if (annotation2 == null) continue;
                arrayList.add(LocatableAnnotation.create((Annotation)annotation2, (Locatable)locatable));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return arrayList.toArray(EMPTY_ANNOTATION);
    }

    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> clazz, MethodDeclaration methodDeclaration, int n, Locatable locatable) {
        ParameterDeclaration[] parameterDeclarationArray = methodDeclaration.getParameters().toArray(new ParameterDeclaration[0]);
        return (A)LocatableAnnotation.create(parameterDeclarationArray[n].getAnnotation(clazz), (Locatable)locatable);
    }

    public <A extends Annotation> A getPackageAnnotation(Class<A> clazz, TypeDeclaration typeDeclaration, Locatable locatable) {
        return (A)LocatableAnnotation.create(typeDeclaration.getPackage().getAnnotation(clazz), (Locatable)locatable);
    }

    public TypeMirror getClassValue(Annotation annotation2, String string) {
        try {
            annotation2.annotationType().getMethod(string, new Class[0]).invoke((Object)annotation2, new Object[0]);
            assert (false);
            throw new IllegalStateException("should throw a MirroredTypeException");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof MirroredTypeException) {
                MirroredTypeException mirroredTypeException = (MirroredTypeException)invocationTargetException.getCause();
                return mirroredTypeException.getTypeMirror();
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    public TypeMirror[] getClassArrayValue(Annotation annotation2, String string) {
        try {
            annotation2.annotationType().getMethod(string, new Class[0]).invoke((Object)annotation2, new Object[0]);
            assert (false);
            throw new IllegalStateException("should throw a MirroredTypesException");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof MirroredTypesException) {
                MirroredTypesException mirroredTypesException = (MirroredTypesException)invocationTargetException.getCause();
                Collection<TypeMirror> collection = mirroredTypesException.getTypeMirrors();
                return collection.toArray(new TypeMirror[collection.size()]);
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    protected String fullName(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getDeclaringType().getQualifiedName() + '#' + methodDeclaration.getSimpleName();
    }
}

