/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.generator;

import com.sun.istack.internal.NotNull;
import com.sun.tools.internal.ws.processor.generator.GeneratorConstants;
import com.sun.tools.internal.ws.processor.model.Fault;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.java.JavaInterface;
import com.sun.tools.internal.ws.processor.model.java.JavaStructureMember;
import com.sun.tools.internal.ws.util.ClassNameInfo;
import com.sun.xml.internal.ws.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class Names
implements GeneratorConstants {
    private static final Map<String, String> reservedWords = new HashMap<String, String>();

    public static String getPortName(Port port) {
        String string = (String)port.getProperty("com.sun.xml.internal.ws.processor.model.JavaPortName");
        if (string != null) {
            return string;
        }
        QName qName = (QName)port.getProperty("com.sun.xml.internal.ws.processor.model.WSDLPortName");
        if (qName != null) {
            return qName.getLocalPart();
        }
        String string2 = Names.stripQualifier(port.getJavaInterface().getName());
        return ClassNameInfo.replaceInnerClassSym(string2);
    }

    public static String stripQualifier(String string) {
        return ClassNameInfo.getName(string);
    }

    public static String getPackageName(String string) {
        String string2 = ClassNameInfo.getQualifier(string);
        return string2 != null ? string2 : "";
    }

    public static String customJavaTypeClassName(JavaInterface javaInterface) {
        return javaInterface.getName();
    }

    public static String customExceptionClassName(Fault fault) {
        return fault.getJavaException().getName();
    }

    public static String getExceptionClassMemberName() {
        return "faultInfo";
    }

    public static boolean isJavaReservedWord(String string) {
        return reservedWords.get(string) != null;
    }

    @NotNull
    public static String getJavaReserverVarialbeName(@NotNull String string) {
        return reservedWords.get(string) == null ? string : reservedWords.get(string);
    }

    public static String getJavaMemberReadMethod(JavaStructureMember javaStructureMember) {
        String string = javaStructureMember.getType().getRealName().equals("boolean") ? "is" + StringUtils.capitalize((String)javaStructureMember.getName()) : "get" + StringUtils.capitalize((String)javaStructureMember.getName());
        return string;
    }

    public static String getResponseName(String string) {
        return string + "Response";
    }

    static {
        reservedWords.put("abstract", "_abstract");
        reservedWords.put("assert", "_assert");
        reservedWords.put("boolean", "_boolean");
        reservedWords.put("break", "_break");
        reservedWords.put("byte", "_byte");
        reservedWords.put("case", "_case");
        reservedWords.put("catch", "_catch");
        reservedWords.put("char", "_char");
        reservedWords.put("class", "_class");
        reservedWords.put("const", "_const");
        reservedWords.put("continue", "_continue");
        reservedWords.put("default", "_default");
        reservedWords.put("do", "_do");
        reservedWords.put("double", "_double");
        reservedWords.put("else", "_else");
        reservedWords.put("extends", "_extends");
        reservedWords.put("false", "_false");
        reservedWords.put("final", "_final");
        reservedWords.put("finally", "_finally");
        reservedWords.put("float", "_float");
        reservedWords.put("for", "_for");
        reservedWords.put("goto", "_goto");
        reservedWords.put("if", "_if");
        reservedWords.put("implements", "_implements");
        reservedWords.put("import", "_import");
        reservedWords.put("instanceof", "_instanceof");
        reservedWords.put("int", "_int");
        reservedWords.put("interface", "_interface");
        reservedWords.put("long", "_long");
        reservedWords.put("native", "_native");
        reservedWords.put("new", "_new");
        reservedWords.put("null", "_null");
        reservedWords.put("package", "_package");
        reservedWords.put("private", "_private");
        reservedWords.put("protected", "_protected");
        reservedWords.put("public", "_public");
        reservedWords.put("return", "_return");
        reservedWords.put("short", "_short");
        reservedWords.put("static", "_static");
        reservedWords.put("strictfp", "_strictfp");
        reservedWords.put("super", "_super");
        reservedWords.put("switch", "_switch");
        reservedWords.put("synchronized", "_synchronized");
        reservedWords.put("this", "_this");
        reservedWords.put("throw", "_throw");
        reservedWords.put("throws", "_throws");
        reservedWords.put("transient", "_transient");
        reservedWords.put("true", "_true");
        reservedWords.put("try", "_try");
        reservedWords.put("void", "_void");
        reservedWords.put("volatile", "_volatile");
        reservedWords.put("while", "_while");
        reservedWords.put("enum", "_enum");
    }
}

