/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.generator;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.JAnnotatable;
import com.sun.codemodel.internal.JAnnotationArrayMember;
import com.sun.codemodel.internal.JAnnotationUse;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JCommentPart;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JDocComment;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.JVar;
import com.sun.tools.internal.ws.api.TJavaGeneratorExtension;
import com.sun.tools.internal.ws.api.wsdl.TWSDLOperation;
import com.sun.tools.internal.ws.processor.generator.GeneratorBase;
import com.sun.tools.internal.ws.processor.generator.GeneratorUtil;
import com.sun.tools.internal.ws.processor.generator.JavaGeneratorExtensionFacade;
import com.sun.tools.internal.ws.processor.generator.Names;
import com.sun.tools.internal.ws.processor.model.AbstractType;
import com.sun.tools.internal.ws.processor.model.AsyncOperation;
import com.sun.tools.internal.ws.processor.model.Block;
import com.sun.tools.internal.ws.processor.model.Fault;
import com.sun.tools.internal.ws.processor.model.Message;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.model.Operation;
import com.sun.tools.internal.ws.processor.model.Parameter;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Request;
import com.sun.tools.internal.ws.processor.model.Response;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.model.java.JavaInterface;
import com.sun.tools.internal.ws.processor.model.java.JavaMethod;
import com.sun.tools.internal.ws.processor.model.java.JavaParameter;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBType;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBTypeAndAnnotation;
import com.sun.tools.internal.ws.resources.GeneratorMessages;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.Options;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.tools.internal.ws.wsdl.document.PortType;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPStyle;
import java.util.ArrayList;
import java.util.List;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import org.xml.sax.Locator;

public class SeiGenerator
extends GeneratorBase {
    private String serviceNS;
    private TJavaGeneratorExtension extension;
    private List<TJavaGeneratorExtension> extensionHandlers = new ArrayList<TJavaGeneratorExtension>();
    private boolean isDocStyle = true;
    private boolean sameParamStyle = true;

    public static void generate(Model model, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver, TJavaGeneratorExtension ... tJavaGeneratorExtensionArray) {
        SeiGenerator seiGenerator = new SeiGenerator(model, wsimportOptions, errorReceiver, tJavaGeneratorExtensionArray);
        seiGenerator.doGeneration();
    }

    private SeiGenerator(Model model, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver, TJavaGeneratorExtension ... tJavaGeneratorExtensionArray) {
        super(model, wsimportOptions, errorReceiver);
        for (TJavaGeneratorExtension tJavaGeneratorExtension : tJavaGeneratorExtensionArray) {
            this.register(tJavaGeneratorExtension);
        }
        this.extension = new JavaGeneratorExtensionFacade(this.extensionHandlers.toArray(new TJavaGeneratorExtension[0]));
    }

    private void write(Port port) {
        JavaInterface javaInterface = port.getJavaInterface();
        String string = Names.customJavaTypeClassName(javaInterface);
        if (this.donotOverride && GeneratorUtil.classExists(this.options, string)) {
            this.log("Class " + string + " exists. Not overriding.");
            return;
        }
        JDefinedClass jDefinedClass = null;
        try {
            jDefinedClass = this.getClass(string, ClassType.INTERFACE);
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            PortType portType;
            QName qName = (QName)port.getProperty("com.sun.xml.internal.ws.processor.model.WSDLPortTypeName");
            Locator locator = null;
            if (qName != null && (portType = port.portTypes.get(qName)) != null) {
                locator = portType.getLocator();
            }
            this.receiver.error(locator, GeneratorMessages.GENERATOR_SEI_CLASS_ALREADY_EXIST(javaInterface.getName(), qName));
            return;
        }
        if (!jDefinedClass.methods().isEmpty()) {
            return;
        }
        JAnnotationUse jAnnotationUse = jDefinedClass.annotate(this.cm.ref(WebService.class));
        this.writeWebServiceAnnotation(port, jAnnotationUse);
        this.writeHandlerConfig(Names.customJavaTypeClassName(port.getJavaInterface()), jDefinedClass, this.options);
        this.writeSOAPBinding(port, jDefinedClass);
        if (this.options.target.isLaterThan(Options.Target.V2_1)) {
            this.writeXmlSeeAlso(jDefinedClass);
        }
        for (Operation operation : port.getOperations()) {
            Object object3;
            Object object4;
            JDocComment jDocComment;
            JMethod jMethod;
            JavaMethod javaMethod = operation.getJavaMethod();
            String string2 = operation.getJavaDoc();
            if (javaMethod.getReturnType().getName().equals("void")) {
                jMethod = jDefinedClass.method(1, Void.TYPE, javaMethod.getName());
                jDocComment = jMethod.javadoc();
            } else {
                object4 = javaMethod.getReturnType().getType();
                jMethod = jDefinedClass.method(1, ((JAXBTypeAndAnnotation)object4).getType(), javaMethod.getName());
                ((JAXBTypeAndAnnotation)object4).annotate(jMethod);
                jDocComment = jMethod.javadoc();
                object3 = jDocComment.addReturn();
                ((JCommentPart)object3).add("returns " + ((JAXBTypeAndAnnotation)object4).getName());
            }
            if (string2 != null) {
                jDocComment.add(string2);
            }
            this.writeWebMethod(operation, jMethod);
            object4 = this.cm.ref(Holder.class);
            for (JavaParameter javaParameter : javaMethod.getParametersList()) {
                JAXBTypeAndAnnotation jAXBTypeAndAnnotation = javaParameter.getType().getType();
                Object object = javaParameter.isHolder() ? jMethod.param(((JClass)object4).narrow(jAXBTypeAndAnnotation.getType().boxify()), javaParameter.getName()) : jMethod.param(jAXBTypeAndAnnotation.getType(), javaParameter.getName());
                jAXBTypeAndAnnotation.annotate((JAnnotatable)object);
                jDocComment.addParam((JVar)object);
                JAnnotationUse jAnnotationUse2 = ((JVar)object).annotate(this.cm.ref(WebParam.class));
                this.writeWebParam(operation, javaParameter, jAnnotationUse2);
            }
            object3 = operation.getWSDLPortTypeOperation();
            for (Object object : operation.getFaultsSet()) {
                jMethod._throws(((Fault)object).getExceptionClass());
                jDocComment.addThrows(((Fault)object).getExceptionClass());
                ((com.sun.tools.internal.ws.wsdl.document.Operation)object3).putFault(((Fault)object).getWsdlFaultName(), ((Fault)object).getExceptionClass());
            }
            this.extension.writeMethodAnnotations((TWSDLOperation)object3, jMethod);
        }
    }

    private void writeXmlSeeAlso(JDefinedClass jDefinedClass) {
        if (this.model.getJAXBModel().getS2JJAXBModel() != null) {
            List<JClass> list = this.model.getJAXBModel().getS2JJAXBModel().getAllObjectFactories();
            if (list.size() == 0) {
                return;
            }
            JAnnotationUse jAnnotationUse = jDefinedClass.annotate(this.cm.ref(XmlSeeAlso.class));
            JAnnotationArrayMember jAnnotationArrayMember = jAnnotationUse.paramArray("value");
            for (JClass jClass : list) {
                jAnnotationArrayMember = jAnnotationArrayMember.param(jClass);
            }
        }
    }

    private void writeWebMethod(Operation operation, JMethod jMethod) {
        Object object;
        Object object2;
        Object object3;
        String string;
        Response response = operation.getResponse();
        JAnnotationUse jAnnotationUse = jMethod.annotate(this.cm.ref(WebMethod.class));
        String string2 = string = operation instanceof AsyncOperation ? ((AsyncOperation)operation).getNormalOperation().getName().getLocalPart() : operation.getName().getLocalPart();
        if (!jMethod.name().equals(string)) {
            jAnnotationUse.param("operationName", string);
        }
        if (operation.getSOAPAction() != null && operation.getSOAPAction().length() > 0) {
            jAnnotationUse.param("action", operation.getSOAPAction());
        }
        if (operation.getResponse() == null) {
            jMethod.annotate(Oneway.class);
        } else if (!operation.getJavaMethod().getReturnType().getName().equals("void") && operation.getResponse().getParametersList().size() > 0) {
            object3 = null;
            object2 = null;
            if (operation.getResponse().getBodyBlocks().hasNext()) {
                object = operation.getResponse().getBodyBlocks().next();
                object3 = ((Block)object).getName().getLocalPart();
                if (this.isDocStyle || ((Block)object).getLocation() == 2) {
                    object2 = ((Block)object).getName().getNamespaceURI();
                }
            }
            for (Parameter parameter : operation.getResponse().getParametersList()) {
                Object object4;
                if (parameter.getParameterIndex() != -1) continue;
                if (operation.isWrapped() || !this.isDocStyle) {
                    object3 = parameter.getBlock().getLocation() == 2 ? parameter.getBlock().getName().getLocalPart() : parameter.getName();
                    if (this.isDocStyle || parameter.getBlock().getLocation() == 2) {
                        object2 = parameter.getType().getName().getNamespaceURI();
                    }
                } else if (this.isDocStyle) {
                    object4 = (JAXBType)parameter.getType();
                    object3 = ((AbstractType)object4).getName().getLocalPart();
                    object2 = ((AbstractType)object4).getName().getNamespaceURI();
                }
                if (operation instanceof AsyncOperation) continue;
                object4 = null;
                if (!((String)object3).equals("return")) {
                    object4 = jMethod.annotate(WebResult.class);
                    ((JAnnotationUse)object4).param("name", (String)object3);
                }
                if (object2 != null && (!((String)object2).equals(this.serviceNS) || this.isDocStyle && operation.isWrapped())) {
                    if (object4 == null) {
                        object4 = jMethod.annotate(WebResult.class);
                    }
                    ((JAnnotationUse)object4).param("targetNamespace", (String)object2);
                }
                if (!this.isDocStyle || !operation.isWrapped() || parameter.getBlock().getLocation() == 2) {
                    if (object4 == null) {
                        object4 = jMethod.annotate(WebResult.class);
                    }
                    ((JAnnotationUse)object4).param("partName", parameter.getName());
                }
                if (parameter.getBlock().getLocation() != 2) continue;
                if (object4 == null) {
                    object4 = jMethod.annotate(WebResult.class);
                }
                ((JAnnotationUse)object4).param("header", true);
            }
        }
        if (!this.sameParamStyle && !operation.isWrapped()) {
            object = jMethod.annotate(SOAPBinding.class);
            ((JAnnotationUse)object).param("parameterStyle", (Enum)SOAPBinding.ParameterStyle.BARE);
        }
        if (operation.isWrapped() && operation.getStyle().equals(SOAPStyle.DOCUMENT)) {
            object = operation.getRequest().getBodyBlocks().next();
            object3 = jMethod.annotate(RequestWrapper.class);
            ((JAnnotationUse)object3).param("localName", ((Block)object).getName().getLocalPart());
            ((JAnnotationUse)object3).param("targetNamespace", ((Block)object).getName().getNamespaceURI());
            ((JAnnotationUse)object3).param("className", ((Block)object).getType().getJavaType().getName());
            if (response != null) {
                object2 = jMethod.annotate(ResponseWrapper.class);
                Block block = response.getBodyBlocks().next();
                ((JAnnotationUse)object2).param("localName", block.getName().getLocalPart());
                ((JAnnotationUse)object2).param("targetNamespace", block.getName().getNamespaceURI());
                ((JAnnotationUse)object2).param("className", block.getType().getJavaType().getName());
            }
        }
    }

    private boolean isMessageParam(Parameter parameter, Message message) {
        Block block = parameter.getBlock();
        return message.getBodyBlockCount() > 0 && block.equals(message.getBodyBlocks().next()) || message.getHeaderBlockCount() > 0 && block.equals(message.getHeaderBlocks().next());
    }

    private boolean isHeaderParam(Parameter parameter, Message message) {
        if (message.getHeaderBlockCount() == 0) {
            return false;
        }
        for (Block block : message.getHeaderBlocksMap().values()) {
            if (!parameter.getBlock().equals(block)) continue;
            return true;
        }
        return false;
    }

    private boolean isAttachmentParam(Parameter parameter, Message message) {
        if (message.getAttachmentBlockCount() == 0) {
            return false;
        }
        for (Block block : message.getAttachmentBlocksMap().values()) {
            if (!parameter.getBlock().equals(block)) continue;
            return true;
        }
        return false;
    }

    private boolean isUnboundParam(Parameter parameter, Message message) {
        if (message.getUnboundBlocksCount() == 0) {
            return false;
        }
        for (Block block : message.getUnboundBlocksMap().values()) {
            if (!parameter.getBlock().equals(block)) continue;
            return true;
        }
        return false;
    }

    private void writeWebParam(Operation operation, JavaParameter javaParameter, JAnnotationUse jAnnotationUse) {
        Parameter parameter = javaParameter.getParameter();
        Request request = operation.getRequest();
        Response response = operation.getResponse();
        boolean bl = this.isHeaderParam(parameter, request) || response != null && this.isHeaderParam(parameter, response);
        boolean bl2 = operation.isWrapped();
        String string = parameter.getBlock().getLocation() == 2 || this.isDocStyle && !bl2 ? parameter.getBlock().getName().getLocalPart() : parameter.getName();
        jAnnotationUse.param("name", string);
        String string2 = null;
        if (this.isDocStyle) {
            string2 = parameter.getBlock().getName().getNamespaceURI();
            if (bl2) {
                string2 = parameter.getType().getName().getNamespaceURI();
            }
        } else if (bl) {
            string2 = parameter.getBlock().getName().getNamespaceURI();
        }
        if (string2 != null && (!string2.equals(this.serviceNS) || this.isDocStyle && bl2)) {
            jAnnotationUse.param("targetNamespace", string2);
        }
        if (bl) {
            jAnnotationUse.param("header", true);
        }
        if (parameter.isINOUT()) {
            jAnnotationUse.param("mode", (Enum)WebParam.Mode.INOUT);
        } else if (response != null && (this.isMessageParam(parameter, response) || this.isHeaderParam(parameter, response) || this.isAttachmentParam(parameter, response) || this.isUnboundParam(parameter, response) || parameter.isOUT())) {
            jAnnotationUse.param("mode", (Enum)WebParam.Mode.OUT);
        }
        if (!this.isDocStyle || !bl2 || bl) {
            jAnnotationUse.param("partName", javaParameter.getParameter().getName());
        }
    }

    private void writeSOAPBinding(Port port, JDefinedClass jDefinedClass) {
        JAnnotationUse jAnnotationUse = null;
        boolean bl = this.isDocStyle = port.getStyle() == null || port.getStyle().equals(SOAPStyle.DOCUMENT);
        if (!this.isDocStyle) {
            jAnnotationUse = jDefinedClass.annotate(SOAPBinding.class);
            jAnnotationUse.param("style", (Enum)SOAPBinding.Style.RPC);
            port.setWrapped(true);
        }
        if (this.isDocStyle) {
            boolean bl2 = true;
            boolean bl3 = true;
            for (Operation operation : port.getOperations()) {
                if (bl2) {
                    bl3 = operation.isWrapped();
                    bl2 = false;
                    continue;
                }
                boolean bl4 = this.sameParamStyle = bl3 == operation.isWrapped();
                if (this.sameParamStyle) continue;
                break;
            }
            if (this.sameParamStyle) {
                port.setWrapped(bl3);
            }
        }
        if (this.sameParamStyle && !port.isWrapped()) {
            if (jAnnotationUse == null) {
                jAnnotationUse = jDefinedClass.annotate(SOAPBinding.class);
            }
            jAnnotationUse.param("parameterStyle", (Enum)SOAPBinding.ParameterStyle.BARE);
        }
    }

    private void writeWebServiceAnnotation(Port port, JAnnotationUse jAnnotationUse) {
        QName qName = (QName)port.getProperty("com.sun.xml.internal.ws.processor.model.WSDLPortTypeName");
        jAnnotationUse.param("name", qName.getLocalPart());
        jAnnotationUse.param("targetNamespace", qName.getNamespaceURI());
    }

    public void visit(Model model) throws Exception {
        for (Service service : model.getServices()) {
            service.accept(this);
        }
    }

    public void visit(Service service) throws Exception {
        String string = this.model.getJavaDoc();
        if (string != null) {
            JPackage jPackage = this.cm._package(this.options.defaultPackage);
            jPackage.javadoc().add(string);
        }
        for (Port port : service.getPorts()) {
            this.visitPort(service, port);
        }
    }

    private void visitPort(Service service, Port port) {
        if (port.isProvider()) {
            return;
        }
        this.write(port);
    }

    private void register(TJavaGeneratorExtension tJavaGeneratorExtension) {
        this.extensionHandlers.add(tJavaGeneratorExtension);
    }
}

