/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.annotation;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JAnnotationArrayMember;
import com.sun.codemodel.internal.JAnnotationUse;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JCommentPart;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JDocComment;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import com.sun.codemodel.internal.writer.ProgressCodeWriter;
import com.sun.codemodel.internal.writer.PrologCodeWriter;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.tools.internal.ws.processor.generator.GeneratorBase;
import com.sun.tools.internal.ws.processor.generator.Names;
import com.sun.tools.internal.ws.processor.modeler.ModelerException;
import com.sun.tools.internal.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.internal.ws.processor.modeler.annotation.FaultInfo;
import com.sun.tools.internal.ws.processor.modeler.annotation.MakeSafeTypeVisitor;
import com.sun.tools.internal.ws.processor.modeler.annotation.MemberInfo;
import com.sun.tools.internal.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.internal.ws.processor.modeler.annotation.TypeModeler;
import com.sun.tools.internal.ws.processor.modeler.annotation.TypeMonikerFactory;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceVisitor;
import com.sun.tools.internal.ws.processor.modeler.annotation.WrapperInfo;
import com.sun.tools.internal.ws.processor.util.DirectoryUtil;
import com.sun.tools.internal.ws.resources.WebserviceapMessages;
import com.sun.tools.internal.ws.util.ClassNameInfo;
import com.sun.tools.internal.ws.wscompile.FilerCodeWriter;
import com.sun.tools.internal.ws.wscompile.WsgenOptions;
import com.sun.tools.internal.ws.wscompile.WsimportTool;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPStyle;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.ws.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceWrapperGenerator
extends WebServiceVisitor {
    protected Set<String> wrapperNames;
    protected Set<String> processedExceptions;
    protected JCodeModel cm;
    protected MakeSafeTypeVisitor makeSafeVisitor;

    public WebServiceWrapperGenerator(ModelBuilder modelBuilder, AnnotationProcessorContext annotationProcessorContext) {
        super(modelBuilder, annotationProcessorContext);
        this.makeSafeVisitor = new MakeSafeTypeVisitor(modelBuilder.getAPEnv());
    }

    @Override
    protected void processWebService(WebService webService, TypeDeclaration typeDeclaration) {
        this.cm = new JCodeModel();
        this.wrapperNames = new HashSet<String>();
        this.processedExceptions = new HashSet<String>();
    }

    @Override
    protected void postProcessWebService(WebService webService, InterfaceDeclaration interfaceDeclaration) {
        super.postProcessWebService(webService, interfaceDeclaration);
        this.doPostProcessWebService(webService, interfaceDeclaration);
    }

    @Override
    protected void postProcessWebService(WebService webService, ClassDeclaration classDeclaration) {
        super.postProcessWebService(webService, classDeclaration);
        this.doPostProcessWebService(webService, classDeclaration);
    }

    protected void doPostProcessWebService(WebService webService, TypeDeclaration typeDeclaration) {
        if (this.cm != null) {
            File file = this.builder.getSourceDir();
            assert (file != null);
            WsgenOptions wsgenOptions = this.builder.getOptions();
            try {
                CodeWriter codeWriter = new FilerCodeWriter(file, wsgenOptions);
                codeWriter = new PrologCodeWriter(codeWriter, WsimportTool.getJAXClassComment());
                if (wsgenOptions.verbose) {
                    codeWriter = new ProgressCodeWriter(codeWriter, System.out);
                }
                this.cm.build(codeWriter);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    protected void processMethod(MethodDeclaration methodDeclaration, WebMethod webMethod) {
        this.builder.log("WrapperGen - method: " + methodDeclaration);
        this.builder.log("method.getDeclaringType(): " + methodDeclaration.getDeclaringType());
        boolean bl = false;
        if (this.wrapped && this.soapStyle.equals(SOAPStyle.DOCUMENT)) {
            bl = this.generateWrappers(methodDeclaration, webMethod);
        }
        boolean bl2 = bl = this.generateExceptionBeans(methodDeclaration) || bl;
        if (bl) {
            this.builder.setWrapperGenerated(bl);
        }
    }

    private boolean generateExceptionBeans(MethodDeclaration methodDeclaration) {
        String string = this.packageName + ".jaxws.";
        if (this.packageName.length() == 0) {
            string = "jaxws.";
        }
        boolean bl = false;
        for (ReferenceType referenceType : methodDeclaration.getThrownTypes()) {
            ClassDeclaration classDeclaration = ((com.sun.mirror.type.ClassType)referenceType).getDeclaration();
            if (classDeclaration == null) {
                this.builder.onError(WebserviceapMessages.WEBSERVICEAP_COULD_NOT_FIND_TYPEDECL(referenceType.toString(), this.context.getRound()));
                return false;
            }
            boolean bl2 = this.generateExceptionBean(classDeclaration, string);
            bl = bl || bl2;
        }
        return bl;
    }

    private boolean duplicateName(String string) {
        for (String string2 : this.wrapperNames) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        this.wrapperNames.add(string);
        return false;
    }

    private boolean generateWrappers(MethodDeclaration methodDeclaration, WebMethod webMethod) {
        ResponseWrapper responseWrapper;
        boolean bl = methodDeclaration.getAnnotation(Oneway.class) != null;
        String string = this.packageName + ".jaxws.";
        if (this.packageName.length() == 0) {
            string = "jaxws.";
        }
        String string2 = methodDeclaration.getSimpleName();
        String string3 = this.builder.getOperationName(string2);
        String string4 = string3 = webMethod != null && webMethod.operationName().length() > 0 ? webMethod.operationName() : string3;
        String string5 = string3 + "Response";
        String string6 = this.typeNamespace;
        String string7 = this.typeNamespace;
        String string8 = string + StringUtils.capitalize((String)methodDeclaration.getSimpleName());
        RequestWrapper requestWrapper = methodDeclaration.getAnnotation(RequestWrapper.class);
        if (requestWrapper != null) {
            if (requestWrapper.className().length() > 0) {
                string8 = requestWrapper.className();
            }
            if (requestWrapper.localName().length() > 0) {
                string4 = requestWrapper.localName();
            }
            if (requestWrapper.targetNamespace().length() > 0) {
                string6 = requestWrapper.targetNamespace();
            }
        }
        this.builder.log("requestWrapper: " + string8);
        File file = new File(DirectoryUtil.getOutputDirectoryFor(string8, this.builder.getSourceDir()), Names.stripQualifier(string8) + ".java");
        this.builder.getOptions().addGeneratedFile(file);
        boolean bl2 = this.builder.canOverWriteClass(string8);
        if (!bl2) {
            this.builder.log("Class " + string8 + " exists. Not overwriting.");
        }
        if (this.duplicateName(string8) && bl2) {
            this.builder.onError(WebserviceapMessages.WEBSERVICEAP_METHOD_REQUEST_WRAPPER_BEAN_NAME_NOT_UNIQUE(this.typeDecl.getQualifiedName(), methodDeclaration.toString()));
        }
        String string9 = null;
        boolean bl3 = bl2;
        if (!bl) {
            string9 = string + StringUtils.capitalize((String)methodDeclaration.getSimpleName()) + "Response";
            responseWrapper = methodDeclaration.getAnnotation(ResponseWrapper.class);
            if (responseWrapper != null) {
                if (responseWrapper.className().length() > 0) {
                    string9 = responseWrapper.className();
                }
                if (responseWrapper.localName().length() > 0) {
                    string5 = responseWrapper.localName();
                }
                if (responseWrapper.targetNamespace().length() > 0) {
                    string7 = responseWrapper.targetNamespace();
                }
            }
            if (!(bl3 = this.builder.canOverWriteClass(string9))) {
                this.builder.log("Class " + string9 + " exists. Not overwriting.");
            }
            if (this.duplicateName(string9) && bl3) {
                this.builder.onError(WebserviceapMessages.WEBSERVICEAP_METHOD_RESPONSE_WRAPPER_BEAN_NAME_NOT_UNIQUE(this.typeDecl.getQualifiedName(), methodDeclaration.toString()));
            }
            file = new File(DirectoryUtil.getOutputDirectoryFor(string9, this.builder.getSourceDir()), Names.stripQualifier(string9) + ".java");
            this.builder.getOptions().addGeneratedFile(file);
        }
        responseWrapper = new ArrayList();
        ArrayList<MemberInfo> arrayList = new ArrayList<MemberInfo>();
        WrapperInfo wrapperInfo = new WrapperInfo(string8);
        wrapperInfo.setMembers((List<MemberInfo>)responseWrapper);
        WrapperInfo wrapperInfo2 = null;
        if (!bl) {
            wrapperInfo2 = new WrapperInfo(string9);
            wrapperInfo2.setMembers(arrayList);
        }
        this.seiContext.setReqWrapperOperation(methodDeclaration, wrapperInfo);
        if (!bl) {
            this.seiContext.setResWrapperOperation(methodDeclaration, wrapperInfo2);
        }
        try {
            if (!bl2 && !bl3) {
                return false;
            }
            JDefinedClass jDefinedClass = null;
            if (bl2) {
                jDefinedClass = this.getCMClass(string8, ClassType.CLASS);
            }
            JDefinedClass jDefinedClass2 = null;
            if (!bl && bl3) {
                jDefinedClass2 = this.getCMClass(string9, ClassType.CLASS);
            }
            this.writeXmlElementDeclaration(jDefinedClass, string4, string6);
            this.writeXmlElementDeclaration(jDefinedClass2, string5, string7);
            this.collectMembers(methodDeclaration, (ArrayList<MemberInfo>)responseWrapper, arrayList);
            this.writeXmlTypeDeclaration(jDefinedClass, string4, string6, (ArrayList<MemberInfo>)responseWrapper);
            this.writeXmlTypeDeclaration(jDefinedClass2, string5, string7, arrayList);
            this.writeMembers(jDefinedClass, (ArrayList<MemberInfo>)responseWrapper);
            this.writeMembers(jDefinedClass2, arrayList);
        }
        catch (Exception exception) {
            throw new ModelerException("modeler.nestedGeneratorError", exception);
        }
        return true;
    }

    private void collectMembers(MethodDeclaration methodDeclaration, ArrayList<MemberInfo> arrayList, ArrayList<MemberInfo> arrayList2) {
        WebResult webResult = methodDeclaration.getAnnotation(WebResult.class);
        List<Annotation> list = this.collectJAXBAnnotations(methodDeclaration);
        String string = "return";
        String string2 = "_return";
        String string3 = this.wrapped ? "" : this.typeNamespace;
        boolean bl = false;
        if (webResult != null) {
            if (webResult.name().length() > 0) {
                string = webResult.name();
                string2 = JAXBRIContext.mangleNameToVariableName((String)webResult.name());
                string2 = Names.getJavaReserverVarialbeName(string2);
            }
            string3 = webResult.targetNamespace().length() > 1 ? webResult.targetNamespace() : string3;
            bl = webResult.header();
        }
        int n = -1;
        TypeMirror typeMirror = this.getSafeType(methodDeclaration.getReturnType());
        if (!(methodDeclaration.getReturnType() instanceof VoidType) && !bl) {
            arrayList2.add(new MemberInfo(typeMirror, string2, new QName(string3, string), methodDeclaration, list.toArray(new Annotation[list.size()])));
        }
        for (ParameterDeclaration parameterDeclaration : methodDeclaration.getParameters()) {
            String string4;
            List<Annotation> list2 = this.collectJAXBAnnotations(parameterDeclaration);
            WebParam.Mode mode = null;
            ++n;
            TypeMirror typeMirror2 = this.builder.getHolderValueType(parameterDeclaration.getType());
            WebParam webParam = parameterDeclaration.getAnnotation(WebParam.class);
            TypeMirror typeMirror3 = typeMirror = this.getSafeType(parameterDeclaration.getType());
            String string5 = string4 = this.wrapped ? "" : this.typeNamespace;
            if (typeMirror2 != null) {
                typeMirror3 = typeMirror2;
            }
            String string6 = "arg" + n;
            if (webParam != null && webParam.header()) continue;
            if (webParam != null) {
                mode = webParam.mode();
                if (webParam.name().length() > 0) {
                    string6 = webParam.name();
                }
                if (webParam.targetNamespace().length() > 0) {
                    string4 = webParam.targetNamespace();
                }
            }
            String string7 = JAXBRIContext.mangleNameToVariableName((String)string6);
            string7 = Names.getJavaReserverVarialbeName(string7);
            MemberInfo memberInfo = new MemberInfo(typeMirror3, string7, new QName(string4, string6), parameterDeclaration, list2.toArray(new Annotation[list2.size()]));
            if (typeMirror2 != null) {
                if (mode == null || mode.equals((Object)WebParam.Mode.INOUT)) {
                    arrayList.add(memberInfo);
                }
                arrayList2.add(memberInfo);
                continue;
            }
            arrayList.add(memberInfo);
        }
    }

    private List<Annotation> collectJAXBAnnotations(ParameterDeclaration parameterDeclaration) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        XmlAttachmentRef xmlAttachmentRef = parameterDeclaration.getAnnotation(XmlAttachmentRef.class);
        if (xmlAttachmentRef != null) {
            arrayList.add((Annotation)xmlAttachmentRef);
        }
        if ((xmlAttachmentRef = parameterDeclaration.getAnnotation(XmlMimeType.class)) != null) {
            arrayList.add((Annotation)xmlAttachmentRef);
        }
        if ((xmlAttachmentRef = parameterDeclaration.getAnnotation(XmlJavaTypeAdapter.class)) != null) {
            arrayList.add((Annotation)xmlAttachmentRef);
        }
        if ((xmlAttachmentRef = parameterDeclaration.getAnnotation(XmlList.class)) != null) {
            arrayList.add((Annotation)xmlAttachmentRef);
        }
        return arrayList;
    }

    private List<Annotation> collectJAXBAnnotations(MethodDeclaration methodDeclaration) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        XmlAttachmentRef xmlAttachmentRef = methodDeclaration.getAnnotation(XmlAttachmentRef.class);
        if (xmlAttachmentRef != null) {
            arrayList.add((Annotation)xmlAttachmentRef);
        }
        if ((xmlAttachmentRef = methodDeclaration.getAnnotation(XmlMimeType.class)) != null) {
            arrayList.add((Annotation)xmlAttachmentRef);
        }
        if ((xmlAttachmentRef = methodDeclaration.getAnnotation(XmlJavaTypeAdapter.class)) != null) {
            arrayList.add((Annotation)xmlAttachmentRef);
        }
        if ((xmlAttachmentRef = methodDeclaration.getAnnotation(XmlList.class)) != null) {
            arrayList.add((Annotation)xmlAttachmentRef);
        }
        return arrayList;
    }

    private TypeMirror getSafeType(TypeMirror typeMirror) {
        return (TypeMirror)this.makeSafeVisitor.apply(typeMirror, this.builder.getAPEnv().getTypeUtils());
    }

    private JType getType(TypeMirror typeMirror) {
        String string = ((Object)typeMirror).toString();
        try {
            return this.cm.parseType(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.cm.ref(string);
        }
    }

    private ArrayList<MemberInfo> sortMembers(ArrayList<MemberInfo> arrayList) {
        TreeMap<String, MemberInfo> treeMap = new TreeMap<String, MemberInfo>();
        for (MemberInfo memberInfo : arrayList) {
            treeMap.put(memberInfo.getParamName(), memberInfo);
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(treeMap.values());
        return arrayList2;
    }

    private void writeMembers(JDefinedClass jDefinedClass, ArrayList<MemberInfo> arrayList) {
        if (jDefinedClass == null) {
            return;
        }
        for (MemberInfo memberInfo : arrayList) {
            Object object;
            JType jType = this.getType(memberInfo.getParamType());
            JFieldVar jFieldVar = jDefinedClass.field(4, jType, memberInfo.getParamName());
            QName qName = memberInfo.getElementName();
            if (qName != null) {
                if (this.soapStyle.equals(SOAPStyle.RPC) || this.wrapped) {
                    object = jFieldVar.annotate(XmlElement.class);
                    ((JAnnotationUse)object).param("name", qName.getLocalPart());
                    ((JAnnotationUse)object).param("namespace", qName.getNamespaceURI());
                    if (memberInfo.getParamType() instanceof ArrayType) {
                        ((JAnnotationUse)object).param("nillable", true);
                    }
                } else {
                    jFieldVar.annotate(XmlValue.class);
                }
                this.annotateParameterWithJAXBAnnotations(jFieldVar, memberInfo.getJaxbAnnotations());
            }
            if ((object = memberInfo.getDecl().getAnnotation(XmlJavaTypeAdapter.class)) == null) continue;
            JAnnotationUse jAnnotationUse = jFieldVar.annotate(XmlJavaTypeAdapter.class);
            try {
                object.value();
                throw new AssertionError();
            }
            catch (MirroredTypeException mirroredTypeException) {
                jAnnotationUse.param("value", this.getType(mirroredTypeException.getTypeMirror()));
            }
        }
        for (MemberInfo memberInfo : arrayList) {
            this.writeMember(jDefinedClass, memberInfo.getParamType(), memberInfo.getParamName());
        }
    }

    private void annotateParameterWithJAXBAnnotations(JFieldVar jFieldVar, Annotation[] annotationArray) {
        for (Annotation annotation2 : annotationArray) {
            JAnnotationUse jAnnotationUse;
            if (annotation2 instanceof XmlMimeType) {
                jAnnotationUse = jFieldVar.annotate(XmlMimeType.class);
                jAnnotationUse.param("value", ((XmlMimeType)annotation2).value());
                continue;
            }
            if (annotation2 instanceof XmlJavaTypeAdapter) {
                jAnnotationUse = jFieldVar.annotate(XmlJavaTypeAdapter.class);
                XmlJavaTypeAdapter xmlJavaTypeAdapter = (XmlJavaTypeAdapter)annotation2;
                jAnnotationUse.param("value", xmlJavaTypeAdapter.value());
                jAnnotationUse.param("type", xmlJavaTypeAdapter.type());
                continue;
            }
            if (annotation2 instanceof XmlAttachmentRef) {
                jFieldVar.annotate(XmlAttachmentRef.class);
                continue;
            }
            if (!(annotation2 instanceof XmlList)) continue;
            jFieldVar.annotate(XmlList.class);
        }
    }

    protected JDefinedClass getCMClass(String string, ClassType classType) {
        JDefinedClass jDefinedClass;
        try {
            jDefinedClass = this.cm._class(string, classType);
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            jDefinedClass = this.cm._getClass(string);
        }
        return jDefinedClass;
    }

    private boolean generateExceptionBean(ClassDeclaration classDeclaration, String string) {
        if (this.builder.isRemoteException(classDeclaration)) {
            return false;
        }
        String string2 = ClassNameInfo.getName(classDeclaration.getQualifiedName());
        if (this.processedExceptions.contains(string2)) {
            return false;
        }
        this.processedExceptions.add(string2);
        WebFault webFault = classDeclaration.getAnnotation(WebFault.class);
        String string3 = string + string2 + "Bean";
        TreeMap<String, MethodDeclaration> treeMap = new TreeMap<String, MethodDeclaration>();
        TypeModeler.collectExceptionProperties(classDeclaration, treeMap);
        boolean bl = this.isWSDLException(treeMap, classDeclaration);
        String string4 = this.typeNamespace;
        String string5 = string2;
        if (bl) {
            TypeMirror typeMirror = this.getSafeType(treeMap.get("faultInfo").getReturnType());
            FaultInfo faultInfo = new FaultInfo(TypeMonikerFactory.getTypeMoniker(typeMirror), true);
            string4 = webFault.targetNamespace().length() > 0 ? webFault.targetNamespace() : string4;
            string5 = webFault.name().length() > 0 ? webFault.name() : string5;
            faultInfo.setElementName(new QName(string4, string5));
            this.seiContext.addExceptionBeanEntry(classDeclaration.getQualifiedName(), faultInfo, this.builder);
            return false;
        }
        if (webFault != null) {
            string4 = webFault.targetNamespace().length() > 0 ? webFault.targetNamespace() : string4;
            string5 = webFault.name().length() > 0 ? webFault.name() : string5;
            string3 = webFault.faultBean().length() > 0 ? webFault.faultBean() : string3;
        }
        JDefinedClass jDefinedClass = this.getCMClass(string3, ClassType.CLASS);
        FaultInfo faultInfo = new FaultInfo(string3, false);
        if (this.duplicateName(string3)) {
            this.builder.onError(WebserviceapMessages.WEBSERVICEAP_METHOD_EXCEPTION_BEAN_NAME_NOT_UNIQUE(this.typeDecl.getQualifiedName(), classDeclaration.getQualifiedName()));
        }
        ArrayList<MemberInfo> arrayList = new ArrayList<MemberInfo>();
        for (String object2 : treeMap.keySet()) {
            MethodDeclaration methodDeclaration = treeMap.get(object2);
            TypeMirror typeMirror = this.getSafeType(methodDeclaration.getReturnType());
            MemberInfo memberInfo = new MemberInfo(typeMirror, object2, null, methodDeclaration, new Annotation[0]);
            arrayList.add(memberInfo);
        }
        faultInfo.setMembers(arrayList);
        boolean bl2 = this.builder.canOverWriteClass(string3);
        if (!bl2) {
            this.builder.log("Class " + string3 + " exists. Not overwriting.");
            this.seiContext.addExceptionBeanEntry(classDeclaration.getQualifiedName(), faultInfo, this.builder);
            return false;
        }
        if (this.seiContext.getExceptionBeanName(classDeclaration.getQualifiedName()) != null) {
            return false;
        }
        JDocComment jDocComment = jDefinedClass.javadoc();
        for (String string6 : GeneratorBase.getJAXWSClassComment(this.builder.getSourceVersion())) {
            jDocComment.add(string6);
        }
        this.writeXmlElementDeclaration(jDefinedClass, string5, string4);
        arrayList = this.sortMembers(arrayList);
        this.writeXmlTypeDeclaration(jDefinedClass, string2, this.typeNamespace, arrayList);
        this.writeMembers(jDefinedClass, arrayList);
        this.seiContext.addExceptionBeanEntry(classDeclaration.getQualifiedName(), faultInfo, this.builder);
        return true;
    }

    protected boolean isWSDLException(Map<String, MethodDeclaration> map, ClassDeclaration classDeclaration) {
        WebFault webFault = classDeclaration.getAnnotation(WebFault.class);
        if (webFault == null) {
            return false;
        }
        return map.size() == 2 && map.get("faultInfo") != null;
    }

    private void writeXmlElementDeclaration(JDefinedClass jDefinedClass, String string, String string2) {
        if (jDefinedClass == null) {
            return;
        }
        JAnnotationUse jAnnotationUse = jDefinedClass.annotate(XmlRootElement.class);
        jAnnotationUse.param("name", string);
        if (string2.length() > 0) {
            jAnnotationUse.param("namespace", string2);
        }
        JAnnotationUse jAnnotationUse2 = jDefinedClass.annotate(this.cm.ref(XmlAccessorType.class));
        jAnnotationUse2.param("value", (Enum)XmlAccessType.FIELD);
    }

    private void writeXmlTypeDeclaration(JDefinedClass jDefinedClass, String string, String string2, ArrayList<MemberInfo> arrayList) {
        if (jDefinedClass == null) {
            return;
        }
        JAnnotationUse jAnnotationUse = jDefinedClass.annotate(this.cm.ref(XmlType.class));
        jAnnotationUse.param("name", string);
        jAnnotationUse.param("namespace", string2);
        if (arrayList.size() > 1) {
            JAnnotationArrayMember jAnnotationArrayMember = jAnnotationUse.paramArray("propOrder");
            for (MemberInfo memberInfo : arrayList) {
                jAnnotationArrayMember.param(memberInfo.getParamName());
            }
        }
    }

    private void writeMember(JDefinedClass jDefinedClass, TypeMirror typeMirror, String string) {
        if (jDefinedClass == null) {
            return;
        }
        String string2 = JAXBRIContext.mangleNameToPropertyName((String)string);
        String string3 = ((Object)typeMirror).toString().equals("boolean") ? "is" : "get";
        JType jType = this.getType(typeMirror);
        JMethod jMethod = jDefinedClass.method(1, jType, string3 + string2);
        JDocComment jDocComment = jMethod.javadoc();
        JCommentPart jCommentPart = jDocComment.addReturn();
        jCommentPart.add("returns " + jType.name());
        JBlock jBlock = jMethod.body();
        jBlock._return(JExpr._this().ref(string));
        jMethod = jDefinedClass.method(1, this.cm.VOID, "set" + string2);
        JVar jVar = jMethod.param(jType, string);
        jDocComment = jMethod.javadoc();
        JCommentPart jCommentPart2 = jDocComment.addParam(string);
        jCommentPart2.add("the value for the " + string + " property");
        jBlock = jMethod.body();
        jBlock.assign(JExpr._this().ref(string), jVar);
    }
}

