/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.wsdl;

import com.sun.tools.internal.ws.resources.WscompileMessages;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import java.io.OutputStream;
import java.io.PrintStream;
import org.xml.sax.SAXParseException;

public class ConsoleErrorReporter
extends ErrorReceiver {
    private boolean hasError;
    private PrintStream output;
    private boolean debug;

    public ConsoleErrorReporter(PrintStream printStream) {
        this.output = printStream;
    }

    public ConsoleErrorReporter(OutputStream outputStream) {
        this.output = new PrintStream(outputStream);
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void error(SAXParseException sAXParseException) {
        if (this.debug) {
            sAXParseException.printStackTrace();
        }
        this.hasError = true;
        this.print(WscompileMessages.WSIMPORT_ERROR_MESSAGE(sAXParseException.getMessage()), sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        if (this.debug) {
            sAXParseException.printStackTrace();
        }
        this.hasError = true;
        this.print(WscompileMessages.WSIMPORT_ERROR_MESSAGE(sAXParseException.getMessage()), sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        this.print(WscompileMessages.WSIMPORT_WARNING_MESSAGE(sAXParseException.getMessage()), sAXParseException);
    }

    public void info(SAXParseException sAXParseException) {
        this.print(WscompileMessages.WSIMPORT_INFO_MESSAGE(sAXParseException.getMessage()), sAXParseException);
    }

    public void debug(SAXParseException sAXParseException) {
        this.print(WscompileMessages.WSIMPORT_DEBUG_MESSAGE(sAXParseException.getMessage()), sAXParseException);
    }

    private void print(String string, SAXParseException sAXParseException) {
        this.output.println(string);
        this.output.println(this.getLocationString(sAXParseException));
        this.output.println();
    }

    public void enableDebugging() {
        this.debug = true;
    }
}

