/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.document;

import com.sun.tools.internal.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.internal.ws.api.wsdl.TWSDLExtension;
import com.sun.tools.internal.ws.wsdl.document.BindingFault;
import com.sun.tools.internal.ws.wsdl.document.BindingInput;
import com.sun.tools.internal.ws.wsdl.document.BindingOutput;
import com.sun.tools.internal.ws.wsdl.document.Documentation;
import com.sun.tools.internal.ws.wsdl.document.OperationStyle;
import com.sun.tools.internal.ws.wsdl.document.WSDLConstants;
import com.sun.tools.internal.ws.wsdl.document.WSDLDocumentVisitor;
import com.sun.tools.internal.ws.wsdl.framework.Entity;
import com.sun.tools.internal.ws.wsdl.framework.EntityAction;
import com.sun.tools.internal.ws.wsdl.framework.ExtensibilityHelper;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingOperation
extends Entity
implements TWSDLExtensible {
    private ExtensibilityHelper _helper;
    private Documentation _documentation;
    private String _name;
    private BindingInput _input;
    private BindingOutput _output;
    private List<BindingFault> _faults = new ArrayList<BindingFault>();
    private OperationStyle _style;
    private String _uniqueKey;
    private TWSDLExtensible parent;

    public BindingOperation(Locator locator) {
        super(locator);
        this._helper = new ExtensibilityHelper();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getUniqueKey() {
        if (this._uniqueKey == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._name);
            stringBuffer.append(' ');
            if (this._input != null) {
                stringBuffer.append(this._input.getName());
            } else {
                stringBuffer.append(this._name);
                if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    stringBuffer.append("Request");
                } else if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    stringBuffer.append("Response");
                }
            }
            stringBuffer.append(' ');
            if (this._output != null) {
                stringBuffer.append(this._output.getName());
            } else {
                stringBuffer.append(this._name);
                if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    stringBuffer.append("Solicit");
                } else if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    stringBuffer.append("Response");
                }
            }
            this._uniqueKey = stringBuffer.toString();
        }
        return this._uniqueKey;
    }

    public OperationStyle getStyle() {
        return this._style;
    }

    public void setStyle(OperationStyle operationStyle) {
        this._style = operationStyle;
    }

    public BindingInput getInput() {
        return this._input;
    }

    public void setInput(BindingInput bindingInput) {
        this._input = bindingInput;
    }

    public BindingOutput getOutput() {
        return this._output;
    }

    public void setOutput(BindingOutput bindingOutput) {
        this._output = bindingOutput;
    }

    public void addFault(BindingFault bindingFault) {
        this._faults.add(bindingFault);
    }

    public Iterable<BindingFault> faults() {
        return this._faults;
    }

    @Override
    public QName getElementName() {
        return WSDLConstants.QNAME_OPERATION;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation documentation) {
        this._documentation = documentation;
    }

    @Override
    public String getNameValue() {
        return this.getName();
    }

    @Override
    public String getNamespaceURI() {
        return this.parent.getNamespaceURI();
    }

    @Override
    public QName getWSDLElementName() {
        return this.getElementName();
    }

    @Override
    public void addExtension(TWSDLExtension tWSDLExtension) {
        this._helper.addExtension(tWSDLExtension);
    }

    public Iterable<TWSDLExtension> extensions() {
        return this._helper.extensions();
    }

    @Override
    public TWSDLExtensible getParent() {
        return this.parent;
    }

    @Override
    public void withAllSubEntitiesDo(EntityAction entityAction) {
        if (this._input != null) {
            entityAction.perform(this._input);
        }
        if (this._output != null) {
            entityAction.perform(this._output);
        }
        for (BindingFault bindingFault : this._faults) {
            entityAction.perform(bindingFault);
        }
        this._helper.withAllSubEntitiesDo(entityAction);
    }

    public void accept(WSDLDocumentVisitor wSDLDocumentVisitor) throws Exception {
        wSDLDocumentVisitor.preVisit(this);
        this._helper.accept(wSDLDocumentVisitor);
        if (this._input != null) {
            this._input.accept(wSDLDocumentVisitor);
        }
        if (this._output != null) {
            this._output.accept(wSDLDocumentVisitor);
        }
        for (BindingFault bindingFault : this._faults) {
            bindingFault.accept(wSDLDocumentVisitor);
        }
        wSDLDocumentVisitor.postVisit(this);
    }

    @Override
    public void validateThis() {
        if (this._name == null) {
            this.failValidation("validation.missingRequiredAttribute", "name");
        }
        if (this._style == null) {
            this.failValidation("validation.missingRequiredProperty", "style");
        }
        if (this._style == OperationStyle.ONE_WAY) {
            if (this._input == null) {
                this.failValidation("validation.missingRequiredSubEntity", "input");
            }
            if (this._output != null) {
                this.failValidation("validation.invalidSubEntity", "output");
            }
            if (this._faults != null && this._faults.size() != 0) {
                this.failValidation("validation.invalidSubEntity", "fault");
            }
        }
    }

    public void setParent(TWSDLExtensible tWSDLExtensible) {
        this.parent = tWSDLExtensible;
    }
}

