/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.istack.internal.SAXParseException2;
import com.sun.tools.internal.ws.resources.WsdlMessages;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.tools.internal.ws.wsdl.parser.DOMForest;
import com.sun.tools.internal.ws.wsdl.parser.NamespaceContextImpl;
import com.sun.tools.internal.xjc.util.DOMUtils;
import com.sun.xml.internal.bind.v2.util.EditDistance;
import com.sun.xml.internal.ws.util.DOMUtil;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Internalizer {
    private static final XPathFactory xpf = XPathFactory.newInstance();
    private final XPath xpath = xpf.newXPath();
    private final WsimportOptions options;
    private final DOMForest forest;
    private final ErrorReceiver errorReceiver;

    public Internalizer(DOMForest dOMForest, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver) {
        this.forest = dOMForest;
        this.options = wsimportOptions;
        this.errorReceiver = errorReceiver;
    }

    public void transform() {
        HashMap<Element, Node> hashMap = new HashMap<Element, Node>();
        for (Element element : this.forest.outerMostBindings) {
            this.buildTargetNodeMap(element, element, hashMap);
        }
        for (Element element : this.forest.outerMostBindings) {
            this.move(element, hashMap);
        }
    }

    private void validate(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr.getNamespaceURI() == null && !attr.getLocalName().equals("node") && !attr.getLocalName().equals("wsdlLocation")) continue;
        }
    }

    private void buildTargetNodeMap(Element element, Node node, Map<Element, Node> map) {
        Element[] elementArray;
        Element element2;
        Object object;
        Node node2 = node;
        this.validate(element);
        if (this.isTopLevelBinding(element)) {
            if (element.getAttributeNode("wsdlLocation") != null) {
                object = element.getAttribute("wsdlLocation");
                try {
                    object = new URL(new URL(this.forest.getSystemId(element.getOwnerDocument())), (String)object).toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {
                    object = JAXWSUtils.absolutize((String)JAXWSUtils.getFileOrURLName((String)object));
                }
            } else {
                object = this.forest.getFirstRootDocument();
            }
            if ((node2 = this.forest.get((String)object)) == null) {
                this.reportError(element, WsdlMessages.INTERNALIZER_INCORRECT_SCHEMA_REFERENCE(object, EditDistance.findNearest((String)object, (String[])this.forest.listSystemIDs())));
                return;
            }
        }
        if ((object = DOMUtil.getFirstElementChild((Node)node2)) != null && object.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") && object.getLocalName().equals("definitions") && (element2 = DOMUtils.getFirstChildElement((Element)object, "http://schemas.xmlsoap.org/wsdl/", "types")) != null) {
            elementArray = DOMUtils.getChildElements(element2, "http://www.w3.org/2001/XMLSchema", "schema");
            int n = elementArray.length;
            for (int i = 0; i < n; ++i) {
                Element element3 = elementArray[i];
                if (!element3.hasAttributeNS("http://www.w3.org/2000/xmlns/", "jaxb")) {
                    element3.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
                }
                if (element3.hasAttributeNS("http://java.sun.com/xml/ns/jaxb", "version")) continue;
                element3.setAttributeNS("http://java.sun.com/xml/ns/jaxb", "jaxb:version", "2.0");
            }
        }
        boolean bl = true;
        if ((this.isJAXWSBindings(element) || this.isJAXBBindings(element)) && element.getAttributeNode("node") != null) {
            node2 = this.evaluateXPathNode(element, node2, element.getAttribute("node"), new NamespaceContextImpl(element));
        } else if (this.isJAXWSBindings(element) && element.getAttributeNode("node") == null && !this.isTopLevelBinding(element)) {
            bl = false;
        } else if (this.isGlobalBinding(element) && !this.isWSDLDefinition(node2) && this.isTopLevelBinding(element.getParentNode())) {
            node2 = this.getWSDLDefintionNode(element, node2);
        }
        if (node2 == null) {
            return;
        }
        if (bl) {
            map.put(element, node2);
        }
        for (Element element4 : elementArray = Internalizer.getChildElements(element)) {
            this.buildTargetNodeMap(element4, node2, map);
        }
    }

    private Node getWSDLDefintionNode(Node node, Node node2) {
        return this.evaluateXPathNode(node, node2, "wsdl:definitions", new NamespaceContext(){

            public String getNamespaceURI(String string) {
                return "http://schemas.xmlsoap.org/wsdl/";
            }

            public String getPrefix(String string) {
                throw new UnsupportedOperationException();
            }

            public Iterator getPrefixes(String string) {
                throw new UnsupportedOperationException();
            }
        });
    }

    private boolean isWSDLDefinition(Node node) {
        if (node == null) {
            return false;
        }
        String string = node.getLocalName();
        String string2 = node.getNamespaceURI();
        return Internalizer.fixNull(string).equals("definitions") && Internalizer.fixNull(string2).equals("http://schemas.xmlsoap.org/wsdl/");
    }

    private boolean isTopLevelBinding(Node node) {
        return node.getOwnerDocument().getDocumentElement() == node;
    }

    private boolean isJAXWSBindings(Node node) {
        return node.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws") && node.getLocalName().equals("bindings");
    }

    private boolean isJAXBBindings(Node node) {
        return node.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxb") && node.getLocalName().equals("bindings");
    }

    private boolean isGlobalBinding(Node node) {
        if (node.getNamespaceURI() == null) {
            this.errorReceiver.warning(this.forest.locatorTable.getStartLocation((Element)node), WsdlMessages.INVALID_CUSTOMIZATION_NAMESPACE(node.getLocalName()));
            return false;
        }
        return node.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws") && (node.getLocalName().equals("package") || node.getLocalName().equals("enableAsyncMapping") || node.getLocalName().equals("enableAdditionalSOAPHeaderMapping") || node.getLocalName().equals("enableWrapperStyle") || node.getLocalName().equals("enableMIMEContent"));
    }

    private static Element[] getChildElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !"http://java.sun.com/xml/ns/jaxws".equals(node.getNamespaceURI()) && !"http://java.sun.com/xml/ns/jaxb".equals(node.getNamespaceURI())) continue;
            arrayList.add((Element)node);
        }
        return arrayList.toArray(new Element[arrayList.size()]);
    }

    private Node evaluateXPathNode(Node node, Node node2, String string, NamespaceContext namespaceContext) {
        NodeList nodeList;
        try {
            this.xpath.setNamespaceContext(namespaceContext);
            nodeList = (NodeList)this.xpath.evaluate(string, node2, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            this.reportError((Element)node, WsdlMessages.INTERNALIZER_X_PATH_EVALUATION_ERROR(xPathExpressionException.getMessage()), xPathExpressionException);
            return null;
        }
        if (nodeList.getLength() == 0) {
            this.reportError((Element)node, WsdlMessages.INTERNALIZER_X_PATH_EVALUATES_TO_NO_TARGET(string));
            return null;
        }
        if (nodeList.getLength() != 1) {
            this.reportError((Element)node, WsdlMessages.INTERNALIZER_X_PATH_EVAULATES_TO_TOO_MANY_TARGETS(string, nodeList.getLength()));
            return null;
        }
        Node node3 = nodeList.item(0);
        if (!(node3 instanceof Element)) {
            this.reportError((Element)node, WsdlMessages.INTERNALIZER_X_PATH_EVALUATES_TO_NON_ELEMENT(string));
            return null;
        }
        return node3;
    }

    private void move(Element element, Map<Element, Node> map) {
        Element[] elementArray;
        Node node = map.get(element);
        if (node == null) {
            return;
        }
        for (Element element2 : elementArray = DOMUtils.getChildElements(element)) {
            if ("bindings".equals(element2.getLocalName())) {
                this.move(element2, map);
                continue;
            }
            if (this.isGlobalBinding(element2)) {
                node = map.get(element2);
                this.moveUnder(element2, (Element)node);
                continue;
            }
            if (!(node instanceof Element)) {
                return;
            }
            this.moveUnder(element2, (Element)node);
        }
    }

    private boolean isJAXBBindingElement(Element element) {
        return Internalizer.fixNull(element.getNamespaceURI()).equals("http://java.sun.com/xml/ns/jaxb");
    }

    private boolean isJAXWSBindingElement(Element element) {
        return Internalizer.fixNull(element.getNamespaceURI()).equals("http://java.sun.com/xml/ns/jaxws");
    }

    private void moveUnder(Element element, Element element2) {
        if (this.isJAXBBindingElement(element)) {
            if (!element2.hasAttributeNS("http://www.w3.org/2000/xmlns/", "jaxb")) {
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
            }
            if (!element2.hasAttributeNS("http://java.sun.com/xml/ns/jaxb", "version")) {
                element2.setAttributeNS("http://java.sun.com/xml/ns/jaxb", "jaxb:version", "2.0");
            }
            if (element2.getLocalName().equals("schema") && element2.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && !element2.hasAttributeNS("http://java.sun.com/xml/ns/jaxb", "extensionBindingPrefixes")) {
                element2.setAttributeNS("http://java.sun.com/xml/ns/jaxb", "jaxb:extensionBindingPrefixes", "xjc");
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xjc", "http://java.sun.com/xml/ns/jaxb/xjc");
            }
            element2 = this.refineSchemaTarget(element2);
            this.copyInscopeNSAttributes(element);
        } else if (this.isJAXWSBindingElement(element)) {
            if (!element2.hasAttributeNS("http://www.w3.org/2000/xmlns/", "JAXWS")) {
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:JAXWS", "http://java.sun.com/xml/ns/jaxws");
            }
            element2 = this.refineWSDLTarget(element2);
            this.copyInscopeNSAttributes(element);
        } else {
            return;
        }
        if (element2.getOwnerDocument() != element.getOwnerDocument()) {
            element = (Element)element2.getOwnerDocument().importNode(element, true);
        }
        element2.appendChild(element);
    }

    private void copyInscopeNSAttributes(Element element) {
        Element element2 = element;
        HashSet<String> hashSet = new HashSet<String>();
        while (true) {
            NamedNodeMap namedNodeMap = element2.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string;
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !hashSet.add(string = attr.getName().indexOf(58) == -1 ? "" : attr.getLocalName()) || element2 == element) continue;
                element.setAttributeNodeNS((Attr)attr.cloneNode(true));
            }
            if (element2.getParentNode() instanceof Document) break;
            element2 = (Element)element2.getParentNode();
        }
        if (!hashSet.contains("")) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
    }

    public Element refineSchemaTarget(Element element) {
        Element element2;
        Element element3 = DOMUtils.getFirstChildElement(element, "http://www.w3.org/2001/XMLSchema", "annotation");
        if (element3 == null) {
            element3 = this.insertXMLSchemaElement(element, "annotation");
        }
        if ((element2 = DOMUtils.getFirstChildElement(element3, "http://www.w3.org/2001/XMLSchema", "appinfo")) == null) {
            element2 = this.insertXMLSchemaElement(element3, "appinfo");
        }
        return element2;
    }

    public Element refineWSDLTarget(Element element) {
        Element element2 = DOMUtils.getFirstChildElement(element, "http://java.sun.com/xml/ns/jaxws", "bindings");
        if (element2 == null) {
            element2 = this.insertJAXWSBindingsElement(element, "bindings");
        }
        return element2;
    }

    private Element insertXMLSchemaElement(Element element, String string) {
        String string2 = element.getTagName();
        int n = string2.indexOf(58);
        string2 = n == -1 ? string : string2.substring(0, n + 1) + string;
        Element element2 = element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", string2);
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            element.appendChild(element2);
        } else {
            element.insertBefore(element2, nodeList.item(0));
        }
        return element2;
    }

    private Element insertJAXWSBindingsElement(Element element, String string) {
        String string2 = "JAXWS:" + string;
        Element element2 = element.getOwnerDocument().createElementNS("http://java.sun.com/xml/ns/jaxws", string2);
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            element.appendChild(element2);
        } else {
            element.insertBefore(element2, nodeList.item(0));
        }
        return element2;
    }

    @NotNull
    private static String fixNull(@Nullable String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private void reportError(Element element, String string) {
        this.reportError(element, string, null);
    }

    private void reportError(Element element, String string, Exception exception) {
        SAXParseException2 sAXParseException2 = new SAXParseException2(string, this.forest.locatorTable.getStartLocation(element), exception);
        this.errorReceiver.error((SAXParseException)sAXParseException2);
    }
}

